;=================================================
; MAZE-3D RAYCASTING ENGINE Copyright(C)1998-1999
;-------------------------------------------------
; MazeDraw.asm: part of Maze-3D source code
; Maze-3D Raycasting Engine version 0.5 beta
; Written by Clem Vasseur <darkclem@wanadoo.fr>
; Icarus Productions <http://icarus.ticalc.org>
;=================================================

; A = Tile number
; C = Slice height
; L = Column of the wall to display (0-255)

DrawSlice:
 ld d,c
 ld c,a
 ld a,d

 and %01111111
 ld e,0
 rra
 rr e
 rra
 rr e
 ld d,a
 ld ix,Textures-64
 add ix,de

 ld a,l
 and %11110000
 rra
 rra
 rra
 rra
 cp 8
 jr c,SkipIncIX
 inc ix
SkipIncIX:
 and %00000111
 ld h,MaskTable/256
 ld l,a
 ld a,(hl)
 ld (TextureMask),a
 ld (TextureMask2),a

 res 0,c
 ld a,c
 cp 2
 ret c
 cp MAX_SCALE+1
 ret nc

 ld hl,MappingPtrs-2
 ld b,0
 add hl,bc
 ld e,(hl)
 inc hl
 ld d,(hl)
 push de
 pop iy

 ld b,64
 ld e,0
ScrnCol = $-1
 ld a,c
 cp b
 jr nc,Sup64

 ld a,(GrayScrn)
 add a,2
 ld d,a

 ld a,c
 add a,a
 add a,a
 ld l,a
 ld h,0
 add hl,hl
 ex de,hl
 sbc hl,de
 ld b,c
 ld d,0
 jr RenderLoop

Sup64:
 ld a,(GrayScrn)
 ld h,a
 ld l,e
 ld d,0

RenderLoop:
 ld e,(iy)
 add ix,de

 ld a,0
TextureMask = $-1
 and (ix)
 ld a,0
ColMask = $-1
 jr z,ClearPixel1
 or (hl)
 jr SkipClearPixel1
ClearPixel1:
 cpl
 and (hl)
SkipClearPixel1:
 ld (hl),a

 set 2,h
 ld a,0
TextureMask2 = $-1
 and (ix+32)
 ld a,0
ColMask2 = $-1
 jr z,ClearPixel2
 or (hl)
 jr SkipClearPixel2
ClearPixel2:
 cpl
 and (hl)
SkipClearPixel2:
 ld (hl),a
 res 2,h

 ld e,16
 add hl,de
 inc iy
 djnz RenderLoop
 ret

ColorFlag:
 .db 0

.end
