;Lunar Lander 2.0 Source
;Copyright (C) 1997
;By: Ahmed El-Helw
;ahmed3@worldnet.att.net
;http://asm86.home.ml.org

;Please learn from this source, if you don't understand anything, just email me.  Also, if you
;use anything from this source, please make sure to give me credit.  If you would like to convert
;this program to another calculator, feel free to do so, as long as you give me credit.  If you
;use the sprite routine, make sure to give credit to AVD (Andrew Von Dollen) and Movax for the
;routine.  Thanks.

#include "asm86.h"         
#include "ti86asm.inc"

#include "ti86math.inc"
#include "ti86ops.inc"
#include "ti86abs.inc"

_setxxop1	equ	4613h
_setxxop2	equ	4617h
_cpop1op2	equ	41fbh
_convop1        equ     5577h
_fpmult         equ     548Ch
_homeUp		equ	4A95h

.org _asm_exec_ram 

;------------------AShell Description -----------------------------------
	nop         ;Identifies the table
	jp init
.dw $0000   ;Version # of Table
.dw Title   ;Absolute pointer to program description

;------------------Begin Program ----------------------------------------

init:
	call	_clrLCD
	call	_runindicoff
	call	title			;Calls Title
	jp	TitleGetkey		;Goes to TitleGetkey

title:
	call	_homeUp			;Cursor at 0,0
	ld	hl,titlestring		;Loads Title String
	call	_puts			;Sends it to screen
	ld      b,0			;Load line coords
   	ld      c,55			
   	ld      d,94			
   	ld      e,55			
  	ld      h,1			
  	call    _ILine			;Draw a line w/above coordinates
	ld	hl,9*256+0		;Load (_penCol)*256+(penrow) into hl
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,author		;Loads Author String
	call	_vputs			;Sends to screen
	ld	hl,16*256+0		;Load (_penCol)*256+(penrow) into hl
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,email		;Loads E-Mail String
	call	_vputs			;Sends to screen
	ld	hl,23*256+0		;Load (_penCol)*256+(penrow) into hl
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,website		;Loads Website string
	call	_vputs			;Sends to screen
	ld	hl,30*256+0
	ld	(_penCol),hl
	ld	hl,sp10x
	call	_vputs
	ld	hl,37*256+35		;Load (_penCol)*256+(penrow) into hl
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,MenuString		;Loads MenuString
	call	_vputs			;Sends to screen
	ld	hl,44*256+20		;Load (_penCol)*256+(penrow) into hl
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,EasyString		;Loads EasyString
	call	_vputs			;Sends to screen
	ld	hl,51*256+20		;Load (_penCol)*256+(penrow) into hl
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,MediumString		;Loads MediumString
	call	_vputs			;Sends to screen
	ld	hl,57*256+20		;Load (_penCol)*256+(penrow) into hl
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,HardString		;Loads HardString
	call	_vputs			;Sends to screen
	ret				;Return to where it was called from (init)
	

TitleGetkey:
	halt				;Saves memory during getkey
	call	_getkey			;Check for a keypress
	cp	01dh			;Is the key 1?
	jp	z,easy			;Goto Easy
	cp	01eh			;Is the key 2 ?
	jp	z,medium		;Goto Medium
	cp	01fh			;Is the key 3
	jp	z,hard			;Goto Hard
	cp	007h			;Is the key Exit ?
	jp	z,quit			;If so, goto Quit
	jp	nz,TitleGetkey

easy:				;Sets Easy Getkey Level
	ld	a,60		;Stores 60 to A
	ld	(getvar),a	;Stores a to GetVar
	ld	a,90
	ld	(fuel),a	;Stores Fuel
	jp	gameinit	;Goes to GameInit

medium:				;Sets Medium GetKey Level
	ld	a,20		;Stores 20 to A
	ld	(getvar),a	;Stores a to GetVar
	ld	a,50
	ld	(fuel),a	;Stores Fuel
	jp	gameinit	;Goes to GameInit

hard:				;Sets Hard GetKey Level
	ld	a,10		;Stores 10 to A
	ld	(getvar),a	;Stores a to GetVar
	ld	a,30
	ld	(fuel),a	;Stores Fuel 
	jp	gameinit	;Goes to GameInit

		
dispLander:
	ld	a,(temp)
	cp	0
	jp	z,noLander
	jp	nz,yesLander
	
noLander:
	ld	a,1
	ld	(temp),a
	ld	a,(landy)
	ld	e,a
	ld	a,(landx)
	ld	hl,SHIP
	call	PutSprite
	ret

yesLander:
	ld	a,0
	ld	(temp),a
	ld	a,(landy)
	ld	e,a
	ld	a,(landx)
	ld	hl,SHIP
	call	CLRSPR
	ret


gameinit:
	ld	a,0
	ld	(temp),a
	call	_clrLCD		;Clear Screen
	call	putBG		;Puts the background
	call	random		;Calls routine that creates Random Init
	call	dispPlat	;Calls routine to display Platform
	ld	a,45		;Load 45 into a
	ld	(landx),a	;Load a into Lander X
	ld	a,10		;Load 10 into a
	ld	(landy),a	;Load a into Lander Y
	ld	hl,0*256+0		;Load Coordinates
	ld	(_penCol),hl		;Into _penCol
	ld	hl,fuelstring		;Load "Fuel"
	call	_vputs			;Send to Screen
	jp	MainLoop

dispFuel:
	ld	hl,0*256+20
	ld	(_penCol),hl
	ld	hl,blank
	call	_vputs
	ld	hl,0*256+20
	ld	(_penCol),hl
	ld	a,(fuel)
	call	DispA
	ret

;-----Display Routine [By: SCaBBy]-----
DispA:
 ld l,a
 ld h,0
DispHL:					;dipslay 5 digits from hl
 xor a
 ld de,-1
 ld (_curRow),de
 call 4A33h
 dec hl
 jp _vputs



MainLoop:
	call	dispFuel
	call	dispLander		;Displays Lander
	jp	chklocation		;Goto CheckLocation
	
MainLoop1:
	call	Delay
 	jp	movegkey		;Gets Key

Delay:
	PUSH AF
	PUSH BC
	LD BC, $2000
DelayLoop:
	DEC BC
	LD A, B
	OR C
	JR NZ, DelayLoop
	POP BC
	POP AF
	RET

movegkey:
	halt
	call	GET_KEY
	cp	K_RIGHT			;If key is right
	jp 	z,left			;Goto left
	cp 	K_LEFT			;If key is left
	jp 	z,right			;Goto right
	cp 	K_DOWN			;If key is down
	jp 	z,down			;Goto Down
	cp	K_UP			;Up?
	jp	z,up			;Goto Up
	cp 	K_EXIT			;If key is clear
	jp 	z,quit			;Goto Quit
	cp	K_MORE			;More?
	jr	z,QuickPause		;Pause
	jp	nz,automove		;Goto Automove if no key

QuickPause:
	call	_getkey
	jp	movegkey

;Automatically Moves Ship

automove:
	ld	a,(auto)		;Loads AutoVariable into a
	inc	a			;Increases it
	ld	(auto),a		;Loads A back into AutoVariable
	call	_setxxop1		;Stores into OP1
	ld	a,(getvar)		;Loads GetVar into A
	call	_setxxop2		;Stores it into OP2
	call	_cpop1op2		;Compare Op1 w/Op2 
	jp	nz,movegkey		;If it is not 0, goto Movekey
	call	dispLander		;Remove Lander off the screen
	ld	a,(fuel)
	dec	a
	ld	(fuel),a
	cp	0
	jp	z,outofuel
	ld	a,0			;Reset Auto Variable
	ld	(auto),a
	ld	a,(landy)		;Loading Lander Y into A
	inc	a			;Increasing it
	ld	(landy),a		;Store Back to A
	ld	a,(landy)		;Check Y Coordinate
	cp	43			;Below the platform?
	jp	z,out
	jp	MainLoop		;Start over!

;Update if you press key

left:
	call	dispLander		;Clear sprite
	ld	a,(landx)
	dec	a			;Decrease A
	ld	(landx),a		;Reload A into LandX
	cp	0			;If X is going out
	jp	z,out			;Goto Out
	ld	a,(fuel)
	dec	a
	ld	(fuel),a
	cp	0
	jp	z,outofuel
	ld	a,(landy)		;Check Y Coordinate
	cp	60			;Below the platform?
	jp	z,out
	jp	nz,MainLoop
	
right:
	call	dispLander		;Clear sprite
	ld	a,(landx)
	inc	a			;Increase A
	ld	(landx),a		;Load A back into LandX
	cp 	120			;If it is 112
	jp	z,out			;Goto out
	ld	a,(fuel)
	dec	a
	ld	(fuel),a
	cp	0
	jp	z,outofuel
	ld	a,(landy)		;Check Y Coordinate
	cp	60			;Below the platform?
	jp	z,out
	jp	nz,MainLoop

down:
	call	dispLander		;Again clear sprite
	ld	a,(landy)		;Load YCoord into A
	dec	a			;Decrease it
	ld	(landy),a		;Put it into LANDY
	cp	7			;If you are at 7
	jp	z,out			;Goto Out
	ld	a,(fuel)
	dec	a
	ld	(fuel),a
	cp	0
	jp	z,outofuel
	cp	60			;Below the platform?
	jp	z,out
	jp	nz,MainLoop

up:
	call	dispLander		;Again clear sprite
	ld	a,(landy)		;Load YCoord into A
	inc	a			;Increase it
	ld	(landy),a		;Put it into LANDY
	cp	60			;Below the platform?
	jp	z,out
	jp	nz,MainLoop

out:
	call	_clrLCD	
	ld	hl,30*256+5		;Load hl,30 (_penCol) and 5 (PENROW), *256 is a must
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,outt			;Load string
	call	_vputs			;Terminate String to screen
	call	Pause			;Call Pause Loop
	ret

outofuel:
	call	_clrLCD
	ld	hl,30*256+5
	ld	(_penCol),hl
	ld	hl,outoffuel
	call	_vputs
	call	Pause
	ret

random:				;Gives the Platform a Random Location
	call	_RANDOM
	ld	a,80		;Maximum Random Number
	call	_setxxop2	;Stores it to Op2
	call	_fpmult		;Multiplies Op1*Op2 -> Op1
	call	_convop1	;Converts Op1 to E
	ld	a,e		;Loads E into A
	ld	(platx),a	;Loads A into Variable
	ret			;Returns to CallLocation

dispPlat:
	ld	a,45		;Loads Y Coordinate Into A
	ld	e,a		;Loads A into E
	ld	a,(platx)	;Loads PlatformX Coordinate into A
	ld	hl,platform	;Load Sprite Name in HL
	call	PutSprite	;Put the Sprite
	ret			;Return

chklocation:			;Checks your Location =)
	ld	a,(landy)	;Checks Y Coordinate
	cp	42		;If 45
	jp	nz,MainLoop1	;If it is not 45, goto MainLoop1
	ld	a,(landx)	;Otherwise, begin comparing #'s
	call	_setxxop1	;Store LandX to Op1
	ld	a,(platx)	;Store PlatformX into A
	call	_setxxop2	;Then into Op2
	call	_cpop1op2	;Check Op1 vs. op2
	jp	z,safteyland	;Numbers are equal ?  You land saftley!
	jp	nz,chkloc1	;No?  Try something else ...

chkloc1:
	ld	a,(landx)	;Lander X into A
	call	_setxxop1	;Op1
	ld	a,(platx)	;PlatForm X
	inc	a		;Increase A
	call	_setxxop2	;Into Op2
	call	_cpop1op2	;Compare Op1/2
	jp	z,safteyland	;Equal?  Landed Saftley
	jp	nz,chkloc2	;No ? Check another one ...

chkloc2:
	ld	a,(landx)
	call	_setxxop1
	ld	a,(platx)
	inc	a
	inc	a
	call	_setxxop2
	call	_cpop1op2
	jp	z,safteyland
	jp	nz,chkloc3

chkloc3:
	ld	a,(landx)
	call	_setxxop1
	ld	a,(platx)
	dec	a
	call	_setxxop2
	call	_cpop1op2
	jp	z,safteyland
	jp	nz,chkloc4

chkloc4:
	ld	a,(landx)
	call	_setxxop1
	ld	a,(platx)
	dec	a
	dec	a
	call	_setxxop2
	call	_cpop1op2
	jp	z,safteyland
	jp	nz,crash

crash:
	call	_clrLCD
	ld	hl,30*256+20		;Load hl,30 (_penCol) and 20 (PENROW), *256 is a must
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,crashburn		;Load string
	call	_vputs			;Terminate String to screen
	call	Pause			;Call Pause Loop
	ret

safteyland:
	call	_clrLCD
	ld	hl,30*256+20		;Load hl,30 (_penCol) and 5 (PENROW), *256 is a must
	ld	(_penCol),hl		;Load hl into _penCol
	ld	hl,landstr		;Load string
	call	_vputs			;Terminate String to screen
	call	Pause			;Call Pause Loop
	ret		

quit:
	call	_clrLCD		;Clear Screen
	ret			;Return to Basic Mode

Pause:
	call	_getkey
	cp	006h
	jp	nz,Pause
	ret
	
putBG:
	LD DE,$FC00
	LD BC,1024			
	LD HL,PIC_LANDER	;Name of the Picture
	ldir			;Put it on the Screen!
	ret			;Return to Call Location


;hl = image
;a = x coord
;e = y coord

PutSprite:
       push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$FC00
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp	0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP
        pop     de

        ld      a,b             ; Write line to graphbuf
        or      (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        or      (hl)
        ld      (hl),a

        ld      bc,15           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP        ; Next line

        jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        or      (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,16
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
        ret
; SPRITE 

; CLRSPR
;
;
;Ŀ
; Blit or erase sprite  a=x, e=y, hl=sprite address                         
;
;
CLRSPR:
        push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$FC00
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN2


;   Non aligned sprite erase starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP2: ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP2: srl     b
        rr      c
        dec     d
        jp      nz,SHLOP2
        pop     de

        ld      a,b             ; Write line to graphbuf
        cpl
        and     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        cpl
        and     (hl)
        ld      (hl),a

        ld      bc,15           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP2       ; Next line

        jp      DONE5


;   Aligned sprite erase starts here   

ALIGN2:                         ; Erase an aligned sprite in graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP2:  ld      a,(de)
        cpl
        and     (hl)
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,16
        add     hl,bc
        pop     bc
        djnz    ALOP2

DONE5:
        ret
; CLRSPR
;





#include "lander.asm"


;-----------------------------------------------------

SHIP:
   	.db %00011000
   	.db %00100100
   	.db %00100100
   	.db %00100100
   	.db %01000010
   	.db %01011010
   	.db %11100111
   	.db %00011000

platform:
	.db %00000000
	.db %00000000
	.db %10000001
	.db %11000011
	.db %11100111
	.db %11111111
	.db %11111111
	.db %11111111

;----------------------------- Variables ----------------------------------------

getvar:	.db	0			;Define Difficulty Variable, for Getkey
platx:	.db	0			;Define PlatForm X coord
landx:	.db	0			;Define Lander X
landy:	.db	0			;Define Lander Y
auto:	.db	0			;Define AutoVariable (For GetkY)
fuel:	.db	0			;Define Fuel Variable
temp:	.db	0			;Define Temp Variable

;----------------------------- Text Strings --------------------------------------

Title:		.db	"Lunar Lander II By : ARE",0
titlestring:	.db	"Lunar Lander II",0
author:		.db	"By: Ahmed El-Helw",0
email:		.db	"ahmed3@worldnet.att.net",0
sp10x:		.db	"Thanks to AVD and Movax",0
website:	.db	"http://asm86.home.ml.org",0
MenuString:	.db	"Menu",0
EasyString:	.db	"Press 1 for Easy",0
MediumString:	.db	"Press 2 for Medium",0
HardString:	.db	"Press 3 for Hard",0
outt:		.db	"You got sucked out of orbit!",0
landstr:	.db	"You Landed Saftley!",0
crashburn:	.db	"Crash and Burn =(",0
outoffuel:	.db	"You ran out of fuel!",0
fuelstring:	.db	"Fuel:",0
blank:		.db	"     ",0

;--------------------------- End Text Strings --------------------------------------

.end 
END
