.include "crash82.inc"
.db "Lines",0

    set 7,  (IY+$14)    ; mini text drawn to GRAPH_MEM
	
	ld	a,	8
	ld	(speed),a
	
	ld	(saved_sp),sp
	
	ld	a,	(saved_game_flag)
	or	a
	jr	nz,	restore_game
; reset score
	xor	a
	ld	a,	(score)

; clear board
	ld	hl,	board
	ld	(hl),	0
	ld	de,	board+1
	ld	bc,	80
	ldir

	call	get_next
	call	place_next
	
restore_game:
	ld	bc,	0
play_game:
start_over:	
	push	bc
        ld	a,	(line_flag)
        or	a
        call	z,	get_next
	pop	bc
	call	select_start
	call	move_ball
        push	bc
	ld	a,	$FF		; start at -1
	ld	(length_new_list),a
        call	check_for_lines
        call	remove_tiles
        ld	a,	(line_flag)
        or	a
        call	z,	place_next		; lines checked in place_next
        pop	bc
        jr	start_over
        ret

select_start:          
          xor	a			; dont' flash the tile
          ld        (start_flag),a
          
          call      get_square

new_start:          
          call	get_board_piece		; make sure that they selected a piece
          ld	a,	(hl)
          cp	0
          jr	z,	select_start
          
          ld	(placed_tile),	a
          ld        hl,       start     ; save start position
          ld        (hl),     b
          inc       hl
          ld        (hl),     c
                    
          ld        a,        1         ; flash that tile
          ld        (start_flag),a

select_goal:          
          
          call      get_square
	
          call	get_board_piece		; make sure they didn't select a piece
          ld	a,	(hl)
          or	a
          jr	nz,	new_start
          
	push	bc
	call	make_table
        pop	bc
        ld	a,	(table_flag)
        or	a
        jr	z,	select_goal
  	  
          ret

.include "SPR30AX.inc"          ; sprite routines
.include "variable.asm"          ; declares all the variables
.include "sprites.asm"            ; routines to draw the balls
.include "select.asm"        
.include "pathfind.asm"
.include "check.asm"
.include "DM_DECI.asm"
.include "help.asm"

;==========================================
clear_graph_mem:
;
; input:
; output:   graph_mem cleared
;===========================================
    ld  hl, GRAPH_MEM
    ld  de, GRAPH_MEM+1
    ld  (hl),   0
    ld  bc, 767
    ldir
    ret

;=========================================
delay:
;
; input:    (speed)
; output:   program delayed a little bit
;===========================================
    ld  a,        (speed)      
    ld  b,  a
_short_delay:
    halt
    djnz    _short_delay
	ret
;=============================================
game_over:
	call	draw_stripe
	ld	hl,	27 *256+ 30
	ld	(GRAF_CURS),hl
	
          set 3,  (IY+$05)                        ; inverted text
          ld        hl,       game_over_str       ; ask if they want to quit
          ROM_CALL(D_ZM_STR)                      ; disp the string
          call      CR_GRBCopy             

	call	wait_key
	call	exit_main
game_over_str:
	.db	"Game Over",0

;==================================================
sure_quit:
;
; input:  none
; output  To quit or not to quit, that is the question
;==================================================
	push	bc
          
          call	draw_stripe
          ld        hl,       24 *256+ 4          ; x = 4, y = 24
          ld        (GRAF_CURS),hl                ; load the cursor
          
          set 3,  (IY+$05)                        ; inverted text
          ld        hl,       quit_str            ; ask if they want to quit
          ROM_CALL(D_ZM_STR)                      ; disp the string
          
          ld        de,       31 *256+ 54         ; x = 6, y = 31
          ld        (GRAF_CURS),de
          ROM_CALL(D_ZM_STR)
          
          ld        de,       31 *256+ 10          ; x = 6, y = 31
          ld        (GRAF_CURS),de
          ROM_CALL(D_ZM_STR)
          res 3,  (IY+$05)                        ; normal text
          call      CR_GRBCopy             
          
sure_quit_loop:
          call	wait_key
          cp        G_MODE
          call      z,        exit_main
          cp        G_2ND
          jr        nz,        sure_quit_loop

;          call      clear_graph_mem
          pop	bc
          ret

draw_stripe:
          ld        hl,       GRAPH_MEM + (23*12) ; row 23
          ld        de,       GRAPH_MEM + (23*12+1); next byte
          ld        bc,       12 *16- 1           ; color 16 rows
          ld        (hl),     $FF                 ; load black into all the bytes
          ldir                                    ; block copy
          ret

wait_key:
          halt
          call      GET_KEY                       ; a = key
          cp        G_NONE
          jr        z,        wait_key
	  ret
quit_str:
  .db "Do you really want to quit?",0
  .db "MODE - Yes",0
  .db "2ND - No",0

;==================================================
exit_main:
; 
; input:  (saved_sp)
; output: returned back to where main function was called
;===================================================
          xor	a
          ld	(saved_game_flag),a		; don't save the game
          ld        sp,       (saved_sp)
          ret


