
;===================================
move_ball:
;
; input: 	path_board
; output:	the ball is moved to the goal
;===================================
	ld	a,	(start)
	ld	b,	a
	ld	a,	(start+1)
	ld	c,	a
		
	ld	hl,	path_board
	call	row_col_to_address
	ld	a,	(hl)		; a = the number we are on in path_board

	push	af
	ld	hl,	board
	call	row_col_to_address
	ld	e,	(hl)		; e = the tile that we are moving
	pop	af

path_loop:
	
	ld	(hl),	0
	
	call	find_direction

	push	de
	push	bc
	push	af
	
	ld	hl,	board
	call	row_col_to_address
	ld	(hl),	e
	push	hl
	call	clear_graph_mem
	call	draw_screen
	call	CR_GRBCopy
	call	delay
	pop	hl
	pop	af
	pop	bc
	pop	de
	
	cp	1			; if we get to number 1 then we are done
	jr	nz,	path_loop
	ret

;===================================
find_direction:
;
; input:	bc = current_row and col
; output:	bc = next place to go
;		a = the value that we are at
;===================================
	dec	a

;check up	
	dec	b			; row ^
	call	check_direction
	ret	z
;right
	inc	b			; row v / col >
	inc	c
	call	check_direction
	ret	z
;down
	inc	b			; row v / col <
	dec	c
	call	check_direction
	ret	z
;left:
	dec	b			; row ^ / col <
	dec	c
	ret

;=========================================
check_direction:
;
; input:	a = value of whats were looking for
; output:	z flag = move here
;		nz flag wrong place
;=========================================
	push	af
	call	on_board
	jr	nc,	dir_not_on_board
	
	ld	hl,	path_board
	call	row_col_to_address
	ld	d,	(hl)
	pop	af
	cp	d
	ret

dir_not_on_board:	
	pop	af
	cp	$FF			; zero flag not set	
	ret

;===================================
make_table:
;
; input:	bc = row and collumn of goal
;		board
; output:	path_board
;		(table_flag) 1 = possible, 0 = unreachable
;===================================

	
	
	ld	a,	0
	ld	(table_done),a
	ld	(table_flag),a
	ld	a,	$FF
	ld	(length_new_list),a
	ld	a,	1
	ld	(distance_from_goal),a
	push	bc
	call	copy_board
	pop	bc			; restore goal row and col
	
	call	add_to_list		; add the goal to the list and 
					;  put a 1 there
	call	copy_new_list

make_table_loop:
	ld	a,	(distance_from_goal)
	inc	a
	ld	(distance_from_goal),a
	
	call	complete_level
	
	ld	a,	(table_done)
	or	a
	jr	z,	make_table_loop
	
	ret


;==================================
copy_board:
;
; input:	board
; output:	path_board = board (0 -> 0, non-zero -> $FF)
;===================================	
	
	ld	hl,	board
	ld	de,	path_board
	ld	b,	81

copy_loop:	
	ld	a,	(hl)
	or	a
	jr	z,	copy_zero
	
	ld	a,	$FF
copy_zero:
	ld	(de),	a
	inc	hl
	inc	de
	djnz	copy_loop
	ret
	
;=======================================
complete_level:
;
; input:	length_list
;		list
;		distance_from_goal
; output:	level is complete
;=======================================

	ld	a,	$FF
	
	ld	(length_new_list),a
	
	ld	a,	(length_list)
	inc	a			; now length starts at 1 for 1
	ld	b,	a
	ld	hl,	list
complete_level_loop:
	push	bc
	push	hl
	

	ld	b,	(hl)
	inc	hl
	ld	c,	(hl)
	
	call	add_possible_to_list
	
	call	are_we_there_yet
	
	pop	hl
	inc	hl
	inc	hl
	pop	bc
	
	ld	a,	(table_done)
	cp	0
	ret	nz				; return if the table is done
	
	djnz	complete_level_loop
	
	ld	a,	(length_new_list)	; if length_new_list > 0
	cp	$FF				;  then copy_new_list then ret
	jr	nz,	copy_new_list		;  else table_done = 1
	
	ld	a,	1
	ld	(table_done),a
	ret

;========================================
are_we_there_yet:
;
; input:	bc = row and col of where we are now
;		(start) = row and col of where there is
; output:	(table_done) and (table_flag) updated
;========================================
	
	ld	a,	(start+1)
	cp	c
	ret	nz
	
	ld	a,	(start)
	cp	b
	ret	nz
	
	ld	a,	1
	ld	(table_done),a
	ld	(table_flag),a
	ret

;========================================
copy_new_list:
;
; input:	new_list
; output:	list = new_list
;=========================================

;	call	remove_tiles
	
	ld	hl,	new_list
	ld	de,	list
	ld	bc,	81*2
	ldir
	
	ld	a,	(length_new_list)
;	push	af
;	ld	hl,	$0000
;	ld	(CURSOR_POS),hl
;	ld	l,	a
;	ROM_CALL(D_HL_DECI)
;	call	CR_KHAND
;	pop	af
	ld	(length_list),a
	ret


;====================================
add_possible_to_list:
;
; input:	bc = row and col
; output:	possible entries added to end of new_list if on board
;		length_new_list updated
;====================================
;add_up	
	dec	b			; row ^
	call	add_to_list
	
;add_right
	inc	b			; row v / col >
	inc	c
	call	add_to_list

;add_down
	inc	b			; row v / col <
	dec	c
	call	add_to_list

;add_left:
	dec	b			; row ^ / col <
	dec	c
	call	add_to_list
	ret

;====================================
add_to_list:
;
; input:	bc = row and col to add
;		length_new_list = length of end of list
; output:	bc added to end of list if on board and its a valid spot
;		length_new_list updated
;=====================================
	call	on_board		; return if not on the board
	ret	nc

	call	are_we_there_yet
	push	af
	ld	hl,	path_board
	call	row_col_to_address
	pop	af
	jr	z,	we_are_there
	
	ld	a,	(hl)
	or	a
	ret	nz			; if tile at row and col is not zero
					;  then don't add it to the list
we_are_there:
	ld	a,	(distance_from_goal) ; put the distance from goal there
	ld	(hl),	a
	

add_bc_to_new_list:
	ld	a,	(length_new_list) ; add bc to the end of the list
	inc	a
	ld	(length_new_list),a
	
	add	a,	a
	ld	e,	a
	ld	d,	0
	ld	hl,	new_list
	add	hl,	de
	ld	(hl),	b
	inc	hl
	ld	(hl),	c
	
	ret	

;====================================
on_board:
;
; input:	bc = row and col
; output:	nc = not on board
;		c = on board (0-8)
; destroy:	a
;====================================
	ld	a,	b
	cp	9
	ret	nc
	ld	a,	c
	cp	9
	ret
	
