;========================================
remove_tiles:
;
; input:	(new_list)
; output:	all spots in new list removed and animated
;=========================================
	xor	a
	ld	(line_flag),a
	
	ld	a,	(length_new_list)
	cp	$FF
	ret	z

	ld	hl,	(high_score)
	push	hl
	pop	de
	
	inc	a
	ld	c,	a
	ld	b,	5
	sub	b
	add	a,	c
	
	ld	c,	a		; bc = score to add
	ld	b,	0
	ld	hl,	(score)		
	add	hl,	bc
	ld	(score),hl

	call	CP_HL_DE
	jr	c,	not_high_score
	ld	(high_score),hl
not_high_score:
	ld	a,	1
	ld	(line_flag),a
	ld	a,	6
	ld	(explode),a

	ld	b,	2			; explode sequence is 2 frames
explode_loop:	
	push	bc
	
	ld	a,	(length_new_list)
	ld	b,	a
	inc	b
	ld	hl,	new_list
remove_tiles_loop:
	push	bc
	
	ld	b,	(hl)
	inc	hl
	ld	c,	(hl)
	inc	hl
	
	push	hl
	ld	hl,	board
	call	row_col_to_address
	ld	a,	(explode)
	ld	(hl),	a
	pop	hl
	pop	bc
	djnz	remove_tiles_loop
	
	call	draw_screen
	call	CR_GRBCopy
	call	delay
	
	xor	a			; turn them to zero
	ld	(explode),a
	
	pop	bc
	djnz	explode_loop
	ret
	
;========================================
check_for_lines:
;
; input:	bc = place to check from
; output:	score updated
;========================================
	
	ld	hl,	check_table
	ld	a,	4		; loop four times
check_lines_loop:
	push	af
	push	hl
	
	push	bc
	call	LD_HL_MHL		; hl = (hl)
	pop	bc
	push	bc
	call	check_for_line
	pop	bc
	
	pop	hl
	inc	hl
	inc	hl
	pop	af
	dec	a
	jr	nz,	check_lines_loop
	
	ret
	

check_table:
	.db 1,0		; up
	.db 1,1		; up-right
	.db 0,1		; right
	.db -1,1	; down-right 

;========================================
check_for_line:
;
; input		hl = row and collumn adder
;		bc = place to check from
;		(placed_tile) = tile at bc
; output:	list updated, length_list updated
;		score updated
;========================================

find_end:				; find the end of the line	
	push	hl
	ld	a,	h		; b = h + b
	add	a,	b
	ld	b,	a
	ld	a,	l		; c = l + c
	add	a,	c
	ld	c,	a
	
	ld	hl,	board
	call	row_col_to_address
	ld	d,	(hl)
	ld	a,	(placed_tile)
	pop	hl
	ld	e,	a
	call	on_board
	jr	nc,	found_end
	ld	a,	e
	cp	d
	jr	z,	find_end
					; bc = one after the end
found_end:	
	ld	a,	h
	neg	
	ld	h,	a
	ld	a,	l
	neg	
	ld	l,	a
	
	ld	a,	(length_new_list)	; save length in case it isn't a line
	ld	(length_list),	a

	ld	a,	$FF			; start with -1 in the line
	ld	(size_line),	a		; cause the first doesn't count

find_other_end:				; find the other end of the line	
	push	hl
	ld	a,	h		; b = h + b
	add	a,	b
	ld	b,	a
	ld	a,	l		; c = l + c
	add	a,	c
	ld	c,	a
	
	ld	a,	(size_line)
	inc	a
	ld	(size_line),a
	
	call	add_bc_to_new_list		; add it to 
						;  the new list
	ld	hl,	board
	call	row_col_to_address
	ld	d,	(hl)
	ld	a,	(placed_tile)
	pop	hl
	ld	e,	a
	call	on_board
	jr	nc,	found_other_end
	
	ld	a,	e
	cp	d
	jr	z,	find_other_end
found_other_end:	
	ld	a,	(size_line)
	cp	5		
	jr	nc,	keep_line	; if there is a line then keep it

	ld	a,	(length_list)
	ld	(length_new_list),a	; reset the list to what it was
	ret

keep_line:
	ld	a,	(length_new_list)	; loop went one beyond end of 
	dec	a				; line so erase it
	ld	(length_new_list),a
	ret

;========================================
is_board_full:
;
; input:	board
; output:	call	game over if the board is full
;		nz flag = full
;========================================
	ld	b,	81		; check 81 squares
	ld	hl,	board		; check from board
	ld	a,	0
is_board_full_loop:
	cp	(hl)
	ret	z
	inc	hl
	djnz	is_board_full_loop
	call	draw_screen		; put the balls on the screen so can tell
	call	game_over		; that you really lost
	ret

;========================================
get_next:
;
; input:	none
; output:	(next) has three random balls in it
;========================================

	ld	b,	3
	ld	hl,	next
get_next_loop:
	push	hl
	push	bc
	call	RAND
	and	%00000111		; a = [0,8]
	cp	5
	pop	bc
	pop	hl
	jr	nc,	get_next_loop
	inc	a
	ld	(hl),	a
	inc	hl
	djnz	get_next_loop
	ret

;=========================================	
place_next:	
;
; input:
; output:	three balls placed in empty spots checked for lines
;==========================================
	
	ld	a,	$FF		; start at -1
	ld	(length_new_list),a
	
	ld	b,	3
	ld	de,	next

place_next_loop:
	push	bc
	push	de

already_tile_there:	
	call	rand_row_col
	ld	b,	a
	call	rand_row_col
	ld	c,	a
	ld	hl,	board
	call	row_col_to_address
	ld	a,	(hl)
	cp	0
	jr	nz,	already_tile_there
	
	pop	de
	ld	a,	(de)
	ld	(hl),	a
	inc	de
	push	de
	ld	(placed_tile),a
	call	check_for_lines
	call	is_board_full			; game over if board is full
	pop	de
	pop	bc
	djnz	place_next_loop
	
	call	remove_tiles
	ret
	
rand_row_col:
	push	bc
	call	RAND
	and	%00001111
	pop	bc
	cp	9
	jr	nc,	rand_row_col
	
	ret


