/*
Lunar Lander for ti85
(C) Tiger/Istar 1997 except landscape generator (C) Dape/Istar 1997
*/

char surface[128];

char x;
char y;
char vx;
char vy;
char key @ TEXT_MEM + 132;
char i @ TEXT_MEM + 133;
char k @ TEXT_MEM + 134;
char oldx;
char oldy;
char l @ TEXT_MEM + 137;
unsigned char control @ TEXT_MEM + 138;
unsigned char loop1 @ TEXT_MEM + 139;
unsigned char loop2 @ TEXT_MEM + 140;
unsigned char loop3 @ TEXT_MEM + 141;
int fuel;

int hiscore;
int score;
int maxfuel=40;
int maxvel=7;
char teacherkey=0;

/* lander module (looks baaaaad) */

unsigned char spr[8] = {
  bin2dec(00011010),
  bin2dec(00111111),
  bin2dec(01001010),
  bin2dec(11111110),
  bin2dec(01111110),
  bin2dec(00100100),
  bin2dec(01000010),
  bin2dec(11100111),
  };

/****************/
/* main program */
/****************/

void main()
{
while(1)    /* main() loop */
    {
    if(teacherkey!=0)
        goto _resumegame;
    if(score>hiscore)
        hiscore=score;


    clrscr();
    invtext();
    goto_xy(0);
    prints("Lunar Lander 85  v1.1");
    goto_xy(1);
    prints("   (C) Istar 1997    ");
    normtext();
    goto_xym(0x1100);
    printsm("2nd - start   Exit - quit");
    goto_xym(0x1800);
    printsm("Arrows - settings");
    goto_xym(0x2000);
    printsm("Hiscore:");
    goto_xym(0x2030);
    printdm(hiscore);
    goto_xym(0x2700);
    printsm("Last score:");
    goto_xym(0x2730);
    printdm(score);
    goto_xym(0x2E00);
    printsm("Max fuel:");
    goto_xym(0x3500);
    printsm("Max speed:");
    _restart:
    goto_xym(0x2E30);
    printdm(maxfuel);
    goto_xym(0x3530);
    printdm(maxvel);

    while(1)
        {
        key=getch();
        if(key==K_EXIT)
            return;       /* if exit pressed terminate program */
        if(key==K_SECOND)
            break;        /* otherwise start game */
        if(key==K_LEFT && maxfuel>30)
            {
            maxfuel--;
            goto _restart;
            }
        if(key==K_RIGHT && maxfuel<80)
            {
            maxfuel++;
            goto _restart;
            }
        if(key==K_UP && maxvel<7)
            {
            maxvel++;
            goto _restart;
            }
        if(key==K_DOWN && maxvel>3)
            {
            maxvel--;
            goto _restart;
            }
        }

    score=0;
    oldx=0;

    while(oldx!=-1)
        {
        vx=0;
        vy=0;
        x=32+abs(rand()>>9);
        oldx=x;
        y=63;
        oldy=y;
        fuel=maxfuel;

/*        for(loop1=0;loop1<128;loop1++)
            surface[loop1]=16+abs(rand()>>11);   */

/* landscape generator */

  surface[0] = (rand()&0x1f)+(rand()&0x1f);
  if(surface[0]>32) surface[0]=32;
  for(loop1 = 1; loop1 < 128; loop1++) {
    k=surface[loop1-1]+(rand()&0x0f)-(rand()&0x0f);
    if(k>32) k = 32;
    if(k<0) k = 0;
    surface[loop1] = k;
    }
  /* Eroosio iskee */
  l = (rand()&0x0f)+2;
  for(k = 0; k < l; k++)
    for(i = 1; i < 128-1; i++) {
      surface[i] = (char)((int)(surface[i-1] + surface[i] + surface[i+1] + surface[i]))>>2;
      }

/* end of landscape generator */

        loop2=32+abs(rand()>>9);    /* 32...96 */
        loop3=surface[loop2]-4;

        for(loop1=loop2;loop1<loop2+10;loop1++)
            surface[loop1]=loop3;

_resumegame:
        clrscr();
        teacherkey=0;

        for(loop1=0;loop1<128;loop1++)
            for(loop2=0;loop2<surface[loop1];loop2++)
                pixel_change(loop1,loop2);

        for(loop1=0;loop1<=fuel;loop1++)
            pixel_change(loop1,63);

        sprx2(spr,8,x,63-y);

        while(1)    /* game loop */
            {
            vy--;   /* "gravitation" */

            control=0;
            control=getarrow();

            if((control&2)!=0 && fuel>0)
                {
                vx-=2;
                pixel_change(fuel,63);
                fuel--;
                }
            if((control&4)!=0 && fuel>0)
                {
                vx+=2;
                pixel_change(fuel,63);
                fuel--;
                }
            if((control&8)!=0 && fuel>0)
                {
                vy+=2;      /* that 2 to negate gravitation... */
                pixel_change(fuel,63);
                fuel--;
                }
            if((control&16)!=0)
                {
                teacherkey=1;
                clrscr();
                return;
                }
            if((control&64)!=0)
                {
                oldx=-1;
                break;
                }
            if((control&128)!=0)
                {
                delay(20);
                getch();
                }

            if(vx>0)    /* friction??? at moon??? */
                vx--;
            if(vx<0)
                vx++;

            if(vx>maxvel)
                vx=maxvel;
            if(vx<-maxvel)
                vx=-maxvel;
            if(vy>maxvel)
                vy=maxvel;
            if(vy<-maxvel)
                vy=-maxvel;

            x+=vx;
            y+=vy;

            sprx2(spr,8,oldx,63-oldy); /* erase old image of player's ship */

            oldx=x;
            oldy=y;

            sprx2(spr,8,x,63-y);

            if(y>63 || x<0 || x>120)
                {
                goto_xy(1026);
                invtext();
                prints("Out of screen!");
                normtext();
                delay(200);
                oldx=-1;
                break;
                }

            k=0;
            l=surface[x];
            for(i=x;i<x+8;i++)
                {
                if(surface[i]>y-9 && surface[i]==l && vy>=-3)
                    k++;
                else
                    if((surface[i]>y-9 && vy<-3) || (surface[i]>y-4))
                        {
                        goto_xy(1794);
                        invtext();
                        prints("Crash!!!");
                        normtext();
                        delay(200);
                        oldx=-1;
                        break;
                        }
                }

            if(k>6)
                {
                goto_xy(2);
                prints("The Hawk has landed!");
                delay(200);
                score+=(((90-maxfuel)*fuel)/maxfuel)*maxvel;  /* phew! */
                break;
                }

            delay(20);
            if(oldx==-1) break;

            }   /* end of game loop */

        } /*while(oldx!=-1);*/   /* end of newgame loop */

    }   /* end of main loop */

}
