#include "asm86.h"        ;We need this stuff for most programs
#include "ti86asm.inc"
#include "ti86abs.inc"
#include "old86.h"
EnemyX equ $C9FA;1
EnemyY equ $C9FB;1
PrevEX equ $C9FC;1
PrevEY equ $C9FD ;1
Ebackground equ $C9FE ;8
PAnimTimer equ $CA06;1
Anim equ $CA07;1
PlayerD equ $CA08;1
PlayerMove? equ $CA09;1
PrevPlayerX equ $CA0A;1
PrevPlayerY equ $CA0B;1
DataPointer equ $CA0C;2
ScrollX equ $CA0E;1
PlayerX equ $CA0F;1
PlayerY equ $CA10;1
Jump equ $CA11;1
EAnim equ $CA12;1
EnemyD equ $CA13;1
EAnimTimer equ $CA14;1
clipmask equ $CA15;1
rows2put equ $CA16;1
bitmask equ $CA17;1
PlayerBack equ $CA18;8
die equ $CA21;1
screen equ $CA22;1
.org _asm_exec_ram

	nop
	jp ProgStart
	.dw 0
	.dw ShellTitle

ShellTitle:
	.db "Hover Bug by Matt Teiken",0

ProgStart:
 call BUSY_OFF

 im 1          ;This is where we fix the down-left freeze
 ld hl,$D400   ;I didn't make this code
 ld de,$D401
 ld bc,$0100
 ld (hl),$D3
 ldir
 ld hl,int_handler
 ld de,$D3D3
 ld bc,int_end-int_handler
 ldir
 ld a,$D4
 ld i,a
 im 2
 jr donepatch

int_handler:
 ex af,af'
 ld a,($C1B4)   ;_CXCURAPP
 cp $1D
 jr c,int_ok
 cp $20
 jr nc,int_ok
 im 1
 jp $0039
int_ok:
 in a,($03)
 bit 3,a
 jp z,$0039
 res 0,a
 out ($03),a
 jp $0039
int_end:
donepatch:  ;We have just fixed it!
 call _flushallmenus		; close any open menus
 call _runindicoff			; turn off the run indicator
 call _clrScrn
 ld hl,$FC00
 ld de,$F600
 ld bc,1024
 ldir

 ld hl,Pic2					; point to RLE picture to display
 ld de,$fc00				; display picture in video memory
 call DispRLE				; decode and display the picture
	ld hl, $0506	; stores $00 in h, $00 in l
	ld (_curRow),hl	; stores 0 in _curRow, 0 in _curCol
	ld hl,Enter	; hl points to string Hello
	call _puts		; print the string

 ld hl,Pic1
 ld de,$f600
 call DispRLE

 call Grey
 ld a,$3C
 out (0),a


 call _clrLCD

 call _clrLCD
 ld hl,$FC00
 ld de,$C9FA
 ld bc,1024
 ldir;clear the graph memory too

 ld a,8
 ld (PlayerX),a ;Start the Player 8 pixels from the left side
 ld (PrevPlayerX),a
 ld (PlayerY),a ;and 8 pixels from the top
 ld (PrevPlayerY),a
 ld a,255 ;this will be incrimented to equal 0
 ld (ScrollX),a
 ld a,5
 ld (EnemyD),a

 xor a
 ld (PlayerMove?),a ;Did the player move?
 ld (Anim),a
 ld (PlayerD),a

 sbc hl,hl	
 ld (DataPointer),hl
 ld hl,(DataPointer)
 add hl,hl


 call InitialScroll
 call FirstPdisp

MainLoop:

 ld hl,$F600
 ld de,$FC00 ;load the backround into the video memory
 ld bc,1024
 ldir


 call dispPlayer
 call restoreEBack
 call dispEnemy
 call changeEAnim
 call MoveEnemy

 jp PlayerDead?
Pnotdead:;player isn't dead!
 xor a
 ld (die),a
 call Gravity
 call GetInput
 ld a,(die)
 cp 2
 jp z,BeatLevel
 cp 1
 jp z,Pdead

 ld a,$BF
 out (1),a
 nop
 nop
 in a,(1)
 bit 6,a
 jp z,Exit
 
 jp MainLoop

Grey:
 ld a,(screen)
 inc a
 ld (screen),a
 cp 3
 jp z,screen2

 call GET_KEY
 cp K_ENTER
 jp z,break

 ld a,$36
 out (0),a
 halt
 halt
 jp Grey
screen2:
 xor a
 ld (screen),a
 ld a,$3C
 out (0),a
 halt
 halt
 jp Grey

BeatLevel:
 call _clrLCD
	ld hl, $0002	; stores $00 in h, $00 in l
	ld (_curRow),hl	; stores 0 in _curRow, 0 in _curCol
	ld hl,Wow	; hl points to string Hello
	call _puts		; print the string

	ld hl, $0003	; stores $00 in h, $00 in l
	ld (_curRow),hl	; stores 0 in _curRow, 0 in _curCol
	ld hl,Beat	; hl points to string Hello
	call _puts		; print the string
 call _pause
 call _clrLCD
 call _homeup
 ret

PlayerDead?:; check if the player is dead!!!
 ld a,(PlayerY)
 cp 63
 jp p,Pdead

 ld a,(EnemyD)
 cp 5
 jp z,Pnotdead

 ld a,(PlayerX)
 ld d,a
 ld a,(PlayerY)
 ld e,a
 ld a,(EnemyX)
 ld h,a
 ld a,(EnemyY)
 ld l,a
 call Collision?
 cp 0
 jp nz,Pdead
 jp Pnotdead
Pdead:;player died!!!
 call dispPlayer
 ld hl,$F600
 ld de,$FC00
 ld bc,1024
 ldir
 call _clrLCD
	ld hl, $0002	; stores $00 in h, $00 in l
	ld (_curRow),hl	; stores 0 in _curRow, 0 in _curCol
	ld hl,hover	; hl points to string Hello
	call _puts		; print the string

	ld hl, $0003	; stores $00 in h, $00 in l
	ld (_curRow),hl	; stores 0 in _curRow, 0 in _curCol
	ld hl,invincible	; hl points to string Hello
	call _puts		; print the string

	ld hl, $0005	; stores $00 in h, $00 in l
	ld (_curRow),hl	; stores 0 in _curRow, 0 in _curCol
	ld hl,again	; hl points to string Hello
	call _puts		; print the string
 call _pause
 call _clrLCD
 call _homeup
 ret
Collision?:
 ld a,d
 cp 0
 jp nz,not0
 inc a
 ld d,a
not0:
 ld a,e
 cp 0
 jp nz,ynot0
 inc a
 ld e,a
ynot0:
;collision detection!!
 ld a,h
 sub 7
 ld c,a
 ld a,d
 cp c
 jp p,ContIntercept
 ld b,a
 xor a
 sub b
ContIntercept:
 jp p, cont2
 jp NoIntersect
cont2:
 ld a,h
 add a,7
 ld c,a
 ld a,d
 cp c
 jp p,NoIntersect

 ld a,l
 sub 7
 ld c,a
 ld a,e
 cp c
 jp p,ContIntercept2
 ld b,a
 xor a
 sub b
ContIntercept2:
 jp p, cont3
 jp NoIntersect
cont3:
 ld a,l
 add a,7
 ld c,a
 ld a,e
 cp c
 jp p,NoIntersect
Intersect:
 ld a,1
 ret
NoIntersect:
 xor a
 ret



MoveEnemy:
 ld a,(EnemyD)
 cp 5
 jp z,break
 ld a,(EnemyX)
 ld h,a
 ld a,(EnemyY)
 ld l,a
 ld a,(EnemyD)
 cp 0
 jp z,moveEright
 call CheckBlockLeft
 cp 0
 jp nz,ChangeED0

 ld a,(EnemyX)
 dec a
 ld (EnemyX),a
 cp 0;;;;
 jp z,EnemyDie
 ret
moveEright:
 call CheckBlockRight
 cp 0
 jp nz,ChangeED2
 ld a,(EnemyX)
 inc a
 ld (EnemyX),a
 cp 121
 jp z,EnemyDie
 ret

EnemyDie:
 call restoreEBack
 ld a,5
 ld (EnemyD),a
 ret

ChangeED0:
 xor a
 ld (EnemyD),a
 ret
ChangeED2:
 ld a,2
 ld (EnemyD),a
 ret

changeEAnim:
 ld a,(EAnimTimer)
 inc a
 ld (EAnimTimer),a
 cp 6
 jp nz,break
 xor a
 ld (EAnimTimer),a
 ld a,(EAnim)
 inc a
 ld (EAnim),a
 cp 2
 jp nz,break
 xor a
 ld (EAnim),a
 ret


ChangePAnim:
 ld a,(PAnimTimer)
 inc a
 ld (PAnimTimer),a
 cp 5
 jp nz,break
 xor a
 ld (PAnimTimer),a
 ld a,(Anim)
 cp 0
 jp nz,panim2
 inc a
 ld (Anim),a
 ret
panim2:
 xor a
 ld (Anim),a
 ret

dispPlayer:
 ld a,(PrevPlayerX)
 ld b,a
 ld a,(PrevPlayerY)
 ld c,a
 ld hl,PlayerBack ;Draw the old background
 call PutSprite
FirstPdisp:
 ld a,(PlayerD)
 ld b,a
 ld h,0
 ld a,(Anim)
 add a,b
 ld l,a
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl

 ld de,Player
 add hl,de

 ld a,(PlayerX)
 ld (PrevPlayerX),a
 ld b,a
 ld a,(PlayerY)
 ld (PrevPlayerY),a
 ld c,a
 ld de,PlayerBack
 call PutSprite_MSB
 ret


restoreEBack:
 ld a,(EnemyD)
 cp 5 ;if EnemyD = 5 then he's dead
 jp z,break
 ld a,(PrevEX)
 ld b,a
 ld a,(PrevEY)
 ld c,a
 ld hl,Ebackground ;Draw the old background
 call PutSprite
 ret
dispEnemy:
 ld a,(EnemyD)
 cp 5 ;if EnemyD = 5 then he's dead
 jp z,break
 ld b,a
 ld h,0
 ld a,(EAnim)
 add a,b
 ld l,a
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl

 ld de,EnemySprite
 add hl,de

 ld a,(EnemyX)
 ld (PrevEX),a
 ld b,a
 ld a,(EnemyY)
 ld (PrevEY),a
 ld c,a
 ld de,Ebackground
 call PutSprite_MSB
 ret

Gravity:
 ld a,(EnemyD)
 cp 5
 jp z,MPlayerDown
 ld a,(EnemyX)
 ld h,a
 ld a,(EnemyY)
 ld l,a
 call CheckBlockDown
 cp 0
 jp nz,MPlayerDown
 ld a,(EnemyY)
 inc a
 ld (EnemyY),a
 cp 63
 jp p,EraseE
 jp MPlayerDown
EraseE:
 call EnemyDie
MPlayerDown:
 call MoveDown
 ld a,(Jump);jump flag
 cp 0
 jp z,break
 dec a
 ld (Jump),a
 call MoveUp ;counteract gravity
 call MoveUp ;and move up
 ret


InitialScroll:
 ld e,0
InitialS2:
 push de
 call yepRightMore
 ld hl,$F600
 ld de,$FC00
 ld bc,1024
 ldir
 pop de
 ld a,e
 cp 127
 jp z,break
 inc e
 jp InitialS2



GetInput:
 xor a
 ld (PlayerMove?),a
CheckJump:
 ld a,$BF
 out (1),a
 nop
 nop
 in a,(1)
 bit 5,a	       ; Check if the 2nd key is being pressed
 jp nz,noJump  
 call Jump? ;player wants to jump.  can he?
 jp CheckRight
noJump:
 xor a
 ld (Jump),a

CheckRight:
 ld a,$FE
 out (1),a
 nop
 nop
 in a,(1)      
 bit 2,a	       ; Check if the right key is being pressed
 jp nz,CheckLeft
 call MoveRight
 jp CheckLeft
CheckLeft:
 ld a,$FE
 out (1),a
 nop
 nop
 in a,(1)      
 bit 1,a	       ; Check if the left key is being pressed
 jp nz,CheckAlpha
 call MoveLeft
CheckAlpha:
 ld a,$DF
 out (1),a
 nop
 nop
 in a,(1)
 bit 7,a	      
 jp nz,CheckUp
 call Hover
CheckUp:;can't do this anymore.  you have to jump
 ;ld a,$FE
 ;out (1),a
 ;nop
 ;nop
 ;in a,(1)      
 ;bit 3,a	      
 ;jp nz,break
 ;call MoveUp

 ld a,(PlayerMove?)
 cp 0
 jp nz,break
 xor a
 ld (Anim),a
 ret

Jump?:
 ld a,(Jump)
 cp 0
 jp nz,ContJump
 ld a,(PlayerX)
 ld h,a
 ld a,(PlayerY)
 ld l,a
 call CheckBlockDown
 cp 0
 jp z,break
 ld a,50
 ld (Jump),a
ContJump:
 dec a
 ld (Jump),a
 cp 0
 jp z,break
 ret

Hover:
 ld a,(Jump)
 cp 0
 jp z,break
 call MoveDown
 ret

MoveDown:
 ld a,(PlayerX)
 ld h,a
 ld a,(PlayerY)
 ld l,a
 call CheckBlockDown
 cp 0
 jp nz,break

 ld a,1
 ld (PlayerMove?),a;we moved!

 ld a,(PlayerY)
 cp 63
 jp z,break
 inc a
 ld (PlayerY),a
 ret
MoveUp:
 ld a,(PlayerX)
 ld h,a
 ld a,(PlayerY)
 ld l,a
 call CheckBlockUp
 cp 0
 jp nz,BreakJump;oops, he hit his head

 ld a,1
 ld (PlayerMove?),a;we moved!

 ld a,(PlayerY)
 cp 0
 jp z,BreakJump
 dec a
 ld (PlayerY),a
 ret
BreakJump:
 xor a
 ld (Jump),a
 ret

MoveLeft:
 ld a,(PlayerX)
 ld h,a
 ld a,(PlayerY)
 ld l,a
 call CheckBlockLeft
 cp 0
 jp nz,break

 ld a,2
 ld (PlayerD),a
 call ChangePAnim

 ld a,(PlayerX)
 cp 0
 jp z,break
 dec a
 ld (PlayerX),a

 ld a,1
 ld (PlayerMove?),a;we moved!
 ret

MoveRight: ;Player wants to move right
 ld a,(PlayerX)
 ld h,a
 ld a,(PlayerY)
 ld l,a
 call CheckBlockRight
 cp 0
 jp nz,break

 ld a,1
 ld (PlayerMove?),a;we moved!
 xor a
 ld (PlayerD),a;0=right
 call ChangePAnim

 ld a,(PlayerX)
 cp 56
 jp p,RightMore
norightmore:
 inc a
 ld (PlayerX),a
 ret
RightMore:
 ld hl,(DataPointer)
 ld de,8
 add hl,de
 ex de,hl
 ld hl,LevelData
 add hl,de
 ld a,(hl)
 cp 255
 jp nz,yepRightMore ;yep, more data to scroll onto the screen!
 ld a,(ScrollX)
 cp 7
 jp nz,yepRightMore

 ld a,(PlayerX)
 cp 120
 jp z,break
 inc a
 ld (PlayerX),a
 ret
yepRightMore:
 call MoveAllXvalues
 call ScrollR
 call NewColumn
 ret

MoveAllXvalues: ;hey, we scrolled. so now we need to move everything to the left
 ld a,(PrevPlayerX)
 dec a
 ld (PrevPlayerX),a
 ld a,(PrevEX)
 dec a
 ld (PrevEX),a
 ld a,(EnemyX)
 dec a
 ld (EnemyX),a
 ret

CheckBlockUp:
 ld a,l;(PlayerY)
 cp 0
 jp nz,checkBU2
 xor a
 ret
checkBU2:
 and 7
 jp nz,DontCheckUp
 ld a,l;(PlayerY)
 srl a
 srl a
 srl a
 dec a
 ld c,a
 ld a,(ScrollX)
 ld b,a
 ld a,h;(PlayerX)
 add a,b
 srl a
 srl a
 srl a
 inc a
 ld b,a
 push hl
 call CheckBlock
 pop hl
 call PassableBlock?
 cp 0
 jp nz,BlockedUp
;not done yet if player x isn't divisible by 8!
 ld a,(ScrollX)
 ld d,a
 ld a,h;(PlayerX)
 add a,d
 and 7
 cp 7
 jp z,DontCheckUp
 dec b
 call CheckBlock
 call PassableBlock?
 cp 0
 jp nz,BlockedUp
DontCheckUp: ;We aren't blocked
 xor a
 ret
BlockedUp: ;blocked, darn!
 ld a,1
 ret

CheckBlockDown:
 ld a,l;(PlayerY)
 cp 56
 jp p,DontCheckDown
 and 7
 jp nz,DontCheckDown
 ld a,l;(PlayerY)
 srl a
 srl a
 srl a
 inc a
 ld c,a
 ld a,(ScrollX)
 ld b,a
 ld a,h;(PlayerX)
 add a,b
 srl a
 srl a
 srl a
 inc a
 ld b,a
 push hl
 call CheckBlock
 pop hl
 call PassableBlock?
 cp 0
 jp nz,BlockedDown
;not done yet if player x isn't divisible by 8!
 ld a,(ScrollX)
 ld d,a
 ld a,h;(PlayerX)
 add a,d
 and 7
 cp 7
 jp z,DontCheckDown
 dec b
 call CheckBlock
 call PassableBlock?
 cp 0
 jp nz,BlockedDown
DontCheckDown: ;We aren't blocked
 xor a
 ret
BlockedDown:
 ld a,1
 ret


CheckBlockLeft:
 ld a,h;(PlayerX)
 and 7
 inc a
 ld b,a
 ld a,(ScrollX)
 ld c,a
 ld a,8
 sub c
 cp b
 jp nz,DontCheckLeft
 ld a,h;(PlayerX)
 srl a
 srl a
 srl a ;now a is the x value for the block we need to check
 ld b,a;this is the block x to the left
 ld a,l;(PlayerY)
 srl a
 srl a
 srl a
 ld c,a
 push hl
 call CheckBlock
 pop hl
 call PassableBlock?
 cp 0
 jp nz,BlockedLeft
;hey, wait, we aren't done yet!!  If the player's y-value isn't divisible by 8 then... 
 ld a,l;(PlayerY)
 and 7
 jp z,DontCheckLeft
 inc c
 call CheckBlock
 call PassableBlock?
 cp 0
 jp nz,BlockedLeft
DontCheckLeft: ;We aren't blocked
 xor a
 ret
BlockedLeft: ;damn, we're blocked.
 ld a,1
 ret

CheckBlockRight:
 ld a,h;(PlayerX)
 and 7
 inc a
 ld b,a
 ld a,(ScrollX)
 ld c,a
 ld a,8
 sub c
 cp b
 jp nz,DontCheckRight
 ld a,h;(PlayerX)
 srl a
 srl a
 srl a ;now a is the x value for the block we need to check
 add a,2
 ld b,a;this is the block x to the right
 ld a,l;(PlayerY)
 srl a
 srl a
 srl a
 ld c,a
 push hl
 call CheckBlock
 pop hl
 call PassableBlock?
 cp 0
 jp nz,BlockedRight
;hey, wait, we aren't done yet!!  If the player's y-value isn't divisible by 8 then... 
 ld a,l;(PlayerY)
 and 7
 jp z,DontCheckRight
 inc c
 call CheckBlock
 call PassableBlock?
 cp 0
 jp nz,BlockedRight
DontCheckRight: ;We aren't blocked
 xor a
 ret
BlockedRight: ; We ARE blocked
 ld a,1
 ret

PassableBlock?:
 cp 13
 jp z,dieflag
 cp 14
 jp z,dieflag
 cp 3
 jp z,door
 cp 20;the first 40 blocks are passable
 jp p,NotPassable
 xor a
 ret
NotPassable:
 ld a,1
 ret
dieflag:
 ld a,1
 ld (die),a
 xor a
 ret
door:
 ld a,2
 ld (die),a
 xor a
 ret


CheckBlock:  ;Inputs- 0<=b<=16, 0<=c<=8   output-a=block at (b,c)
 ld hl,LevelData
 ld de,(DataPointer)
 add hl,de
 ld a,16
 sub b
 add a,a
 add a,a
 add a,a
 ld e,a
 ld d,0
 sbc hl,de
 ld e,c
 add hl,de
 ld a,(hl)
 ret


NewColumn:
 ld e,0
 ld d,0
NewC2:
 ld a,e
 ld (temp),a
 ld hl,LevelData
 push de
 ld de,(DataPointer)
 add hl,de
 pop de
 add hl,de
 ld a,(hl) ;Here we have the block

 push hl
 push de
 push af
 call AddEnemy?
 pop af
 pop de
 pop hl

 call DrawPixels

 ld a,e
 cp 7
 jp z,break
 inc e
 jp NewC2 

DrawPixels:
 push de
 ld h,0
 ld l,a
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld hl,Sprites
 add hl,de
 call DrawSpriteClip
 pop de
 ret

DrawSpriteClip:
 push de
 ld e,0

DrawSC2:
 ld a,(temp)
 add a,a
 add a,a
 add a,a
 add a,e
 ld c,a

 push de
 push hl
 add hl,de
 ld a,(ScrollX)
 ld d,a
 ld a,(hl)
 call ShiftA
 bit 7,a
 jp z,nopixel
 call PixelOn
nopixel:
 pop hl
 pop de
 ld a,e
 cp 7
 jp z,doneSC
 inc e
 jp DrawSC2
doneSC:
 pop de
 ret

AddEnemy?:
 ld b,a
 ld a,(ScrollX)
 cp 7
 jp nz,break
 ld a,b
 cp 15
 jp z,add_15
 ret

add_15:
 call restoreEBack
 ld a,(temp)
 add a,a
 add a,a
 add a,a
 ld (EnemyY),a
 ld a,120
 ld (EnemyX),a 
 ld a,2
 ld (EnemyD),a
 call dispEnemy
 ld a,120
 ld (PrevEX),a
 ld a,(EnemyY)
 ld (PrevEY),a
 ret

temp:
.db 0
ShiftA:
Shift:
 push af
 ld a,d
 cp 0
 jp z,doneShift
 dec d
 pop af
 rlca
 jp Shift
doneShift:
 pop af
 ret 

 
ScrollR:
 ld hl,$F600+1023
 ld b,64
ScrollRightLoop:
 sla (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 ;res 7,(hl)
 ;call PutFromMap
 djnz ScrollRightLoop



 ld a,(ScrollX)
 inc a
 ld (ScrollX),a
 cp 8
 jp nz,break
 xor a
 ld (ScrollX),a
 ld hl,(DataPointer)
 ld de,8
 add hl,de
 ld (DataPointer),hl
 ret


Exit:
 call _getkey
 call _clrScrn
 ret


break:
 ret

Enter:
.db "Press Enter",0

Wow:
.db "Wow, You're cool!",0
Beat:
.db "You beat the level",0

hover:
.db "He's HOVER bug,",0
invincible:
.db "not INVINCIBLE bug!",0
again:
.db "Ohh well.  Try again",0


LevelData:
.db 23,23,00,00,00,00,04,24 ;top of level to bottom of level.
.db 15,23,00,00,00,00,00,24
.db 00,23,00,00,00,00,00,24
.db 00,23,00,00,00,00,05,24
.db 00,23,00,00,00,00,06,24
.db 00,23,00,00,00,00,23,24
.db 00,23,00,00,00,23,23,24
.db 00,23,00,00,23,23,23,24
.db 00,23,00,23,23,23,23,24
.db 00,23,00,00,00,00,05,24
.db 00,23,00,00,00,00,04,24
.db 19,19,23,23,19,19,19,24
.db 10,10,10,23,23,23,10,24
.db 00,00,00,00,00,00,06,24
.db 00,00,00,00,00,23,23,24
.db 00,00,00,00,25,23,23,24
.db 00,00,00,00,00,23,23,24
.db 00,00,00,00,00,00,23,24
.db 00,00,00,00,00,00,04,24
.db 00,00,00,00,07,19,19,24
.db 00,00,00,00,08,10,10,24
.db 00,00,00,00,00,00,00,24
.db 00,00,00,00,00,00,06,24
.db 00,00,00,00,00,25,25,24
.db 00,00,00,00,00,00,25,24
.db 00,00,00,00,00,00,06,24
.db 00,00,00,00,00,00,00,24
.db 00,00,23,00,00,23,00,24
.db 00,00,00,00,23,23,05,24
.db 00,00,00,13,23,00,07,24
.db 00,00,00,00,23,00,08,24
.db 00,00,00,23,23,23,04,24
.db 00,00,15,23,00,23,00,24
.db 00,00,00,00,00,00,00,24
.db 00,00,00,23,00,00,06,24
.db 00,00,00,23,00,00,13,24
.db 00,00,00,13,00,00,04,24
.db 00,00,00,00,00,00,00,00
.db 23,23,23,13,00,00,00,24
.db 00,00,00,13,00,00,06,24
.db 00,00,13,00,00,20,05,24
.db 00,13,00,00,00,00,06,24
.db 00,00,00,00,07,09,11,24
.db 00,00,00,00,08,10,12,24
.db 00,00,00,20,00,00,04,24
.db 00,00,00,00,00,00,06,24
.db 20,15,00,21,21,21,21,21
.db 20,00,00,00,21,21,21,21
.db 20,00,00,00,00,21,21,21
.db 20,00,00,00,00,00,21,21
.db 20,00,00,00,00,00,00,02
.db 20,00,00,22,00,00,00,02
.db 20,00,00,00,00,00,00,02
.db 20,00,00,00,14,00,00,02
.db 20,00,00,00,00,00,00,02
.db 20,00,00,00,00,22,00,02
.db 20,00,00,00,00,00,00,02
.db 20,00,00,00,22,00,00,02
.db 20,00,00,00,00,00,00,02
.db 20,00,00,22,00,00,00,02
.db 20,00,00,00,00,13,22,20
.db 20,15,22,00,13,03,22,20
.db 20,00,00,00,00,13,22,20
.db 20,00,00,00,00,00,00,20
.db 20,00,00,00,00,00,00,20
.db 20,00,00,00,00,00,00,20
.db 20,00,00,22,00,00,00,20
.db 26,00,00,00,00,00,00,13
.db 26,00,00,00,00,00,00,14
.db 26,00,00,00,00,00,00,13
.db 26,00,00,26,00,00,00,14
.db 26,00,00,26,26,00,00,13
.db 26,00,00,00,26,26,00,14
.db 26,00,00,00,00,26,00,13
.db 26,26,26,26,00,00,00,14
.db 26,00,00,26,00,00,00,13
.db 26,00,13,26,00,00,00,14
.db 26,00,00,26,00,27,00,13
.db 26,00,00,00,00,27,00,14
.db 26,00,00,27,00,27,00,13
.db 26,00,27,00,00,27,00,26
.db 26,00,27,27,27,27,00,26
.db 26,00,00,13,00,00,00,26
.db 26,00,00,14,00,27,00,26
.db 26,00,00,13,00,27,00,26
.db 26,00,00,00,00,00,14,26
.db 26,00,00,00,00,00,14,26
.db 26,00,14,00,00,27,00,26
.db 26,00,27,00,00,27,00,26
.db 26,00,27,00,00,27,00,26
.db 26,00,14,00,00,00,00,26
.db 26,00,00,00,00,00,00,02
.db 26,00,00,00,00,00,00,02
.db 26,00,00,00,00,00,00,02
.db 26,00,00,00,00,00,00,02
.db 26,00,00,00,00,00,00,02
.db 26,00,00,07,19,19,19,30
.db 26,00,00,18,29,29,29,30
.db 26,00,00,08,10,10,10,30
.db 26,00,00,00,00,00,04,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,06,30
.db 26,00,23,23,23,23,05,30
.db 26,00,23,00,00,00,07,30
.db 26,00,23,00,00,23,23,30
.db 26,00,23,00,23,23,04,30
.db 26,00,23,00,00,00,04,30
.db 26,00,23,00,23,00,05,30
.db 26,00,23,23,23,00,23,30
.db 26,00,23,00,00,00,23,00
.db 26,00,23,00,23,23,23,30
.db 26,00,00,00,00,00,04,30
.db 26,00,00,00,00,13,05,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,23,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,23,00,00,04,30
.db 26,00,00,23,00,00,00,30
.db 26,00,23,13,00,00,07,30
.db 26,00,00,14,00,00,18,30
.db 26,00,00,13,00,00,18,30
.db 26,00,00,14,00,00,08,30
.db 26,00,23,13,00,00,00,30
.db 26,00,23,23,23,23,23,30
.db 26,00,00,23,00,23,00,30
.db 26,00,00,00,00,23,06,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,04,30
.db 26,00,00,00,00,00,05,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,06,30
.db 26,00,00,00,00,00,04,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,00,00,30
.db 26,00,00,00,00,28,00,30
.db 26,00,00,26,00,00,28,30
.db 26,00,00,26,00,28,28,30
.db 26,00,03,26,28,28,28,30
.db 26,00,15,26,28,28,28,30
.db 26,26,26,26,28,28,28,30
.db 255


Sprites:

Blank:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite1:
	.db %11111111
	.db %00010001
	.db %11111111
	.db %01000100
	.db %11111111
	.db %00010001
	.db %11111111
	.db %01000100

Sprite2:
	.db %01100011
	.db %10010110
	.db %00001100
	.db %01110001
	.db %11011011
	.db %10101110
	.db %01010101
	.db %10101010

Sprite3:
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111011
	.db %11111111
	.db %11111111
	.db %11111111

Sprite4:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01000010
	.db %10010100
	.db %10100101

Sprite5:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %10001000
	.db %01010010
	.db %00110100
	.db %10111010
	.db %01111100

Sprite6:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01000010
	.db %00100100
	.db %10101010

Sprite7:
	.db %00000111
	.db %00111101
	.db %01111010
	.db %11101011
	.db %01110110
	.db %00111001
	.db %01110110
	.db %01011011

Sprite8:
	.db %00100000
	.db %11110000
	.db %10111000
	.db %01001000
	.db %10110000
	.db %10111000
	.db %01011000
	.db %00110000

Sprite9:
	.db %01011011
	.db %01101111
	.db %00111111
	.db %00111011
	.db %00000111
	.db %00000111
	.db %00000101
	.db %00000111

Sprite10:
	.db %11011000
	.db %10110000
	.db %11000000
	.db %10000000
	.db %10100000
	.db %11000000
	.db %10000000
	.db %10000000

Sprite11:
	.db %00000111
	.db %00000111
	.db %00000111
	.db %00000111
	.db %00001111
	.db %00011110
	.db %00011011
	.db %00110011

Sprite12:
	.db %10000000
	.db %10000000
	.db %11000000
	.db %11100000
	.db %11110000
	.db %10111000
	.db %11011000
	.db %01001100

Sprite13:
	.db %10000001
	.db %01001010
	.db %00111100
	.db %01101100
	.db %00110110
	.db %00111100
	.db %01010010
	.db %10000001

Sprite14:
	.db %11000001
	.db %00110001
	.db %00110110
	.db %00011110
	.db %01111000
	.db %01101100
	.db %10001100
	.db %10000011

Sprite15:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite16:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite17:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite18:
	.db %10000110
	.db %11011101
	.db %01111110
	.db %11100011
	.db %01110111
	.db %10111001
	.db %01110110
	.db %11011011

Sprite19:
	.db %00010011
	.db %00001101
	.db %00000011
	.db %00000001
	.db %00000001
	.db %00000011
	.db %00000101
	.db %00000001

Sprite20:
	.db %11111111
	.db %11101011
	.db %11011101
	.db %10111101
	.db %10111101
	.db %10111011
	.db %11010111
	.db %11111111

Sprite21:
	.db %11111111
	.db %11000011
	.db %10100101
	.db %10011001
	.db %10011001
	.db %10100101
	.db %11000011
	.db %11111111

Sprite22:
	.db %11111111
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11111111

Sprite23:
	.db %11111111
	.db %00010001
	.db %11111111
	.db %01000100
	.db %11111111
	.db %00010001
	.db %11111111
	.db %01000100

Sprite24:
	.db %11111111
	.db %11111111
	.db %11011111
	.db %00111110
	.db %01110111
	.db %11100011
	.db %11001111
	.db %10111111

Sprite25:
	.db %11111111
	.db %11110111
	.db %11101111
	.db %10100011
	.db %11000101
	.db %11110111
	.db %11101111
	.db %11111111

Sprite26:
	.db %11111111
	.db %10000001
	.db %11111111
	.db %10000001
	.db %11111111
	.db %10000001
	.db %11111111
	.db %10000001

Sprite27:
	.db %11111111
	.db %10000001
	.db %10111101
	.db %10100101
	.db %10100101
	.db %10111101
	.db %10000001
	.db %11111111


Sprite28:
	.db %11111111
	.db %11010011
	.db %10111101
	.db %10110101
	.db %11101111
	.db %10111101
	.db %11001011
	.db %11111111

Sprite29:
	.db %11111111
	.db %10111011
	.db %10111111
	.db %10111101
	.db %10101101
	.db %11101101
	.db %11101111
	.db %01101111

Sprite30:
	.db %11111111
	.db %10101101
	.db %01111111
	.db %11110111
	.db %10111101
	.db %11101110
	.db %11111111
	.db %10110101

Sprite31:
	.db %00110001
	.db %01111010
	.db %10011110
	.db %00001101
	.db %01001100
	.db %00111000
	.db %01001110
	.db %11100110




Player:
	.db %00111100
	.db %01111110
	.db %11011101
	.db %11001111
	.db %01100110
	.db %01111100
	.db %00101000
	.db %01111100
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %01111110
	.db %01111100
	.db %00101000
	.db %01111100

	.db %00111100
	.db %01111110
	.db %11001101
	.db %11100111
	.db %01110110
	.db %00111100
	.db %01000010
	.db %11100111
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100
	.db %01000010
	.db %11100111

	.db %00111100
	.db %01111110
	.db %10111011
	.db %11110011
	.db %01100110
	.db %00111110
	.db %00010100
	.db %00111110
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111110
	.db %00010100
	.db %00111110

	.db %00111100
	.db %01111110
	.db %10110011
	.db %11100111
	.db %01101110
	.db %00111100
	.db %01000010
	.db %11100111
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100
	.db %01000010
	.db %11100111

EnemySprite:
	.db %10001100
	.db %01010110
	.db %01111001
	.db %10110000
	.db %00110010
	.db %00011100
	.db %01110010
	.db %01100111
	.db %10001100
	.db %01011110
	.db %01111001
	.db %10110000
	.db %00110010
	.db %00011100
	.db %01110010
	.db %01100111

	.db %00000000
	.db %10011100
	.db %01110110
	.db %01111000
	.db %10110010
	.db %00011100
	.db %00010100
	.db %00011010
	.db %00000000
	.db %10011100
	.db %01111110
	.db %01111000
	.db %10110010
	.db %00011100
	.db %00010100
	.db %00011010

	.db %00110001
	.db %01101010
	.db %10011110
	.db %00001101
	.db %01001100
	.db %00111000
	.db %01001110
	.db %11100110
	.db %00110001
	.db %01111010
	.db %10011110
	.db %00001101
	.db %01001100
	.db %00111000
	.db %01001110
	.db %11100110

	.db %00000000
	.db %00111001
	.db %01101110
	.db %00011110
	.db %01001101
	.db %00111000
	.db %00101000
	.db %01011000
	.db %00000000
	.db %00111001
	.db %01111110
	.db %00011110
	.db %01001101
	.db %00111000
	.db %00101000
	.db %01011000


PixelOn: ;routine puts a pixel at (127,c) on Graph Memory by Matt Teiken
 ld a,c
 ld h,0
 ld l,c
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,15
 add hl,de
 ex de,hl
 ld hl,$F600
 add hl,de
 set 0,(hl)
 ret


; ASCR	- Advanced Sprite Clipping Routines
;
; 	by Jimmy Mrdell	970304	 Last update 970803
;
; Temporary variables needed:
;  clipmask  : Byte
;  rows2put  : Byte
;  bitmask	 : Byte
;
;
; PutSprite_MSB:
;  Puts an 8x8 sprite at coordinates B,C. HL should point to a bitmapped
;  sprite followed by a bitmapped mask, total 16 bytes. DE should point
;  to an a memory location where the background will be stored as a
;  bitmap (8 bytes). The sprite will be clipped.
;
; PutSprite:
;  Puts an 8x8 sprite at B,C. HL = pointer to sprite. No mask and no
;  background storage, just clipping.


PutSprite_MSB:		; BC = x,y	DE = background storage  HL = sprite + mask
 ld a,c
 cp 150
 jr nc,PMSB_NoBotClip
 cp 64
 ret nc
PMSB_NoBotClip:
 push bc
 push de
 push hl
 push ix
 ld a,$FF
 ld (clipmask),a
 bit 7,b
 jr z,PMSB_CheckRightClip
 ld a,b
 cp 249
 jr c,EndPMSB
 neg
 push bc
 ld b,a
 ld a,$FF
PMSB_LeftClip:
 srl a
 djnz PMSB_LeftClip
 pop bc
 res 7,b
 dec c
 ld (clipmask),a
 jr PMSB_CheckBotClip
PMSB_CheckRightClip
 ld a,b
 sub 120
 jr c,PMSB_CheckBotClip
 push bc
 ld b,a
 inc b
 ld a,$FF
PMSB_RightClip:
 add a,a
 djnz PMSB_RightClip
 ld (clipmask),a
 pop bc
PMSB_CheckBotClip:
 ld a,8
 ld (rows2put),a
 bit 7,c
 jr nz,PMSB_CheckTopClip
 bit 6,c
 jp nz,EndMSB
 ld a,64
 sub c
 cp 8
 jr nc,PMSB_ClippingDone
 ld (rows2put),a
 jr PMSB_ClippingDone
PMSB_CheckTopClip:
 ld a,c
 cp 249
EndPMSB:
 jr c,EndMSB
 ret c
 push bc
 neg
 ld b,a
 sub 8
 neg
 ld (rows2put),a
PMSB_TopClip:
 inc hl
 inc de
 djnz PMSB_TopClip
 pop bc
 ld c,0
PMSB_ClippingDone:
 di
 push iy
 push hl
 pop iy
 push de
 pop ix
 ld a,(rows2put)
 push af
 call FIND_PIXEL
Modify_5:
 ld de,$F600;FC00
 add hl,de
 ld (bitmask),a
 pop bc
PMSB_PutRow:
 push bc
 push hl
 ld a,(clipmask)
 ld e,a
 ld a,(iy+8)
 and e
 ld e,a 	 ; e = mask for this row
 ld d,0 	 ; d = background for this row
 ld b,8 	 ; b = pixels left to put
 ld c,(iy) ; c = sprite row
 inc iy
PMSB_PutCol:
 push bc
 sla d
 ld a,(bitmask)
 and (hl)
 jr z,PMSB_NPH
 inc d
PMSB_NPH:
 rlc e
 jr nc,PMSB_NextBit
 ld a,(bitmask)
 rlc c
 jr c,PMSB_BitOn
 cpl
 and (hl)
 ld (hl),a
 jr PMSB_NextBit
PMSB_BitOn:
 or (hl)
 ld (hl),a
PMSB_NextBit:
 ld a,(bitmask)
 rrca
 ld (bitmask),a
 jr nc,PMSB_SSB
 inc hl
PMSB_SSB:
 pop bc
 rlc c
 djnz PMSB_PutCol
 ld (ix),d
 inc ix
 pop hl
 ld de,16
 add hl,de
 pop bc
 djnz PMSB_PutRow
 pop iy
 ei
EndMSB:
 pop ix
 pop hl
 pop de
 pop bc
 ret


PutSprite:		 ; BC = x,y  HL = sprite
 push bc
 push de
 push hl
 push ix
 ld a,$FF
 ld (clipmask),a
 bit 7,b
 jr z,PSC_CheckRightClip
 ld a,b
 cp 249
 jr c,EndPPS
 neg
 push bc
 ld b,a
 ld a,$FF
PSC_LeftClip:
 srl a
 djnz PSC_LeftClip
 pop bc
 res 7,b
 dec c
 ld (clipmask),a
 jr PSC_CheckBotClip
PSC_CheckRightClip
 ld a,b
 sub 120
 jr c,PSC_CheckBotClip
 push bc
 ld b,a
 inc b
 ld a,$FF
PSC_RightClip:
 add a,a
 djnz PSC_RightClip
 ld (clipmask),a
 pop bc
PSC_CheckBotClip:
 ld a,8
 ld (rows2put),a
 bit 7,c
 jr nz,PSC_CheckTopClip
 bit 6,c
 jr nz,EndPS
 ld a,64
 sub c
 cp 8
 jr nc,PSC_ClippingDone
 ld (rows2put),a
 jr PSC_ClippingDone
PSC_CheckTopClip:
 ld a,c
 cp 249
EndPPS:
 jr c,EndPS
 push bc
 neg
 ld b,a
 sub 8
 neg
 ld (rows2put),a
PSC_TopClip:
 inc hl
 inc de
 djnz PSC_TopClip
 pop bc
 ld c,0
PSC_ClippingDone:
 push hl
 pop ix
 ld a,(rows2put)
 push af
 call FIND_PIXEL
Modify_6:
 ld de,$F600;FC00
 add hl,de
 ld d,a
 pop bc
PSC_PutRow:
 push bc
 push hl
 ld a,(clipmask)
 ld e,a
 ld b,8
 ld c,(ix)
 inc ix
PSC_PutCol:
 push bc
 rlc e
 jr nc,PSC_NextBit
 ld a,d
 rlc c
 jr c,PSC_BitOn
 cpl
 and (hl)
 ld (hl),a
 jr PSC_NextBit
PSC_BitOn:
 or (hl)
 ld (hl),a
PSC_NextBit:
 rrc d
 jr nc,PSC_SSB
 inc hl
PSC_SSB:
 pop bc
 rlc c
 djnz PSC_PutCol
 pop hl
 ld bc,16
 add hl,bc
 pop bc
 djnz PSC_PutRow
EndPS:
 pop ix
 pop hl
 pop de
 pop bc
 ret



FIND_PIXEL:
 push bc
 push de
 ld hl,ExpTable+1
 ld d,0
 ld a,b
 and $07
 ld e,a
 add hl,de
 ld e,(hl)
 ld h,d
 srl b
 srl b
 srl b
 ld a,c
 add a,a
 add a,a
 ld l,a
 add hl,hl
 add hl,hl
 ld a,e
 ld e,b
 add hl,de
 pop de
 pop bc
 ret

ExpTable:
 .db $01,$80,$40,$20,$10,$08,$04,$02,$01

Pic1:
; compressed picture made with PIC2RLE
; PIC2RLE by David Phillips <david@acz.org>

 .db $91,$00,$ff,$91,$00,$12,$03,$c3,$8f,$e0,$06,$3f
 .db $1b,$e0,$03,$fc,$71,$20,$38,$91,$00,$03,$03,$c7
 .db $9d,$f1,$8f,$bf,$df,$f0,$02,$fe,$79,$c0,$fc,$91
 .db $00,$03,$03,$c7,$3f,$ff,$cb,$bf,$dd,$f8,$03,$ff
 .db $68,$e1,$d0,$91,$00,$03,$03,$c2,$be,$fb,$0b,$3c
 .db $16,$68,$03,$4f,$59,$e3,$70,$91,$00,$03,$01,$fd
 .db $bc,$79,$bf,$3d,$df,$f0,$03,$fe,$79,$63,$9e,$91
 .db $00,$03,$03,$df,$bc,$79,$f6,$3f,$5e,$e0,$01,$ff
 .db $59,$a6,$9e,$91,$00,$03,$03,$ff,$3c,$f8,$7e,$3c
 .db $1e,$e0,$01,$cf,$61,$e7,$58,$91,$00,$03,$01,$c7
 .db $9f,$b8,$fc,$3d,$df,$30,$03,$fb,$7b,$a3,$fe,$91
 .db $00,$03,$03,$c7,$0f,$70,$3c,$1f,$56,$10,$02,$fe
 .db $7e,$a1,$f2,$91,$00,$03,$03,$87,$87,$40,$7c,$1d
 .db $8e,$78,$03,$fe,$1f,$e0,$fe,$91,$00,$3b,$37,$c0
 .db $91,$00,$07,$03,$e0,$00,$04,$00,$00,$01,$c3,$00
 .db $03,$91,$00,$06,$1e,$f0,$00,$0e,$c0,$00,$01,$02
 .db $00,$77,$91,$00,$07,$b0,$00,$1d,$c0,$01,$83,$06
 .db $00,$06,$91,$00,$06,$01,$e6,$c0,$3f,$de,$73,$83
 .db $86,$07,$3f,$0f,$e0,$91,$00,$04,$03,$f5,$c0,$6d
 .db $ae,$63,$01,$86,$0f,$6f,$9d,$e0,$91,$00,$04,$06
 .db $37,$80,$c5,$ec,$f7,$80,$04,$1e,$4f,$35,$e0,$91
 .db $00,$04,$02,$23,$81,$9f,$f0,$46,$00,$0c,$9e,$de
 .db $2e,$c0,$91,$00,$04,$07,$c7,$82,$1b,$4c,$73,$00
 .db $05,$9b,$f9,$2e,$60,$91,$00,$05,$03,$03,$91,$00
 .db $04,$0e,$91,$00,$09,$03,$86,$91,$00,$0e,$03,$91
 .db $00,$ff,$91,$00,$6d


Pic2:
 .db $91,$00,$ff,$91,$00,$12,$03,$87,$8b,$80,$00,$0e
 .db $1d,$a0,$01,$9c,$71,$e0,$38,$91,$00,$03,$03,$c7
 .db $17,$b2,$8f,$27,$d5,$60,$01,$e8,$51,$60,$ec,$91
 .db $00,$03,$02,$07,$3f,$f7,$c5,$2c,$ca,$90,$03,$f7
 .db $68,$a1,$f8,$91,$00,$03,$01,$83,$bc,$9b,$cf,$18
 .db $16,$78,$01,$46,$58,$62,$e8,$91,$00,$03,$01,$bb
 .db $b0,$70,$fe,$3a,$0d,$70,$03,$68,$58,$42,$9e,$91
 .db $00,$03,$01,$e9,$04,$78,$ec,$0f,$1b,$c0,$03,$1f
 .db $28,$e3,$1e,$91,$00,$03,$01,$2f,$0a,$b0,$d2,$38
 .db $1e,$e0,$03,$cf,$71,$c4,$ce,$91,$00,$03,$02,$43
 .db $15,$f0,$fc,$1a,$05,$d0,$01,$7f,$7c,$63,$3e,$91
 .db $00,$03,$01,$84,$84,$d0,$7c,$1d,$9e,$f0,$02,$f6
 .db $7f,$e1,$76,$91,$00,$03,$03,$07,$87,$c0,$7c,$3c
 .db $9c,$70,$03,$fa,$1b,$20,$4e,$91,$00,$3b,$19,$c0
 .db $91,$00,$07,$03,$e0,$00,$06,$00,$00,$01,$c2,$00
 .db $03,$91,$00,$06,$06,$d0,$00,$0a,$40,$00,$03,$04
 .db $00,$46,$91,$00,$06,$01,$b0,$00,$0e,$80,$11,$83
 .db $06,$00,$06,$91,$00,$06,$01,$e6,$c0,$2f,$de,$61
 .db $83,$82,$07,$3c,$86,$c0,$91,$00,$04,$02,$d5,$c0
 .db $2f,$3c,$41,$01,$86,$0d,$2d,$83,$e0,$91,$00,$04
 .db $02,$15,$80,$07,$e0,$76,$80,$04,$1f,$6e,$19,$e0
 .db $91,$00,$04,$06,$61,$81,$8b,$6c,$c6,$00,$0c,$5c
 .db $de,$3b,$c0,$91,$00,$04,$05,$47,$83,$09,$c8,$e7
 .db $80,$05,$9f,$d2,$b0,$40,$91,$00,$05,$02,$03,$91
 .db $00,$04,$0f,$91,$00,$09,$01,$86,$91,$00,$0e,$03
 .db $91,$00,$ff,$91,$00,$6d


;===========================================================
; RLE picture displayer v1.1
; Decodes a RLE picture made by RLE2PIC
;
; written by David Phillips <electrum@tfs.net>
; started: 8/19/98
; last update: 11/5/98
;
; input: HL = RLE encoded picture, DE = where to display
; output: 1024 byte decoded picture
; destroys: AF, BC, DE, HL
; current size: 32 bytes
;===========================================================
DispRLE:
 ld bc,1024			; we need to copy 
DispRLEL:
 ld a,(hl)			; get the next byte
 cp $91				; is it a run?
 jr z,DispRLERun	; then we need to decode the run
 ldi				; copy the byte, and update counters
DispRLEC:
 ld a,b				; check the low byte and
 or c				; the high byte for 0
 jr nz,DispRLEL		; if not, then we're not done either
 ret				; if it's zero, we're done
DispRLERun:
 inc hl				; move to the run value
 ld a,(hl)			; get the run value
 inc hl				; move to the run count
 push hl			; save source pointer
 ld h,(hl)			; get the run count
 ex de,hl			; swap source and destination pointers
DispRLERunL:
 ld (hl),a			; copy the byte
 inc hl				; increase destination pointer
 dec bc				; decrease byte count
 dec d				; decrease run count
 jr nz,DispRLERunL	; if we're not done, then loop
 ex de,hl			; swap pointers back
 pop hl				; recover source pointer
 inc hl				; advance the source pointer
 jr DispRLEC		; check to see if we should loop
.end

random: 	       ; Creates a random number 0 <= x < A
 	push bc
 	push de
 	push hl
 	ld b,a
 	ld a,r
 	add a,a
 	ld hl,0
 	ld d,0
 	ld e,a
RMul:
 	add hl,de
 	djnz RMul
 	ld a,h
 	pop hl
 	pop de
 	pop bc
 	ret


Delay:
 ;ld a,30
Delay2:
 dec a
 cp 0
 jp z,Delay3
 jp Delay2
Delay3:
 ld a,b
 dec a
 ld b,a
 cp 0
 jp nz,Delay
 ret



