#include "asm86.h"         ;I use Asm86 to compile, so I include this
#include "ti86asm.inc"     ;this is TI's include file


;
; FROGGER v1.0 by Trent Lillehaugen
; program started: 9-04-97
; last updated   : 9-07-97
;

x_pos       = $CFAB     ;  byte   x-pos of FROGGER
y_pos       = $CFAC     ;  byte   y-pos of FROGGER
old_x       = $CFAD
old_y       = $CFAE
place       = $CFAF
count       = $CFB0
temp        = $CFB1
inwater     = $CFB2     ; 1 on a log. 0 on a road..
homes       = $CFB3
level       = $CFB4
lives       = $CFB5
exit        = $CFB6
StringPlace = $CFB7     ; 6 bytes

.org _asm_exec_ram          ;starting point for all asm progs, $D748
   call BUSY_OFF          ; turn that damn thing off!!!!
   ld a,1
   ld (level),a
   ld a,0
   ld (exit),a
   call Intro
   call DrawInitScreen    ; draw blank road and water
   call LoadLevel

   ld a,0
   ld (homes),a
   ld b,5        ; how many inital lives!
MainLoop:
   ld a,b          ;.
   ld (lives),a    ;. store b as number of lives
   ld a,%10000000
   ld (place),a
   ld a,50
   ld (x_pos),a
   ld b,a
   ld a,56
   ld (y_pos),a
   ld c,a
   ld hl,FROGGER
   call PutSprite
   ld a,0
   ld (inwater),a
   call ShowLives
   call MoveFrogger
   ld a,(exit) ;
   cp 1        ;if they pressed exit!
   jp z,ENDOFGAME

   ld a,(x_pos)
   ld b,a
   ld a,(y_pos)
   ld c,a

   push bc
MLKeyLoop:
   pop bc
   ld hl,SPLAT
   push bc
   call PutSprite
   pop bc
   halt
   halt
   halt
   ld hl,BLANK
   push bc
   call PutSprite
   pop bc
   halt
   halt
   push bc
   call GET_KEY
   cp K_ENTER
   jp nz,MLKeyLoop
   pop bc
   ld a,(lives) ;.
   ld b,a       ;. this is cool

   djnz MainLoop
ENDOFGAME:
   call _clrLCD
   ret


;***** MoveFrogger ******
MoveFrogger:
    ;****** see if he won!!!!!!!!!!!!1
    ld a,(homes)
    cp %00011111
    jp z,NextLevel

    call MoveCars

;******** test to see if FROGGER is hit :( *****
    ld a,(inwater)
    cp 1
    jp z,InWater




    ld a,(x_pos)   ;.
    ld b,a         ;.  
    ld a,(y_pos)   ;.
    add a,3        ;Get where FROGGER is..
    ld c,a         ;Go down 3 lines
    push bc
    call TestPixel ;get pixel at b,c
    pop bc
    jr z,FroggerDead
    ld a,b
    add a,6
    ld b,a
    call TestPixel
    jr z,FroggerDead
    jp FroggerNotDead
FroggerDead:
    ret
FroggerNotDead:
InWater:
    ld a,(x_pos)
    cp 0     ; if he's over end of screen, make him stay there
    jp m, ATZERO2
    cp 120
    jp p, PASTEND2
    jr INMIDDLE2
ATZERO2:
    ld a,(inwater)  ;
    cp 1
    ret z           ; dead if he's in water

    ld a,0
    ld (x_pos),a
    ld b,a
    jr INMIDDLE2
PASTEND2:
    ld a,120
    ld (x_pos),a
    ld b,a
INMIDDLE2:

;***********************************************


    ld a,(x_pos)
    ld (old_x),a
    ld a,(y_pos)
    ld (old_y),a

    call GET_KEY           
    cp K_UP
    jr z,MoveUp
    cp K_DOWN
    jp z,MoveDown
    cp K_LEFT
    jp z,MoveLeft
    cp K_RIGHT
    jp z,MoveRight
    cp K_EXIT
    jp z,QUITTER
    jr MoveFrogger     ; if they pressed nothing, loop until they do!
MoveUp:
    ld a,(inwater)
    cp 1
    jp z,ToHome
    ld a,(y_pos)
    cp 20
    jr z,ToWater
    sub 9
    jr NoWater
ToWater:
    sub 10
    push af

    add a,3        ;Get where FROGGER is..
    ld c,a         ;Go down 3 lines
    ld a,(x_pos)   ;.
    ld b,a         ;.  
    push bc
    call TestPixel ;get pixel at b,c
    pop bc
    jr nz,TWFroggerDead
    ld a,b
    add a,6
    ld b,a
    call TestPixel
    jr nz,TWFroggerDead
    jp TWFroggerNotDead
TWFroggerDead:
    pop af    ; so we don't get any weird errors!!!!!
    ret
TWFroggerNotDead:

    ld a,1
    ld (inwater),a
    pop af
NoWater:
    ld (y_pos),a
    jp DrawFrogger
ToHome:
    ;*********** this is if FROGGER is jumping up to home
    ld a,(homes)     ;.
    ld b,a           ;b=homes
    ld a,(x_pos)
    cp 4
    jr z,Home1
    cp 5
    jr z,Home1
    cp 6
    jr z,Home1
    cp 27
    jp z,Home2
    cp 28
    jp z,Home2
    cp 29
    jp z,Home2
    cp 50
    jp z,Home3
    cp 51
    jp z,Home3
    cp 52
    jp z,Home3
    cp 73
    jp z,Home4
    cp 74
    jp z,Home4
    cp 75
    jp z,Home4
    cp 96
    jp z,Home5
    cp 97
    jp z,Home5
    cp 98
    jp z,Home5
    ret           ; if he's not in front of anyhome.. he's DEAD!
Home1:
    ld a,b           ;
    and %00010000    ;
    ret nz           ; if someone is already there.. he's DEAD!!!
    ld a,b           ;.
    or %00010000     ; add him to there!
    ld (homes),a     ; save it!
    ld b,5
    ld c,0
    ld hl, FROGGERIN
    call PutSprite
    ld a,50
    ld (x_pos),a
    ld b,a
    ld a,56
    ld (y_pos),a
    ld c,a
    ld hl,FROGGER
    call PutSprite
    ld a,0
    ld (inwater),a
    jp MoveFrogger
Home2:
    ld a,b           ;
    and %00001000    ;
    ret nz           ; if someone is already there.. he's DEAD!!!
    ld a,b           ;.
    or %00001000     ; add him to there!
    ld (homes),a     ; save it!
    ld b,28
    ld c,0
    ld hl, FROGGERIN
    call PutSprite
    ld a,50
    ld (x_pos),a
    ld b,a
    ld a,56
    ld (y_pos),a
    ld c,a
    ld hl,FROGGER
    call PutSprite
    ld a,0
    ld (inwater),a
    jp MoveFrogger
    
Home3:
    ld a,b           ;
    and %00000100    ;
    ret nz           ; if someone is already there.. he's DEAD!!!
    ld a,b           ;.
    or %00000100     ; add him to there!
    ld (homes),a     ; save it!
    ld b,51
    ld c,0
    ld hl, FROGGERIN
    call PutSprite
    ld a,50
    ld (x_pos),a
    ld b,a
    ld a,56
    ld (y_pos),a
    ld c,a
    ld hl,FROGGER
    call PutSprite
    ld a,0
    ld (inwater),a
    jp MoveFrogger
Home4:
    ld a,b           ;
    and %00000010    ;
    ret nz           ; if someone is already there.. he's DEAD!!!
    ld a,b           ;.
    or %00000010     ; add him to there!
    ld (homes),a     ; save it!
    ld b,74
    ld c,0
    ld hl, FROGGERIN
    call PutSprite
    ld a,50
    ld (x_pos),a
    ld b,a
    ld a,56
    ld (y_pos),a
    ld c,a
    ld hl,FROGGER
    call PutSprite
    ld a,0
    ld (inwater),a
    jp MoveFrogger
Home5:
    ld a,b           ;
    and %00000001    ;
    ret nz           ; if someone is already there.. he's DEAD!!!
    ld a,b           ;.
    or %00000001     ; add him to there!
    ld (homes),a     ; save it!
    ld b,97
    ld c,0
    ld hl, FROGGERIN
    call PutSprite
    ld a,50
    ld (x_pos),a
    ld b,a
    ld a,56
    ld (y_pos),a
    ld c,a
    ld hl,FROGGER
    call PutSprite
    ld a,0
    ld (inwater),a
    jp MoveFrogger   
    ret

MoveDown:
    ld a,(y_pos)
    cp 10
    jr z,FromWater
    cp 56
    jp z,MoveFrogger

    add a,9
    jr NotFromWater
FromWater:
    add a,10
    push af
    ld a,0
    ld (inwater),a
    pop af
NotFromWater:
    ld (y_pos),a
    jr DrawFrogger
MoveLeft:
    ld a,(x_pos)
    sub 5
    ld (x_pos),a

    ld a,(inwater)
    cp 0
    jr z, NotInWaterL

    ld a,(y_pos)
    add a,3        ;Get where FROGGER is..
    ld c,a         ;Go down 3 lines
    ld a,(x_pos)   ;.
    ld b,a         ;.  
    push bc
    call TestPixel ;get pixel at b,c
    pop bc
    jr nz,TWFroggerDead2
    ld a,b
    add a,6
    ld b,a
    call TestPixel
    jr nz,TWFroggerDead2
    jp TWFroggerNotDead2
TWFroggerDead2:
    ret
TWFroggerNotDead2:
NotInWaterL:
    jr DrawFrogger



MoveRight:
    ld a,(x_pos)
    add a,5
    ld (x_pos),a

    ld a,(inwater)
    cp 0
    jr z, NotInWaterR

    ld a,(y_pos)
    add a,3        ;Get where FROGGER is..
    ld c,a         ;Go down 3 lines
    ld a,(x_pos)   ;.
    ld b,a         ;.  
    push bc
    call TestPixel ;get pixel at b,c
    pop bc
    jr nz,TWFroggerDead3
    ld a,b
    add a,6
    ld b,a
    call TestPixel
    jr nz,TWFroggerDead3
    jp TWFroggerNotDead3
TWFroggerDead3:
    ret
TWFroggerNotDead3:
NotInWaterR:
    jr DrawFrogger
DrawFrogger:
    ld a,(old_x)
    ld b,a
    ld a,(old_y)
    ld c,a
    ld hl,BLANK
    call PutSprite

    ld a,(y_pos)
    ld c,a
    ld a,(x_pos)
    ld b,a
    cp 0     ; if he's over end of screen, make him stay there
    jp m, ATZERO
    cp 120
    jp p, PASTEND
    jr INMIDDLE
ATZERO:
    ld a,(inwater)  ;
    cp 1
    ret z           ; dead if he's in water

    ld a,0
    ld (x_pos),a
    ld b,a
    jr INMIDDLE
PASTEND:
    ld a,120
    ld (x_pos),a
    ld b,a
INMIDDLE:


    ld hl,FROGGER
    call PutSprite
    jp MoveFrogger

QUITTER:
   ld a,1
   ld (lives),a
   ld (exit),a
   ret


NextLevel:
   call _clrLCD
   ld (place),a

   ld a,(level)
   inc a
   ld (level),a
   ;********** load next level!!!!!!!!
   call LoadLevel
   ;**********************************

   ;********** Display Picture here:
    ld hl,LEVELPIC
    ex de,hl
    ld hl,$FD03
    ld b,17       ; 26 lines
NLNextLine:
    push bc
    ld b,10       ; there are 16 bytes in each line
NLNextByte:
    ld a,(de)     ;
    ld (hl),a     ; get byte and copy to vid mem
    inc de        ; increment our de
    inc hl        ; inc out hl
    djnz NLNextByte
    ld bc,6
    add hl,bc
    pop bc
    djnz NLNextLine


    ld hl,$263B             ;this is the cursor place
    ld (_penCol),hl         ;and put it in
    ld a,(level)           ;now we get score
    ld h,0
    ld l,a
    ld de,StringPlace+1     ;start of unpacking         [4]
    ld b,2                  ;2 digits                   [5]
ShowLives22:
    call UNPACK_HL          ;divide hl by 10 and a contains remainder
    add a,'0'               ;asciiize it
    ld (de),a               ;put it in
    dec de                  ;next digit place to load
    djnz ShowLives22         ;keep going
    ld de,StringPlace+2
    ld a,0
    ld (de),a
    ld hl,StringPlace       ;now we put it back
    call _vputs             ;and display the score





    ld b,1
    ld hl,PressAKeyText
PAKRowii:
    push hl
    call LD_HL_MHL
    ld ($C37C),hl
    pop hl
    inc hl
    inc hl
    call _vputs
    djnz PAKRowii





NLWaitForKey:          ;.
    call GET_KEY       ;.    
    cp K_ENTER         ;.
    jr nz,NLWaitForKey   ;wait until they press a key!
    call DrawInitScreen
    call ShowLives

   
   ld a,50
   ld (x_pos),a
   ld b,a
   ld a,56
   ld (y_pos),a
   ld c,a
   ld hl,FROGGER
   call PutSprite
   ld a,0
   ld (inwater),a
   ld (homes),a
   ld a,%10000000
   ld (place),a


   jp MoveFrogger



   


;***** END MoveFrogger *****



;**** LoadLevel ************

LoadLevel:
   ld a,(level)    ;.
   ld b,a          ;.
   ld hl,LEVEL1    ;HL will point to real level
   ex de,hl
   ld hl,LEVEL1        ;DE will point to buffer [level1]

LLLoop:
   inc hl ;.
   inc hl ;.
   inc hl ;.
   inc hl ;.
   inc hl ;.
   inc hl ;.
   inc hl ;.
   inc hl ;.
   inc hl ;.
   inc hl ;.point to next level!!!!!1
   djnz LLLoop


   ld b,10
LLLoop2:
   ld a,(hl)
   ld (de),a
   inc de
   inc hl
   djnz LLLoop2
   ret
;***** END LoadLevel




;***** MoveCars *****
MoveCars:
   ld hl,CARTIMER ;.
   ld a,(hl)      ;.
   inc a          ;.
   cp 8           ;.
   jp nz,MCD      ;.
   ;*** rotate all cars
   ld hl,LEVEL1
   ex de,hl
   ld a,(de)   ; get the first bit
   rlca        ; rotate left circular
   ld (de),a   ; save it like that


   inc de
   inc de
   ld a,(de)   ; get the first bit
   rlca        ; rotate left circular
   ld (de),a   ; save it like that
   inc de
   inc de
   ld a,(de)   ; get the first bit
   rrca        ; rotate right circular
   ld (de),a   ; save it like that
   inc de
   inc de
   ld a,(de)   ; get the first bit
   rlca        ; rotate left circular
   ld (de),a   ; save it like that
   inc de
   inc de
   ld a,(de)   ; get the first bit
   rrca        ; rotate right circular
   ld (de),a   ; save it like that
   ld a,0         ;.
   ld hl,CARTIMER
MCD:              ;.
   ld (hl),a      ;get the car timer, increment, limit to 0-7

;***** if frogger is in water then he MOVES too!!!!!!!!!!1
   ld a,(inwater)
   cp 1
   jr z,MFInWater
   jr MFNotInWater
MFInWater:
   ld a,(x_pos)
   dec a
   ld (x_pos),a
MFNotInWater:
;*********************


;*** now actually draw cars!

   ld hl,LEVEL1
   ex de,hl

   ld a,0
   ld (count),a
   ld b,8
MCDrawCars5:
   push bc
   ld a,(place)
   ld c,a
   ld a,(de)     ;.

   and c         ;.  (c=placE) place = 1000000 the 01000000 ...
   cp  c         ;if there is a car here draw it!
   jp z, MCDraw5
   jp MCDrawDone5
MCDraw5:
   ld hl,CARTIMER
   ld a,(count)
   ld c,a            ; c = count
   ld a,(hl)
   ld b,a            ; a = count
   ld a,c 
   sub b
   ld b,a
   ld c,10
   ld hl,LOGL
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite


   ld hl,LOGM
   ld a,b
   sub 56
   ld b,a
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite

   ld hl,LOGR
   ld a,b
   sub 56
   ld b,a
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite




MCDrawDone5:
   ld a,(place) ;
   rrca         ;
   ld (place),a ; rotate place right circular
   ld a,(count) ;
   add a,8      ;
   ld (count),a ; increment count by 8 
   pop bc
   djnz MCDrawCars5

;***** if frogger is in water, redraw HIM!!!!!!!!!! the logs moved!!!!!
   ld a,(inwater)
   cp 1
   jr z, MFInWater2
   jr MFNotInWater2
MFInWater2:
   ld a,(x_pos)
   ld b,a
   ld a,(y_pos)
   ld c,a
   ld hl, FROGGER
   push de
   call PutSprite
   pop de
MFNotInWater2:



   inc de
   inc de

   ld a,0
   ld (count),a
   ld b,8
MCDrawCars4:
   push bc
   ld a,(place)
   ld c,a
   ld a,(de)     ;.

   and c         ;.  (c=placE) place = 1000000 the 01000000 ...
   cp  c         ;if there is a car here draw it!
   jp z, MCDraw4
   jp MCDrawDone4
MCDraw4:
   ld hl,CARTIMER
   ld a,(count)
   ld c,a            ; c = count
   ld a,(hl)
   ld b,a            ; a = count
   ld a,c 
   sub b
   ld b,a
   ld c,23
   ld hl,CAR2a
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite

   ld hl,CAR2b
   ld a,b
   sub 56
   ld b,a
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite

MCDrawDone4:
   ld a,(place) ;
   rrca         ;
   ld (place),a ; rotate place right circular
   ld a,(count) ;
   add a,8      ;
   ld (count),a ; increment count by 8 
   pop bc
   djnz MCDrawCars4


   inc de
   inc de
   ld a,0
   ld (count),a
   ld b,8
MCDrawCars:
   push bc
   ld a,(place)
   ld c,a
   ld a,(de)     ;.

   and c         ;.  (c=placE) place = 1000000 the 01000000 ...
   cp  c         ;if there is a car here draw it!
   jp z, MCDraw
   jp MCDrawDone
MCDraw:
   ld hl,CARTIMER
   ld a,(count)
   ld c,a            ; c = count
   ld a,(hl)
   ld b,c            ; b = count
   add a,b
   ld b,a
   ld c,32
   ld hl,CAR1
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite
MCDrawDone:
   ld a,(place) ;
   rrca         ;
   ld (place),a ; rotate place right circular
   ld a,(count) ;
   add a,8      ;
   ld (count),a ; increment count by 8 
   pop bc
   djnz MCDrawCars


   inc de
   inc de
   ld a,0
   ld (count),a
   ld b,8
MCDrawCars3:
   push bc
   ld a,(place)
   ld c,a
   ld a,(de)     ;.

   and c         ;.  (c=placE) place = 1000000 the 01000000 ...
   cp  c         ;if there is a car here draw it!
   jp z, MCDraw3
   jp MCDrawDone3
MCDraw3:
   ld hl,CARTIMER
   ld a,(count)
   ld c,a            ; c = count
   ld a,(hl)
   ld b,a            ; a = count
   ld a,c 
   sub b
   ld b,a
   ld c,41
   ld hl,CAR2a
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite

   ld hl,CAR2b
   ld a,b
   sub 56
   ld b,a
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite

MCDrawDone3:
   ld a,(place) ;
   rrca         ;
   ld (place),a ; rotate place right circular
   ld a,(count) ;
   add a,8      ;
   ld (count),a ; increment count by 8 
   pop bc
   djnz MCDrawCars3



   inc de
   inc de
   ld a,0
   ld (count),a
   ld b,8
MCDrawCars2:
   push bc
   ld a,(place)
   ld c,a
   ld a,(de)     ;.

   and c         ;.  (c=placE) place = 1000000 the 01000000 ...
   cp  c         ;if there is a car here draw it!
   jp z, MCDraw2
   jp MCDrawDone2
MCDraw2:
   ld hl,CARTIMER
   ld a,(count)
   ld c,a            ; c = count
   ld a,(hl)
   ld b,c            ; b = count
   add a,b
   ld b,a
   ld c,50
   ld hl,CAR1
   call PutSprite
   ld a,b
   add a,64
   ld b,a
   call PutSprite
MCDrawDone2:
   ld a,(place) ;
   rrca         ;
   ld (place),a ; rotate place right circular
   ld a,(count) ;
   add a,8      ;
   ld (count),a ; increment count by 8 
   pop bc
   djnz MCDrawCars2

   halt
   halt
   halt
   halt
   halt
   halt
   halt
   ret
;***** END MoveCars *****

;***** Intro *****
Intro:
    call _clrLCD
    ld hl,INTRO
    ex de,hl

    ld hl,$FC00
    ld b,26       ; 26 lines
INextLine:
    push bc
    ld b,16       ; there are 16 bytes in each line
INextByte:
    ld a,(de)     ;
    ld (hl),a     ; get byte and copy to vid mem
    inc de        ; increment our de
    inc hl        ; inc out hl
    djnz INextByte
    pop bc
    djnz INextLine

    ld b,5
    ld hl,IntroText
SITRow:
    push hl
    call LD_HL_MHL
    ld ($C37C),hl
    pop hl
    inc hl
    inc hl
    call _vputs
    djnz SITRow



IWaitForKey:           ;.
    call GET_KEY       ;.    
    cp K_TABLE
    jr z,AddLevel
    cp 0               ;.
    jr z,IWaitForKey   ;wait until they press a key!
    jr IEnd
AddLevel:
    ld a,(level)
    inc a
    ld (level),a
    jp IWaitForKey
IEnd:
    ret
;***** END Intro *****

;***** DrawInitScreen *****
DrawInitScreen:
     call _clrLCD
     ld b,55
DITLoop2:
     ld c,b
     ld b,120
     ld hl,STREET
DITLoop:
     call PutSprite
     dec b
     dec b
     dec b
     dec b
     dec b
     dec b
     dec b
     djnz DITLoop
     call PutSprite
     ld a,c         ;.
     sub 9          ;.
     ld b,a         ;b=oldb-9
     cp 19          ; b - 28
     jp m,DITDone1   ; if b<28 then  quit
     jp DITLoop2    ; else go to loop 2
DITDone1:
     ;**** now draw water!!!!!!!
     ld c,8
     ld b,120
     ld hl,WATER
DITLoop3:
     call PutSprite
     ld a,b
     sub 7
     ld b,a
     djnz DITLoop3
     call PutSprite

    ld hl,TOP
    ex de,hl
    ld hl,$FC00
    ld b,8        ; 8 lines
DITNextLine:
    push bc
    ld b,16       ; there are 16 bytes in each line
DITNextByte:
    ld a,(de)     ;
    ld (hl),a     ; get byte and copy to vid mem
    inc de        ; increment our de
    inc hl        ; inc out hl
    djnz DITNextByte
    pop bc
    djnz DITNextLine


     ret
;***** END DrawInitScreen *****


PutSprite: ; Puts a sprite stored at (HL) at B,C
      
      ld a,b        ;**
      cp 0          ;**
      jp m,PS_Minus ;**
      jr PS_NotMinus;**
PS_Minus:
      add a,128      ;**
      ld b,a        ;**
PS_NotMinus:
      ld (temp),a ;**
      

      push bc         		; save BC
      push de         		; save DE
      push hl			; save HL
      push hl			; save HL
      ld e,b
      ld d,c
      call FindPixel
      ld de,$FC00		; DE points to VID MEM
      
      ex de,hl                  ; DE = VID MEM + PIXEL LOC
      pop hl                    ; HL = PIC LOC
      ld b,(hl)                 ; get first byte from PIC LOC (width)

      inc hl                    ; HL = next byte in PIC LOCATION
      ld c,(hl)                 ; get second byte from PIC LOC (height)
      inc hl                    ; HL = START OF PIC
      push hl                   ; save HL
      pop ix			; IX = START OF PIC
      ex de,hl                  ; HL = VID MEM + PIXEK LOC DE = START OF PIC
PS_NewRow:
      push bc                   ; save BC
      ld d,(ix)			; D = next byte of PIC
      inc ix			; IX points to next byte
      push af                   ; save AF
      push hl			; save HL
PS_NewCol:
      rl d			; Rotate Left D
      ld e,a			; e = a
      jr nc,PS_NoPixel        ; if No Carry then goto NoPixel
      ;************ can be OR or XOR *********************
      or (hl)                   ; a = a or (hl)
      ;***************************************************
      ld (hl),a                 ; hl = hl or a (basically)
      jr PS_NextPixel
PS_NoPixel:
      cpl 
      and (hl)
      ld (hl),a
PS_NextPixel:
      ld a,e                    ; get A back
      rrca                      ; rotate right circular
      jr nc,PS_SameByte         ; if no carry then same byte
      inc hl                    ; else HL points to next byte in PIC
      push af           ;**
      ld a,(temp)       ;**
      add a,8           ;**
      cp 128            ;**
      jp p,PSWrap       ;**
      jr PSEndWrap      ;**
PSWrap:
      push bc       ;.
      ld bc,$fff0   ;.
      add hl,bc     ;.
      pop bc        ;HL=HL-15
      
PSEndWrap:
      pop af       ;**

PS_SameByte:
      djnz PS_NewCol            ; go to next column
      pop hl
      pop af      
      ld de,16
      add hl,de
     
      pop bc
      dec c
      jr nz,PS_NewRow
      pop hl
      pop de
      pop bc
      ret




;************

;***** TestPixel *****
TestPixel: ; Tests the pixel at B,C. If the Z flag is set, no pixel, else a pixel is lit
      ld e,b
      ld d,c  
      call FindPixel
      and (hl)
      ret
;***** END TestPixel *****


;**** ShowLives *****
ShowLives:
    ld hl,$0073             ;this is the cursor place
    ld (_penCol),hl         ;and put it in
    ld a,(lives)           ;now we get score
    ld h,0
    ld l,a
SLHere:
    ld de,StringPlace+1     ;start of unpacking         [4]
    ld b,2                  ;2 digits                   [5]
ShowLives2:
    call UNPACK_HL          ;divide hl by 10 and a contains remainder
    add a,'0'               ;asciiize it
    ld (de),a               ;put it in
    dec de                  ;next digit place to load
    djnz ShowLives2         ;keep going
    ld hl,StringPlace       ;now we put it back
    call _vputs             ;and display the score
SLEnd:
    ret
;***** END ShowLives *****



FindPixel:
        ld a,e
        and $07         ; a = bit offset
        ld b,0
        ld c,a
        ld hl,FP_Bits
        add hl,bc
        ld b,(hl)       ; b = bitmask for (hl)
;56 t-states up to this point
        ld a,d
        rlca            ; multiply y by 4
        rlca
        ld l,a
        ld h,0
        add hl,hl       ; multiply y by 4 again
        add hl,hl       ;   because there are 16 bytes in a pixel row
        ld a,e
        rrca            ; divide x by 8 (8 pixels/byte)
        rrca
        rrca
        and $0F
        ld c,a
        ld a,b          ; now a = bitmask for (hl)
        ld b,$FC
        add hl,bc       ; hl -> byte in LCD memory
;150 t-states up to this point
        ret

FP_Bits: .db $80,$40,$20,$10,$08,$04,$02,$01

IntroText:
 .db 42,27,"written by:",0
 .db 30,35,"Trent Lillehaugen",0
 .db 10,43,"tllilleh@polymail",0
 .db 71,43,".calpoly.edu",0
PressAKeyText:
 .db 45,52,"press enter",0



#include "fintro.h"
#include "grx.h"
#include "cars.h"
#include "top.h"
#include "level.h"
.end



