; Freecell v1.0
; by Ben Mickle
; bmickle@yahoo.com
;
; Date Started: August 15,1999
; Date Completed: September 8,1999
;
; This code is pretty messy and sparsely commented.
; If you make any adjustments to this code, do so
; only for personal use.  Do not release any
; modifications on this code without permission
; from me.
;

card_height	=$8100	;space between the cards
x_coord	=$8101
y_coord	=$8102
selected_card =$8103
selected_card_addr =$8104
second_just_pressed =$8106
cards_moving =$8107	;flag - 0=not moving, 1=moving
Wins_ThisSession =$8108
Loses_ThisSession =$810A
col1		=$8300
col2		=col1+21
col3		=col2+21
col4		=col3+21
col5		=col4+21
col6		=col5+21
col7		=col6+21
col8		=col7+21
cell1		=$8500
cell2		=$8501
cell3		=$8502
cell4		=$8503
stack1	=$8504
stack2	=$8505
stack3	=$8506
stack4	=$8507
buffer	=$9000
buffer2	=buffer+1024
cardbuffer	=$9800
cardbuffer2	=cardbuffer+1024

#include "ti86asm.inc"

.org _asm_exec_ram

	nop
	jp Begin
	.dw 0
	.dw Description

Description:
	.db "Freecell v1.0 by Ben Mickle",0

Begin:
	call _runindicoff
	call _flushallmenus
	call _clrLCD
	ld hl,$0401
	ld (_curRow),hl
	ld hl,Title
	call _puts
	ld de,$152E
	call DispStr
	ld de,$1D2E
	call DispStr
	ld de,$2C28
	ld hl,NewGame_str
	call DispStr
	ld de,$3622
	call DispStr
	ld hl,0
	ld (Wins_ThisSession),hl
	ld (Loses_ThisSession),hl
IntroKeyLoop:
	halt
	call _get_key
	cp K_F1
	jr z,Begin2
	cp K_F2
	push af
	call z,ViewStatistics
	pop af
	jr z,Begin
	cp K_EXIT
	jr nz,IntroKeyLoop
	call _clrLCD
	jp _homeup
Begin2:
	ld a,5
	ld (card_height),a
Start:
	ld hl,x_coord
	ld de,y_coord
	ld bc,6
	ld (hl),0
	ldir
	ld hl,cell1
	ld de,cell2
	ld bc,8
	ld (hl),0
	ldir
	call InitColumns
	call DrawBoard
	call OpenGray
MainLoop:
	call CopyScreen
	halt
	call _get_key
	cp K_EXIT
	jp z,Exit2
	cp K_MORE
	jp z,Options
	cp K_PLUS
	push af
	call z,MoreWidth
	pop af
	cp K_MINUS
	call z,LessWidth
	ld a,$FF
	out (1),a
	ld a,%01111110
	out (1),a
	nop
	nop
	in a,(1)
	bit 0,a
	call z,MoveDown
	bit 1,a
	call z,MoveLeft
	bit 2,a
	call z,MoveRight
	bit 3,a
	call z,MoveUp
	ld a,(cards_moving)
	or a
	jr nz,AutoMoveCards
	ld a,%00111111
	out (1),a
	nop \ nop
	in a,(1)
	bit 5,a
	jp z,SecondPressed
AutoMoveCards:
	xor a
	ld (second_just_pressed),a
	ld a,(cards_moving)
	or a
	jr z,MainLoop
	ld a,(selected_card)
	ld e,a
	ld hl,col1
	ld c,12
CheckCellsForStackMove:
	ld (DynamicCard),hl
	ld a,c
	cp 5
	jr nc,CheckColumn2
	ld a,4
	sub c
	ld hl,cell1
	ld l,a	;this is okay since it is alligned
	jr CCFSM_Continue2
CheckColumn2:
	call PointToEndOfCol
CCFSM_Continue2:
	ld a,(hl)
	ld (selected_card),a
	push hl
	ld hl,stack1
	ld b,4
CCFSM_Loop:
	push bc
	call CheckValidMoveOnStack
	pop bc
	jr z,AutoMoveToStack
CCFSM_Continue:
	inc hl
	djnz CCFSM_Loop
	pop hl
	ld hl,(DynamicCard)
	push de
	ld de,21
	add hl,de
	pop de
	dec c
	jr nz,CheckCellsForStackMove
	ld a,e
	ld (selected_card),a
	xor a
	ld (cards_moving),a
	jp CheckWinLose
AutoMoveToStack:
	push hl
	push bc
	ld b,4
	ld c,0
	ld hl,stack1
AMTS_CheckLoop:
	ld a,(selected_card)
	and %00010000
	ld d,a
	ld a,(hl)
	or a
	jr z,AMTS_NoSuiteCheck
	and %00010000
	cp d
	jr z,AMTS_SameSuite
AMTS_NoSuiteCheck:
	ld a,(selected_card)
	and %00001111
	dec a
	cp 1
	jr nz,NotATwo
	dec a
NotATwo:
	ld d,a
	ld a,(hl)
	and %00001111
	cp d
	jr c,AMTS_SameSuite
	inc c
AMTS_SameSuite:
	inc hl
	djnz AMTS_CheckLoop
	ld a,c
	pop bc
	pop hl
	cp 2
	jr c,CCFSM_Continue
	ld a,e
	ld (selected_card),a
	pop de
	ld a,(de)
	ld (hl),a
	ex de,hl
	ld (hl),0
	call DrawBoard
	jp MainLoop

SecondPressed:
	ld a,(second_just_pressed)
	or a
	jp nz,MainLoop
	inc a
	ld (second_just_pressed),a
	call InterpretMouse
	jp nc,DeselectCard
	push hl
	ld de,stack1
	or a
	sbc hl,de
	pop hl
	jp nc,PutOnStack
	ld a,(selected_card)
	or a
	jp z,SelectCard
	push hl
	ld de,cell1
	or a
	sbc hl,de
	pop hl
	jr c,SP_Continue
	ld a,(hl)
	or a
	jr z,PlaceCard
	jp DeselectCard
SP_Continue:
	call CheckValidMove
	jp nz,DeselectCard
	ld a,(hl)
	or a
	jr nz,SP_NotEmptyColumn
	ld a,b
	dec a
	jr z,PlaceCard
	push hl
	push de
	push bc
	call DialogBox
	ld de,$1413
	ld hl,MoveCol_str
	call DispStr
	ld de,$1C13
	call DispStr
	ld de,$2413
	call DispStr
	pop bc
	pop de
	pop hl
SP_KeyLoop:
	halt
	push hl
	push de
	push bc
	call _get_key
	pop bc
	pop de
	pop hl
	cp K_F3
	jp z,DeselectCard
	cp K_EXIT
	jp z,DeselectCard
	cp K_F1
	jr z,SP_EmptyColumn
	cp K_F2
	jr z,PlaceCard
	jr SP_KeyLoop
SP_NotEmptyColumn:
	inc hl
SP_EmptyColumn:
	ex de,hl
MoveStringLoop:
	ld a,(hl)
	ld (de),a
	ld (hl),0
	inc hl
	inc de
	djnz MoveStringLoop
	jr PC_Continue
PlaceCard:
	ld a,(selected_card)
	ld (hl),a
	ld hl,(selected_card_addr)
	ld (hl),0
PC_Continue:
	ld a,1
	ld (cards_moving),a
DeselectCard:
	xor a
	ld (selected_card),a
	jr RedrawBoard
PutOnStack:
	ld a,(selected_card)
	or a
	jr z,RedrawBoard
	call CheckValidMoveOnStack
	jr nz,DeselectCard
	jp PlaceCard
SelectCard:
	ld a,(hl)
	or a
	jr z,DeselectCard
	ld (selected_card),a
	ld (selected_card_addr),hl
RedrawBoard:
	call DrawBoard
	jp MainLoop

Exit2:
	call RegisterLoss
Exit:
	ld hl,progname-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	ld de,Statistics-$D748+4
	add hl,de
	adc a,0
	call _set_abs_dest_addr
	ld hl,Statistics
	xor a
	call _set_abs_src_addr
	ld hl,CurrentStreakType+1-Statistics
	call _set_mm_num_bytes
	call _mm_ldir
	call CloseGray
	jp _homeup

MoreWidth:
	ld a,(card_height)
	cp 6
	ret z
	inc a
	ld (card_height),a
	jp DrawBoard

LessWidth:
	ld a,(card_height)
	dec a
	ret z
	ld (card_height),a
	jp DrawBoard

MoveDown:
	call MoveDown+3
	ld e,a
	ld hl,y_coord
	ld a,63
	cp (hl)
	ld a,e
	ret z
	inc (hl)
	ret
MoveUp:
	call MoveUp+3
	ld e,a
	ld hl,y_coord
	xor a
	cp (hl)
	ld a,e
	ret z
	dec (hl)
	ret
MoveLeft:
	call MoveLeft+3
	ld e,a
	ld hl,x_coord
	xor a
	cp (hl)
	ld a,e
	ret nc
	dec (hl)
	ret
MoveRight:
	call MoveRight+3
	ld e,a
	ld hl,x_coord
	ld a,120
	cp (hl)
	ld a,e
	ret z
	inc (hl)
	ret

CopyScreen:
	ld hl,cardbuffer
	ld de,buffer
	ld bc,1024*2
	ldir
	call DrawMouse
	ld hl,buffer
	ld de,$FC00
	ld bc,1024
	ldir
	ld hl,buffer2
	ld de,$CA00
	ld bc,1024
	ldir
	ret

CheckWinLose:
	ld hl,stack1
	ld b,4
CheckWinner:
	ld a,(hl)
	and %00001111
	cp 13
	jr nz,NoWinner
	inc hl
	djnz CheckWinner
	jp Winner
NoWinner:
	ld hl,cell1
	xor a
	ld b,4
CheckCells:
	cp (hl)
	jp z,MainLoop
	inc hl
	djnz CheckCells
	ld hl,col1
	ld de,21
	ld b,12
	ld c,0	;counter of valid moves
CheckLoser:
	push hl
	push bc
	ld a,b
	cp 5
	jr nc,CheckColumn
	ld a,4
	sub b
	ld hl,cell1
	ld l,a	;this is okay since it is alligned
	jr CL_Continue
CheckColumn:
	call PointToEndOfCol
CL_Continue:
	ld a,(hl)
	ld (DynamicCard),a	;temporary
	ld hl,col1
	ld b,8
CheckLoser2:
	ld a,(hl)
	or a
	jr z,DeselectCard2
	push hl
	push bc
	call PointToEndOfCol
	push de
	ld a,(DynamicCard)
	call CVM
	pop de
	pop bc
	pop hl
	jr nz,CL2_NotValid
	inc c
CL2_NotValid:
	add hl,de
	djnz CheckLoser2
	ld hl,stack1
	ld b,4
CheckStackMoves:
	push bc
	ld a,(DynamicCard)
	call CheckValidMoveOnStack2
	pop bc
	jr nz,CSM_NotValid
	inc c
CSM_NotValid:
	inc hl
	djnz CheckStackMoves
	ld a,c
	pop bc
	ld c,a
	pop hl
	add hl,de
	djnz CheckLoser
	or a
	jp z,Loser
	dec a
	jp nz,MainLoop
	ld b,4
IS_Loop:
	push bc
	ld hl,$FC00
	ld bc,1024
InverseScreen:
	ld a,(hl)
	cpl
	ld (hl),a
	cpi
	jp pe,InverseScreen
	ld b,30
IS_Delay:
	halt
	djnz IS_Delay
	pop bc
	djnz IS_Loop
	jp MainLoop
DeselectCard2:
	pop hl
	pop hl
	jp MainLoop

DrawMouse:
	ld a,(selected_card)
	or a
	jr z,NormalArrow
	call InterpretMouse
	jr nc,NormalArrow
	push hl
	ld de,stack1
	or a
	sbc hl,de
	pop hl
	jr nc,MouseOnStack
	ld a,(hl)
	or a
	jr z,DrawArrow3
	push hl
	ld de,cell1
	or a
	sbc hl,de
	pop hl
	jr nc,NormalArrow
	call CheckValidMove
	jr nz,NormalArrow
	ld hl,x_coord
	ld a,(hl)
	sub 3
	ld b,a
	inc hl
	ld a,(hl)
	sub 9
	ld c,a
	ld hl,Arrow2
	ld a,10
	jr DrawArrow
MouseOnStack:
	call CheckValidMoveOnStack
	jr nz,NormalArrow
DrawArrow3:
	ld hl,x_coord
	ld a,(hl)
	sub 3
	ld b,a
	inc hl
	ld c,(hl)
	ld hl,Arrow3
	ld a,8
	jr DrawArrow
NormalArrow:
	ld hl,x_coord
	ld b,(hl)
	inc hl
	ld c,(hl)
	ld hl,Arrow
	ld a,8
DrawArrow:
	jp PutSpriteGray

InterpretMouse:
	ld a,(y_coord)
	cp 16
	jr nc,IM_NotOnCell
	ld hl,cell1
	ld a,(x_coord)
	cp 16
	ret c
	inc hl
	cp 31
	ret c
	inc hl
	cp 46
	ret c
	inc hl
	cp 61
	ret c
	cp 67
	jr c,IM_Done
	inc hl
	cp 82
	ret c
	inc hl
	cp 97
	ret c
	inc hl
	cp 112
	ret c
	inc hl
	cp 255
	ret c
IM_Done:
	or a
	ret
IM_NotOnCell:
	ld a,(x_coord)
	rlca
	rlca
	rlca
	rlca
	and %00001111
	ld l,a
	ld h,0
	call PointToCol
	xor a
	cp (hl)
	jr nz,NotEmptyColumn
	scf
	ret
NotEmptyColumn:
	push hl
	call PointToEndOfCol
	pop de
	or a
	push hl
	sbc hl,de
	ld c,l
	pop hl
	ld a,(card_height)
	ld b,a
	xor a
MultLoop2:
	add a,c
	djnz MultLoop2
	add a,32
	ld b,a
	ld a,(y_coord)
	cp b
	ret nc
	scf
	ret

CheckValidMove:
	ld a,(selected_card)
	call CVM
	ld de,(selected_card_addr)
	ld b,1
	ret z
	ld a,(hl)
	and %00001111
	jr z,CVM_Continue
	ld c,a
	ld a,(de)
	and %00001111
	sub c
	jp nc,CVM_NotValid2
	neg
CVM_Continue:
	ld (DynamicCard),a
	ld a,(hl)
	or a
	jr z,CVM_Loop
	and %00010001
	ld c,a
	ld a,(de)
	and %00010001
	cp c
	jr z,CVM_Loop
	xor %00010001
	cp c
	ret nz
CVM_Loop:
	ld a,(de)
	push hl
	ld h,d
	ld l,e
	dec hl
	push bc
	call CVM
	pop bc
	pop hl
	jr nz,CVM_StringBroken
	inc b
	dec de
	ld a,(de)
	inc a
	xor %00010000
	ld c,a
	ld a,(hl)
	and %00011111
	cp c
	jr z,CountCells
	jr CVM_Loop
CVM_StringBroken:
	ld a,(DynamicCard)
	or a
	jr z,CountCells
	cp b
	jr z,CountCells
	jr nc,CVM_NotValid2
	ld c,a
	sub b
	neg
	add a,e
	ld e,a
	jr nc,$ +3
	inc d
	ld b,c
CountCells:
	push bc
	push hl
	push de
	ld hl,cell1
	ld b,4
	xor a
	ld c,a
CountCells1:
	cp (hl)
	jr nz,CellNotFree
	inc c
CellNotFree:
	inc hl
	djnz CountCells1
	ld hl,col1
	ld de,21
	ld b,8
CountCells2:
	cp (hl)
	jr nz,CellNotFree2
	inc c
CellNotFree2:
	add hl,de
	djnz CountCells2
	pop de
	pop hl
	ld a,(hl)
	or a
	jr nz,CC_NoDec
	ld a,c
	pop bc
	cp b
	jr nc,CC_Done
	ld c,a
	sub b
	neg
	add a,e
	ld e,a
	jr nc,$ +3
	inc d
	ld b,c
CC_Done:
	cp a
	ret
CC_NoDec:
	ld a,c
	pop bc
	inc a
	cp b
	jr c,CVM_NotValid2
	cp a
	ret

CVM:
	push af
	and %00010000
	ld b,a
	ld a,(hl)
	and %00010000
	cp b
	jr z,CVM_NotValid
	ld a,(hl)
	and %00001111
	dec a
	ld b,a
	pop af
	and %00001111
	cp b
	ret nz
	cp a
	ret
CVM_NotValid:
	pop af
CVM_NotValid2:
	xor a
	dec a
	ret

CheckValidMoveOnStack:
	ld a,(selected_card)
CheckValidMoveOnStack2:
	ld c,a
	ld a,(hl)
	or a
	jr z,POS_Continue
	and %11110000
	ld b,a
	ld a,c
	and %11110000
	cp b
	ret nz
POS_Continue:
	ld a,(hl)
	and %00001111
	inc a
	ld b,a
	ld a,c
	and %00001111
	cp b
	ret nz
	cp a
	ret

DrawBoard:
	call DrawColumns
DrawCells:
	ld a,$98
	ld (PutSprite_buffer+1),a
	ld hl,cell1
	ld bc,0
	ld a,8
DrawCardsLoop:
	push af
	ld a,(hl)
	push hl
	push bc
	call DrawCard
	pop bc
	pop hl
	inc hl
	ld a,b
	add a,15
	ld b,a
	pop af
	cp 5
	jr nz,DCL_NoAdd
	push af
	ld a,b
	add a,7
	ld b,a
	pop af
DCL_NoAdd:
	dec a
	jr nz,DrawCardsLoop
	ld a,$90
	ld (PutSprite_buffer+1),a
	ret
DrawCard:
	or a
	jp z,DrawBlankCard
	push af
	call PointToSprite
	call AddMask2
	pop af
	push af
	ld e,a
	ld a,(selected_card)
	cp e
	ld a,%01111111
	ld e,6
	call z,DC_InverseCard
	ld a,6
	push bc
	call PutSpriteGray
	pop bc
	ld a,c
	add a,6
	ld c,a
	ld hl,CardBottom_Left
	pop af
	push af
	ld e,a
	ld a,(selected_card)
	cp e
	ld a,%01111111
	ld e,10
	call z,DC_InverseCard
	ld a,10
	push bc
	call PutSpriteGray
	pop bc
	ld hl,CardBottom_Right
	ld a,b
	add a,8
	ld b,a
	pop af
	push af
	ld e,a
	ld a,(selected_card)
	cp e
	ld a,%11111110
	ld e,10
	call z,DC_InverseCard
	ld a,10
	push bc
	call PutSpriteGray
	pop bc
	pop af
	push af
	call PointToSuiteSprite
	call AddMask
	ld a,c
	sub 6
	ld c,a
	pop af
	ld e,a
	ld a,(selected_card)
	cp e
	ld a,%11111110
	ld e,6
	call z,DC_InverseCard
	ld a,6
	jp PutSpriteGray
DrawBlankCard:
	ld hl,BlankCard_Left
	ld a,16
	push bc
	call PutSpriteGray
	pop bc
	ld a,b
	add a,8
	ld b,a
	ld hl,BlankCard_Right
	ld a,16
	call PutSpriteGray
	ret
DC_InverseCard:
	push bc
	ld c,a
	ld b,e
	ld de,DynamicCard
DCIC_Loop:
	ld a,(hl)
	cpl
	and c
	ld (de),a
	inc de
	inc hl
	djnz DCIC_Loop
	ld bc,20
	ldir
	ld hl,DynamicCard
	pop bc
	ret
AddMask2:
	push bc
	ld de,$8600
	ld bc,6
	push hl
	push bc
	ldir
	pop bc
	pop hl
	ldir
	ld hl,$8600
	pop bc
AddMask:
	push bc
	ld de,DynamicCard
	ld bc,12
	ldir
	ld h,d
	ld l,e
	inc de
	ld (hl),$FF
	ld bc,5
	ldir
	ld hl,DynamicCard
	pop bc
	ret

DrawColumns:
	ld hl,cardbuffer
	ld de,cardbuffer+1
	ld bc,1024*2-1
	ld (hl),0
	ldir
	ld b,0
DrawColumnsLoop:
	ld l,b
	ld h,0
	call PointToCol
	ld c,0
DrawColumn:
	ld a,(hl)
	or a
	jp z,NextColumn
	push hl
	push af
	call PointToSprite
	ex de,hl
	ld a,b
	add a,a
	or $10
	ld l,a
	ld h,$99
	push bc
	push hl
	ld a,(card_height)
	ld b,a
	xor a
MultLoop1:
	add a,c
	djnz MultLoop1
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ld b,h
	ld c,l
	pop hl
	add hl,bc
	push hl
	push hl
	push de
	ld b,6
	ld c,$98+4
	call DrawLoop
	pop de
	pop hl
	ld bc,1024
	add hl,bc
	ld b,6
	ld c,$98+8
	call DrawLoop
	pop hl
	pop bc
	pop af
	push hl
	call PointToSuiteSprite
	ex de,hl
	pop hl
	push bc
	inc hl
	push hl
	push de
	ld b,6
	ld c,$98+4
	call DrawLoop
	pop de
	ex de,hl
	ld bc,6
	add hl,bc
	ex de,hl
	pop hl
	push hl
	ld bc,1024
	add hl,bc
	ld b,6
	ld c,$98+8
	call DrawLoop
	pop hl
	ld de,$60
	add hl,de
	dec hl
	ex de,hl
	pop bc
	pop hl
	inc hl
	inc c
	jp DrawColumn
NextColumn:
	ld a,c
	or a
	jr z,NoDrawCardBottom
	dec hl
	ld a,(selected_card)
	cp (hl)
	jr z,DrawInverseCard
	push bc
	ld b,8
	ex de,hl
	ld de,15
	push hl
DrawLoop3:
	ld a,h
	cp $98+4
	jr nc,DL3_Done
	ld (hl),%01000000
	inc hl
	ld (hl),%00000010
	add hl,de
	djnz DrawLoop3
	ld (hl),%01111111
	inc hl
	ld (hl),%11111110
DL3_Done:
	pop hl
	ld bc,1024
	add hl,bc
	ld b,8
DrawLoop3_:
	ld a,h
	cp $98+8
	jr nc,DL3__Done
	ld (hl),%01000000
	inc hl
	ld (hl),%00000010
	add hl,de
	djnz DrawLoop3_
	ld (hl),%01111111
	inc hl
	ld (hl),%11111110
DL3__Done:
	pop bc
NoDrawCardBottom:
	inc b
	ld a,b
	cp 8
	jp nz,DrawColumnsLoop
	ret
DrawInverseCard:
	push bc
	ex de,hl
	push hl
	ld de,$60
	or a
	sbc hl,de
	ld de,15
	ld b,6
DIC_Loop:
	ld a,h
	cp $98+4
	jr nc,DIC_Done
	ld a,(hl)
	cpl
	and %01111111
	ld (hl),a
	inc hl
	ld a,(hl)
	cpl
	and %11111110
	ld (hl),a
	add hl,de
	djnz DIC_Loop
DIC_Done:
	pop hl
	ld b,8
	ld de,15
	push hl
DrawLoop4:
	ld a,h
	cp $98+4
	jr nc,DL4_Done
	ld (hl),%00111111
	inc hl
	ld (hl),%11111100
	add hl,de
	djnz DrawLoop4
	ld (hl),%00000000
	inc hl
	ld (hl),%00000000
DL4_Done:
	pop hl
	ld bc,1024
	add hl,bc
	ld b,8
DrawLoop4_:
	ld a,h
	cp $98+8
	jr nc,DL4__Done
	ld (hl),%01000000
	inc hl
	ld (hl),%00000010
	add hl,de
	djnz DrawLoop4_
	ld (hl),%01111111
	inc hl
	ld (hl),%11111110
DL4__Done:
	pop bc
	jr NoDrawCardBottom
DrawLoop:
	ld a,h
	cp c
	ret nc
	ld a,(de)
	ld (hl),a
	push de
	ld de,16
	add hl,de
	pop de
	inc de
	djnz DrawLoop
	ret

PointToSprite:
	and %00001111
	dec a
	add a,a	;*2
	ld l,a
	ld h,0
	ld d,h
	ld e,l
	add hl,hl	;*4
	add hl,de
	ld de,Ace
	add hl,de
	ret
PointToSuiteSprite:
	and %11110000
	rrca
	rrca
	rrca
	ld l,a
	ld h,0
	ld e,l
	ld d,h
	add hl,hl
	ld d,h
	ld e,l
	add hl,hl
	add hl,de
	ld de,Heart
	add hl,de
	ret

PointToCol:
	ld d,h
	ld e,l
	add hl,hl	;*2
	add hl,hl	;*4
	add hl,de	;*5
	add hl,hl	;*10
	add hl,hl	;*20
	add hl,de	;*21
	ld de,col1
	add hl,de
	ret
PointToEndOfCol:
	push bc
	ld bc,22
	xor a
	cpir
	dec hl
	dec hl
	pop bc
	ret

InitColumns:
	ld hl,col1
	ld de,col1+1
	ld bc,21*8
	ld (hl),0
	ldir		;makes bc = 0
InitColumnsLoop:
	push bc
	ld l,c
	ld h,0
	call PointToCol
	ld b,7
	ld a,c
	cp 4
	jr c,InitCol
	dec b
InitCol:
	halt
	ld a,12
	call random
	inc a
	ld (_cmdShadow),a
	ld c,a
	ld a,4
	call random
	or a
	rla
	rla
	rla
	rla
	or c
InitCol2:
	push hl
	ld de,col1
	or a
	sbc hl,de
	push bc
	ld b,h
	ld c,l
	inc bc
	ld hl,col1
	cpir
	pop bc
	pop hl
	jp po,NotAlreadyUsed
	ld d,a
	and %00001111
	cp 13
	jr nz,IC_NoReset
	xor a
IC_NoReset:
	inc a
	ld c,a
	ld a,(_cmdShadow)
	cp c
	jr nz,IC_NoChangeSuite
	ld a,d
	and %11110000
	or a
	rra
	rra
	rra
	rra
	inc a
	cp 4
	jr nz,IC_NoReset2
	xor a
IC_NoReset2:
	or a
	rla
	rla
	rla
	rla
	or c
	jr InitCol2
IC_NoChangeSuite:
	ld a,d
	and %11110000
	or c
	jr InitCol2
NotAlreadyUsed:
	ld (hl),a
	inc hl
	djnz InitCol
	pop bc
	inc c
	ld a,c
	cp 8
	jr nz,InitColumnsLoop
	ret

Options:
	call DialogBox
	ld de,$1213
	ld hl,NewGame_str
	call DispStr
	ld de,$1913
	call DispStr
	ld de,$2013
	call DispStr
	ld de,$2713
	call DispStr
	ld de,$2E13
	call DispStr
OptionsKeyLoop:
	halt
	call _get_key
	cp K_EXIT
	jp z,MainLoop
	cp K_F4
	jp z,MainLoop
	cp K_F1
	jr z,NewGame
	cp K_F3
	jr z,ClearStatistics
	cp K_F5
	jr nz,OptionsKeyLoop_Continue
	ld a,$01
	out ($03),a
	halt
	ld a,$0B
	out ($03),a
	res 4,(iy+$09)
OptionsKeyLoop_Continue:
	cp K_F2
	push af
	call z,ViewStatistics
	pop af
	jr z,Options
	jr OptionsKeyLoop
NewGame:
	call RegisterLoss
	jp Start
ClearStatistics:
	ld hl,Statistics
	ld de,Statistics+1
	ld (hl),0
	ld bc,10
	ldir
	ld (Wins_ThisSession),bc
	ld (Loses_ThisSession),bc
	jr Options
ViewStatistics:
	call DialogBox
	ld de,$1013
	ld hl,ThisSession_str
	call DispStr
	ld de,$1616
	ld hl,wins_str
	call DispStr
	ld de,$1C16
	;ld hl,loses_str
	call DispStr
	ld de,$2213
	ld hl,Total_str
	call DispStr
	ld hl,(Loses)
	ld de,(Wins)
	add hl,de
	ex de,hl
	call DispPercentage
	ld de,$2816
	ld hl,wins_str
	call DispStr
	ld de,$2E16
	;ld hl,loses_str
	call DispStr
	ld de,$103D
	ld hl,Streaks_str
	call DispStr
	ld de,$1640
	;ld hl,wins_str
	call DispStr
	ld de,$1C40
	;ld hl,loses_str
	call DispStr
	ld de,$2240
	;ld hl,current_str
	call DispStr
	ld de,$1628
	ld hl,(Wins_ThisSession)
	call DispHL
	ld de,$1C28
	ld hl,(Loses_ThisSession)
	call DispHL
	ld de,$2828
	ld hl,(Wins)
	call DispHL
	ld de,$2E28
	ld hl,(Loses)
	call DispHL
	ld de,$1652
	ld hl,(LongestWinStreak)
	call DispHL
	ld de,$1C52
	ld hl,(LongestLossStreak)
	call DispHL
	ld de,$2252
	ld hl,(CurrentStreak)
	call DispHL
	ld a,' '
	call _vputmap
	ld hl,wins_str
	ld a,(CurrentStreakType)
	or a
	jr z,VS_NotLoses
	ld hl,loses_str
VS_NotLoses:
	call _vputs
VS_KeyLoop:
	halt
	call _get_key
	or a
	jr z,VS_KeyLoop
	ret
DispHL:
	ld (_penCol),de
	ld de,-1
	ld (_curRow),de
	xor a
	call $4A33
	dec hl
	jp _vputs
DispStr:
	ld (_penCol),de
	jp _vputs

Winner:
	call CopyScreen
	call RegisterWin
	call DialogBox
	ld de,$1413
	ld hl,Win_str
	call DispStr
WinLoseContinue:
	ld de,$2913
	ld hl,PlayAgain_str
	call DispStr
	ld de,$2F13
	;ld hl,YesNo_str
	call DispStr
WinLoseKeyLoop:
	halt
	call _get_key
	cp K_EXIT
	jp z,Exit
	cp K_9		;N
	jp z,Exit
	cp K_0
	jp z,Start		;Y
	jr WinLoseKeyLoop
Loser:
	call CopyScreen
	call RegisterLoss
	call DialogBox
	ld de,$1213
	ld hl,Lose_str
	call DispStr
	ld de,$1913
	;ld hl,NoLegalMoves_str
	call DispStr
	ld de,$1F13
	call DispStr
	jr WinLoseContinue

RegisterWin:
	ld hl,(Wins)
	inc hl
	ld (Wins),hl
	ld hl,(Wins_ThisSession)
	inc hl
	ld (Wins_ThisSession),hl
	ld a,(CurrentStreakType)
	or a
	jr z,AlreadySetToWin
	dec a
	ld (CurrentStreakType),a
	ld hl,0
	ld (CurrentStreak),hl
AlreadySetToWin:
	ld hl,(CurrentStreak)
	inc hl
	ld (CurrentStreak),hl
	ld de,(LongestWinStreak)
	push hl
	or a
	sbc hl,de
	pop hl
	ret c
	ld (LongestWinStreak),hl
	ret

RegisterLoss:
	ld hl,(Loses)
	inc hl
	ld (Loses),hl
	ld hl,(Loses_ThisSession)
	inc hl
	ld (Loses_ThisSession),hl
	ld a,(CurrentStreakType)
	dec a
	jr z,AlreadySetToLose
	ld a,1
	ld (CurrentStreakType),a
	ld hl,0
	ld (CurrentStreak),hl
AlreadySetToLose:
	ld hl,(CurrentStreak)
	inc hl
	ld (CurrentStreak),hl
	ld de,(LongestLossStreak)
	push hl
	or a
	sbc hl,de
	pop hl
	ret c
	ld (LongestLossStreak),hl
	ret

DialogBox:
	ld hl,$FCE2
	ld a,$FF
	ld c,%00000011
	call DrawDialogBox
	ld hl,$CAE2
	ld c,%00000010
	xor a
DrawDialogBox:
	push af
	ld a,%01111111
	or (hl) 
	ld (hl),a
	inc hl
	ld b,10
DBLoop3:
	ld (hl),$FF
	inc hl
	djnz DBLoop3
	ld a,%11111110
	or (hl)
	ld (hl),a
	ld b,40
	ld de,5
	add hl,de
DBLoop1:
	push bc
	ld (hl),%10000000
	inc hl
	ld b,10
DBLoop2:
	ld (hl),0
	inc hl
	djnz DBLoop2
	ld (hl),c
	add hl,de
	pop bc
	djnz DBLoop1
	ld b,11
DBLoop4:
	ld (hl),$FF
	inc hl
	djnz DBLoop4
	ld a,c
	or %11111110
	ld (hl),a
	add hl,de
	pop af
	ld c,a
	ld a,%01111111
	and c
	ld (hl),a
	inc hl
	ld b,11
DBLoop5:
	ld (hl),c
	inc hl
	djnz DBLoop5
	ret

DispPercentage:
	ld a,h
	or l
	jr nz,Not0
	ld hl,0
	jr DisplayPercentage
Not0:
	push hl
	or a
	sbc hl,de
	pop hl
	jr nz,Not100
	ld hl,100
	jr DisplayPercentage
Not100:
	xor a
	call MultAHL100
	push de
	pop ix
	ld c,1
	ld b,0
DivAHLBDE:
	push de
	push ix
	pop de
	call cpahlbde
	pop de
	jr c,Done
	jr z,Done
	add ix,de
	push af
	ld a,b
	adc a,0
	ld b,a
	pop af
	inc c
	jr DivAHLBDE
cpahlbde:
	push bc
	push hl
	cp b
	jr z,ContinueCompare
	jr c,BDEGreater
AHLGreater:
	ld c,a
	ld a,1
	or a
	ld a,c
AHLGreater2:
	pop hl
	pop bc
	ret
ContinueCompare:
	or a
	sbc hl,de
	jr z,AHLGreater2
	jr nc,AHLGreater
BDEGreater:
	scf
	pop hl
	pop bc
	ret
Done:
	ld l,c
	xor a
	ld h,a
DisplayPercentage:
	call _divHLby10
	push af
	call _divHLby10
	push af
	call _divHLby10
	or a
	jr z,NoDisp1
	add a,'0'
	call _vputmap
NoDisp1:
	pop af
	add a,'0'
	call _vputmap
	pop af
	add a,'0'
	call _vputmap
	ld a,'%'
	call _vputmap
	ret
MultAHL100:
	ld b,h
	ld c,l
	add hl,hl
	add hl,hl
	add hl,bc
	add hl,hl
	ld b,h
	ld c,l
	add hl,hl
	add hl,hl
	adc a,0
	add hl,bc
	adc a,0
	add hl,hl
	adc a,0
	ret

PutSpriteGray:
	ld (PutSprite_Height+1),a
	add a,a
	ld (PutSprite_Height2+2),a
	xor a
	ld (PutSprite_Height3+1),a
	ld a,c
	cp 57
	jr c,PS_NoClip
	ld d,a
	ld a,64
	sub d
	ld (PutSprite_Height+1),a
	ld d,a
	ld a,8
	sub d
	ld (PutSprite_Height3+1),a
PS_NoClip:
	push hl
	ld d,0
	ld a,b
	cp 200
	jr c,PS_NotOffScreen
	xor a
	ld b,a
PS_NotOffScreen:
	and $07
	ld e,a
	ld h,d
	srl b
	srl b
	srl b
	ld a,c
	add a,a
	add a,a
	ld l,a
	add hl,hl
	add hl,hl
	ld a,e
	ld e,b
PutSprite_buffer:
	ld d,$90
	add hl,de
	ld e,a
	pop ix
	push hl
	push de
	call PutSprite_Height
	pop de
	pop hl
	ld bc,1024
	add hl,bc
	ld a,(PutSprite_Height2+2)
	or a
	rra
	ld (PutSprite_Height2+2),a
PutSprite_Height3:
	ld bc,0
	add ix,bc
PutSprite_Height:
	ld b,8
PS_Draw:
	push bc
	push de
	ld c,(ix)
PutSprite_Height2:
	ld b,(ix+8)		;this is altered
	inc ix
	xor a
	ld d,a
PS_Shift:
	dec e
	jp m,PS_DoneShift
	srl c
	rra
	srl b
	rr d
	jp PS_Shift
PS_DoneShift:
	inc hl
	ld e,a
	ld a,e
	or (hl)
	ld (hl),a
	ld a,d
	xor e
	cpl
	and (hl)
	ld (hl),a
	dec hl
	ld a,c
	or (hl)
	ld (hl),a
	ld a,b
	xor c
	cpl
	and (hl)
	ld (hl),a
	ld de,16
	add hl,de
	pop de
	pop bc
	djnz PS_Draw
	ret

;Randomization routine by Jimmy Mardell
random:	       ; Creates a pseudorandom number 0 <= x < A
	push bc
	push hl
	ld b,a
	ld a,r
	add a,a
	ld hl,0
	ld d,0
	ld e,a
RMul:
	add hl,de
	djnz RMul
	ld a,h
	pop hl
	pop bc
	ret


#include grayscale2.h

progname:
	.db 8,"freecell"
Title:
	.db "FreeCell v1.0",0
	.db "written by:",0
	.db "Ben Mickle",0
Win_str:
	.db "Congratulations, you win!",0
PlayAgain_str:
	.db "Do you want to play again?",0
YesNo_str:
	.db "([Y]es / [N]o)",0
Lose_str:
	.db "Sorry, you lose.",0
NoLegalMoves_str:
	.db "There are no more",0,"legal moves.",0
NewGame_str:
	.db "F1 - New Game",0
ViewStats_str:
	.db "F2 - View Statistics",0
ClearStats_str:
	.db "F3 - Clear Statistics",0
ResumeGame_str:
	.db "F4 - Resume Game",0
TurnOff_str:
	.db "F5 - Turn off calculator",0
MoveCol_str:
	.db "F1 - Move Column",0
	.db "F2 - Move Card",0
	.db "F3 - Cancel",0
ThisSession_str:
	.db "This session",0
Total_str:
	.db "Total    ",0
Streaks_str:
	.db "Streaks",0
wins_str:
	.db "wins",0
loses_str:
	.db "loses",0
current_str:
	.db "curr",0

Statistics:
Wins:
	.dw 0
Loses:
	.dw 0
LongestWinStreak:
	.dw 0
LongestLossStreak:
	.dw 0
CurrentStreak:
	.dw 0
CurrentStreakType:
	.db 0		;0 - wins, 1 - loses


Arrow:
	;.db 8, 8
	.db %11111110
	.db %10000100
	.db %10001000
	.db %10000100
	.db %10100010
	.db %11010100
	.db %10001000
	.db %00000000
	.db %11111110
	.db %10000100
	.db %10001000
	.db %10000100
	.db %10100010
	.db %11010100
	.db %10001000
	.db %00000000
	.db %11111110
	.db %11111100
	.db %11111000
	.db %11111100
	.db %11111110
	.db %11011100
	.db %10001000
	.db %00000000

Arrow2:
	;.db 8, 10
	.db %01111100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %10000010
	.db %01000100
	.db %00101000
	.db %00010000
	.db %01111100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %10000010
	.db %01000100
	.db %00101000
	.db %00010000
	.db %01111100
	.db %01111100
	.db %01111100
	.db %01111100
	.db %01111100
	.db %01111100
	.db %11111110
	.db %01111100
	.db %00111000
	.db %00010000

Arrow3:
	;.db 8, 8
	.db %00010000
	.db %00111000
	.db %01111100
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00010000
	.db %00111000
	.db %01111100
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000

Ace:
	;.db 8, 6
	.db %01111111
	.db %01001100
	.db %01010010
	.db %01011110
	.db %01010010
	.db %01010010

Two:
	;.db 8, 6
	.db %01111111
	.db %01011000
	.db %01000100
	.db %01001000
	.db %01010000
	.db %01011100

Three:
	;.db 8, 6
	.db %01111111
	.db %01011000
	.db %01000100
	.db %01001000
	.db %01000100
	.db %01011000

Four:
	;.db 8, 6
	.db %01111111
	.db %01010100
	.db %01010100
	.db %01011100
	.db %01000100
	.db %01000100

Five:
	;.db 8, 6
	.db %01111111
	.db %01011100
	.db %01010000
	.db %01011000
	.db %01000100
	.db %01011000

Six:
	;.db 8, 6
	.db %01111111
	.db %01001100
	.db %01010000
	.db %01011100
	.db %01010100
	.db %01011100

Seven:
	;.db 8, 6
	.db %01111111
	.db %01011100
	.db %01000100
	.db %01001000
	.db %01010000
	.db %01010000

Eight:
	;.db 8, 6
	.db %01111111
	.db %01011100
	.db %01010100
	.db %01011100
	.db %01010100
	.db %01011100

Nine:
	;.db 8, 6
	.db %01111111
	.db %01011100
	.db %01010100
	.db %01011100
	.db %01000100
	.db %01011000

Ten:
	;.db 8, 6
	.db %01111111
	.db %01010010
	.db %01010101
	.db %01010101
	.db %01010101
	.db %01010010

Jack:
	;.db 8, 6
	.db %01111111
	.db %01011110
	.db %01000100
	.db %01000100
	.db %01010100
	.db %01011100

Queen:
	;.db 8, 6
	.db %01111111
	.db %01011100
	.db %01010100
	.db %01010100
	.db %01010100
	.db %01001110

King:
	;.db 8, 6
	.db %01111111
	.db %01010010
	.db %01010100
	.db %01011000
	.db %01010100
	.db %01010010

Heart:
	;.db 8, 6
	.db %11111110
	.db %01010010
	.db %10101010
	.db %10001010
	.db %01010010
	.db %00100010
	.db %11111110
	.db %01010010
	.db %11111010
	.db %11111010
	.db %01110010
	.db %00100010

Club:
	;.db 8, 6
	.db %11111110
	.db %01110010
	.db %01110010
	.db %11111010
	.db %11011010
	.db %00100010
	.db %11111110
	.db %01110010
	.db %01110010
	.db %11111010
	.db %11011010
	.db %00100010

Diamond:
	;.db 8, 6
	.db %11111110
	.db %00100010
	.db %01010010
	.db %10001010
	.db %01010010
	.db %00100010
	.db %11111110
	.db %00100010
	.db %01110010
	.db %11111010
	.db %01110010
	.db %00100010

Spade:
	;.db 8, 6
	.db %11111110
	.db %00100010
	.db %01110010
	.db %11111010
	.db %11011010
	.db %00100010
	.db %11111110
	.db %00100010
	.db %01110010
	.db %11111010
	.db %11011010
	.db %00100010

CardBottom_Left:
	;.db 8, 10
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01111111
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111

CardBottom_Right:
	;.db 8, 10
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %11111110
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110

BlankCard_Left:
	;.db 8, 16
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01111111
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111
	.db %01111111

BlankCard_Right:
	;.db 8, 16
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111110
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110

DynamicCard:

.end
