;FallDown Forever by Aaron Curtis in '99

;Best in 1024x768 or higher

;Thought you were going to do some easy reading, eh?
;Not likely!
;You thought wrong!
;I have made this source disturbingly complicated...
;Hahahahahahahahahah...

;In retrospect I think it would've been better (ie/ it
;wouldn't flicker as much) to do the double buffering
;in the interupts, but the way I have it works at least.

;Known problems:
;-link routines are not very stable...
;-pressing down-left increases flicker (wtf?)
;-something may be corrupting the memory on page 1?

;Basics of how this thing works:
;	4 video planes are set up starting at $f000, each plane
;comprising half of the screen (for grayscale).  The game then
;runs as follows:  Sprites are drawn to the currently inactive
;screen (2 planes).  The inactive screen is made active and vice-
;versa.  The active screen is copied to the inactive one,
;but offset by 16 bytes.  This accomplishes scrolling.  Then
;one randomly determined tile is drawn to a buffer; this buffer
;is copied 1 line at a time onto the inactive screen at set 
;intervals.  This is done to prevent choppiness, and is necessary
;for link play.  Sprites are then erased from the inactive
;screen (the opposite one on which they were drawn).  Player
;information is then updated either by keypresses or by the
;link.  The process is then repeated.


#include "ti86asm.inc"
#include ti86und.inc
#include ti86abs.inc
#include asm86.h

x equ $b800

backsave equ x						;32 bytes to save background
ycoord equ x+32						;2 bytes for coordinates
xcoord equ x+33
backcount equ x+34					;1 byte counter for the background tile
backtile equ x+35					;2 bytes pointer to background tile
losses equ x+37						;1 byte, number of link failures in a row
animcount equ x+40					;1 byte counter, tell what animation frame is in use
									;a 0 must preceed page and follow animcount
page equ $eee0						;1 byte, upper byte of pointer to current page flipping address (2 consecutive planes)
score equ x+45						;3 bytes, score (stored low-middle-high)
temp equ x+48						;7 bytes, string used to display score (last must=0)
passedlines equ x+56				;1 byte counter of number of platforms gone by
speedcount equ x+57					;1 byte, tells when the game should speed up
players equ x+58					;1 byte, number of players (1=1, 0=2)
linkstat equ x+59					;1 byte, tells whether this calc is sending or receiving
oppycoord equ x+60					;2 bytes for opponent's coordinates
oppxcoord equ x+61
oppback	equ x+62					;32 bytes to save background under opponent

spritedata equ $9000				;table of pre-shifted gfx

newstack equ $ec00					;$100 bytes (256) need the old stack space for video layers (must not be on page 1)

ltiles equ $a000
dtiles equ $b000					;64 bytes each, areas for the next row of tiles to be drawn (off screen)

.org _asm_exec_ram

	nop
	jp start
	.dw $0001
	.dw title
	.dw icon
	
title:
	.db "Fall Down Forever 2.0",0
icon:
	.db 16,1
	.db %11100110
	.db %10000101
	.db %11000101
	.db %10000110
	.db %00000000
	.db %01111100
	.db %11111110
	.db %11111111
	.db %11100111
	.db %11100111
	.db %00001111
	.db %00011110
	.db %00111100
	.db %01111111
	.db %11111111
	.db %11111111


start:
	;**** move the stack ****
	ld hl,$fb00	
	ld de,newstack
	ld bc,256
	ldir								;copy the stack to it's new home
	ld h,b								;ld hl,0
	add hl,sp							;put sp in hl
	ld h,$ec
	ld sp,hl						

	call _flushallmenus
	call _runindicoff

	xor a								;make sure a 0 comes before page (useful later)
	ld (page-1),a
start2:
	call copytext
	call duplicate

startgame:
	ld a,%11000000						;put link in normal state
	out (7),a

	;**** set up grayscale handler ****
	ld hl,$ed00							;vector table starts here
	ld a,h
	ld i,a								;put table address in i
	ld b,1								;ld bc,256
	ld d,h								;put $ed01 in de
	ld e,b
	ld (hl),$ee							;table points to $eeee
	ldir								;table is 257 bytes
	ld d,(hl)
	ld e,(hl)							;ld de,$eeee
	ld hl,intcode
	ld c,endintcode-intcode				;intcode < 256 bytes
	ldir								;copy the interupt code to $eeee
	im 2								;tell calc to use im 2

	call _clrLCD
	call copytext
	ld hl,$a000							
	ld de,$a001						
	ld b,$b9-$a0						;c doesn't matter
	ld (hl),l							;l=0
	ldir								;clear stuff on ram page 1, all variables set to 0

	ld (linkend+1),sp					;save the stack pointer

	call setupscreen					;set up variables, has nothing to do with the screen
	call titlescreen					;display the title screen
	call _clrLCD

	ld hl,waittext
	ld d,b
	ld e,c								;bc=0 after _clrLCD
	ld a,(players)						;check how many players we have
	ld b,a
	ld a,(linkstat)						;see if this calc has been marked as sending
	or b								;see if both=0 (2 players, receiving)
	push af
	call z,disptext						;the first player to get here will be receiving...
										;linkstat is 0 by default
	call copytext
	call transition

	pop af
	jr nz,singleplay					;if 1 player or sending, skip this part
	ld a,%11010100						;lower the red wire to signal other calc
	out (7),a
wait2play:
	call getkeyz
	cp K_EXIT
	jp z,start2
	in a,(7)
	and %00000011
	jr nz,wait2play						;wait for the white wire to go low
	ld a,%11000000						;raise both wires
	out (7),a
waitlinkstart:
	in a,(7)
	rra
	rra
	jr nc,waitlinkstart					;wait for white wire to go high (other calc must give ok)
	ld bc,(numhalts+1)					;ld c,(numhalts+1)
sendagain:
	call send							;send the game speed to the other calc
	jr c,sendagain						;if link failed, try again	

singleplay:
	ld a,%00000101
	ld ($eeee+reloadc+1-intcode),a		;switch to 1:2 mixing in game (title uses 2:3)
	ld hl,$c008							;increase contrast a bit (see interrupt routine)
	inc (hl)

	;**** the main program loop ****
mainloop:
	call drawball						;draw the ball to the invisible layer
	ld a,(players)
	or a
	call z,drawoppball					;draw opponent's ball if in 2 player mode

	ld a,(page)						
	xor %00001000						;$f0<->$f8, change visible layer to invisible
	ld (page),a							;double buffering (the hard way) (n.b. hard=fast)

numhalts:
	ld a,0								;get number of halts (self-modifying)
	or a
	jr z,superfast
haltloop:
	dec a								;cp 0, also decrement counter
	halt								;delay program a bit
	jr nz,haltloop						;do it again
superfast:

	ld d,a								;ld de,0 (coordinates for the top-left corner)
	ld e,a
	ld a,(players)						;no score in multiplayer
	or a
	push af
	call nz,dispscore					;display score

	call scroll							;scroll up, also draw a tile in the tile buffer
										;scrolling actually copies the visible layer to the invisible one
									
	pop af
	call z,eraseoppball					;erase opponent's ball in 2 player mode

	call eraseball						;remove the ball from the invisible layer

	ld a,(ycoord)						;update y coordinate (gravity)
	cp 55								;55 is the bottom
	adc a,0								;increment if less than 55
	ld (ycoord),a						;save position

	call fallcheck						;see if the ball will be pushed up
	call z,addpoints					;if the ball falls, you get some points
	
	ld a,%10111111						;begin key checking
	out (1),a							;I have elected not to use any nop's
	in a,(1)
	rla									;check for more key
	call nc,pause
	rla									;check for exit key
	jr c,exitnotpressed
	ld a,(players)						;exit does different things for different player modes...
	or a
	jp z,exitpressed					;if 2-player, exit=game over
	jp nz,exitgame						;if 1-player, it assumes you want to leave quickly :)
exitnotpressed:

	ld bc,(ycoord)						;get coordinates before changing them
	ld de,7*16							;pre-load value used in both routines
	ld a,%11111110						;\
	out (1),a							; \
	in a,(1)							;  |
	rra									;  |
	rra									;  	- check for arrow keys	
	push af								; /
	call nc,moveleft					; \
	pop af								;  |
	rra									; /
	call nc,moveright					;/

	ld a,(players)
	or a
	jr nz,nolink						;see if we need to update the opponent's position
	ld a,(linkstat)
	or a
	jr z,receivestuff					;see which order we're doing this in
	call senddata						;send player coords to other calc
	call receivedata					;receive opponent coords
	jr nolink
receivestuff:
	call receivedata					;same as above but in reverse order
	call senddata
nolink:

	ld a,(backcount)					;\
	inc a								; |
	and 7								;  -- go to next line in background
	ld (backcount),a					;/
	jr nz,jpmain						;and do it all over again

	ld a,(animcount)					;do this 1 in 8 times
	add a,16							;16 bytes per frame...
	and %00110000
	ld (animcount),a
jpmain:
	jp mainloop
	


receivedata:
	call receive						;receive low byte
	ret c
	ld l,c								;otherwise use the received byte
	call receive						;receive high byte
	ret c
	ld h,c
notreceived:
	ld (oppycoord),hl
	ret

senddata:
	ld hl,(ycoord)
	ld c,l
	call send
	ret c
	ld c,h
	jp send

dump_cache:								;a=0-3, the line we're on in the tile buffer
	add a,a								;multiply by 16
	add a,a
	add a,a
	add a,a

	ld l,a
	ld h,$b0							;now hl points to somewhere in dtiles
	.db $dd,$6f			;ld ixl,a		(undocumented op-codes)
	.db $dd,$26,$a0		;ld ixh,$a0		ix points to an equivalent place in ltiles

	ld a,(page)							;high byte of current viewable layer
	xor %00001000						;switch to the invisible one
	add a,3								;\
	ld d,a								; \
	ld e,$f0							;--- put the last line (light layer) in de, ie/ $03f0 from the start of the page

	ld c,e								;\
	add a,4								; \
	ld b,a								;--- dark invisible layer in bc, same offset as the light layer

	ld a,16
drawline:
	push af								;arr!!!  I need more registers!
	ld a,(hl)							;swipe a byte from the dark tile buffer
	or a								;cp 0
	jr z,notile							;if 0, there's a hole there
	ld (bc),a							;otherwise stick it on the screen
	ld a,(ix+0)							;then get on from the light layer
	ld (de),a							;and stick that on the screen
notile:
	inc l								;increment everything (only lower bytes necessary)
	inc e
 	inc c
	.db $dd,$2c			;inc ixl
	pop af
	dec a
	jr nz,drawline						;do 16 times

	ld a,(passedlines)					;count up how many times this routine has been called
	inc a
	and %00111111
	ld (passedlines),a
	ret nz
	ld a,(numlines+1)					;after 64, make the platforms get closer together
	cp 26								;but not if they're already really close
	jr z,tooclose
	dec a
	dec a
	ld (numlines+1),a
tooclose:
	ld a,(speedcount)					;count up how many times the above has happened
	inc a
	and %00000011
	ld (speedcount),a
	ret nz
	ld a,(numhalts+1)					;after 4, speed the game up
	sub 1								;cp 1 / dec a
	ret c								;can't remove a halt if there are none
	ld (numhalts+1),a
	ld hl,ldpoints+1					;only fair to give you more points
	inc (hl)
	ld hl,(backtile)					;go to next background as well
	ld bc,8
	add hl,bc
	ld (backtile),hl
	ret

pause:									;actually turn off the calc
	ld a,(players)
	or a								;no pausing in 2 player games
	ld a,%10000000						;for keypresses
	ret z
	rlca								;ld a,%00000001 mask timer interupts, turn lcd off
	out (3),a
	halt								;wait till you press on (puts thing back to normal too)
	ld bc,$f000							;give the calc a LONG time to think about it
										; (the hardware must return to normal before another halt
										; is reached, not sure on the specifics of this)
	rrca								;ld a,%10000000 (for keypresses)	
pauseloop:
	cpi									;dec bc
	ret po								;ret if bc=0
	jr pauseloop						;otherwise keep looping

addpoints:
	ld a,(players)
	or a
	ret z
	ld hl,(score)
ldpoints:								;self-modifying code here
	ld bc,1								;points added depends on game speed
	add hl,bc
	ld (score),hl
	ret nc
	ld hl,score+2						;if score goes over 64k, make a note of it
	inc (hl)
	ret

dispscore:								;the routine that uses _dispAHL is too slow
	ld hl,(score)
	ld a,(score+2)
dispahl:
	ld (_penCol),de
	ld iy,$c3e5
	ld de,temp+5
scoreloop:
	call _divAHLby10					;this call is very weird, it divides ahl by 10, but
	add a,$30							; puts the remainder in a, thus screwing up the answer...
	dec de
	ld (de),a
	ld a,h
	or l								;only check for hl=0
	ld a,0								;if the score is <19 bits, a would be 0 anyway (need flags)
	jr nz,scoreloop
	ex de,hl
	jp _vputs

copytext:								;text is all in dark gray, this makes it black
	ld hl,$fc00
	ld de,$f800
	ld bc,1024
	ldir
	ret

moveleft:
	ld a,b
	or a
	ret z								;return if x coord is 0
	call findpixel						;returns z if no shift
	jr nz,nolcheck						;only have to check if there's no shift
	ld a,h								;findpixel returns hl in the light layer, so move is to dark
	add a,4
	ld h,a
	dec l								;checking the byte to the left
	ld a,(hl)	
	or a
	ret nz								;return if there's a dark byte to the left, ie/ a wall
	add hl,de
	cp (hl)								;a=0
	ret nz								;have to do the same for the bottom of the ball too
nolcheck:		
	ld hl,xcoord
	dec (hl)
	dec (hl)
	ret

moveright:
	ld a,b
	cp 120	
	ret z
	call findpixel
	ld a,h
	add a,4
	ld h,a
	inc l
	ld a,(hl)
	or a
	ret nz
	add hl,de
	cp (hl)								;a=0
	ret nz
	ld hl,xcoord
	inc (hl)
	inc (hl)
	ret


gameover:
	pop af								;was in a call...
exitpressed:
	ld de,$0600
	ld hl,govertext
	ld a,(players)
	or a
	jr nz,normaldeath
	ld a,%11111100						;lower both wires
	out (7),a							;signal for "I'm dead"
	ld hl,losertext
linkdeath:
	ld de,$0800
normaldeath:
	ld (_curRow),de
	push hl
	call duplicate
	call _clrLCD
	pop hl
	call _puts							;print Game Over or whatever
	call getkeyz						;flush keypress buffer

	ld de,(score)
	ld a,(score+2)						;your score in ade
	ld hl,lastscore+2					;pointer to lowest high score (high byte)
	ld b,5								;counter for this loop...
checkscore:
	push bc
	push hl
	ld b,(hl)
	dec hl
	ld c,(hl)
	dec hl
	ld l,(hl)
	ld h,c								;high score in bhl
	ex de,hl							;ahl and bde, respectively
	call _cp_ahl_bde					;c if your score is lower
	ex de,hl							;your score back to ade
	pop hl
	pop bc
	jr c,scorechecked
	push bc
	ld bc,-14							;go to the next highest score
	add hl,bc
	pop bc
	djnz checkscore
scorechecked:
	ld c,a								;score in cde
	ld a,b
	cp 5
	jp z,exitwait						;leave if score<lowest high score
	push bc
	push de								;save your score (in cde)

	ld de,$10000-(lastscore+2-(14*5))	;highest (lowest in memory) position attainable
	add hl,de							;hl=last address reached
	push hl								;now hl=the difference

	ld de,-(14*4)
	add hl,de
	ld d,h
	ld e,l
	add hl,hl
	ex de,hl
	or a
	sbc hl,de
	jr z,nomovedown
	ld c,l
	ld b,h
	ld hl,highnames+(14*4)-1
	ld de,highnames+(14*5)-1
	lddr								;move all the low scores down a notch

nomovedown:
	ld hl,hiscore						;display high score text
	ld de,$1220
	call disptext						;hl automatically points to the next string
	ld d,$18							;de=$1820
	call disptext

	ld hl,$0505
	ld (_curRow),hl
	call copytext
	call transition

	pop de								;get high score position (from push hl above)
	ld hl,highnames+11
	add hl,de							;hl points to the high scores
	pop bc	
	ld (hl),c
	inc hl
	ld (hl),b							;save your score
	pop bc
	inc hl
	ld (hl),c
	ld hl,highnames
	add hl,de							;now hl points to the names...
	
;**** string input routine ****

	ld b,10								;max 10 letters
nameloop:
	exx									;save counter and pointer to high score data
namewait:								;no need to di because of custom interrupt routine
	ld a,'_'
	call _putmap						;put an underscore on the screen
	call getkeyz
	cp K_ENTER							;if enter, leave this routine
	jr z,donename
	cp K_DEL							;if del, go back a space
	jr z,backspace
	or a								;if no keypress, check again
	jr z,namewait
	ld e,a								;save keypress in e
	ld a,$2e							;$2e = keypress for A
	ld d,0								;d is a counter...
letterloop:
	cp e
	jr z,gotletter						;if keypress = keypress for a certain letter
	inc d								;go to next letter in alphabet
	jr z,namewait						;if d = 0, it was a bad key (no letter above it)
	sub 8								;go to corresponding keypress for the next letter
	cp $0a								;check the include file...  there is a pattern for the letters
	jr nc,letterloop
	add a,$27
	jr letterloop						;keep going until the key codes match
gotletter:
	ld a,d								;put the number of the letter in a
	cp 20								;decrement if over 20 (equal sign)
	adc a,-1
	cp 24								;decrement if over 26 (pattern is disrupted for some reason...)
	adc a,-1
	cp 26								;the space doesn't follow the pattern, so it has to be fixed manually
	call z,space

	add a,LcapA							;translate to ascii codes
	call _putc							;stick it on the screen
	exx									;get counter/high score address back
	ld (hl),a							;save the letter there
	inc hl								;go to next byte
	djnz nameloop						;repeat up to 10 times
	jr exitgame							;and then we're done

donename:								;if enter was pressed...
	exx
spaceloop:
	ld (hl),$20							;fill the rest of the string with spaces
	inc hl
	djnz spaceloop	
	jr exitgame

space:
	ld a,$20-$41						;code for the space, adjusted to fit in the routine
	ret

backspace:
	ld a,$20
	call _putmap						;erase the underscore
	ld a,(_curCol)
	dec a								;go back a space in the text coordinates
	cp 4
	jr z,namewait
	ld (_curCol),a	
	exx
	dec hl								;same with the high score data
	inc b								;and the counter
	exx
	jr namewait

exitwait:								;wait for a keypress...
	call copytext
	call transition
waitexit:
	call getkeyz
	or a	
	jr z,waitexit

exitgame:
	call duplicate
	ld hl,$c008							;put contrast back to original value
	dec (hl)
	jp startgame						;go back to title screen

quit:
	pop af								;quit was jumped to from w/in a call
	ld iy,$c3e5							;put iy back to system flags
	im 1								;back to normal interupts, system needs those too
	ld a,$3c							;same as $fc
	out (0),a							;make sure the display is where it's supposed to be

	;**** return the stack ****
	ld hl,newstack
	ld de,$fb00
	ld bc,256
	ldir								;copy the stack back to it's original spot
	ld h,b								;ld hl,0
	add hl,sp
	ld h,$fb
	ld sp,hl							;put sp back to what it should be

	;**** write back for high scores ****
	ld hl,gamefile-1
	call varstuff
	ld de,-16384+highnames-_asm_exec_ram+4
	add hl,de
	ex de,hl
	ld hl,highnames
	ld bc,71
	ldir
	ld a,$0d
	out (5),a

	call _homeup
	jp _clrScrn	

gamefile:
	.db 3,"FD2"

varstuff:
	rst 20h
	rst 10h
	ret c
	ex de,hl
	ld a,b
	call _load_ram_ahl
	out (5),a
	inc a
	out (6),a
	ret

getkeyz:
	halt								;save some battery life
	call $01a1							;this is normally done in interupts, but those were changed...
	jp _getky							;otherwise this is the same as the _getky command

fallcheck:
	ld bc,(ycoord)
	ld a,c
	add a,6
	ld c,a								;checking the line beneath the ball (6 lines because it's been scrolled)
	call findpixel
	ld d,a
	ld a,h								;go to the dark layer
	add a,4
	ld h,a
	ld a,(hl)
	or a								;if the byte is 0, there's nothing there
	jr nz,ballup
	cp d								;a=0, see if d=0 too (means it's not shifted)
	ret z
	inc hl
	cp (hl)								;a=0
	ret z
ballup:
	ld a,(ycoord)
	dec a
	jr z,jpgameover
	dec a
jpgameover:
	jp z,gameover
	ld (ycoord),a
	ret

titlescreen:
	ld hl,titlefile-1
	call varstuff
	jr c,notitlepic
	ld de,-16384+2			;skip header bytes and go back 1 ram page
	add hl,de
	ld de,$f800
	call DispRLE			;a big thanks to Dave Phillips for this one
notitlepic:
	ld a,$0d				;put the call table back in
	out (5),a
	call _RAM_PAGE_1

	ld hl,speedtext
	exx						;the interupt routine only uses a and c, so no need to use di
	ld hl,texttable
	ld b,8
textloop:
	ld e,(hl)
	inc hl
	ld d,(hl)	
	inc hl
	push de
	exx
	pop de
	call disptext
	exx
	djnz textloop	

	call toggleplayers
	ld a,(backflag)
	call checkback

waitloop:
	in a,(7)
	and %00000011
	cp 2					;if red wire is low and white is high a 2 player game has been started
	jr z,startlink
	call getkeyz
	ld hl,$c008
	cp K_PLUS
	call z,incathl
	cp K_MINUS
	call z,decathl
	cp K_ALPHA
	call z,doplayers
	sub K_SECOND
	call z,toggleback
	dec a
	jp z,quit
	dec a
	jp z,halloffame
	add a,7
	jr nc,waitloop

startit:
	ld (numhalts+1),a
	neg
	add a,7
	ld (ldpoints+1),a 
	sub 3
	add a,a
	add a,a
	add a,a
	ld hl,backtile1
	ld e,a
	ld d,0
	add hl,de
	ld (backtile),hl
	ret

startlink:
	call _clrLCD
	ld d,b
	ld e,b
	ld hl,opptext
	call disptext
	call _vputs
	ld de,$0600
	call disptext
	call copytext
	call transition
waitkey:
	call getkeyz	
	or a
	jr z,waitkey

	cp K_EXIT
	jp z,killlink2	

	ld a,62
	ld (xcoord),a			;this calc controls the one on the right
	ld (linkstat),a			;any non-zero number means this calc is sending (in the main loop)
	ld a,50
	ld (oppxcoord),a		;the other calc controls the left (done in setupscreen)
	xor a
	ld (players),a			;have to be in 2 player mode

	ld a,%11101000
	out (7),a				;lower white wire in response
wait4red:
	in a,(7)
	rra
	jr nc,wait4red			;wait for red wire to be raised		
	ld a,%11000000
	out (7),a				;raise both wires on this side (ready to go now)
	call receive			;receive game speed from other calc
	ld a,c
	jr startit

toggleback:
	ld a,(backflag)
	xor 1
	ld (backflag),a
checkback:
	inc a
	ld b,a
	ld hl,offtext
offoron:
	push bc
	ld de,$3448
	call disptext
	pop bc
	djnz offoron
endtoggle:
	call transition
	call duplicate
	ld a,200
	ret

doplayers:
	call toggleplayers
	jr endtoggle

toggleplayers:
	ld a,(players)
	xor 1
	ld (players),a
	rra					;ld a,0 and check the lowest bit
	sbc a,-$32
	ld hl,$3a3d
	ld (_penCol),hl
	jp _vputmap

incathl:
	inc (hl)
	ret
decathl:
	dec (hl)
	ret

behold:
	.db "Behold!  The All Time Champions!",0

highnames:
	.db "----------",0
	.dw 1000
	.db 0
	.db "----------",0
	.dw 900
	.db 0
	.db "----------",0
	.dw 800
	.db 0
	.db "----------",0
	.dw 700
	.db 0
	.db "----------",0
lastscore:
	.dw 600
	.db 0

backflag:
	.db 0

titlefile:
	.db 8,"fd2title"					

disptext:
	push de
	ld (_penCol),de
	call _vputs
	pop de
	ret

govertext:
	.db "Game Over",0

hiscore:
	.db "You have a high score!",0
entername:
	.db "Enter your name:",0
speedtext:
	.db "Choose",0
	.db "Speed",0
fkeytext:
	.db "[F1-F5]",0
hightext:
	.db "Hall of",0
	.db "Fame",0
moretext:
	.db "[MORE]",0
optext:
	.db "[2ND] Background - O",0
playerstext:
	.db "[ALPHA] Players - ",0
offtext:
	.db "FF",0
ontext:
	.db "N  ",0
opptext:
	.db "Your Opponent Is ",0
waittext
	.db "Waiting...",0
presskeytext:
	.db "Press Any Key",0
winnertext:
	.db "Winner!",0
losertext:
	.db "Loser!",0
errortext:
	.db "Error!",0
author:
	.db "Made by Aaron Curtis",0 
	.db "<acurti1@umbc.edu>",0



halloffame:
	pop af
	call _clrLCD
	ld hl,author
	ld de,$340c
	call disptext
	ld d,$3a			;de=$3a0c
	call disptext
	ld hl,behold
	ld d,$00			;de=$000c
	call disptext
	ld b,5
	ld de,$0c12
namesloop:
	push bc
	call disptext
	push de
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	push hl
	ld a,(hl)
	ld h,b
	ld l,c
	ld e,$58
	call dispahl
	pop hl
	pop de
	ld a,d
	add a,7
	ld d,a
	inc hl
	pop bc
	djnz namesloop
	call copytext
	call transition
hallwait:
	call getkeyz
	or a
	jr z,hallwait
	call duplicate
	jp startgame




scroll:
	;**** main scrolling part ****
	ld hl,(page-1)							;because there's a 0 before the page byte, this is actually the right address
	ld a,h									;so hl is a pointer to the visible layer
	xor %00001000
	ld d,a									;now de is a pointer to the invisible one
	ld e,l
	push de									;hang on to this for later
	ld bc,16
	add hl,bc								;offset hl down 1 line, so when copied the 2nd line becomes the first
	ld bc,2048								;2 video pages = 2048 bytes (one for light, one for dark)
	ldir									;now the screen is scrolled *and* copied to the invisible layer

	;**** redrawing the bottom line ****    (a pain with the double buffering)
	pop hl									;get invisible layer back in hl
	ld de,2048-16
	add hl,de								;go to the last line of the dark tiles
	ld d,h
	ld e,l
	inc e									;put a pointer to the next byte over in de
	ld c,15									;ld bc,15 (b is 0 from above)
	ld (hl),b		
	ldir									;zero-out the whole bottom line

	push hl
	ld hl,(backtile)						;get pointer to the background tile
	ld a,(backcount)
	ld c,a
	add hl,bc								;then move to the correct line
	ld a,(backflag)
	or a									;if this is 0 there is no background
	ld c,a
	jr z,nobg
	ld c,(hl)								;now get one line of the background tile in a
nobg:
	pop hl

	ld a,-4
	add a,h	
	ld h,a
	ld d,h
	ld e,l
	dec e									;put one less than hl in de
	ld (hl),c
	ld c,15									;same as before, ld bc,15
	lddr									;same as before, but going backwards and copying the background	

	;**** pre-caching platform tiles ****
linecount:									;label for self-modifying code
	ld a,4									;starts at 4 so the platforms don't come right away
	inc a
numlines:
	cp 40									;more self-modifying code here
	jr c,stillgood
	xor a									;reset after it hits a certain number
stillgood:
	ld (linecount+1),a						;save a back to the "ld a,4" line above
	cp 4									;if under 4, draw the cache to the screen
	jp c,dump_cache							; instead of updating it

platformcount:
	ld a,0									;which tile we're drawing (self-modifying)
	ld c,a									;put in bc
	inc a
	and 15
	ld (platformcount+1),a					;update counter while we're here

	ld hl,dtiles							;put the dark tile buffer in hl
	add hl,bc								;now point to the right one
	ld d,$a0								;slick way of putting ltiles in de with the right offset
	ld e,l

	push de									;link routines will destroy de
	ld a,(players)
	or a
	jr nz,oneplayer							;if 1 player, just go to the random generator
	ld a,(linkstat)
	or a
	jr z,receiverand						;if 2 player and receiving, go to that part
	call random								;if 2 player and sending, get a random number
	ld c,a									;get ready to send it
	push af									;save it, because sending destroys a and c
	call send								;now send it
	pop af									;get the number back
	jr gotrand								;and resume normal operation
receiverand:
	call receive							;now the receiving part...
	ld a,c									;get the number from the other calc
	jr nc,gotrand							;if link worked, use that number
oneplayer:
	call random
gotrand:
	pop de
	ld b,4									;4 lines per tile
	cp 45									;45/255 chance of getting a hole
	jr c,putahole

tilecount:
	ld a,0									;see how many tiles in a row there are (self-modifying)
	inc a									;add another one...
	ld (tilecount+1),a
	cp 13									;if too many, put a hole
	jr nc,putahole

	ld ix,platformdark						;gfx in ix
platdraw:
	push bc									;save counter
	ld a,(ix+0)								;get line from dark gfx
	ld (hl),a								;put in the buffer
	ld a,(ix+4)								;get line from light gfx	
	ld (de),a								;put in the light buffer
	inc ix									;go to next line in gfx
	ld bc,16								;\
	add hl,bc								; \
	ld e,l									;  |- move to next line in both buffers
	pop bc									;get counter back
	djnz platdraw							;do the whole thing
	ret

putahole:
	xor a
	ld (tilecount+1),a						;reset consecutive tiles to 0
	ld de,16
holeloop:
	ld (hl),a
	add hl,de
	djnz holeloop
	ret

random:
	;This routine uses rom data to simulate random numbers...
	;It does a rather poor job of it, but it's good enough for
	;this game
	push hl
	ld a,r						;a=random-ish number <128
	srl a						;a<64
	ld h,a						;use that as the upper byte of an address (always rom page 0)
lrand:
	ld l,0						;use some value as the lower byte... (self-modifying)
	add a,(hl)					;get a number from there
	ld (lrand+1),a				;and use that as the next lower byte	
	pop hl
	ret

eraseoppball:
	ld bc,(oppycoord)
	ld de,oppback
	jr anti_mad

eraseball:
	ld bc,(ycoord)
	ld de,backsave

anti_mad:
	;routine to erase mad sprites
	;inputs: de=where you stored the background  b=x coord  c=y coord
	;destroys:  hl, de, bc, af

	dec c						;due to the screen being scrolled up...
	call findpixel				;get the invisible light layer in hl
	ld a,8						;8 lines per sprite
restoreloop:
	ex de,hl					;now the saved stuff is in hl, video mem in de
	ldi
	ldi							;load and increment a couple times
	ex de,hl					;put video mem back in hl
	ld bc,1022					;move back 2 bytes and go to the dark layer
	add hl,bc
	ex de,hl					;put video mem back in de (destination)
	ldi
	ldi
	ex de,hl
	sbc hl,bc					;go back to light layer (6 bytes ahead of where we should be)
	ld bc,10
	add hl,bc					;move to next line in video mem
	dec a						;decrement counter
	jr nz,restoreloop			;and do it again if needed
	ret							;wasn't that easy?

drawoppball:
	ld bc,(oppycoord)
	ld iy,oppback
	jr drawball2

drawball:
	ld bc,(ycoord)
	ld iy,backsave
drawball2:
	ld ix,bgfx11
	ld hl,spritemask
	ld de,(animcount)
	add ix,de

mad_sprite:
	;about this wonderful routine: 
	;-sprites are in grayscale, and the routine will compensate for double buffering
	;-sprite masking is also used on the light layer
	;-the background behind the sprite is saved in 16-bit format for fast erasure (anti_mad)
	;All this is accomplished by pre-calculating all possible sprite shifts and storing them in 256*2*8 table
	;Yeah...  it needs 4k free :(
	;This thing can probably be optimized...
	;inputs:  ix=bitmap data  iy=background storage space  b=x coord  c=y coord  hl=pointer to mask
	;destroys:  hl, bc, de, af, ix, iy, (spritemaskld+1) (hey, at least no shadow registers :)

	;note:  the sprites must be done like the stack; i.e. firt drawn=last erased

	ld (spritemaskld+1),hl	

	call findpixel
	add a,$90						;the sprite table starts at $9000
	;**** sprite drawing part ****

	ld d,a
	ld b,8
spriteloop:

	ld c,(hl)
	ld (iy+0),c
spritemaskld:
	ld a,(spritemask)				;self-modifying code here
	ld e,a
	push de
	ld a,(de)
	cpl
	and c
	ld c,a
	ld e,(ix+8)
	ld a,(de)
	or c
	ld (hl),a
	pop de
	inc d
	inc hl
	ld c,(hl)
	ld (iy+1),c
	ld a,(de)
	cpl
	and c
	ld c,a
	ld e,(ix+8)
	ld a,(de)	
	or c
	ld (hl),a

	inc h
	inc h
	inc h
	inc h

	ld e,(ix+0)				;\
	ld a,(hl)				; \
	ld (iy+3),a				;  \
	ld a,(de)				;   \
	or (hl)					;    \
	ld (hl),a				;     \
	dec d					;------  this is your basic non-aligned sprite, note how much crap the masking
	dec hl					;	  /				adds in the previous section
	ld a,(hl)				;    /
	ld (iy+2),a				;   /
	ld a,(de)				;  /
	or (hl)   				; /
	ld (hl),a				;/

	inc ix
	dec h
	dec h
	dec h
	dec h

	push bc
	ld bc,16
	add hl,bc
	pop bc
	.db $fd,$2c				;inc iyl, faster than inc iy
	.db $fd,$2c
	.db $fd,$2c
	.db $fd,$2c
	ld a,(spritemaskld+1)
	inc a
	ld (spritemaskld+1),a
	djnz spriteloop
	ret

findpixel:
	ld a,(page)					;get the appropriate video layer
	xor %00001000				;draw on the invisible layer
	rra							;\
	rra							;-- divide by 4, a little faster that srl a / srl a
	ld h,a						;this will get multiplied by 4 later
	ld a,c						;put y coord in a
	add a,a						;--multiply by 4
	add a,a						;/
	ld l,a						;now put that in l
	ld a,b						;put x coord in a
	rra							;\
	add hl,hl					; \
	rra							;--- divide a by 8, multiply hl by 4 (must be in this order)
	add hl,hl					; /
	rra							;/
								;so now hl is the y coord * 16, added to the appropriate offset
	add a,l
	ld l,a						;put the x coord together with hl, to get the offset in video mem (dark layer)
	ld a,b						;put the x coord in a
	and %00000111				;this is the amount the pic must be shifted to the right
	add a,a
	ret							;outputs: hl=postion in invisible light layer   a=upper byte of table address
								;z=no shift

setupscreen:
	ld hl,(50*256)+1
	ld (ycoord),hl
	ld h,62
	ld (oppycoord),hl

	ld a,4
	ld (linecount+1),a
	ld a,40
	ld (numlines+1),a

	;**** generate table of gfx ****
	ld hl,spritedata
	ld d,0
gentable:
	ld c,0
	ld b,c
gfxloop:
	push bc
	ld b,d
	ld a,d
	or a
	jr z,notshifted
	xor a
shiftloop:
	srl c
	rra
	djnz shiftloop
notshifted:
	ld (hl),c
	inc h
	ld (hl),a
	dec h
	inc hl
	pop bc
	inc c
	djnz gfxloop
	inc h
	inc d
	ld a,d
	cp 8
	jr nz,gentable
	ret

duplicate:
	ld hl,$f800
	ld de,$f000
duplication:
	ld a,d
	ld (page),a
	ld bc,2048
	ldir
	ret

transition:
	ld b,8
transouter:
	ld de,$f000
	ld hl,$f800
transloop:
	srl (hl)
	ld a,(de)
	rra
	ld (de),a
	inc de
	inc hl
	ld a,h
	or a
	jr nz,transloop
	halt	
	djnz transouter
	ld h,$f0			;l=0
	ld d,$f8			;e=0
	jr duplication

;**** link routines ****
;these are identical in concept to the routines used in ZTetris, ZPong, and probably
;every other link game out there.  However, these are commented :)

send:
;inputs: c=byte to send, both wires must be high by default
;outputs: b=8-number of bits sent, both wires high, goes to game over on certain conditions
;destroys: af,bc,de
	in a,(7)
	and %00000011
	jr z,killlink		;if both lines low, get out of here (game over signal)
	ld b,8				;sending 8 bits
sendloop:
	ld de,$8000			;error timer
	rl c				;force high bit into carry
	ld a,%11010100		;lower the red wire by default (sending 0) ($d4)
	jr nc,selected		;if high bit was 0, use above value
	ld a,%11101000		;if 1, lower the white wire instead ($e8)
selected:
	out (7),a			;put it out the link port
waitconfirm:
	call linktimer
	in a,(7)			;see what the wires are doing
	and %00000011		;check lower 2 bits
	jr nz,waitconfirm	;if both bits 0, data was received ok (both wires low)
	ld a,%11000000
	out (7),a			;give the ok to raise both wires (one will be done automatically) ($c0)
waitconfirm2:
	call linktimer
	in a,(7)
	and %00000011
	cp 3
	jr nz,waitconfirm2	;wait for other calc to raise the other wire
	djnz sendloop		;continue sending
	xor a				;reset c; ld a,0
	ld (losses),a		;reset number of losses
	ret


receive:
;inputs: both wires must be high by default
;outputs: c=byte received, b=8-number of bits received, both wires high
;	goes to game over on certain conditions
;destroys: af,bc,de
	in a,(7)
	and %00000011
	jr z,killlink		;game over signal applies to receiving too
	ld b,8				;receiving 8 bits
receiveloop:
	ld de,$8000			;error timer
waitreceive:
	call linktimer
	in a,(7)
	and %00000011
	cp 3				;if bits 0 and 1 set, both wires are high
	jr z,waitreceive	;wait for one of the wires to go low
	rra					;check red wire status
	rl c				;if set, red is high (thus white is low), so put the correct bit into c
	rra					;now check white wire (since the flags are destroyed)
	ld a,%11010100		;$d4
	jr nc,selected2		;if white is low, lower red and vice versa		
	ld a,%11101000		;$e8
selected2:
	out (7),a			;so now both wires are low
waitreceive2:
	call linktimer
	in a,(7)
	and %00000011
	jr z,waitreceive2	;wait for the wire we didn't lower to go high again (the other will remain low)
	ld a,%11000000		;$c0
	out (7),a			;raise both wires since the other calc will have given the ok sign
	djnz receiveloop	;if not done, wait for next bit
	xor a				;reset c
	ld (losses),a		;reset number of losses
	ret

linktimer:				;leave if we have to wait too long (and return an error)
	dec de
	ld a,d
	or e				;see if de is 0
	ret nz				;if not, keep going as usual
						;otherwise we have to deal with a link failure
	ld a,%11000000		;$c0
	out (7),a			;reset link status (both high)
	ld a,(losses)		;see how many consecutive losses we have
	inc a
	ld (losses),a		;add this loss to it
	pop de				;fix the stack to leave the link routine (de is ok to destroy)
	cp 20				;see if this is the 20th consecutive failure
	ret c				;if not, keep playing
						;otherwise, all is probably lost...

killlink2:
	ld hl,errortext		;will be used with _puts later
	jr linkend
killlink:
	ld hl,winnertext
linkend:
	ld sp,0				;undo all the calls that were made (self-modifying)
	jp linkdeath	


;**** interupt routine ****
intcode:								;start of interupt, both iff's reset
	ex af,af'							;flip to shadow registers

	ld a,%00001000						;rather than check port 3, just reset both interupt types (bits 1 and 0)
	out (3),a							;now tell the hardware to turn them off
	ld a,%00001011						;turn both types of interupts back on (bit 3 is set, so the lcd is on)
	out (3),a							;and tell the hardware to do it...  (note bit 2 is reset)

	exx

	ld a,($c008)						;save a few bytes by putting this here
	out (2),a							;use whatever contrast is stored in memory

	ld a,(page)							;page is $f0 or $f8
	srl c
	jr nz,cnotzero
reloadc:								;this actually goes l-d-d-l-d-repeat when you see it on the screen
	ld c,%00011100						;if the counter hit 0, reset it
cnotzero:							
	jr nc,nopageflip					;if the bit was set, we're on the dark layer
	add a,$04							;$f0->$f4 and $f8->$fc, put on dark layer if the bit was 1
nopageflip:	
	out (0),a							;make it so

	ex af,af'
	exx
	ei									;ei must be here or calc dies (in the power down routine)
	ret									;return from interupt (reti not needed)
	
endintcode:

texttable:
	.dw $1b02
	.dw $2102
	.dw $2702
	.dw $2d67
	.dw $3367
	.dw $3a67
	.dw $3402
	.dw $3a02

platformdark:
	.db %11111111
	.db %11111111
	.db %11110000
	.db %11110000
platformlight:
	.db %11111111
	.db %11000000
	.db %11001111
	.db %11001100


backtile1:
	.db %10000011
	.db %10000100
	.db %01001000
	.db %00111000
	.db %00011100
	.db %00010010
	.db %00100001
	.db %11000001

backtile2:
	.db %00100010
	.db %01010101
	.db %10001000
	.db %10001000
	.db %10001000
	.db %01010101
	.db %00100010
	.db %00100010

backtile3:
	.db %10000001
	.db %01000010
	.db %00111100
	.db %00100100
	.db %00100100
	.db %00111100
	.db %01000010
	.db %10000001

backtile4:
	.db %00010000
	.db %00010000
	.db %00101000
	.db %01000100
	.db %10000011
	.db %01000100
	.db %00101000
	.db %00010000

backtile5:
	.db %00010000
	.db %00100000
	.db %00100000
	.db %01100000
	.db %11010111
	.db %00001100
	.db %00001000
	.db %00001000


spritemask:							;a pretty wasteful mask :(							
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100

bgfx11:
	.db %00111100
	.db %01000010
	.db %10000001
	.db %10000011
	.db %10000011
	.db %10000111
	.db %01011110
	.db %00111100

bgfx12:
	.db %00111100
	.db %01001110
	.db %10001111
	.db %10011101
	.db %11111101
	.db %11111001
	.db %01100010
	.db %00111100

bgfx21:
	.db %00111100
	.db %01111110
	.db %11111111
	.db %11000011
	.db %10000011
	.db %10000111
	.db %01011110
	.db %00111100

bgfx22:
	.db %00111100
	.db %01111110
	.db %11000111
	.db %10011111
	.db %11111101
	.db %11111001
	.db %01100010
	.db %00111100

bgfx31:
	.db %00111100
	.db %01000010
	.db %10011001
	.db %11111111
	.db %11111111
	.db %10011111
	.db %01011110
	.db %00111100

bgfx32:
	.db %00111100
	.db %01001110
	.db %10101111
	.db %11111111
	.db %11111111
	.db %11111101
	.db %01100010
	.db %00111100

bgfx41:
	.db %00111100
	.db %01000010
	.db %10000001
	.db %10000011
	.db %11000011
	.db %11111111
	.db %01111110
	.db %00111100

bgfx42:
	.db %00111100
	.db %01001110
	.db %10001111
	.db %10011101
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100

#include rle.asm

.end
