#include "usgard.h"
#define ld_text   	res 3,(IY+05)
#define xor_text  	set 3,(IY+05) 
#define goto(xy)  	ld hl,xy \ ld (CURSOR_X),hl
#define disp_str  	call D_ZM_STR
#define disp_char 	call M_CHARPUT
#define disp_hl	  	call DM_HL_DECI
#define out_chr(chr)   	ld a,chr \ call M_CHARPUT

currow		= CURSOR_ROW
curcol		= CURSOR_COL
curx		= CURSOR_X
cury		= CURSOR_Y


;Menu Draw Variables

M_F1 		= TEXT_MEM2+0      ;where the f1 str is stored
M_F2 		= TEXT_MEM2+2      ;etc.   
M_F3 		= TEXT_MEM2+4      ;
M_F4 		= TEXT_MEM2+6      ;
M_F5 		= TEXT_MEM2+8      ;
MENUVAR 	= TEXT_MEM2+10     
MENUVAR1 	= TEXT_MEM2+11     
MENUVAR2 	= TEXT_MEM2+12     
MENUPT 		= TEXT_MEM2+13

;Main Variables

debt	= TEXT_MEM+0
cash	= TEXT_MEM+2
bank	= TEXT_MEM+4

day	= TEXT_MEM+6
guns	= TEXT_MEM+8
quant	= TEXT_MEM+10

coke	= TEXT_MEM+12
hero	= TEXT_MEM+14
acid	= TEXT_MEM+16
weed	= TEXT_MEM+18

coke2	= TEXT_MEM+20
hero2	= TEXT_MEM+22
acid2	= TEXT_MEM+24
weed2	= TEXT_MEM+26

qty	= TEXT_MEM+28
drug	= TEXT_MEM+30
string	= TEXT_MEM+32
hold	= TEXT_MEM+34

randvar = TEXT_MEM+36

time	= TEXT_MEM+70
x	= TEXT_MEM+74
noLet   = TEXT_MEM+76

temp	= TEXT_MEM+80

TermZero = TEXT_MEM+90

digit	= TEXT_MEM+98
itable	= TEXT_MEM+100	;input table

;Aliases
;cash values = actual value/100

coke_max	= 255
coke_rng	= 255-150
coke_min	= 150

hero_max	= 140
hero_rng	= 140-50
hero_min	= 50

acid_max	= 45
acid_rng	= 45-10
acid_min	= 10

weed_max	= 9
weed_rng	= 9-3
weed_min	= 3

.org 0

pstart:

.db "Drugwars 2.7 Beta",0

	ld	a,4
	out	(5),a
	xor	a
	ld	(temp),a
	call	CLEARLCD
	ld	hl,TEXT_MEM2
	ld	d,h
	ld	e,l
	inc	hl
	ld	(hl),0
	ld	bc,167
	ldir
;-----------------
	xor_text
	ld	hl,$0000
	ld	(CURSOR_ROW),hl
	ld	hl,&title_str
	call	D_ZT_STR
;-----------------
	ld_text
	ld	hl,$0401
	ld	(CURSOR_ROW),hl
	ld	hl,&coder_str
	call	D_ZT_STR
;-----------------
	ld	hl,$0002
	ld	(CURSOR_ROW),hl
	ld	hl,&email_str
	call	D_ZT_STR
	call	&select_new
next_key:
	call	&wait
	cp	K_Clear \ jr    z,cheater
	cp	K_Enter \ jr	z,startwar
	cp	K_Down \ jr	z,change
	cp	K_Up \ jr	z,change
	cp	K_Exit \ ret	z
	jr	next_key
cheater:
	call	CLEARLCD
	call	&wait
	cp	K_More
	ret	nz
	ld	hl,2000
	ld	(cash),hl
	ld	a,100
	ld	(hold),a
	jp	&first_day
change:
	ld	a,(temp)
	xor	%1
	ld	(temp),a
	push	af
	call	z,&select_new
	pop	af
	call	nz,&select_old
	jr	next_key

select_new:
	xor_text
        call    &select1
	ld_text
        call    &select2
	ret
select_old:
	ld_text
        call    &select1
	xor_text
        call    &select2
	ret
;-----------------
select1:
	ld	hl,$0105
	ld	(CURSOR_ROW),hl
        ld      hl,&newgame_s
	call	D_ZT_STR
	ret
select2:
	ld	hl,$0106
	ld	(CURSOR_ROW),hl
        ld      hl,&oldgame_s
	call	D_ZT_STR
	ret
;-----------------
startwar:
	ld	a,(temp)
	or	a
	jr	z,drugwars
        ld      hl,&saved_game
	ld	de,TEXT_MEM
	ld	bc,20
	ldir
	jr	first_day
drugwars:
	ld	a,20
	ld	(cash),a
	ld	a,50
	ld	(debt),a
	ld	a,100
	ld	(hold),a
	jr	first_day
main:
        call    &status
        call    &prices
        call    &market
waiter:
        call    &wait
	cp	K_EXIT
	jr	z,new_day
	cp	K_F3
	jr	z,new_day
	cp	K_F2
        jp      z,&sell
	cp	K_F1
        jp      z,&buy
	jr	waiter
new_day:
        call    &interest
first_day:
	call	&status
	ld	hl,(day)
	inc	hl
	ld	(day),hl
	ld	de,30
	or a \ 	sbc hl,de
	jr	nz,not_day_30
	ld	hl,(debt)
	ld	de,0
	or a \ 	sbc hl,de
	jr	z,not_day_30
        goto($2801)
        ld      hl,&lose_str
        disp_str
        call    &wait
        call    &status
	goto($3001)
	ld	hl,&go2_str
	disp_str
	call	&wait
	jp	&high_score_2
not_day_30:
        call	&where
        call	&mugging
        call    &cops
        call    &randomize
        jp      &main
        call    &status

;========================================================================
; CCC	  A	L	L	 SSSS
;C	 A A	L	L	S
;C	AAAAA	L	L	 SSS
;C	A   A	L	L	    S
; CCC	A   A	LLLLL	LLLLL	SSSS
;========================================================================
;CHANCE-	chance for a gun
;INTEREST-	increase the debt by 1/8
;MULT-		hl=a*b
;SELL-		sell routine
;BUY-		buy routine
;MARKET-	displays market menu
;CHOICE-	displays drug choice menu, gets a key, returns hl -> drug
;PRICES-	displays prices
;STATUS-	displays status
;RAND-		randomizes reg a, destroys b
;RANDOMIZE-	randomizes prices
;WAIT-		wait for key, returns keycode in a
;M_DRAW-    in: M_Fx -> str
;		a = flag byte
;	   out: draws a menu

cops:
	ld	hl,(quant)
	ld	de,25
	or	a \ sbc hl,de
	ret	c
	ld	(quant),hl
	goto($2801)
        ld      hl,&cop_str 
	disp_str
        ld      hl,&run_str 
	ld (M_F1),hl
        ld      hl,&fight_str 
	ld (M_F2),hl
	ld	a,%110000
        call    &M_Draw
cop_input:
        call    &wait
	cp	K_F1 \ jr z,cop_run
	cp	K_F2 \ jr z,cop_fight
	jr	cop_input
cop_run:
        call    &rand
	and	%11000
	ret	nz
	jr	cop_caught
	ld	b,4
	ld	hl,coke
cop_fight:
	ld_text
	ld	a,(guns)
	or	a
	jr	z,cop_caught
	call	&rand
	and	%11000
	jr	z,cop_caught
	goto($2801)
	ld	hl,&shoot_str
	disp_str
	call	&wait
	jr 	where
cop_caught:
        call    &clear_bot
	goto($2801)
        ld      hl,&go_str
	disp_str
	goto($3001)
        ld      hl,&go2_str
	disp_str
        call    &wait
	jp	&high_score
where:
	goto($2801)
        ld      hl,&save_str
	disp_str
	goto($3001)
        ld      hl,&place_str
	disp_str
        ld      hl,&place_1 
	ld (M_F1),hl
        ld      hl,&place_2 
	ld (M_F2),hl
        ld      hl,&place_3 
	ld (M_F3),hl
        ld      hl,&place_4 
	ld (M_F4),hl
        ld      hl,&place_5 
	ld (M_F5),hl
	ld	a,%111110
        call    &M_Draw
w_input:
        call    &wait
	cp	K_F1 \ 	jr	z,where_ok
	cp	K_F2 \	jr	z,where_ok
	cp	K_F3 \	jr	z,where_ok
	cp	K_F4 \	jr	z,where_ok
	cp	K_F5 \	jr	z,where_ok
	cp	K_More
	jp	z,&saving
	cp	K_Exit 
	jp	z,&high_score
	jr	w_input

where_ok:
	cp	K_F5
	ret	nz
        call    &clear_bot
	goto($2801)
        ld      hl,&loan_str
	disp_str
        call    &YN 
	cp	K_F2
	jr	z,banking
;-----------------------------
        call    &status
repaying:
        ld      hl,&pay_instr
	ld	(string),hl
        call    &input   
	jr	c,borrowing
	ex	de,hl		;de=amt to repay
	ld	hl,(cash)
	or a \	sbc hl,de
	jr	c,repaying
	ld	hl,(debt)
	or a \	sbc hl,de
	jr	c,repaying
	ld	(debt),hl
	ld	hl,(cash)
	or a \  sbc hl,de
	ld	(cash),hl
	call	&status
borrowing:
        ld      hl,&borr_instr
	ld	(string),hl
        call    &input   
	jr	c,banking
	ld	de,21
	call	CP_HL_DE
	jr	c,borr_ok
        call    &clear_bot
	goto($2801)
        ld      hl,&crazy_str
	disp_str
	jr	borrowing
borr_ok:
	ex	de,hl		;de=amt to repay
	ld	hl,(cash)
	add	hl,de
	ld	(cash),hl
	ld	hl,(debt)
	add	hl,de
	ld	(debt),hl	
banking:
        call    &status
	goto($2801)
        ld      hl,&banking_str
	disp_str
        call    &YN
	cp	K_F2
	ret	z
deposit:
        ld      hl,&depo_instr
	ld	(string),hl
        call    &input          ;hl=amt to deposit
	jr	c,withdraw
	ex	de,hl		
	ld	hl,(cash)	;hl=cash, de=deposit
	or  a \ sbc hl,de
	jr	c,deposit
	ld	(cash),hl
	ld	hl,(bank)
	add	hl,de
	ld	(bank),hl
        call    &status
	jr	banking
withdraw:
        ld      hl,&with_instr
	ld	(string),hl
        call    &input           ;hl=amt to withdraw
	ret	c
	ld	de,(bank)
	ex	de,hl		;hl=bank, de=withdrawal
	or  a \ sbc hl,de
	jr	c,withdraw
	ld	(bank),hl
	ld	hl,(cash)
	add	hl,de
	ld	(cash),hl
	jr	banking
saving:
	ld	hl,TEXT_MEM
        ld      de,&saved_game
	ld	bc,20
	ldir
	pop	hl
	ret

mugging:
	ld	hl,(day)
	ld	de,1
	or	a
	sbc	hl,de
	ret	z
	ld 	a,(guns)
        or	a
	jr	nz,chance
        call    &rand
	and	%111000
	jr	nz,chance
	ld	hl,(cash)
        srl     h
        rr	l        
	ld	(cash),hl
        call    &status
	goto($2801)
        ld      hl,&mug_str
	disp_str
        call    &wait
chance:
        call    &rand
	and	%111100
	ret	nz
        call    &status
	ld	hl,(cash)
	ld	a,(hero2)
	ld	e,a
	ld	d,0
	or	a \ sbc hl,de
	ret	c
	goto($2801)
	push	de
	push	de
        ld      hl,&gun_str1
	disp_str
	pop	hl
	disp_hl
	ld	a,'?'
	disp_char
        call    &YN
	pop	de
	cp	K_F2
	ret	z
	ld	hl,(cash)
	or	a \ sbc hl,de
	ld	(cash),hl
	ld	hl,(guns)
	inc	hl
	ld	(guns),hl
        call    &wait
	ret

YN:
        ld      hl,&yes_str 
	ld (M_F1),hl
        ld      hl,&no_str 
	ld (M_F2),hl
	ld	a,%110000
        call    &M_Draw
YN_input:
        call    &wait
 	cp	K_F1 \	ret	z
	cp	K_F2 \	ret	z
	jr	YN_input

clear_bot:
	ld	hl,$fe60
	ld	de,$fe61
	ld	bc,$10000-$fe61
	ld	(hl),0
	ldir
	ret

interest:
	ld	hl,(debt)
	ld	b,4
shift_loop:
	srl	h
	rr	l		;srl hl
	djnz	shift_loop	;x3
	ld	bc,(debt)
	add	hl,bc		;(debt)=9(debt)/8
	ld	(debt),hl
	ret

mult:			;out- hl=a*b
	ld	hl,0
	ld	e,a
	ld	d,0
	ld	a,b
	or	a
	ret	z
mult2:
	add	hl,de
	djnz	mult2
	ret

mult16:			;out- hl=hl*b
	ex	de,hl
	ld	hl,0
	xor	a
	cp	b
	ret	z
mult17:
	add	hl,de
	djnz	mult17	
	ret

get_hold:
	ld	a,(weed)
	ld	b,a
	ld	a,(acid)
	ld	c,a
	ld	a,(hero)
	ld	d,a
	ld	a,(coke)
	add	a,b
	add	a,c
	add	a,d
	sub	100
	neg
	ld	(hold),a
	ret

buy:
	call	&get_hold
        call    &choice         ;(qty)=a
        jp      c,&main
getinput:
        ld      hl,&buy_instr
	ld	(string),hl
        call    &input
        jp      c,&main
	ld	ix,(drug)
	ld	a,(qty)
	ld	b,a
	ld	a,(hold)
	cp	b
	jr	c,getinput
	ld	l,(ix+8)
	ld	h,(ix+9)
        call    &mult16         ;hl=price of drugs
	ld	de,(cash)	
	ex	de,hl
	or	a \ sbc hl,de	;cash - price
	jr	c,getinput	;reinput if number is bad
	ld	(cash),hl
	ld	l,(ix)
	ld	h,(ix+1)
	ld	de,(qty)
	add	hl,de
	ld	(ix),l
	ld	(ix+1),h
        jp      &main 

sell:
        call    &choice
        jp      c,&main
getinput2:
        ld      hl,&sell_instr
	ld	(string),hl
        call    &input
        jp      c,&main
	ld	ix,(drug)
	ld	de,(qty)	;de=amt to sell
	ld	l,(ix)
	ld	h,(ix+1)	;hl=((drug))
	or a \	sbc hl,de
	jr	c,getinput2	;reinput if number is bad
	ld	(ix),l		;drug# = drug# - sell# 
	ld	(ix+1),h
	ld	a,(qty)		;b=amt to sell
	ld	b,a
	ld	l,(ix+8)	
	ld	h,(ix+9)	;hl=price
        call    &mult16         ;hl=# * $
	ld	de,(cash)
	add	hl,de
	ld	(cash),hl	;cash=cash + profits
	ld	de,(qty)
	ld	hl,(quant)
	add	hl,de
	ld	(quant),hl
        jp      &main

choice:
        ld      hl,&coke_str 
	ld      (M_F1),hl
        ld      hl,&hero_str 
	ld      (M_F2),hl
        ld      hl,&acid_str 
	ld      (M_F3),hl
        ld      hl,&weed_str 
	ld      (M_F4),hl
        ld      hl,&none_str 
	ld      (M_F5),hl
	ld	a,%111110
        call    &M_Draw
wait4key:
        call    &wait
;F1=$35=3=6
;F2=$34=2=4
;F3=$33=1=2
;F4=$32=0=0
	cp	K_F1 \	jr	z,ok
	cp	K_F2 \	jr	z,ok
	cp	K_F3 \	jr	z,ok
	cp	K_F4 \	jr	z,ok
	cp	K_F5 \	jr	nz,wait4key
	scf	
	ret
ok:
	sub	$32
	add	a,a
	ld	c,a
	ld	b,0
	ld	hl,weed
	or	a \  sbc hl,bc
	ld	(drug),hl
	ret
input:
        call    &M_Erase
	goto($3900)
        ld      hl,&input_str
	disp_str
	ld	hl,(string)
	disp_str
	ld	a,'?'
	disp_char
	ld	a,(CURSOR_X)
	add	a,3
	ld	(CURSOR_X),a
	ld	hl,itable
	ld	(digit),hl
in2:
        call    &wait
	cp	K_Clear
	jr	z,input
	cp	K_Left
	jr	z,input
	cp	K_Enter 
	jr	z,idone
	cp	K_Exit 
	jr	nz,idigit
	scf
	ret
idigit:
	ld	hl,(digit)
	ld	de,itable+5
	or a \	sbc	hl,de
	jr	nc,in2
        ld      ix,&keycodes
	ld	b,10
in3:
	cp	(ix)
	jr	z,in4
	inc	ix
	djnz	in3
	jr	in2
in4:
	ld	hl,(digit)
	dec	b
	ld	(hl),b
	inc	hl
	ld	(digit),hl
	ld	a,b
	add	a,'0'
	disp_char
	jr	in2
idone:
	ld	hl,(digit)
	ld	(hl),$ff
	ld	ix,itable
	ld	hl,0
id2:
	ld	a,(ix)
	cp	$ff
	jr	z,id3
	ld	b,0
	ld	c,a
	add	hl,hl
	ld	d,h
	ld 	e,l
	add 	hl,hl
	add 	hl,hl
	add 	hl,de
	add 	hl,bc
	inc 	ix
	jr 	id2
id3:
	ld	(qty),hl
	ret
	
keycodes:
.db	K_9,K_8,K_7,K_6,K_5,K_4,K_3,K_2,K_1,K_0

market:
        ld      hl,&menu_buy 
	ld      (M_F1),hl
        ld      hl,&menu_sell
	ld      (M_F2),hl
        ld      hl,&menu_jet 
	ld      (M_F3),hl
	ld	a,%111000
        call    &M_Draw
	ret

prices:
	ld	hl,$fe50
	ld	de,$fe51
	ld	(hl),$ff
	ld	bc,$5f
	ldir

	xor_text
	goto($2501)
        ld      hl,&price_str
	disp_str

	ld_text
	goto($2b02)
        ld      hl,&coke_str
	disp_str
	ld	hl,(coke2)
	disp_hl

	goto($3100)
        ld      hl,&hero_str
	disp_str
	ld	hl,(hero2)
	disp_hl

	goto($2b4a)
        ld      hl,&acid_str
	disp_str
	ld	hl,(acid2)
	disp_hl

	goto($3146)
        ld      hl,&weed_str
	disp_str
	ld	hl,(weed2)
	disp_hl
	ret

status:
	call	CLEARLCD
	ld	hl,$fc00
	ld	de,$fc01
	ld	(hl),$ff
	ld	bc,$5f
	ldir

	ld	b,$25
	ld	de,$10
	ld	hl,$fc08
vert1:
	set	7,(hl)
	add	hl,de
	djnz	vert1

	ld	hl,$fe50
	ld	de,$fe51
	ld	(hl),$ff
	ld	bc,$f
	ldir

	xor_text
	goto($0001)
        ld      hl,&pstart
	disp_str

	goto($0600)
        ld      hl,&cash_str
	disp_str
;	goto($0610)
	out_chr('[')
	out_chr('$')
	ld	hl,(cash)
	disp_hl
	out_chr(']')

	ld_text
	goto($0c00)
        ld      hl,&debt_str
	disp_str
;	goto($0c10)
	out_chr('[')
	out_chr('$')
	ld	hl,(debt)
	disp_hl
	out_chr(']')

	goto($1200)
        ld      hl,&bank_str
	disp_str
;	goto($1210)
	out_chr('[')
	out_chr('$')
	ld	hl,(bank)
	disp_hl
	out_chr(']')

	goto($1807)
        ld      hl,&guns_str
	disp_str
	out_chr('[')
	ld	hl,(guns)
	disp_hl
	out_chr(']')

	goto($1e0a)
        ld      hl,&days_str
	disp_str
	out_chr('[')
	ld	hl,(day)
	disp_hl
	out_chr(']')

;==================================================================

	goto($0644)
        ld      hl,&coke_str
	disp_str
	out_chr('[')
	ld	hl,(coke)
	disp_hl
	out_chr(']')

	goto($0c42)
        ld      hl,&hero_str
	disp_str
	out_chr('[')
	ld	hl,(hero)
	disp_hl
	out_chr(']')

	goto($124a)
        ld      hl,&acid_str
	disp_str
	out_chr('[')
	ld	hl,(acid)
	disp_hl
	out_chr(']')

	goto($1846)
        ld      hl,&weed_str
	disp_str
	out_chr('[')
	ld	hl,(weed)
	disp_hl
	out_chr(']')

	goto($1e49)
        ld      hl,&hold_str
	disp_str
	out_chr('[')
	call	&get_hold
	ld	hl,(hold)
	disp_hl
	out_chr(']')
	ret

randomize:
coke_r0:
        call    &rand
coke_r1:
	ld	b,coke_rng
	cp	b
	jr	c,coke_r2
	sub	b
	jr	coke_r1
coke_r2:
	add	a,coke_min
	ld	(coke2),a
	xor	a
	ld	(coke2+1),a
;=========================
hero_r0:
        call    &rand
hero_r1:
	ld	b,hero_rng
	cp	b
	jr	c,hero_r2
	sub	b
	jr	hero_r1
hero_r2:
	add	a,hero_min
	ld	(hero2),a
	xor	a
	ld	(hero2+1),a
;=========================
acid_r0:
        call    &rand
acid_r1:
	ld	b,acid_rng
	cp	b
	jr	c,acid_r2
	sub	b
	jr	acid_r1
acid_r2:
	add	a,acid_min
	ld	(acid2),a
	xor	a
	ld	(acid2+1),a
;=========================
weed_r0:
        call    &rand
weed_r1:
	ld	b,weed_rng
	cp	b
	jr	c,weed_r2
	sub	b
	jr	weed_r1
weed_r2:
	add	a,weed_min
	ld	(weed2),a
	xor	a
	ld	(acid2+1),a
;=========================
        call    &rand
	and	%11100
	ret	nz
        call    &clear_bot
	goto($2801)
        call    &rand
	and	%1100000
	srl	a
	srl	a
	srl	a
	srl	a
	srl	a
	dec	a \ jr	z,w_out
	dec	a \ jr	z,a_out
	dec	a \ jr	z,h_out
	ld	hl,1250
	ld	(coke2),hl
        ld      hl,&c1
	disp_str
	goto($3001)
        ld      hl,&c2
	disp_str
	jr	wait
w_out:
	ld	a,1
	ld	(weed2),a
        ld      hl,&w1
	disp_str
	goto($3001)
        ld      hl,&w2
	disp_str
	goto($3801)
        ld      hl,&w3
	disp_str
	jr	wait
a_out:
	ld	a,6
	ld	(acid2),a
        ld      hl,&a1
	disp_str
	goto($3001)
        ld      hl,&a2
	disp_str
	jr	wait
h_out:
	ld	hl,350
	ld	(hero2),hl
        ld      hl,&h1
	disp_str
	goto($3001)
        ld      hl,&h2
	disp_str
wait:
        halt
	call	GET_KEY
	or	a
	jr	z,wait
	ret

RAND:
 ld a,$a6
 push hl
addr17:
 ld hl,$8243
 inc l
 dec h
 add a,(hl)
 ld (&addr17+1),hl
 rlca
 rlca
 sub h
 add a,l
 pop hl
 ld (&RAND+1),a
 srl a
    	ret			;returns a=rand b=destroyed

M_Erase:
	ld	hl,$ffa0
	ld	de,$ffa1
	ld	(hl),$0
	ld	bc,$5f
	ldir
	ret

M_Draw:
	sla     a
	sla     a
	ld      (menuvar1),a
	set     1,(IY+05)            ;SET MENU print 6 rows
	set     3,(IY+05)            ;SET MENU xor video mem
	ld	c,7
        call    &Box
	ld	b,127
        call    &Vert
	ld      a,58
	ld      (CURSOR_Y),a
	ld      a,2
	ld      (CURSOR_X),a
	ld      a,1
	ld      (menuvar),a
	ld      a,5
	ld      (menuvar2),a
	ld      hl,M_F1
	ld      (MENUPT),hl
M_DISPLAYTEXT:
	ld      a,(menuvar1)
	bit     7,a
	jr      z,M_skip
	ld      a,(menuvar2)
	ld      hl,(MENUPT)
	call    LD_HL_MHL       
	call    D_ZM_STR
M_skip:
	ld      hl,(MENUPT)
	inc     hl
	inc     hl
	ld      (MENUPT),hl
	ld      a,(menuvar1)
	add	a,a
	ld      (menuvar1),a    
        call    &DrawVert       
	ld      a,(menuvar2)
	dec     a
	ld      (menuvar2),a    
	jr      nz,M_DISPLAYTEXT        

	res     1,(IY+05)           
	res     3,(IY+05)           
	ld      a,(menuvar1)
	bit     7,a
	ret     z

BoxB:
	ld      c,7
H1B:
	ld B,126
H2B:
	push    bc
	dec     c
	ld      de,$fc00
        call    &PtOff
	pop     bc
	dec	b
	ld	a,122
	cp	b
	jr	nz,H2B
	dec     c
	jr      nz,H1B
	ld      a,58
	ld      (CURSOR_Y),a
	ld      a,124
	ld      (CURSOR_X),a
	ld      a,$05
	call    M_CHARPUT
	ret                     ;return to program

DrawVert:
	ld      a,(CURSOR_X)
	ld      b,a
	inc     b
	inc     b
	ld      a,(menuvar)
	add     a,25
	ld      (menuvar),a
	cp      b
	jr      nc,DV2
	ld      a,b
DV2:
	ld      (CURSOR_X),a
	ld      b,a
        call    &Vert
	ld      a,(CURSOR_X)
	inc     a
	inc     a
	inc     a
	ld      (CURSOR_X),a
	ret
Box:
	ld	hl,$ffa0
	ld	de,$ffa1
	ld	(hl),$ff
	ld	bc,$5f
	ldir
	ret
Vert:
	ld      c,7
V2:
	dec     c
	push    af
	ld      de,$fc00
        call    &PtOff
	pop     af
	jr      nz,v2
	ret
PtOff:
	call    FIND_PIXEL
	add     hl,de
	cpl
	and     (hl)
	ld      (hl),a
	ret
PtOn:
	call    FIND_PIXEL
	add     hl,de
	or      (HL)
	ld      (HL),a
	ret            

;========================================================================
;DDD	  A	TTTTT	  A
;D  D	 A A	  T	 A A
;D  D	AAAAA	  T	AAAAA
;D  D	A   A	  T	A   A
;DDD	A   A 	  T	A   A
;========================================================================

;	      	    "012345678901234567890"
newgame_s:	.db "  Start new game   ",0
oldgame_s:	.db " Continue old game ",0
coder_str:	.db     "by Terry Peng",0
email_str:	.db "<tpeng@geocities.com>",0
you_str:	.db "Your Score: ",0
coke_str: 	.db "crack ",0
hero_str: 	.db "heroin ",0
acid_str: 	.db "acid ",0
weed_str: 	.db "weed ",0
hold_str:	.db "hold ",0
none_str:	.db "none",0
debt_str:	.db "debt  ",0
bank_str:	.db "bank ",0
guns_str:	.db "guns ",0
cash_str:	.db "cash  ",0
days_str:	.db "day ",0
ndays_str:	.db "  days:     $",0
stash_str: 	.db "Stash",0
price_str: 	.db "Prices",0
menu_buy:	.db "Buy",0
menu_sell:	.db "Sell",0
menu_jet:	.db "Jet",0
input_str:	.db "How much to ",0
buy_instr:	.db "buy",0
sell_instr:	.db "sell",0
depo_instr:	.db "deposit",0
with_instr:	.db "withdraw",0
borr_instr:	.db "borrow",0
pay_instr:	.db "repay",0
trans_instr:	.db "transfer",0
crazy_str:	.db "You think he is crazy?!",0
gun_str1:	.db "Will you buy a Beretta for $",0
yes_str:	.db "Yes",0
no_str:		.db "No",0
place_str:	.db "Where to dude?",0
place_1:	.db "Manhat",0
place_2:	.db "Ghetto",0
place_3:	.db "Brkln",0
place_4:	.db "Park",0
place_5:	.db "Bronx",0
loan_str:	.db "Would you like to visit the"
		.db "loan shark?",0
banking_str:	.db "Do you want to go to the bank?",0
run_str:	.db "Run",0
fight_str:	.db "Fight",0
shoot_str:	.db "You busted a cap in his ass!!!",0
go_str:		.db "You were busted by the police!",0
go2_str:	.db "Game Over",0
cop_str:	.db "Officer Hardass is chasing"
		.db "you!",0
mug_str:	.db "You were mugged in the subway!",0
lose_str:	.db "You didn't repay your debt in "
		.db "30 days",0
save_str:	.db "[more]: save [exit]: quit",0
c1:		.db "Cops made a cocaine bust!",0
c2:		.db "Prices are outrageous!",0
h1:		.db "Addicts are buying heroin at",0
h2:		.db "outrageous prices!",0
a1:		.db "Homemade acid is flooding the",0
a2:		.db "market! Prices are bottoming"
		.db "out!",0
w1:		.db "Colombian freighter dusted the",0
w2:		.db "coast guard! Weed prices have",0
w3:		.db "bottomed out!",0
title_str:	.db "  Drugwars 2.7 Beta  ",0
saved_game:		;20 bytes (10 words)
;	1  2  3  4  5  6  7  8  9  10
.dw	50,20,00,00,00,00,00,00,00,00
high_score:
	pop	hl
high_score_2:
	ld	hl,(bank)
	ld	de,(cash)
	add	hl,de
	ld	de,(debt)
	or	a
	sbc	hl,de
	jr	nc,positive_score
	ld	hl,0
positive_score:
	ld	(time),hl
	ld	de,0
	or	a
	sbc	hl,de
	jp	z,&main_screen
	ld      hl,(&low_score)
	ld      de,(time)
	or	a
	sbc	hl,de
	jr	nc,main_screen
	ld_text
	call	CLEARLCD
	ld	hl,0
	ld	(currow),hl
	ld	hl,&hiscr_str
	call	D_ZT_STR
	call	&hi_Input
;
	ld	hl,(day)
	ld	(&low_days),hl
;
	ld	hl,(time)
	ld	(&low_score),hl
	ld	ix,&low_name
        ld      b,8
sort_scores:
	ld      e,(ix+17)
	ld      d,(ix+18)
	ld      l,(ix-2)
	ld      h,(ix-1)
	or	a
	sbc	hl,de
	jr	nc,main_screen
	push    bc
	ld      b,19
exg_loop:
	ld      e,(ix)
	ld      c,(ix-19)
	ld      (ix),c
	ld      (ix-19),e
	inc     ix
	djnz    exg_loop
	ld      de,-38
	add     ix,de
	pop     bc
	djnz    sort_scores
main_screen:
	call	CLEARLCD
	ld	hl,$fc00
	ld	d,h
	ld	e,l
	inc	de
	ld	(hl),-1
	ld	bc,$6f
	ldir
	xor_text
	goto($0001)
	ld	hl,&pstart
	disp_str
	ld	hl,&coder_str
	disp_str
	ld_text
	ld	a,8
screen_loop:
	ld	(x),a
	dec	a
	ld	b,6
	ld	c,a
	ld	a,8
screen_mult:
	add	a,c
	djnz	screen_mult
	ld	h,a
	ld	l,0
	ld	(curx),hl
	out_chr('[')
	ld	a,(x)
	add	a,'0'
	call	M_CHARPUT
	out_chr(']')
;display names
	ld	a,12
	ld	(curx),a
	ld	a,(x)
	ld	b,a
	ld	hl,&scores-19
	ld	de,19
screen_loop2:
	add	hl,de
	djnz	screen_loop2
	push	hl
	call	D_ZM_STR
;display days
	pop	hl
	ld	de,15
	add	hl,de
	ld	a,$30
	ld	(curx),a
	call	LD_HL_MHL
	disp_hl
	ld	hl,&ndays_str
	disp_str
;display scores
	ld	a,(x)
	ld	b,a
	ld	ix,&scores-2
	ld	de,19
screen_loop3:
	add	ix,de
	djnz	screen_loop3
	ld	d,(ix+1)
	ld	e,(ix)	
	ex	de,hl
	call	DM_HL_DECI
	ld	a,(x)
	dec	a
	ld	(x),a
	jr	nz,screen_loop
your_score:
	ld	hl,-$70
	ld	d,h
	ld	e,l
	inc	de
	ld	(hl),-1
	ld	bc,$6f
	ldir
	xor_text
	goto($3901)
	ld	hl,&you_str
	disp_str
	ld	a,$30
	ld	(curx),a
	ld	hl,(day)
	disp_hl
	ld	hl,&ndays_str
	disp_str
	ld	hl,(time)
	call	DM_HL_DECI
	call	&wait
	ret

scores:
;                   "012345678901234567890"
		.db "ANON          ",0	;name
		.dw 100			;days
		.dw 2500		;score
		.db "ANON          ",0
		.dw 50
		.dw 2000
		.db "ANON          ",0
		.dw 50
		.dw 1500
		.db "ANON          ",0
		.dw 50
		.dw 1000
		.db "ANON          ",0
		.dw 50
		.dw 750
		.db "ANON          ",0
		.dw 50
		.dw 500
		.db "ANON          ",0
		.dw 50
		.dw 250
low_name:	.db "ANON          ",0
low_days:	.dw 50
low_score:	.dw 100
hiscr_str:      .db "Type in your name:   ",0
;                   "012345678901234567890"

hi_input:
 ld a,14
 ld hl,&low_name
 push bc
 push de
 push hl
 set 2,(iy+12)	; * Turn cursor blinking on (interrupts must be enabled)
 ld (noLet),a	 ; Store the maximum lenght of the string
 ld e,0		; E = numbers of letters written so far
WaK:
 ld a,32
 ld ($800E),a	 ; * Set "character under cursor" to space
 push hl	      ; * Save HL since GET_KEY destroys it's content
 call &wait
 cp $02		; $02 = left key
 jr z,BackSpace
 cp $09		; $09 = enter
 jr z,NameDone
 cp K_EXIT
 jr z,NameDone
 cp $11		; $11 = space
 jr nz,CheckLetter
 ld a,32	      ; Space is ascii char 32
 pop hl
 jr PutLetter	 ; Put the letter on screen and in memory
CheckLetter:
 ld hl,&Letters
 ld bc,26	     ; 26 letters to check
 cpir		 ; Compare A with each letter until a match is found
 ld d,c		; Then C = the letter. Store in D
 pop hl		; HL -> current position in string
 jr nz,WaK	    ; If not valid keystroke, wait for new key
 ld a,65	      ; 65 = ascii char for A
 add a,d	      ; A now holds the ascii char for the letter pressed
PutLetter:
 ld c,a
 ld a,(noLet)	 ; A = max letters
 cp e		 ; Check if max size is reached
 jr z,WaK	     ; If so, wait for a new key
 ld (hl),c	    ; If not, store the key entered
 inc hl		; Point to the next byte in the string
 inc e		; And increase the letter counter
 ld a,c
 call TX_CHARPUT       ; Show the chars pressed on the screen
 jr WaK		; And jump back and wait for a new key
BackSpace:
 pop hl		; HL -> current position in string
 ld a,e
 or a		 ; Check if string size = 0
 jr z,WaK	     ; If so, backspace is impossible. Check for new key.
 res 2,(iy+12)	; * Stopp cursor blinking
 dec e		; Decrease string size
 dec hl		; And string pointer
 push hl
 ld hl,$800D	  ; HL -> x cursor position
 dec (hl)	     ; Decrease it
 ld a,32	      ; Overwrite the last letter with a space
 call TX_CHARPUT       ; Put the space over the chars
 call TX_CHARPUT       ; * And over the blinking cursor
 dec (hl)	     ; * Decrease the x coordinate twice
 dec (hl)	     ;
 pop hl
 set 2,(iy+12)	; * Stopp cursor blinking
 jr WaK		; Wait for a key
NameDone:
 pop hl		; HL -> current position in string
 ld (hl),0	    ; Put a terminating zero at the end of the string
 res 2,(iy+12)	; * Stopp cursor blinking
 pop hl
 pop de
 pop bc
 ret

Letters:
	.db $19,$21,$0A,$12,$1A,$22,$0B,$13,$1B,$23,$2B
	.db $0C,$14,$1C,$24,$2C,$0D,$15,$1D,$25,$2D,$0E
	.db $16,$1E,$26,$2E

.end








