#include "ti86asm.inc"

.org _asm_exec_ram

	nop
	jp start
	.dw 0
	.dw title

getkey:
	call _get_key
	or a
	jr z,getkey
	ret

displines:
	ld de,98*256+1
	call _ILine
	ld de,1*256+62
	jp _ILine

horiz_line:
	ld e,c
	call _ILine
	ld a,c
	add a,l
	ld c,a
	ret

MultHL:
	xor a
	cp h
	jr z,SetZero
	cp l
	jr z,SetZero
	push bc
	call _HtimesL
	pop bc
	ret
SetZero:
	ld hl,0
	ret

; modified routine originally by Matthew Shepcar
GetA:
	ld l,a
	ld h,0
GetHL:
	xor a
	ld de,-1
	ld (_curRow),de
	push bc
	call $4a33
	pop bc
	dec hl
DiscardSpaces:
	ld a,(hl)
	inc hl
	cp ' '
	jr z,DiscardSpaces
	dec hl
	ret

DispAStatus:
	ld l,a
	ld h,0
	ld c,$72:
	call GetHL
	push bc
	push hl
	ld bc,10
	xor a
	cpir			;bc=9-size
	ld a,9
	sub c
	pop hl
	pop bc
	add a,a		;multiply by 2
	cpl
	add a,c		;center column
	ld c,a		;load into current column

vputs:
	ld (_penCol),bc
	jp _vputs

draw_spaces:		;display d spaces at (b,c)
	push af
	push bc
	push hl
	ld (_penCol),bc
space_loop:
	push de
	call _vputspace	;display a space
	pop de
	dec d
	jr nz,space_loop
	pop hl
	pop bc
	pop af
	ret

draw_level:
;display the level
;shamelessly ripped from 86 central
	ld hl,current_level
	ld bc,$0202	;start drawing at (2, 2)
level_loop:
	push hl
	ld l,(hl)		;get the current tile
	ld h,0
	add hl,hl		;* 2
	ld d,h
	ld e,l
	add hl,hl		;* 4
	add hl,hl		;* 8
	add hl,de		;* 10
	add hl,de		;* 12
	add hl,de		;* 14
	ld de,bricks	;load the start of the sprites
	add hl,de		;add together to get correct sprite
	call PutSprite	;draw the sprite
	pop hl		;restore map pointer
	inc hl			;go to next tile
	ld a,b
	add a,12
	ld b,a
	cp 98		;we're done
	jr nz,level_loop	;only jump if the row isn't complete
	ld b,2		;draw at the left again
	ld a,c
	add a,6
	ld c,a		;move location down a row
	cp 62		;check if it's done
	jr nz,level_loop	;jump back to the top if not done
	ret

check_level:
;nz if not a diamonds level
	rst 10h					;do a _findsym to get bde
	ret c
	ld a,b
	ex de,hl
	call _ahl_plus_2_pg3
	call _getb_ahl				;get first byte and hl->string now
	cp $dd
	ret nz
	inc hl	
	ld a,(hl)					;get second byte
	dec a					;cp $01
	ret

draw_ball_status:
	ld bc,$6e22
	jr disp_ball

draw_ball:
	ld bc,(current_coords)

disp_ball:
	ld hl,ball
	jp PutSprite

draw_cursor:
	ld bc,(brick_y)
	ld hl,cursor
	jp PutSprite

draw_brick_mode:
	ld a,(brick_mode)
	ld bc,$6a22
draw_brick:
	ld l,a
	ld h,14
	call MultHL
	ld de,bricks
	add hl,de
	jp PutSprite			;draw the brick

vputs_center:
	push af
	push bc
	push hl
	ld (_penRow),a				;set pen row
	ld e,0					;length
get_size:
	ld a,(hl)					;get next byte
	or a						;check if a=0
	jr z,got_size				;finished getting size
	push hl
	push de
	call _get_vchar				;hl->size of char
	pop de
	ld a,(hl)					;get size
	add a,e					;add to cumulative length
	ld e,a					;save
	pop hl
	inc hl						;next byte
	jr get_size
got_size:
	srl e						;divide by 2
	ld a,64					;center column
	sub e					;a=center column
	ld (_penCol),a
        pop hl					;retrieve start of text
	call _vputs					;print the text
	pop bc
	pop af
	ret

invert_top:
	push hl
	ld hl,$fc00					; point to video ram
	ld b,112
invert_top_loop:
	ld a,(hl)
	cpl
	ld (hl),a
	inc hl
	djnz invert_top_loop
	pop hl
	ret

get_level_offset:
	ld a,(level_num)
	ld h,a
	ld l,42				;size of each level
	call MultHL
	ld de,levels
	add hl,de				;hl->compressed level
	ret

get_title:
	ld hl,enter_name
	call input_str
	ld de,name_too_long
	ld a,(hl)
	cp 9
	jr nc,error_getting_title	;too long
	ld b,a				;b=size
	inc hl
	ld a,(hl)
	or a
	jr nz,error_getting_title
	inc hl
	ld de,varname+1
	ld a,b
	ld (de),a				;store size byte
	inc de
	call _mov9b			;varname now contains the name of the level
	ld hl,varname
	rst 20h				;mov10toop1
	rst 10h				;_findsym
	ret c
	ld de,level_already_exists
error_getting_title:
	ex de,hl
	ld a,$1b
	call vputs_center
	call getkey
	jr get_title

get_description:
	ld hl,enter_description
	call input_str
	ld a,(hl)
	cp 100				;99 letters max
	jr nc,get_description
	ld c,a
	inc hl
	ld a,(hl)
	or a					;anything in second byte means too long
	jr nz,get_description
	ld b,a
	inc hl
	ld de,description			;save description
	ldir					;copy string
	ld (de),a				;null terminator (a=0)
	ret

input_str:
	push hl
	ld hl,_ioPrompt
	ld b,21
fill_io:
	ld (hl),' '
	inc hl
	djnz fill_io				;fill the entire ioprompt with 0's
	pop hl				;so the input is on the next line
	ld de,_ioPrompt
	call _strcpy			;copy the string
	ld a,' '
	ld (de),a				;copy over null byte
get_string:
	call _clrWindow
	ld a,$0c
	ld (_ASAP_IND),a
	res 4,(iy+9)
	set shiftAlpha,(iy+shiftflags)
	set shiftALock,(iy+shiftflags)	;alpha lock
	call _exec_pg3
	bit 4,(iy+9)
	jr nz,get_string			;if they hit on, get string again
	call _runindicoff
	res shiftAlpha,(iy+shiftflags)
	res shiftALock,(iy+shiftflags)
	rst 10h				;_findsym
	ld a,b
	ex de,hl
	jp _load_ram_ahl

start:
	ld hl,_plotSScreen
	ld (hl),0				;clear first byte
	ld de,_plotSScreen+1
	ld bc,1023
	ldir
	call _runindicoff
	call _flushallmenus
	ld de,title_menu
	jp DoMenu

new_level:
	call get_title
	call get_description
	ld hl,starting_highscore
	ld de,highscore
	ld bc,6
	ldir					;copy initial highscore and initials
	ld hl,num_levels
	ld (hl),1				;only 1 to start
	inc hl
	ld (hl),4				;default starting coordinates
	inc hl
	ld (hl),4
	inc hl
	ld b,40
	call _ld_hl_bz			;fill tilemap with 0's
	jp edit_level

level_up:
	ld de,temp_search_name
	call _movfrop1
	xor a
	call _FindAlphaDn		;search for string
	ld hl,_OP1+1
	ld de,temp_search_name+1
	call _strcmp
	jr z,get_last_level		;same var, so we're at beginning of alphabet.
	call check_level
	jr nz,level_up			;invalid level
save_new_level:
	ld de,varname
	call _movfrop1			;copy new name
	jr load_main_loop
;same name, so we load default name and find first level
get_last_level:
	ld hl,ending_name
	rst 20h				;copy starting varname to op1
search_up:
	xor a
	call _FindAlphaDn
	call check_level
	jr nz,search_up			;keep searching until we find something
	jr load_main_loop

level_down:
	ld de,temp_search_name
	call _movfrop1
	xor a
	call _FindAlphaUp		;search for string
	ld hl,_OP1+1
	ld de,temp_search_name+1
	call _strcmp
	jr z,get_first_level		;same var, so we're at end of alphabet.
	call check_level
	jr nz,level_down			;invalid level
	jr save_new_level
;same name, so we load default name and find first level
get_first_level:
	ld hl,starting_name
	rst 20h				;copy starting varname to op1
search_down:
	xor a
	call _FindAlphaUp
	call check_level
	jr nz,search_down		;keep searching until we find something
	jr load_main_loop

load_level:
	ld hl,starting_name
	rst 20h				;copy starting varname to op1
find_first_level:
	rst 08h				;op1 to op2
	xor a
	call _FindAlphaUp		;search for string
	jr c,error_loading		;no strings
	call check_level
	jr z,load_main_loop		;valid level
;now we check if we're getting anywhere in this search
	ld hl,_OP1+1
	ld de,_OP2+1
	call _strcmp			;see if name has changed
	jr nz,find_first_level		;keep searching if name is changing

error_loading:
	ld de,no_levels_found
	jp DoMenu				;no levels

load_main_loop:
	call _clrScrn
	ld hl,load_level_txt
	xor a
	call vputs_center
	call invert_top			;invert top row
	ld bc,$0703
	ld (_curRow),bc
	ld hl,_OP1+2
	call _puts
	call getkey
	dec a				;cp K_DOWN
	jr z,level_down
	cp K_UP-1
	jp z,level_up
	cp K_SECOND-1
	jr z,level_selected
	cp K_ENTER-1
	jr nz,load_main_loop

level_selected:
	ld de,varname
	call _movfrop1			;save varname
	rst 10h				;_findsym
	ld a,b
	ex de,hl
	call _get_word_ahl		;de=size, ahl+=2
	push de
	call _ahl_plus_2_pg3
	call _set_abs_src_addr
	pop hl
	xor a
	call _set_mm_num_bytes	;size to copy
	ld hl,highscore
	call _set_abs_dest_addr	;copy here for now
	call _mm_ldir
	ld hl,description
	call _strlen
	add hl,bc
	inc hl					;hl=byte past 0
	ld a,(hl)				;get number of levels
	push hl
	ld h,a
	ld l,42
	call MultHL			;get size
	inc hl
	push hl
	ld bc,num_levels
	add hl,bc				;hl->end of level data
	ex de,hl				;put in de
	pop bc				;retrieve size
	pop hl				;retrieve pointer to end of string
	add hl,bc				;now we have the end of the actual data
	inc bc				;include size byte
	lddr					;copy it
	rst 10h
	call nc,_delvar			;now delete the level (we recreate it upon exiting)

edit_level:
	xor a
	ld (level_num),a
	ld (using_ball),a
	inc a
	ld (brick_mode),a		;white bricks to start
	ld bc,$0202
	ld (brick_y),bc

edit_new_screen:			;screen needs to be redrawn
	call _clrLCD
	ld h,1
	ld b,h
	ld c,h				;ld bc,$0101	
	call displines
	ld bc,98*256+62
	call displines
	ld bc,99*256+1
	ld d,126
	ld l,19
	call horiz_line
	ld l,22
	call horiz_line
	ld l,20
	call horiz_line
	call horiz_line
	ld bc,126*256+1
	call _ILine
	ld hl,level_text
	ld bc,$0467
	call vputs				;"Level"
	ld bc,$1868
	call vputs				;"Mode"
	ld bc,$2d6b
	call vputs				;"F5-"
	ld bc,$3565
	call vputs				;"Options"
	call draw_brick_mode
	ld a,(using_ball)
	or a
	call z,draw_cursor		;display cursor if we're not using the ball

edit_new_level:
	ld bc,$0c6b
	ld d,b				;ld d,12
	call draw_spaces
	ld a,(level_num)
	inc a
	ld b,$0c
	call DispAStatus
	call get_level_offset		;hl->compressed level
	ld de,current_coords
	ldi
	ldi					;copy starting coordinates
;decompress from hl to de
	ld b,40				;40 bytes per level
	xor a
decomp_level:
	rld
	ld (de),a
	inc de
	rld
	ld (de),a
	inc de
	inc hl
	djnz decomp_level
	call draw_level
	call draw_ball

edit_main_loop:
	call compress_level		;save data
	call getkey
	cp K_ALPHA
	jp z,switch_mode
	ld de,options_table
	cp K_F5
	jp z,DoMenu			;menu for options
	cp K_PLUS
	jr z,next_level
	cp K_MINUS
	jr z,last_level
	cp K_MORE
	jp z,insert_level
	ld de,clear_table
	cp K_CLEAR
	jp z,DoMenu			;make sure they want to
	cp K_EXIT
	jp z,save
	ld b,a
	ld a,(num_levels)
	dec a
	jr z,skip_check_delete
	ld a,b
	ld de,delete_table
	cp K_DEL
	jp z,DoMenu			;make sure they want to
skip_check_delete:
	ld a,(using_ball)
	or a
	ld a,b
	jr nz,check_ball

check_brick:
	cp K_SECOND
	jp z,change_brick
	cp K_F1
	jp z,mode_down
	cp K_F2
	jp z,mode_up
	dec a
	jp z,move_brick_down
	dec a
	jp z,move_brick_left
	dec a
	jp z,move_brick_right
	dec a
	jp z,move_brick_up
	jr edit_main_loop

check_ball:
	dec a
	jp z,move_ball_down
	dec a
	jp z,move_ball_left
	dec a
	jp z,move_ball_right
	dec a
	jp z,move_ball_up
	jr edit_main_loop

next_level:
	call draw_level			;erase the level
	call draw_ball			;erase the ball
	ld hl,level_num
	inc (hl)
	ld a,(num_levels)
	cp (hl)
	jp nz,edit_new_level		;we're loading an existing level
;create a new one
	ld hl,num_levels
	inc (hl)				;another level
	call get_level_offset
	ld (hl),4
	inc hl
	ld (hl),4				;starting ball coordinates
	jr clear_level			;clear the level

last_level:
	ld a,(level_num)
	or a
	jp z,edit_main_loop		;we're at the first level already, so do nothing
	call draw_level			;erase the level
	call draw_ball			;erase the ball
	ld hl,level_num
	dec (hl)
	jp edit_new_level

insert_level:
	call draw_ball			;erase ball
	ld a,(level_num)
	ld b,a
	ld a,(num_levels)
	sub b
	ld h,a
	ld l,42
	call MultHL
	push hl				;save size to copy
	call get_level_offset
	pop bc				;retrieve size to copy
	add hl,bc				;add size of levels
	dec hl
	ld d,h
	ld e,l
	push bc
	ld bc,42
	add hl,bc				;next level up
	pop bc
	ex de,hl
	lddr					;copy levels
	ld hl,current_coords
	ld (hl),4
	inc hl
	ld (hl),4
	inc hl
	ld hl,num_levels
	inc (hl)
	call draw_ball			;draw new ball
;now clear the tiles

clear_level:
	ld hl,current_level
	ld b,80
	call _ld_hl_bz			;fill with zeros
	call compress_level		;save changes
	jp edit_new_screen

delete_level:
	ld a,(level_num)
	ld b,a
	ld a,(num_levels)
	sub b
	ld h,a
	ld l,42
	call MultHL
	push hl				;save size to copy
	call get_level_offset
	ld d,h
	ld e,l
	ld bc,42
	add hl,bc				;hl->next level (where we copy from
	pop bc				;retrieve size to copy
	ldir					;copy over current level
	ld hl,num_levels
	dec (hl)
	ld a,(level_num)
	cp (hl)
	jp nz,edit_new_screen
	dec a
	ld (level_num),a
	jp edit_new_screen

switch_mode:
	call draw_ball_status
	call draw_brick_mode
	call draw_cursor
	ld hl,using_ball
	ld a,(hl)
	xor 1					;0=1, 1=0
	ld (hl),a
	jr editmainloop

mode_up:
	call draw_brick_mode
	ld hl,brick_mode
	inc (hl)
	ld a,(hl)
	cp 14
	jr nz,finish_change_mode
	ld (hl),0				;go back to start
finish_change_mode:
	call draw_brick_mode
	jr editmainloop

mode_down:
	call draw_brick_mode
	ld hl,brick_mode
	dec (hl)
	ld a,(hl)
	inc a					;cp -1
	jr nz,finish_change_mode
	ld (hl),13				;end byte
	jr finish_change_mode

change_brick:
	ld bc,(brick_y)
	push bc
;get the tile
	ld h,0
	ld l,b
	ld a,12
	push bc
	call _divHLbyA
	pop bc
	ld b,l					;store x value
	ld l,c
	ld a,6				;divide by 6
	push bc
	call _divHLbyA
	pop bc
	ld a,l					;a=y coordinate
	add a,a
	add a,a
	add a,a				;y*8
	add a,b				;add to x
	ld hl,current_level
	ld e,a
	ld d,0
	add hl,de				;get offset of tile
	pop bc
	ld a,(hl)				;code for tile
	push hl
	call draw_brick			;erase old brick
	pop hl
	ld a,(brick_mode)
	ld (hl),a				;set new brick type
	call draw_brick			;draw new brick
editmainloop:
	jp edit_main_loop

move_brick_down:
	ld hl,brick_y
	ld bc,56*256+6
	jr move_brick

move_brick_up:
	ld hl,brick_y
	ld bc,2*256+(256-6)
	jr move_brick

move_brick_left:
	ld hl,brick_x
	ld bc,2*256+(256-12)
	jr move_brick

move_brick_right:
	ld hl,brick_x
	ld bc,86*256+12

move_brick:
	ld a,(hl)
	cp b
	jr z,editmainloop
	push af
	push bc
	push hl
	call draw_cursor
	pop hl
	pop bc
	pop af
	add a,c
	ld (hl),a
	call draw_cursor
	jr editmainloop

move_ball_down:
	ld hl,current_coords
	ld bc,57*256+1
	jr move_ball

move_ball_right:
	ld hl,current_coords+1
	ld bc,93*256+1
	jr move_ball

move_ball_up:
	ld hl,current_coords
	jr move_ball_dec

move_ball_left:
	ld hl,current_coords+1

move_ball_dec:
	ld bc,2*256+(256-1)

move_ball:
	ld a,(hl)
	cp b
	jr z,editmainloop
	push af
	push bc
	push hl
	call draw_ball
	pop hl
	pop bc
	pop af
	add a,c
	ld (hl),a
	call draw_ball
	jr editmainloop

compress_level:
	call get_level_offset		;hl->compressed level
	ld de,current_coords
	ex de,hl
	ldi
	ldi					;copy starting coordinates
	ex de,hl
	ld b,40				;40 bytes per level
;compress from de to hl
compress_loop:
	ld a,(de)
	rld					;copy 1 byte into lower chunk of hl
	inc de
	ld a,(de)
	rld					;move first byte up, copy next byte into lower chunk of hl
	inc de
	inc hl
	djnz compress_loop
	ret

change_title:
	call get_title
edit_new_scrn:
	jp edit_new_screen

change_description:
	call get_description
	jr edit_new_scrn

reset_score:
	ld hl,starting_highscore
	ld de,highscore
	ld bc,6
	ldir					;copy default highscore
	jr edit_new_scrn

lookup_keys:
	call _clrLCD
	xor a
	ld hl,lookup_text
	ld b,8
lookup_loop:
	push af
	push bc
	call vputs_center
	pop bc
	pop af
	add a,8
	djnz lookup_loop
	call getkey
	jp edit_new_screen

save:
	ld hl,varname
	rst 20h				;move10toop1
	ld hl,description
	call _strlen
	push bc
	ld a,(num_levels)
	ld h,a
	ld l,42
	call MultHL			;size of levels
	pop bc
	add hl,bc				;add length of description
	ld de,11
	add hl,de				;# of levels+null terminator+indicator bytes+highscore stuff
	push hl
	push bc
	call _createstrng
	ld a,b
	ex de,hl
	call _ahl_plus_2_pg3		;past size bytes
	call _set_abs_dest_addr
	pop bc
	ld hl,description
	add hl,bc				;hl->null byte at end of description
	ld de,num_levels-1		;where we're copying to
	inc bc				;include null byte
	lddr
	ld hl,description-1
	ld bc,6
	lddr					;copy initials and highscore
	ld a,$01
	ld (de),a
	dec de
	ld a,$dd
	ld (de),a
	ex de,hl				;move pointer to hl
	xor a
	call _set_abs_src_addr	;copy from here
	pop hl				;retrieve size from _creatstrng
	call _set_mm_num_bytes
	call _mm_ldir			;copy string

quit:
	res 4,(iy+9)
	xor a
	ld (_asapvar+1),a		;so it's recopied
	jp _clrWindow

DoMenu:
	ex de,hl					; swap menu from de to hl
	push hl					; _clrLCD destroys hl
	call _clrScrn				; clears the screen
	pop hl					; now restore it
	ld c,(hl)					; get number of entries
	inc hl						; move to menu title text
        xor a						; top row
	call vputs_center			; display title
	call invert_top				; invert top row
	ld b,c					; load num entries for loop
	ld a,$0e					; starting row
DoMenuDTL:
	call vputs_center			; print the menu text
	add a,9					; move to next line
	djnz DoMenuDTL			; draw all the text
	push hl 					; save pointer
	ld b,1					; start menu at first entry
	call DoMenuInvBar			; invert it
DoMenuL:
	push bc					; save entries and current entry
	call _getky					; same as GET_KEY
	pop bc					; restore it
	cp K_UP					; did they press up?
	jr z,DoMenuUp				; move menu bar up
	cp K_DOWN				; or was it down?
	jr z,DoMenuDown			; then move the bar down
	cp K_SECOND				; did they hit 2nd?
	jr z,DoMenuSelect			; then they want it
	cp K_ENTER				; some people like enter
	jr z,DoMenuSelect			; so check it too
	jr DoMenuL				; they're just sitting there, loop again
DoMenuUp:
	call DoMenuInvBar			; invert current selection back to normal
	dec b					; move up
	jr nz,DoMenuBar			; if it's zero, we're at the top
	ld b,c					; so move to the bottom
	jr DoMenuBar				; handle menu bar
DoMenuDown:
	call DoMenuInvBar			; same as up, go back to normal text
	ld a,c					; get current entry for check
	cp b						; at the bottom?
	jr z,DoMenuDownT			; the move to the top
	inc b						; move down
	jr DoMenuBar				; handle menu bar
DoMenuDownT:
	ld b,1					; move to the top
DoMenuBar:
	call DoMenuInvBar			; invert the new selection
	jr DoMenuL				; now it's time to loop
DoMenuInvBar:
	push hl					; save pointer
	push bc					; save position and entries
	ld h,b					; get position
	ld l,9*16					; there are 7 lines of 16 bytes each (7*16 = 112)
	call _HtimesL				; do the multiply
	ld de,$fc51					; we need to add to video memory
	add hl,de					; do the add
	call DoMenuInv				; invert the line
	pop bc					; restore position and entries
	pop hl					; restore pointer
	ret						; done inverting
DoMenuInv:
	ld c,7					;# of rows
DoMenuInvLoop:
	ld b,14					;14 bytes across
DoMenuFlipBits:
	ld a,(hl)
	cpl
	ld (hl),a
	inc hl	
	djnz DoMenuFlipBits
	inc hl
	inc hl						;skip 2 bytes
	dec c					;row counter
	jr nz,DoMenuInvLoop
	ret
DoMenuSelect:
	pop hl					; restore the pointer
	ld d,0					; clear upper byte
	ld e,b					; load lower byte with current selection
	dec e					; decrease, starting at 0 instead of 1
	sla e						; multiply by 2, pointers are 16-bit (2 bytes)
	add hl,de					; add to get correct address in the jump table
	call $33					; get pointer
	jp (hl)					; jump to the address from the table--hl, not (hl)


; =============================================================
; Puts a sprite stored at (HL) at B,C
; by Matt Johnson <matt@acz.org>
; =============================================================
PutSprite:

	push bc				; Save BC (X, Y) 
	push de				; Save DE
	push hl				; Save HL (Start of Sprite Data)
	push hl				; Save HL (Start of Sprite Data)

	push bc
	ld d, c
	ld e, b
	call FindPixel				; Finds pixel at E, D
	pop bc
				; PutSprite16 needs pixel at B, C
  
				; A = Bitmask with one bit set; this will be the bit (pixel) "counter"

	ex de,hl				; DE = Address in Display of Sprite
	pop hl				; HL = Start of Sprite Data
	ld b,(hl)				; B = X width of Sprite 
	inc hl					; Next byte
	ld c,(hl)				; C = Y width of Sprite
	inc hl					; Next byte (now pointing at actual sprite data)
	push hl				; Save the twice incremented HL into stack
	pop ix				; IX = The recently twice incremented HL

	ex de,hl				; HL = Address in Display of Sprite

PS_NewRow:
	push bc				; Save X width of Sprite and Y width of Sprite
	ld d,(ix)				; D = (IX), so D = First byte from Sprite
	inc ix
	ld e,(ix)				; E = (IX), so E = Second byte from Sprite
	inc ix					; IX points to next row

	push af				; Save Bitmask 
	push hl				; Save HL, Address in Display of Sprite

PS_NewCol:				; Now the fun begins, remember A is the bitmask, D = the Left Column Byte from Sprite, E = the Right Column Byte from Sprite
	sla e					; 16-bit rotation DE
	rl d

	push af				; Save Bitmask
	jr nc,PS_NewPixel		; Bit not set

	xor (hl)				; Invert Pixel at the "current bit" (Bitmask is the "bit counter")
	ld (hl),a				; (HL) = A, Save changes to

PS_NewPixel:
	pop af				; Restore Bitmask
	rrca					; A is rotated right *through* carry
	jr nc,PS_SameByte		; If the carry was set, that means that one bit set in A (bit counter) 
					;  rotated all the way to the end right into carry and recycles back into Bit 7
					;  so it can be used for the next byte

	inc hl					; Move on to next byte

PS_SameByte:
	djnz PS_NewCol		; B = X (width of sprite), so it loops to PS_NewCol X times. This means that is X = 6, 
				; it will Shift Right the bitmask (move the bit counter to the right) 6 times, comparing 
				; each bit of the bitmask and the sprite and setting or clearing the pixel in that
				; particular bit. It then moves on the the next pixel.

				; Move on to the next row
	pop hl				; Recover HL, the Address in Display of the Sprite
	pop af				; Recover AF, A = Bitmask
	ld de,16				; DE = 16
	add hl,de				; HL = HL + 16, this moves down ONE row in the Display Area (128 width / (8 bits/pixel) = 16 bytes)
	pop bc				; Recover X_width and Y_height of Sprite
	dec c				; C = Y_height of Sprite, subract one, which means one row of the Sprite has been drawn

	jr nz,PS_NewRow		; If there are more rows to be drawn, go back to PS_NewRow

; No more rows. Since there were "effectively" 3 pushes before PS_NewRow, there must be three pops that way the
; ret statement will retrieve the correct address when it returns to the calling program.

	pop hl                                         
	pop de
	pop bc
	ret

; =============================================================
; Dan Eble & James Yopp FindPixel routine
; Input:  D = y, E = x
; Output: HL= addr in vid mem, A = bitmask, C is modified
; =============================================================
FindPixel:
        ld hl,FP_Bits
        ld a,e
        and $07         ; a = bit offset
        add a,l
        ld l,a
        adc a,h
        sub l
        ld h,a
        ld c,(hl)       ; c = bitmask for (hl)
;48 t-states up to this point
        ld hl,FP_RLD
        ld (hl),d
        ld a,e          ; a = x/8 (byte offset within row)
        rrca
        rrca   
        rrca
        rld
        or $FC 
        ld l,(hl)
        ld h,a          ; hl -> byte in vid mem
        ld a,c          ; now a = bitmask for (hl)
;121 t-states up to this point
        ret

FP_RLD:  .db $00
FP_Bits: .db $80,$40,$20,$10,$08,$04,$02,$01


ball:
	.db 5, 5
	.db %01110000,0
	.db %11111000,0
	.db %11111000,0
	.db %11111000,0
	.db %01110000

cursor:
	.db 12, 6
	.db %11111111, %11110000
	.db %11111111, %11110000
	.db %11111111, %11110000
	.db %11111111, %11110000
	.db %11111111, %11110000
	.db %11111111, %11110000


bricks:		;start of bricks
;0
	.db 12, 6
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000

;1
	.db 12, 6
	.db %01111111, %11100000
	.db %10000000, %00010000
	.db %10000000, %00010000
	.db %10000000, %00010000
	.db %10000000, %00010000
	.db %01111111, %11100000

;2
	.db 12, 6
	.db %01111111, %11100000
	.db %10101010, %10110000
	.db %11010101, %01010000
	.db %10101010, %10110000
	.db %11010101, %01010000
	.db %01111111, %11100000

;3
	.db 12, 6
	.db %01111111, %11100000
	.db %10000000, %00010000
	.db %10111111, %11010000
	.db %10111111, %11010000
	.db %10000000, %00010000
	.db %01111111, %11100000

;4
	.db 12, 6
	.db %01111111, %11100000
	.db %10100100, %10010000
	.db %10010010, %01010000
	.db %11001001, %00110000
	.db %10100100, %10010000
	.db %01111111, %11100000

;5
	.db 12, 6
	.db %01111111, %11100000
	.db %11111111, %11110000
	.db %11100000, %01110000
	.db %11100000, %01110000
	.db %11111111, %11110000
	.db %01111111, %11100000

;6
	.db 12, 6
	.db %01111111, %11100000
	.db %11111110, %00110000
	.db %10000000, %10110000
	.db %11001110, %00110000
	.db %11111111, %11110000
	.db %01111111, %11100000

;7
	.db 12, 6
	.db %01111111, %11100000
	.db %11111001, %11110000
	.db %11110110, %11110000
	.db %11110000, %11110000
	.db %11110000, %11110000
	.db %01111111, %11100000

;8
	.db 12, 6
	.db %01111111, %11100000
	.db %11100111, %11110000
	.db %10000000, %00010000
	.db %10000000, %00010000
	.db %11100111, %11110000
	.db %01111111, %11100000

;9
	.db 12, 6
	.db %01111111, %11100000
	.db %11011110, %11110000
	.db %11111011, %11110000
	.db %11101111, %10110000
	.db %11111101, %11110000
	.db %01111111, %11100000

;10
	.db 12, 6
	.db %01111111, %11100000
	.db %10101011, %11110000
	.db %11010101, %11110000
	.db %10101011, %11110000
	.db %11010101, %11110000
	.db %01111111, %11100000

;11
	.db 12, 6
	.db %01111111, %11100000
	.db %10000001, %11110000
	.db %10111111, %11110000
	.db %10111111, %11110000
	.db %10000001, %11110000
	.db %01111111, %11100000

;12
	.db 12, 6
	.db %01111111, %11100000
	.db %10100101, %11110000
	.db %10010011, %11110000
	.db %11001001, %11110000
	.db %10100101, %11110000
	.db %01111111, %11100000

;13
	.db 12, 6
	.db %01111111, %11100000
	.db %11111111, %10110000
	.db %11011100, %00010000
	.db %10000011, %10110000
	.db %11011111, %11110000
	.db %01111111, %11100000


title_menu:
	.db 3
;main menu stuff
title:
	.db "Diamonds Level Editor 1.2",0
	.db "New level",0
	.db "Load level",0
	.db "Exit",0
	.dw new_level
	.dw load_level
	.dw quit

no_levels_found:
	.db 2
	.db "No Diamonds levels found",0
	.db "Create new level",0
	.db "Exit",0
	.dw new_level
	.dw quit

delete_table:
	.db 2
	.db "Delete the level?",0
	.db "Yes, delete it",0
	.db "No, don't delete it",0
	.dw delete_level
	.dw edit_new_screen

clear_table:
	.db 2
	.db "Clear the level?",0
	.db "Yes, clear it",0
	.db "No, don't clear it",0
	.dw clear_level
	.dw edit_new_screen

options_table:
	.db 5
	.db "Diamonds Level Editor Options",0
	.db "Back to editor",0
	.db "Controls",0
	.db "Change level name",0
	.db "Change level title",0
	.db "Reset high score",0
	.dw edit_new_screen
	.dw lookup_keys
	.dw change_title
	.dw change_description
	.dw reset_score

lookup_text:
	.db "2nd - place brick",0
	.db "Alpha - switch to/from ball",0
	.db "F1/F2 - down/up brick mode",0
	.db "Arrows - move cursor/ball",0
	.db "More - insert level",0
	.db "Delete - delete level",0
	.db "Plus/Minus - navigate levels",0
	.db "Clear - clear current level",0

enter_name:
	.db "Enter level name:",0
enter_description:
	.db "Enter level title:",0
load_level_txt:
	.db "Load Diamonds Level",0


name_too_long:
	.db "Cannot be more than 8 letters",0
level_already_exists:
	.db "Variable already exists",0

level_text:
	.db "Level",0
brick_text:
	.db "Mode",0
options_text:
	.db "F5-",0
	.db "Options",0

starting_name:
	.db $0c,1,0

ending_name:
	.db $0c,1,$ff

starting_highscore:
	.dw 0
	.db "AAA",0


varname 				equ			$			;level name
temp_search_name		equ			$+11
level_num				equ			$+22
using_ball				equ			$+23			;1=using ball (0=moving bricks)
brick_mode			equ			$+24			;type of brick we're using
brick_y				equ			$+25
brick_x				equ			$+26
current_coords			equ			$+27			;starting coordinates for current level (2 bytes)
current_level			equ			$+29			;the level being edited (80 bytes)
highscore				equ			$+109		;the highscore (2 bytes)
initials				equ			$+111		;initials (4 bytes)
description				equ			$+115		;the description (100 bytes)
num_levels			equ			$+215
levels				equ			$+216		;the actual levels

.end
