;Somehow you've stumbled across the source to Defender.  Well,
;there aren't too many comments, but I think I did a pretty good
;job with the code.  The sprite engine is not that great though...
;Also, keep in mind that this was made to be fast and not small,
;so there are a good many jp's where there could be jr's.

;Btw, this was made on an Amiga with CAZ, so it won't recompile
;under Assembly Studio.


include ti86asm.inc
include ti86abs.inc

org _asm_exec_ram


alock    equ 4078h
k_enter  equ 09h
k_exit   equ 37h
k_graph  equ 2fh
k_more   equ 38h
k_second equ 36h
_cphlde  equ 403ch
endvat   equ d298h

x  equ _asm_exec_ram+6500

shipspot equ x
shipx       equ x+2
shipy    equ x+3
shipshift   equ x+4
lives    equ x+5
bombs    equ x+7
score    equ x+9
starcounter equ x+15
cityshift   equ x+16
citydata    equ x+300
citynumber  equ x+17
movecounter equ x+18
dataaddress equ x+19
rampage     equ x+21
vataddress  equ x+22
numberofships  equ x+24
startships  equ x+25
shiptable   equ x+26
enemies  equ c0f9h
screenx  equ x+28
randomseed  equ x+30
contrast    equ c008h
liveenemies equ x+31
;numexplosions  equ x+32
toastedflag equ x+33
fireflag equ x+34
enemycounter   equ x+35
numbullets  equ x+36
bullets  equ x+37
flag  equ x+39
immortality equ x+40
level    equ   x+41
tmp   equ x+44
dataaddress2   equ x+47
bulletprob  equ x+49
firetimer   equ x+50
conflag  equ x+51
attackflag  equ x+52
citytoast   equ x+53
citytoastframe equ x+54
powertype   equ x+55
powerpos    equ x+57
capflag     equ x+60
driveby     equ x+61
bulletdata equ x+62


nop
jp startcode
defw 0001h
defw ASEtitle
defw icon

icon:
defb 9,1
defb 00011000b
defb 01111110b
defb 11010101b
defb 10101011b
defb 01111110b
defb 00111100b
defb 00111100b
defb 00101000b
defb 00001000b


startcode:

push iy

call _clrScrn
call _runindicoff
ld a,L3
ld (lives),a
ld (bombs),a
xor a                ;ld a,0 but faster and smaller
ld (rampage),a
ld (lives+1),a
ld (bombs+1),a
ld (score+5),a
ld (starcounter),a
ld (level+2),a
ld a,L0
ld (score),a
ld (score+1),a
ld (score+2),a
ld (score+3),a
ld (score+4),a
ld (level),a
inc a
ld (level+1),a


ld bc,64
ld hl,citystart
ld de,citydata
ldir

ld de,_plotSScreen+1
ld hl,_plotSScreen
ld (hl),b
ld bc,1023
ldir

ld a,127
ld (bulletprob),a

title:
   ld hl,titlescreen
   ld de,fc00h
   ld bc,16*24
   ldir

   ld hl,c000h
   call flipthroughthevat

   titleloop:
      call _getky
      cp k_exit
      jp z,quit
;      cp k_graph
;      call z,screenshot
         ld hl,(vataddress)
         dec hl
      cp k_more
      call z,flipthroughthevat
      cp k_second
      jr z,ontothegame

      cp k_enter
   jr nz,titleloop


ontothegame:
      ld a,(rampage)
      or a
      jr z,titleloop

call _clrScrn


call iniplayer

call inibullets


ld bc,0137h
ld de,7e37h
ld h,1
call _ILine
ld de,1f37h
ld bc,1f3fh
ld h,1
call _ILine
ld de,6037h
ld bc,603fh
ld h,1
call _ILine
ld hl,0101h
ld (_penCol),hl
ld hl,livestxt
call _vputs
ld a,18
ld (_penCol),a
ld hl,bombstxt
call _vputs
ld a,100
ld (_penCol),a
ld hl,scoretxt
call _vputs


di


call iniships


call inicity




scf
ex af,af

call puttext


;************the main program loop*************
mainloop:

   ld de,fca0h
   ld hl,caa0h
   ld bc,720
   ldir

   ld a,(liveenemies)
   or a
   jp z,leveldone

   call clearit
   call clearscan

   call drawstars


   ld a,(immortality)
   or a
   jr z,normaldraw
      dec a
      ld b,a
      ld a,(enemycounter)
      and 00000111b
      cp 4
      jr nc,skipdraw
         ld a,b
         ld (immortality),a
   normaldraw:
   ld bc,(shipshift)
   ld hl,(shipspot)
   ld de,playerdata+4
   ld ix,playerdata
   call drawstuff
   skipdraw:

   call drawscanner

   call drawcitytoast

   call drawpowerups

   xor a
   ld (fireflag),a

;**************key routines******

   ld a,10111111b
   out (1),a
   in a,(1)
   bit 5,a                    ;2nd key
   call z,fire
      ld a,(firetimer)
      or a
      jr z,keeptimer
      dec a
      ld (firetimer),a
      keeptimer:

   call drawenemies

   call drawbullets
      ld a,(toastedflag)
      or a
      jp nz,dead


;   call drawexplosions


;******more key routines********

      ld a,10111111b
      out (1),a
      in a,(1)
      bit 6,a                 ;exit key
      jp z,quit

      bit 7,a
      call z,pause

   ld hl,enemycounter
   inc (hl)

   ld a,(starcounter)
   xor 00000001b
   ld (starcounter),a


   ;******more key routines******

      ld a,11011111b
      out (1),a
      in a,(1)
;      bit 6,a                 ;graph key
;      call z,screenshot
      bit 7,a                 ;alpha key
      call z,megabomb


      ld a,11111110b
      out (1),a
         ld ix,shipspot
;         ld iy,shipshift
         ld de,shipy
      in a,(1)
         bit 0,a
      push af
         call z,movedown
      pop af
         bit 3,a
      push af
         call z,moveup
      pop af
         bit 2,a
      push af
         call z,moveright
      pop af
         bit 1,a
         call z,moveleft





jp mainloop





drawstuff:
   ex af,af
   call nc,switchpic
   ex af,af


   ld b,(ix+1)             ;vertical lines
   verloop:
   push bc
   ld b,(ix+2)             ;horizontal bytes
   horloop:
      push bc
         ld a,c
         or a
         ld a,(de)
         jp z,noslide
         ld b,c
         slideloop:
            srl a
         djnz slideloop
         noslide:
         or (hl)
         ld (hl),a

         inc hl

         ld a,l
         and 00001111b
         jp z,offtheedge

         ld a,8
         sub c
         ld b,a
         ld a,(de)
         slideloop2:
            add a,a
         djnz slideloop2
         or (hl)
         ld (hl),a
      pop bc
      inc de
   djnz horloop
   newline:
   ld a,16
   sub (ix+2)
   ld c,a
   add hl,bc
   pop bc
   djnz verloop
ret

switchpic:
   push hl
   ld l,(ix+3)
   ld h,0
   add hl,de
   ex de,hl
   pop hl
   or a
   ret

offtheedge:
   pop bc
   dec hl
   lineloop:
      inc hl
      inc de
      djnz lineloop
   jp newline


scrollcityright:
         ld a,(citynumber)
         and 00111111b
         ld e,a
         ld d,0
         ld hl,citydata
         add hl,de
         ld e,(hl)
         ld hl,city0
         add hl,de
         ex de,hl
   ld hl,ff80h
   ld bc,(cityshift)
   ld b,8
   scrloop:
         ld a,(de)
         and c
         add a,255
      scrbegin:
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc l
      rr (hl)
      inc hl
         inc de
   djnz scrloop
   ret

scrollcityleft:
         ld de,(citynumber)
         ld d,0
         ld a,16
         add a,e
         and 00111111b
         ld e,a

         ld hl,citydata
         add hl,de
         ld e,(hl)
         ld hl,city0+7
         add hl,de
         ex de,hl
   ld hl,ff8fh+(16*7)
   ld bc,(cityshift)
   ld b,8
   sclloop:
         ld a,(de)
         and c
         add a,255
      sclbegin:
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec l
      rl (hl)
      dec hl
         dec de
   djnz sclloop
   ret

fast8x8draw1:
   ld b,8
   fastloop1:
      push bc
      ld a,(de)
      ld (hl),a   
      inc de
      ld bc,16
      add hl,bc
      pop bc
      djnz fastloop1
      ret


drawstars:
   ld ix,startable1
   ld b,12
   starloop:
      ld a,(star1)
      ld h,(ix+1)
      ld l,(ix+0)
      ld (hl),a

      ld a,(star2)
      ld h,(ix+25)
      ld l,(ix+24)
      ld (hl),a

      inc ix
      inc ix
   djnz starloop
   ret

moveup:
   ld a,(de)
   cp 10
   ret z

   dec a
   ld (de),a
   ld l,(ix+0)
   ld h,(ix+1)
   ld bc,-16
   jr endmove

movedown:
   ld a,(de)
   cp 50
   ret z

   inc a
   ld (de),a
   ld l,(ix+0)
   ld h,(ix+1)
   ld bc,16
endmove:
   add hl,bc
   ld (ix+0),l
   ld (ix+1),h
   ret

moveright:
   ld hl,(screenx)
   inc hl
   ld a,h
   and 00000001b
   ld h,a
   ld (screenx),hl

   scf           ;set carry flag
   ex af,af

   ld de,star1
   ld ix,startable1
   call scrollstarsleft

   ld de,star2
   ld ix,startable2
   ld a,(starcounter)
   or a
   call z,scrollstarsleft

   call scrollcityleft
   call cityleft

   ld c,1
   ld a,(shipx)
      cp 47
      jr nc,over46
         sub 34
         ld hl,righttable
         ld d,0
         ld e,a
         add hl,de
         ld c,(hl)
   over46:

   ld a,(movecounter)
   inc a
   and 00000111b
   ld (movecounter),a
   cp c
   call z,shipleft

   ret

moveleft:
   ld hl,(screenx)
   dec hl
   ld a,h
   and 00000001b
   ld h,a
   ld (screenx),hl

   or a           ;reset carry flag
   ex af,af

   ld de,star1
   ld ix,startable1
   call scrollstarsright

   ld de,star2
   ld ix,startable2
   ld a,(starcounter)
   or a                       ;cp 0
   call z,scrollstarsright

   call cityright
   call scrollcityright

   ld c,1
   ld a,(shipx)
      cp 66
      jr c,under66
         sub 66
         ld hl,lefttable
         ld d,0
         ld e,a
         add hl,de
         ld c,(hl)
   under66:

   ld a,(movecounter)
   inc a
   and 00000111b
   ld (movecounter),a
   cp c
   call z,shipright

   ret

shipleft:
   xor a
   ld (movecounter),a

   ld hl,shipx
   dec (hl)

   ld a,(shipshift)
   or a
   jr z,shipleft2
   dec a
   ld (shipshift),a
   ret

shipleft2:
   ld a,7
   ld (shipshift),a
   ld hl,(shipspot)
   dec hl
   ld (shipspot),hl
   ret

shipright:
   xor a
   ld (movecounter),a

   ld hl,shipx
   inc (hl)

   ld a,(shipshift)
   cp 7
   jr z,shipright2
   inc a
   ld (shipshift),a
   ret

shipright2:
   xor a
   ld (shipshift),a
   ld hl,(shipspot)
   inc hl
   ld (shipspot),hl
   ret


cityright:
   ld a,(cityshift)
   rlca
   ld (cityshift),a
   ret nc
   ld hl,citynumber
   dec (hl)
   ret

cityleft:
   ld a,(cityshift)
   rrca
   ld (cityshift),a
   ret nc
   ld hl,citynumber
   inc (hl)
   ret




scrollstarsleft:
   ld a,(de)
   rlca
   ld (de),a
   ret nc
   ld b,12
      starleftloop:
         ld h,(ix+1)
         ld l,(ix+0)
         dec hl
            ld a,l
            and 00001111b
            cp 15
            jr nz,nowrap1
               ld de,16
               add hl,de
            nowrap1:
         ld (ix+1),h
         ld (ix+0),l
         inc ix
         inc ix
      djnz starleftloop
   ret 

scrollstarsright:
   ld a,(de)
   rrca
   ld (de),a
   ret nc
   ld b,12
      starrightloop:
         ld h,(ix+1)
         ld l,(ix+0)
         inc hl
            ld a,l
            and 00001111b
            or a
            jr nz,nowrap2
               ld de,16
               sbc hl,de
            nowrap2:
         ld (ix+1),h
         ld (ix+0),l
         inc ix
         inc ix
      djnz starrightloop
   ret


star1:
   defb 00000001b
star2:
   defb 00000001b

startable1:             ;front layer
   defw cc37h,cd23h,cbd1h,cd6eh,cab4h,cc20h
   defw cb5eh,cd1ah,ccc8h,caf5h,cd16h,caf3h
startable2:             ;back layer
   defw cc3fh,cb5ah,caa2h,cca9h,cc0bh,cb1ah
   defw cb6dh,cd20h,cc8ch,cb99h,cb5ch,cc33h



playerdata:
   defb 0         ;not used for anything
   defb 5         ;vertical lines
   defb 2         ;horizontal bytes
   defb 10             ;total bytes
shippic1:
defb 11110000b, 00000000b
defb 11111001b, 11100000b
defb 00111111b, 00111111b
defb 00011111b, 11111110b
defb 00110011b, 11110000b

shippic2:
defb 00000000b, 00001111b
defb 00000111b, 10011111b
defb 11111100b, 11111100b
defb 01111111b, 11111000b
defb 00001111b, 11001100b

city0:
defb 0
defb 0
defb 0
defb 0
defb 00000000b
defb 01000000b
defb 01010010b
defb 11111010b

city1:
defb 01110000b
defb 01010000b
defb 01110000b
defb 01010000b
defb 01110010b
defb 01010101b
defb 01110111b
defb 11011111b

city2:
defb 00000000b     ;the KWIK-E-MART!!!
defb 01010101b
defb 01100111b
defb 01010111b
defb 11111111b
defb 11001100b
defb 11001100b
defb 11111111b

city3:
defb 00000000b
defb 01010100b
defb 01011000b
defb 01010100b
defb 11111111b
defb 11001100b
defb 11001100b
defb 11111111b

city4:
defb 00000000b
defb 11100111b
defb 11000111b
defb 11100101b
defb 11111111b
defb 11001100b
defb 11001100b
defb 11111111b

city5:
defb 00000000b
defb 00100111b
defb 01110110b
defb 01010101b
defb 11111111b
defb 11001100b
defb 11001100b
defb 11111111b

city6:
defb 00000000b
defb 01110000b
defb 00100000b
defb 00100000b
defb 11111100b
defb 11001100b
defb 11001100b
defb 11001100b

city7:
defb 11111000b
defb 10001000b
defb 11111010b
defb 11111111b
defb 10001101b
defb 11111111b
defb 11111101b
defb 10101111b

city8:
defb 00000000b
defb 00000000b
defb 00100000b
defb 01010000b
defb 11111000b
defb 10101111b
defb 11111111b
defb 11101101b

city9:
defb 00000100b
defb 00000100b
defb 00001010b
defb 00011111b
defb 10010101b
defb 11111111b
defb 11110101b
defb 10111111b

city10:
defb 00000000b
defb 00000000b
defb 00000001b
defb 11111111b
defb 11111111b
defb 10101010b
defb 11101010b
defb 11111111b

city11:
defb 00011000b
defb 01111110b
defb 11111111b
defb 11111111b
defb 10100101b
defb 10100101b
defb 10111101b
defb 11111111b

city12:
defb 00000000b
defb 00000000b
defb 10000000b
defb 11111111b
defb 11111111b
defb 01010101b
defb 01010111b
defb 11111111b


city13:
defb 00001010b
defb 00001010b
defb 00001010b
defb 00011010b
defb 00101110b
defb 01011111b
defb 01111111b
defb 01110111b

city14:
defb 00000000b
defb 00000000b
defb 00000001b
defb 00000011b
defb 00010111b
defb 00111011b
defb 01111101b
defb 11011110b

city15:
defb 00000000b
defb 10000000b
defb 11000100b
defb 11101110b
defb 11110111b
defb 11111011b
defb 11111101b
defb 11011110b

city16:
defb 00000000b
defb 00000000b
defb 00001111b
defb 00001001b
defb 00001111b
defb 10001001b
defb 11011111b
defb 11111111b

city17:
defb 00001111b
defb 00001001b
defb 01101111b
defb 01111001b
defb 01001111b
defb 01111001b
defb 01001111b
defb 01111111b


clearit:
   ld bc,719
   ld de,caa1h
   ld hl,caa0h
   ld (hl),0
   ldir
   ret

livestxt:
   defm 'L: '
   defb 0
bombstxt:
   defm 'B: '
   defb 0
scoretxt:
   defm 'S: '
   defb 0

citystart:
defb 8,136,8,8,16,24,32,40,48,8,72,8,104,8,8,8
defb 72,8,8,56,104,8,136,136,8,64,8,8,112,120,128,136
defb 8,64,112,120,128,8,56,72,8,80,88,96,8,8,64,56,8,72
defb 8,8,8,104,8,56,136,8,8,64,8,72,136,104

righttable:
   defb 8,7,7,6,6,5,5,4,4,3,3,2,2
lefttable:
   defb 2,2,3,3,4,4,5,5,6,6,7,7,8




;screenshot:
;   ld hl,fc00h
;   ld de,_plotSScreen
;   ld bc,1024
;   ldir
;   ret

quit:
   ld a,0dh
   out (5),a
   pop iy
   ei
quit2:
   call _runindicon
   jp _clrScrn

ASEtitle:
defm 'Woohoo!  Defender!'
defb 0

titlescreen:
defb 11101110b,00000000b,00000000b,00111100b,00011111b,10011111b,10011111b,10011000b,01100111b,10000111b,11100111b,11100000b,00000001b,10000000b,00000000b,00000000b
defb 01000100b,00000000b,00000000b,00111110b,00011111b,10011111b,10011111b,10011100b,01100111b,11000111b,11100111b,11110000b,00000111b,00000000b,00000100b,00000000b
defb 01001110b,00000000b,00000000b,00110010b,00011000b,00011000b,00011000b,00011110b,01100110b,01100110b,00000110b,00011000b,00011100b,10000000b,10000110b,00000000b
defb 00000000b,00000000b,00000000b,01100011b,00110000b,00011000b,00011000b,00011011b,01100110b,00110011b,00000011b,00001100b,00110000b,10000001b,01000010b,00000000b
defb 11101110b,00000000b,00000000b,01100011b,00111111b,00011111b,10011111b,10011001b,01100110b,00010011b,11110011b,01111100b,01100001b,01000000b,00000000b,00010000b
defb 10101000b,00000000b,00000000b,01100011b,00111111b,00111111b,00111111b,00001101b,00110011b,00010011b,11110011b,11111000b,11000001b,00111000b,00000000b,00001000b
defb 11101110b,00000000b,00000000b,01100110b,00110000b,00110000b,00110000b,00001101b,10110011b,00010011b,00000011b,11100000b,10000001b,01000100b,00000000b,00000000b
defb 10101010b,00000000b,00000000b,11001100b,01100000b,00110000b,00110000b,00001100b,11110011b,00110001b,10000001b,10111000b,00000000b,11001101b,00000010b,11000000b
defb 11101110b,00000000b,00000000b,11111000b,01111110b,00110000b,00111111b,00001100b,01110011b,11100001b,11111001b,10001110b,00000011b,01100011b,00100110b,10100100b
defb 00000000b,00000000b,00000000b,11110000b,01111110b,00110000b,00111111b,00001100b,00110011b,11000001b,11111001b,10000011b,00000010b,00101100b,01111000b,10011000b
defb 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00001000b,00111011b,10110111b,01001000b
defb 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000110b,00000100b,01101110b,10111111b,00110000b
defb 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00001100b,00000000b,00101101b,11010111b,00000000b
defb 00001111b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00111111b,11111111b,11111111b,01011111b,00000000b
defb 00001111b,10011110b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000111b,11111111b,11111111b,11111111b,11111111b,11111001b,01101010b,00001000b
defb 00000001b,11110011b,11110000b,00000000b,00000000b,00001111b,11111111b,11111111b,11111111b,11111111b,11111111b,11101100b,00001000b,10111011b,00101111b,00000100b
defb 00000000b,11111111b,11100111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111100b,00000000b,00000000b,00000100b,00100001b,01010100b,11110111b,00000010b
defb 00000001b,10011111b,00011111b,11111111b,11111111b,11111000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000100b,00100111b,00010010b,11010100b,10000100b
defb 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000110b,00011000b,10111011b,10111000b,01000000b
defb 11000000b,00100000b,00000000b,00000011b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000011b,00011011b,11000011b,10101110b,10100000b
defb 10100000b,01010000b,00000000b,00000100b,00000000b,01001000b,00000000b,00000000b,00000000b,00000000b,00000100b,00100001b,00000110b,00000100b,00000011b,01011000b
defb 11001010b,01010010b,01100100b,01000100b,01010110b,11100001b,10000000b,00000000b,00000000b,00000000b,10101100b,01100001b,10000000b,00000110b,00000000b,11000110b
defb 10100100b,01110101b,01001010b,10100100b,01010100b,01001001b,00000000b,00000000b,00000000b,00000000b,10100100b,00100000b,11000100b,00100000b,00000000b,00111000b
defb 11001000b,01010011b,01000100b,10100011b,00100100b,01001011b,00000000b,00000000b,00000000b,00000000b,01000101b,00100000b,01111000b,00000000b,00000000b,00000000b

vatemup:
   ld hl,(vataddress)

flipthroughthevat:
   call _RAM_PAGE_7

   vatloop:
      dec hl
      ld a,(hl)
      and 00011111b
      cp 12h
      jr z,foundsomething
         ld de,(endvat)
         call _cphlde
         jp z,nothingfound
      jr vatloop

foundsomething:
   ld (vataddress),hl

   dec hl
   ld e,(hl)
   dec hl
   ld d,(hl)
   dec hl
   ld a,(hl)
   ex de,hl
   call _load_ram_ahl
      inc hl            ;4 header bytes for programs
      inc hl
      inc hl
      inc hl
      ld (dataaddress),hl

      ld a,(hl)
      cp fdh
      jr nz,vatemup
   ld bc,7
   add hl,bc
   ld a,(hl)
   cp c9h
   jr nz,vatemup
   inc hl
      push hl
         ld hl,fdc0h
         ld de,fdc1h
         ld bc,574
         ld (hl),0
         ldir
      pop hl

      ld bc,1c00h
      ld (_penCol),bc
      ld b,(hl)
      inc hl
         push hl
         push bc
      call _vputsn
         pop bc
         pop hl
      ld c,b
      ld b,0
      add hl,bc
      ld a,(hl)
      ld (numberofships),a
      inc hl
      ld a,(hl)
      ld (startships),a
      inc hl

      ld bc,2405h
      ld (_penCol),bc
      push hl
      call _vputs
      pop hl
      ld bc,17
      add hl,bc

      ld bc,2465h
      ld (_penCol),bc
      call _vputs

      ld bc,2a05h
      ld (_penCol),bc
      push hl
      call _vputs
      pop hl
      ld bc,17
      add hl,bc

      ld bc,2a65h
      ld (_penCol),bc
      call _vputs

      ld bc,3005h
      ld (_penCol),bc
      push hl
      call _vputs
      pop hl
      ld bc,17
      add hl,bc

      ld bc,3065h
      ld (_penCol),bc
      call _vputs

      ld (shiptable),hl

      in a,(6)
      ld (rampage),a
ret


nothingfound:
   ld a,(rampage)
   or a
   jr z,nofiles
   ld hl,bfffh
   jp flipthroughthevat

nofiles:
   ld hl,1c00h
   ld (_penCol),hl
   ld hl,nofilestext
   call _vputs
   ret

nofilestext:
   defm 'No files found'
   defb 0

randomize:
   ld a,(randomseed)                     ;Jimmy Mardell's random routine
   add a,17
   ld (randomseed),a                     ;modified a little by me
   ld c,a
   ld b,255
   ld a,r
   add a,c
   ld hl,0
   ld d,h
   ld e,a
   Rmul:
      add hl,de
      djnz Rmul
   ld a,h

ret


fire:
   ld a,(firetimer)
   inc a
   ld (firetimer),a
   cp 100
   ret nc
      inc a
      inc a
      ld (firetimer),a
   ld hl,(shipspot)
   ex af,af
   jr nc,facingleft
      ex af,af
      ld bc,50
      add hl,bc
      ex de,hl
      ld h,d
      ld l,e
      inc de
      ld (hl),255
      ld a,l
      and 00001111b
      ld b,a
      ld a,15
      sub b
      ld c,a
      ld b,0
      ldir
         ld a,1
         ld (fireflag),a
      ret
   facingleft:
      ex af,af
      ld bc,48
      add hl,bc
      ld b,l
      ld a,l
      and 11110000b
      ld l,a
      ld (hl),255
      ld d,h
      ld e,l
      inc de
      ld a,b
      and 00001111b
      ld c,a
      ld b,0
      ldir
         ld a,2
         ld (fireflag),a
      ret

drawenemies:
   ex af,af
   push af
   ld iy,enemies
   ld b,16

   enemyloop:
   push bc
   ld de,(screenx)
   ld h,(iy+4)
   ld l,(iy+5)
   or a              ;reset c
   sbc hl,de
   jp c,maybenotonscreen
      maybeonscreen:
      ld e,l
      ld bc,128
      sbc hl,bc
      jp nc,notonscreen
         ld a,(shipx)
         cp e
            push af
         ex af,af

         ld a,e
         and 00000111b
         ld c,a
            ld b,e
         srl e
         srl e
         srl e
         ld d,0
         ld hl,ca00h
         add hl,de
         ld e,(iy+6)
         ex de,hl
         add hl,hl
         add hl,hl
         add hl,hl
         add hl,hl
         ex de,hl
         add hl,de

         ld d,(iy+1)
         ld e,(iy+0)

         push de
         pop ix
         xor a
         ld (flag),a
         call collisiondetect


         inc de
         inc de
         inc de
         inc de
         push ix
         call drawstuff
         pop ix
         call addbullet
         pop af
         jp c,checkfireright
         jp checkfireleft
   notonscreen:
      call aistuff

      ld bc,8
      add iy,bc
   pop bc
   djnz enemyloop

   pop af
   ex af,af

   ret


maybenotonscreen:
   ld bc,384
   add hl,bc
   jr c,notonscreen
   ld bc,128
   add hl,bc
   jr maybeonscreen

checkfireright:
   ld a,(fireflag)
   cp 1
   jr nz,notonscreen
   jr checkv
checkfireleft:
   ld a,(fireflag)
   cp 2
   jr nz,notonscreen
checkv:
   ld a,(starcounter)
   or a
   jr z,notonscreen
   ld a,(shipy)
   add a,3
   cp (iy+6)
   jr c,notonscreen
      sub (ix+1)
      cp (iy+6)
      jr nc,notonscreen
   dec (iy+2)
   call z,addpoints
   call z,killship
   jr notonscreen



megabomb:
   ld a,(bombs)
   cp L0
   ret z

   dec a
   ld (bombs),a

   call inibullets

   call puttext
   ld a,(contrast)
   sub 7
   ld (contrast),a
   out (2),a

   ld iy,enemies
   ld b,16
   bombloop:
   push bc
   ld h,(iy+4)
   ld l,(iy+5)
   ld de,(screenx)
      or a
      sbc hl,de
      jr c,checkbombhit
      bombstuff:
         ld bc,128
         sbc hl,bc
         jr nc,nobombhit
;            call calcvid
;            call addexp
            call killship
   nobombhit:
   ld bc,8
   add iy,bc
   pop bc
   djnz bombloop

   call clearit
   call drawstars
   ld bc,(shipshift)
   ld hl,(shipspot)
   ld de,playerdata+4
   ld ix,playerdata
   call drawstuff

   ld bc,720
   ld hl,caa0h
   ld de,fca0h
   ldir



   ld b,7
   fadein:
      push bc
      ld b,255
      outerloop:
         push bc
            ld b,255
            innerloop:
               nop
            djnz innerloop
         pop bc
      djnz outerloop

      ld a,(contrast)
      inc a
      ld (contrast),a
      out (2),a
      pop bc
      djnz fadein
   ret

checkbombhit:
   ld bc,384
   add hl,bc
   jr c,nobombhit
   ld bc,128
   add hl,bc
   jr bombstuff

;calcvid:
;   ld h,(iy+4)                   ;returns position in vid mem in hl,
;   ld l,(iy+5)                   ;shift in c
;   ld de,(screenx)
;   or a
;   sbc hl,de
;   srl l
;   srl l
;   srl l
;   ld bc,fc00h
;   add hl,bc
;   ld e,(iy+6)
;   ld d,0
;   ex de,hl
;   add hl,hl
;   add hl,hl
;   add hl,hl
;   add hl,hl
;   ex de,hl
;   add hl,de
;   ld a,(iy+5)
;   and 00000111b
;   ld c,a

;   ret

;addexp:
;   ld a,(numexplosions)
;   ld e,a
;   inc a
;   ld (numexplosions),a
;   ld d,0
;   ex de,hl
;   add hl,hl
;   add hl,hl
;   ex de,hl
;   ld ix,explosions
;   add ix,de
;   ld (ix+0),l
;   ld (ix+1),h
;   ld (ix+2),c
;   xor a
;   ld (ix+3),a
;   ret


;kaboom1:
;   defb 0
;   defb 8
;   defb 1
;   defb 0
;   defb 00110101b
;   defb 01001001b
;   defb 01110110b
;   defb 10001000b
;   defb 01100000b
;   defb 00000000b
;   defb 00000000b
;   defb 00000000b
;kaboom2:
;   defb 0
;   defb 8
;   defb 1
;   defb 0
;   defb 00110110b
;   defb 01101101b
;   defb 01010010b
;   defb 10010101b
;   defb 10100100b
;   defb 01101000b
;   defb 00000000b
;   defb 00000000b
;kaboom3:
;   defb 0
;   defb 8
;   defb 1
;   defb 0
;   defb 00000111b
;   defb 00010010b
;   defb 00101001b
;   defb 00110100b
;   defb 11001011b
;   defb 01101100b
;   defb 10010000b
;   defb 00000000b
;kaboom4:
;   defb 0
;   defb 8
;   defb 1
;   defb 0
;   defb 00000000b
;   defb 00000001b
;   defb 00000010b
;   defb 00000000b
;   defb 00001101b
;   defb 00011001b
;   defb 00001010b
;   defb 00000000b

;drawexplosions:
;   ld a,(numexplosions)
;   or a
;   ret z
;      ld b,a
;      ld iy,explosions

;   exploop:
;   push bc
;      ld a,(iy+3)
;      push af
;      ld a,(starcounter)
;      or a
;      pop af
;      jr z,removedone
;      inc a
;      and 00000011b
;      jr z,removeexp
;      removedone:
;      ld h,(iy+1)
;      ld l,(iy+0)
;      ld c,(iy+3)
;      ld (iy+3),a
;      sla c
;      sla c
;      ld a,c
;      sla c
;      add a,c
;      ld c,a
;      ld ix,kaboom1
;      ld b,0
;     add ix,bc
;     push ix
;      pop de
;      inc de
;      inc de
;      inc de
;      inc de
;      ld c,(iy+2)
;      call drawstuff
;      ld bc,4
;      add iy,bc
;   pop bc
;   djnz exploop
;   ret

;removeexp:
;   pop bc
;   dec b
;   ret z
;   push bc
;   ld l,b
;   ld h,0
;   add hl,hl
;   add hl,hl
;   ld b,h
;   ld c,l
;   push iy
;   pop hl
;   ld e,l
;   ld d,h
;   inc hl
;   inc hl
;   inc hl
;   inc hl
;   ldir
;   ld hl,numexplosions
;   dec (hl)
;   jr removedone

collisiondetect:
   ld a,(flag)
   cp 2
   jp z,nocheck
   ld a,(immortality)
   or a
   ret nz
   nocheck:
   ld a,(shipy)
      add a,4
   cp (iy+6)
   ret c
      sub 4
      sub (ix+1)
   call c,fixshipy
   cp (iy+6)
   ret nc
      ld a,(shipx)
      add a,16
      cp b
      ret c
      ld a,(ix+2)
         add a,a
         add a,a
         add a,a
         add a,b
         ld b,a
         ld a,(shipx)
         cp b
         ret nc
   ld a,(flag)
   cp 2
   jp z,goodies
   ld a,1
   ld (toastedflag),a
   ld a,(flag)
   or a
   jp z,killship
   pop af
   pop af
   pop af
   ret

fixshipy:
   xor a
   ret

shipdie:

defb 0
defb 5
defb 2
defb 0
defb 00000011b,11000000b
defb 00001100b,01011000b
defb 00010010b,00100100b
defb 00001101b,00011000b
defb 00000011b,11000000b

defb 0
defb 5
defb 2
defb 0
defb 00001100b,00110000b
defb 00110000b,10101100b
defb 01011101b,00010010b
defb 00100000b,10001100b
defb 00011100b,00110000b

defb 0
defb 5
defb 2
defb 0
defb 00110000b,00001000b
defb 01100100b,00100110b
defb 10010010b,01001001b
defb 01100000b,00100010b
defb 00010000b,00001100b

defb 0
defb 5
defb 2
defb 0
defb 01100000b,00000011b
defb 00000000b,00000100b
defb 10110000b,00011001b
defb 00001000b,00000000b
defb 11000000b,00000101b

dead:
   ld bc,(shipshift)
   ld hl,(shipspot)
   ld de,12800
   add hl,de
   ld ix,shipdie
   ld de,shipdie+4
   ld b,4
   blowuploop:
   push bc
   push hl
   push de
   push ix
   ld b,5
   clearexploop:
   ld (hl),0
   inc hl
   ld (hl),0
   ld de,15
   add hl,de
   djnz clearexploop
   pop ix
   pop de
   pop hl
   pop bc
   push bc
   push hl
   push de
   push ix
   call drawstuff
   call slowdown
   pop ix
   pop de
      ld bc,14
      add ix,bc
      ex de,hl
      add hl,bc
      ex de,hl
   pop hl
   pop bc
   djnz blowuploop

   ld a,(lives)
   dec a
   ld (lives),a
   cp L0
   jr z,deadforgood
      call iniplayer
      call inicity
      call inibullets
   call puttext
   jp mainloop


deadforgood:
   ld iy,c3e5h
   ld hl,202dh
   ld (_penCol),hl
   ld hl,gameover
   in a,(5)
   out (6),a
   ld a,0dh
   out (5),a
   call _vputs
overloop:
   ld a,10111111b
   out (1),a
   in a,(1)
   cp 255
   jr z,overloop
   ei
   pop iy
   call checkhigh
   jp quit2

gameover:
   defm 'Game Over',0

iniplayer:
   ld a,10000000b
   ld (cityshift),a

   xor a
   ld (citytoast),a
   ld (shipshift),a
   ld (citynumber),a
   ld (screenx),a
   ld (screenx+1),a
   ld (firetimer),a
   ;ld (numexplosions),a
   ld (toastedflag),a
   ld hl,cc07h
   ld (shipspot),hl
   ld a,56
   ld (shipx),a
   ld a,32
   ld (shipy),a
   ld a,65
   ld (immortality),a
   ret

inicity:
   ld ix,citydata
   ld hl,ff80h
   ld b,16

   drawthecity:
   push hl
   ld e,(ix+0)
   ld d,0
   ld hl,city0
   add hl,de
   ex de,hl
   pop hl
   push bc
   push hl
   call fast8x8draw1 
   pop hl
   pop bc
   inc ix
   inc hl
   djnz drawthecity
   ret

killship:
      call powerup
            xor a
            ld (iy+0),a
            ld (iy+1),a
            dec a
            ld (iy+4),a
            ld (iy+5),a
            push hl
            ld hl,liveenemies
            dec (hl)
            ld a,(iy+7)
            bit 5,a
            call nz,resetdrive
            bit 4,a
            call nz,resetattack
            pop hl
      ret

resetdrive:
   ld hl,driveby
   ld (hl),0
   ret
resetattack:
   ld hl,attackflag
   ld (hl),0
   ret

addpoints:
   push af
   ld b,(ix+2)
   ld a,(ix+1)
   ld c,a
   pointloop:
      add a,c
   djnz pointloop
      sub c
      ld b,a
   addloop:
      push bc
      ld a,(score+4)
      add a,5
      ld (score+4),a
      ld hl,score+4
      call fixnumber
      pop bc
   djnz addloop
   call puttext

   pop af
   ret

fixnumber:
      numberloop:
      ld a,(hl)
      cp L0
      jr nc,oksofar
         ld b,a
         ld a,L0
         sub b
         ld b,a
         ld a,L9+1
         sub b
         ld (hl),a
         dec hl
         dec (hl)
         jr numberloop
      oksofar:
         cp L9+1
         ret c
         sub L9
         add a,L0-1
         ld (hl),a
         dec hl
         inc (hl)
         jr numberloop

aistuff:
   ld a,(iy+0)
   or a
   ret z
   ld a,(enemycounter)
   and (iy+3)
   or a
   ret nz

      ld a,(iy+7)
      or a
      jp z,newdirection
      ld c,a
      bit 5,c
      jp nz,drivebynow
      bit 4,c
      jp nz,gotocitynow
      bit 3,c
      jp nz,goupnow
      bit 2,c
      jp nz,godownnow
      finishedv:
      bit 1,c
      jp nz,gorightnow
      bit 0,c
      jp nz,goleftnow
      finishedh:
      ld a,r
      cp 116
      ret c
      xor a
      ld (iy+7),a

ret

newdirection:
   ld a,r
   cp 80
   jp nc,gotocity
regmovement:
   ld a,r
   cp 20
   jp c,dodriveby
   and 00000011b
   dec a
   jp z,goup
   dec a
   jp z,godown
   donev:
      call randomize
      and 00000011b
      ret z
      dec a
      jp z,goright
      dec a
      jp z,goleft
ret


goupnow:
   ld a,(iy+6)
   cp 11
   jp c,finishedv
   dec (iy+6)
   jp finishedv
godownnow:
   ld a,(iy+6)
   ld h,(iy+1)
   ld l,(iy+0)
   inc hl
   add a,(hl)
   cp 50
   jp nc,finishedv
   inc (iy+6)
   jp finishedv
gorightnow:
   ld h,(iy+4)
   ld l,(iy+5)
   inc hl
   ld a,h
   and 1
   ld (iy+4),a
   ld (iy+5),l
   jp finishedh
goleftnow:
   ld h,(iy+4)
   ld l,(iy+5)
   dec hl
   ld a,h
   and 1
   ld (iy+4),a
   ld (iy+5),l
   jp finishedh
gotocitynow:
   ld a,(iy+6)
   ld h,(iy+1)
   ld l,(iy+0)
   inc hl
   add a,(hl)
   cp 54
   jp nc,destroycity
   inc (iy+6)
   ret
   destroycity:
      ld b,(iy+4)
      ld a,(iy+5)
      srl b
      rra
      rra
      rra
      ld (citytoast),a
      ld a,5
      ld (citytoastframe),a
      xor a
      ld (iy+7),a
      ret
drivebynow:
   ld h,(iy+4)
   ld l,(iy+5)
   dec hl
   ld a,h
   and 1
   ld (iy+4),a
   ld (iy+5),l
   ld hl,driveby
   dec (hl)
   ret nz
   xor a
   ld (iy+7),a
   ret



goup:
   set 3,(iy+7)
   jp donev
godown:
   set 2,(iy+7)
   jp donev
goright:
   set 1,(iy+7)
   ret
goleft:
   set 0,(iy+7)
   ret
gotocity:
   ld a,(attackflag)
   or a
   jp nz,regmovement
   ld a,(iy+5)
   and 00000111b
   or a
   jp nz,regmovement
   ld b,(iy+4)
   ld a,(iy+5)
   srl b
   rra
   rra
   rra
   ld e,a
   ld d,0
   ld hl,citydata
   add hl,de
   ld a,(hl)
   or a
   jp z,regmovement
   ld (attackflag),a
   set 4,(iy+7)
   ret
dodriveby:
   ld a,(iy+3)
   cp 3
   ret nc
   ld a,(driveby)
   or a
   jp nz,regmovement
   set 5,(iy+7)
   ret



puttext:
   in a,(5)
   push af
   ld a,0dh
   out (5),a
   push iy
   ld iy,c3e5h

   ld hl,0107h
   ld (_penCol),hl
   ld hl,lives
   call _vputs
   ld a,24
   ld (_penCol),a
   ld hl,bombs
   call _vputs
   ld a,106
   ld (_penCol),a
   ld hl,score
   call _vputs

   pop iy
   pop af
   out (5),a
ret

addbullet:
   ld a,(starcounter)
   or a
   ret z
   ld a,(bulletprob)
   ld e,a
   ld a,r
   cp e
   ret c
   ld a,(numbullets)
   cp 4
   ret nc
   ld hl,(bullets)
   ld d,(iy+4)
   ld e,(iy+5)
   ld (hl),d
   inc hl
   ld (hl),e
   ld a,(ix+1)
   srl a
   ld c,(iy+6)
   add a,c
   inc hl
   ld (hl),a
   push hl
      ld c,0
      ld hl,(screenx)
      ex de,hl
      or a
      sbc hl,de
      ld a,h
      and 1
      ld h,a
      ld de,(shipx)
      ld d,0
      sbc hl,de
      jr c,shootright
      set 0,c
      vtest:
         ld a,(shipy)
         add a,15
         cp (iy+6)
         jr c,shootup
         sub 25
         cp (iy+6)
         jr nc,shootdown
         endvtest:
   pop hl
   inc hl
   ld (hl),c
   inc hl
   ld (bullets),hl
   ld hl,numbullets
   inc (hl)
   ret

shootright:
   set 1,c
   jr vtest
shootup:
   set 3,c
   jr endvtest
shootdown:
   set 2,c
   jr endvtest

drawbullets:
   ld a,(numbullets)
   or a
   ret z
   ld b,a
   ld iy,bulletdata
   bulletloop:
      push bc
      ld h,(iy+0)
      ld l,(iy+1)
      ld de,(screenx)
      or a
      sbc hl,de
      ld a,h
      and 1
      ld h,a
      ld a,l
      ld b,l
      and 00000111b
      ld c,a
      srl h
      rr l
      srl l
      srl l
      ld a,l
      cp 16
      jr nc,offscreen
         ex de,hl
         ld hl,ca00h
         add hl,de
         ld e,(iy+2)
         ex de,hl
         add hl,hl
         add hl,hl
         add hl,hl
         add hl,hl
         ex de,hl
         add hl,de
         ld ix,bulletpic
         ld de,bulletpic+4
         ld a,1
         ld (flag),a
         push iy
            dec iy
            dec iy
            dec iy
            dec iy
         call collisiondetect
         pop iy
         call drawstuff
      call movebullet
      ld de,8
      add iy,de
      offscreen2:
      pop bc
   djnz bulletloop
   ret

offscreen:
   push iy
   dec iy
   dec iy
   dec iy
   dec iy
   call removebullet
   pop iy
jr offscreen2

bulletpic:
   defb 0
   defb 3
   defb 1
   defb 0
   defb 00001000b
   defb 00011100b
   defb 00001000b

removebullet:
   push hl
   push de
   push bc
   ld hl,4
   push iy
   pop de
   add hl,de
   ex de,hl
   ld bc,8
   add hl,bc
   ld c,12
   ldir
   ld hl,numbullets
   dec (hl)
   ld hl,(bullets)
   ld bc,-4
   add hl,bc
   ld (bullets),hl
   pop bc
   pop de
   pop hl
   dec iy
   dec iy
   dec iy
   dec iy
   ret

movebullet:
   bit 3,(iy+3)
   jp nz,bulletup
   bit 2,(iy+3)
   jp nz,bulletdown
   donebulletv:
   bit 1,(iy+3)
   jp nz,bulletright
   bit 0,(iy+3)
   jp nz,bulletleft
   donebulleth:
      dec iy
      dec iy
      dec iy
      dec iy
   ld a,(iy+6)
   cp 11
   jr c,removebullet
   cp 50
   jr nc,removebullet
   ret

bulletup:
   dec (iy+2)
   jr donebulletv
bulletdown:
   inc (iy+2)
   jr donebulletv
bulletright:
   ld h,(iy+0)
   ld l,(iy+1)
   inc hl
   ld a,h
   and 1
   ld h,a
   ld (iy+0),h
   ld (iy+1),l
   jr donebulleth
bulletleft:
   ld h,(iy+0)
   ld l,(iy+1)
   dec hl
   ld a,h
   and 1
   ld h,a
   ld (iy+0),h
   ld (iy+1),l
   jr donebulleth

leveldone:
   in a,(5)
   push af
   ld a,0dh
   out (5),a
   ld iy,c000h
      ld hl,0103h
      ld (_curRow),hl
      ld hl,leveltext
      call _puts
      ld hl,0703h
      ld (_curRow),hl
      ld hl,level
      call _puts
      ld hl,startships
      inc (hl)
      ld ix,citydata
      ld b,64
      ld hl,0104h
      ld (_curRow),hl
      ld hl,citytext
      call _puts
      ld a,L0
      ld (tmp),a
      ld (tmp+1),a
      citybonusloop:
         push bc
         ld a,(ix+0)
         or a
         call nz,givebonus
         inc ix
         pop bc
         djnz citybonusloop
      call waitforkey
      call iniplayer
      call inicity
      ld hl,level+1
      inc (hl)
      call fixnumber
      call iniships
      call inibullets
   pop af
   out (5),a
   call puttext
   ld a,(bulletprob)
   cp 100
   jp c,mainloop
   dec a
   ld (bulletprob),a
   jp mainloop


waitforkey:
ld a,11111101b
out (1),a
nop
in a,(1)
bit 0,a
ret z
jr waitforkey

givebonus:
   ld a,(score+4)
   add a,5
   ld (score+4),a
   ld hl,score+4
   call fixnumber
   ld hl,tmp+1
   inc (hl)
   call fixnumber
   xor a
   ld (tmp+2),a
   ld hl,1104h
   ld (_curRow),hl
   ld hl,tmp
   call _puts
   call puttext
   ret

leveltext:
   defm 'Level    Completed'
   defb 0

iniships:
xor a
ld (attackflag),a
ld (powertype+1),a
ld (driveby),a
ld a,(rampage)
out (5),a
inc a
out (6),a
ld hl,(shiptable)
ld bc,-16384
add hl,bc
push hl
pop ix
ld iy,enemies
ld hl,(dataaddress)
add hl,bc
ld (dataaddress2),hl

ld a,(numberofships)
ld bc,(startships)
cp c
jr nc,startenemies
   ld (startships),a

startenemies:

ld a,16
ld (liveenemies),a
makeenemies:
   push af
   push ix

   call randomize
   ld bc,(startships)
   redonumber:
   cp c
   jr c,validnumber
      sub c
      jr redonumber
   validnumber:
   add a,a
   ld b,0
   ld c,a
   add ix,bc

   ld d,(ix+1)
   ld e,(ix+0)
   ld hl,(dataaddress2)
   add hl,de
   ld (iy+0),l                         ;first 2 bytes pointer to graphic
   ld (iy+1),h
   ld a,(hl)
      rra
      srl a
      srl a
      srl a
      ld (iy+2),a                      ;3rd byte for toughness
   ld a,(hl)
      and 00001111b
      ld (iy+3),a                      ;4th byte for speed
      inc hl
      ld b,(hl)
      push bc

   call randomize                      ;5th and 6th for horizontal position
   ld l,a
   push hl
   call randomize
   and 00000001b
   pop hl
   ld h,a
   ld de,-64
   push hl
   add hl,de
   pop hl
   call nc,set6
   ld (iy+4),h
   ld (iy+5),l

      pop bc
      ld a,55
      sub b
      push af
      call randomize
      and 00111111b
      ld b,10
      add a,b
      pop bc
      cp b
      jr c,highenough
      ld a,b
      highenough:
      ld (iy+6),a                      ;7th for vertical position
      xor a
      ld (iy+7),a                      ;8th used for ai

   pop ix
      ld bc,8
      add iy,bc

   pop af
dec a
jp nz,makeenemies
ret

set6:
   set 6,l
   ret

citytext:
   defm 'City Remaining:'
   defb 0

inibullets:
   xor a
   ld (numbullets),a
   ld hl,bulletdata
   ld (bullets),hl
   ret

pause:
   ld a,10111111b
   out (1),a
   in a,(1)
   bit 7,a
   jr z,pause
      in a,(5)
      push af
      ld a,0dh
      out (5),a
      push iy
      ld iy,c000h
         ld hl,1e18h
         ld (_penCol),hl
         ld hl,pausetext
         call _vputs
      pop iy
      pop af
      out (5),a
      pause2:
         ld a,11111101b
         out (1),a
         in a,(1)
         bit 2,a
            call z,contrastdown
         bit 1,a
            call z,contrastup
         and 00000110b
            cp 6
            call z,nokey

      ld a,10111111b
      out (1),a
      in a,(1)
      bit 7,a
      jr nz,pause2
         pause3:
         ld a,10111111b
         out (1),a
         in a,(1)
         bit 7,a
         jr z,pause3
         ret

pausetext:
   defm 'Paused   [+,-] for contrast'
   defb 0

drawscanner:
   ld ix,enemies
   ld b,16
   scanloop:
      ld a,(ix+0)
      or a
      jr z,noscan
         push bc
         ld a,(ix+6)
         sub 10
         ld e,a
         srl e
         srl e
         srl e
         inc e
         sla e
         sla e
         sla e
         sla e
         ld d,0
         ld hl,fc00h
         add hl,de
         ld d,(ix+4)
         ld a,(ix+5)
         ld e,a
         and 00111000b
         ld b,a
         srl d
         rr e
         srl e
         srl e
         srl e
         srl e
         srl e
         ld a,e
         add a,4
         ld e,a
         add hl,de
         ld a,b
         or a
         ld a,10000000b
         jr z,noinnerloop
         srl b
         srl b
         srl b
         scaninnerloop:
            rrca
            djnz scaninnerloop
         noinnerloop:
         or (hl)
         ld (hl),a
         pop bc
         noscan:
         ld de,8
         add ix,de
      djnz scanloop

   ld a,(shipy)
   sub 10
   ld c,a
   srl c
   srl c
   srl c
   inc c
   sla c
   sla c
   sla c
   sla c
   ld hl,fc00h
   ld b,0
   add hl,bc
   push hl
   ld de,(screenx)
   ld hl,(shipx)
   ld h,0
   add hl,de
   ex de,hl
   pop hl
   ld a,e
   and 00111000b
   ld b,a
   srl d
   rr e
   srl e
   srl e
   srl e
   srl e
   srl e
   ld a,e
   add a,4
   ld e,a
   ld d,0
   add hl,de
   ld a,b
   or a
   ld a,11000000b
   jr z,noinnerloop2
   srl b
   srl b
   srl b
   scaninnerloop2:
      rra
      djnz scaninnerloop2
   noinnerloop2:
   push af
   or (hl)
   ld (hl),a
   pop af
   ret nc
   inc hl
   ld a,10000000b
   or (hl)
   ld (hl),a
   ret

clearscan:
   ld b,7
   ld hl,fc04h
   ld de,fc05h
   clearloop:
      push bc
      ld (hl),0
      ld bc,7
      ldir
      ld bc,9
      add hl,bc
      ld d,h
      ld e,l
      inc e
      pop bc
   djnz clearloop
   ret

contrastdown:
   push af
      ld a,(conflag)
      or a
      jr nz,nodown
         inc a
         ld (conflag),a
         ld a,(c008h)
         dec a
         ld (c008h),a
         out (2),a
   nodown:
   pop af
ret

contrastup:
   push af
      ld a,(conflag)
      or a
      jr nz,noup
         inc a
         ld (conflag),a
         ld a,(c008h)
         inc a
         ld (c008h),a
         out (2),a
   noup:
   pop af
ret

nokey:
   xor a
   ld (conflag),a
ret

kablam:
   defb 00000000b
   defb 00000000b
   defb 00000000b
   defb 00000000b
   defb 00000000b
   defb 01000000b
   defb 01010001b
   defb 01011011b

   defb 00110100b
   defb 01101011b
   defb 10100101b
   defb 00010000b
   defb 00000000b
   defb 01000000b
   defb 01010001b
   defb 01011011b

   defb 00101100b
   defb 01010010b
   defb 01011001b
   defb 00010000b
   defb 00100100b
   defb 00010000b
   defb 00011001b
   defb 01101111b

   defb 00000000b
   defb 00011100b
   defb 01101010b
   defb 01010001b
   defb 00101110b
   defb 00010100b
   defb 00101001b
   defb 01110111b

   defb 00000000b
   defb 00000000b
   defb 00000000b
   defb 00110100b
   defb 01110110b
   defb 01101110b
   defb 01011010b
   defb 10100101b

drawcitytoast:
   ld a,(citytoast)
   or a
   ret z

   ld a,(enemycounter)
   and 00000111b
   or a
   ret nz

   ld a,(citytoastframe)
   sub 1
   jp c,endtoast
   ld (citytoastframe),a

   ld bc,(citynumber)
   ld a,(screenx)
   and 00000111b
   or a
   jp nz,oneover
   backtotoast:
   ld a,(citytoast)
   sub c
   and 01111111b
   cp 16
   ret nc

   ld hl,ff80h
   add a,l
   ld l,a

   ld ix,kablam
   ld a,(citytoastframe)
   add a,a
   add a,a
   add a,a
   ld c,a
   ld b,0
   add ix,bc

   ld a,(screenx)
   and 00000111b
   ld b,a
   ld a,8
   sub b
   and 00000111b
   or a
   ld b,a
   ld c,a
   ld a,0               ;xor would screw up the flags
   jr z,nomask
   makemask:
      scf
      rra
      djnz makemask
   nomask:
   ld d,a
   xor 255
   ld e,a
   ld b,8

   toastdraw:
      push bc
      ld a,c
      or a
      ld a,(ix+0)
      jp z,dontshift
      ld b,c
      loopshift:
         srl a
         djnz loopshift
      dontshift:
      ld b,a
      ld a,(hl)
      and d
      or b
      ld (hl),a

      inc hl
      ld a,l
      and 00001111b
      jp z,nosecondpart

      ld a,8
      sub c
      ld b,a
      ld a,(ix+0)
      loopshift2:
         add a,a
         djnz loopshift2
      ld b,a
      ld a,(hl)
      and e
      or b
      ld (hl),a

      nosecondpart:
      ld bc,15
      add hl,bc
      inc ix
      pop bc
      djnz toastdraw

   ret


oneover:
   inc c
   jp backtotoast

endtoast:
   ld hl,citydata
   ld de,(citytoast)
   ld d,0
   add hl,de
   xor a
   ld (hl),a
   ld (citytoast),a
   ld (attackflag),a
   ret

slowdown:
   ld b,150
   slowouter:
   push bc
      ld b,150
      slowinner:
         nop
      djnz slowinner
   pop bc
   djnz slowouter
   ret

checkhigh:
   ld hl,(dataaddress)
   ld de,8
   add hl,de
   ld e,(hl)
   add hl,de
   push hl
   ld de,65
   add hl,de
   ld de,score-1
   xor a
   ld b,3

checkloop:
   push bc
   ld b,a
   inc hl
   inc de
   ld c,(hl)
   ld a,(de)
   cp c
   ld a,b
   pop bc
   jr z,checkloop
   jr c,donecheck
   inc a
   push af
      push bc
      ld bc,100
      xor a
      cpdr
      ld bc,22
      sbc hl,bc
      pop bc
      pop af
      ld de,score-1
      djnz checkloop
donecheck:
   pop hl
   inc hl
   inc hl
   inc hl
   or a
   ret z
   dec a
   push af
   jr z,lowestscore
   push hl
   call movesecond
   dec a
   call nz,movefirst
   pop hl
lowestscore:
   pop af
   ld de,63
   add hl,de
   ld c,a
   add a,a
   add a,a
   add a,a
   ld b,a
   add a,a
   add a,b
   sub c
   ld e,a
   ld d,0
   sbc hl,de
   ex de,hl
   push de
   ld hl,score
   ld bc,5
   ldir
   ld hl,1001h
   ld (_penCol),hl
   ld hl,hightext
   call _vputs
   ld hl,0003h
   ld (_curRow),hl
   pop hl
   ld de,-17
   add hl,de
   jp textinput

movefirst:
   push hl
   ld de,23
   add hl,de
   ex de,hl
   pop hl
   ld bc,23
   ldir
   ret

movesecond:
   push hl
   ld de,23
   add hl,de
   push hl
   ld de,23
   add hl,de
   ex de,hl
   pop hl
   ld bc,23
   ldir
   pop hl
   ret

hightext:
   defm 'High Score!  Enter your name',0

powerup:
   ld a,r
   cp 110
   ret c
   ld a,(powertype+1)
   or a
   ret nz
   push bc
   push hl
   push de
   call randomize
   and 00000011b
   ld c,a
   add a,a
   add a,a
   ld b,a
   add a,a
   add a,b
   sub c
   ld c,a
   ld b,0
   ld hl,powerups
   add hl,bc
   ld (powertype),hl
   ld a,(iy+5)
   ld (powerpos),a
   ld a,(iy+4)
   ld (powerpos+1),a
   ld a,(iy+6)
   ld (powerpos+2),a
   pop de
   pop hl
   pop bc
   ret

powerups:
   defb 0,7,1,0
   defb 01111100b
   defb 00111000b
   defb 01111100b
   defb 01111100b
   defb 01111100b
   defb 00111000b
   defb 00010000b

   defb 1,7,1,0
   defb 00011000b
   defb 00100100b
   defb 00011000b
   defb 01111110b
   defb 00111100b
   defb 00011000b
   defb 00011000b

   defb 2,7,1,0
   defb 00111000b
   defb 01000100b
   defb 10010010b
   defb 10111010b
   defb 10010010b
   defb 01000100b
   defb 00111000b

   defb 3,7,1,0
   defb 00010000b
   defb 00111000b
   defb 01001100b
   defb 01011100b
   defb 01111100b
   defb 00111000b
   defb 00010000b

drawpowerups:
   ld a,(powertype+1)
   or a
   ret z
   ld hl,(powerpos)
   ld bc,(screenx)
   sbc hl,bc
   ld a,h
   and 1
   or a
   ret nz
   ld a,l
   ld b,l
   cp 128
   ret nc
   push bc
   and 00000111b
   ld c,a
   srl b
   srl b
   srl b
   ld hl,(powerpos+2)
   ld h,0
   add hl,hl
   add hl,hl
   add hl,hl
   add hl,hl
   ld de,ca00h
   add hl,de
   ld d,e            ;ld d,0
   ld e,b
   add hl,de
   ld de,(powertype)
   ld ix,(powertype)
   inc de
   inc de
   inc de
   inc de
   push ix
   call drawstuff
   pop ix
   pop bc
   ld iy,powerpos-4
   ld a,2
   ld (flag),a
   call collisiondetect

   ret

goodies:
   ld hl,(powertype)
   ld a,(hl)
   dec a
   jr z,givelife
   dec a
   jr z,giveshield
   dec a
   jr z,givepoints
   jr givebomb
givelife:
   ld a,(lives)
   cp L9
   ret z
   inc a
   ld (lives),a
   call puttext
   jr endpower
giveshield:
   ld a,255
   ld (immortality),a
   jr endpower
givepoints:
   ld hl,score+2
   inc (hl)
   call fixnumber
   call puttext
   jr endpower
givebomb:
   ld a,(bombs)
   cp L9
   ret z
   inc a
   ld (bombs),a
   call puttext
endpower:
   xor a
   ld (powertype+1),a
   ret


textinput:
   ld b,16               ;max 16 letters
setcaps:
   xor a
   ld (capflag),a
loopforkeys:
   call alock
   push bc
   xor a
   push hl
   call _putmap
   call _getkey            ;the other one
   pop hl
   pop bc
   or a
   jr z,loopforkeys
   cp kEnter
   jr z,forceout
   push bc
   cp kDel
   jr z,delletter
   cp kLeft
   jr z,delletter
   cp kSpace
   call z,putspace
   add a,57                      ;keys start at 28h
   ld b,a
   ld a,(capflag)
   or a
   ld a,b
   call z,capitalize
   ld (hl),a
   inc hl
   call _putc
   pop bc
   ld a,(capflag)
   dec a
   ld (capflag),a
   djnz loopforkeys

forceout:
   xor a
   ld (hl),a
   res shiftAlpha,(iy+shiftflags)
   res shiftALock,(iy+shiftflags)
   ret

capitalize:
   sub 20h
   ret

putspace:
   ld a,1
   ld (capflag),a
   ld a,Lspace+199         ;Lspace-57 (CAZ won't read it this way)
   ret

delletter:
   ld a,Lspace
   call _putmap
   pop bc
   ld a,(_curCol)
   or a
   jr z,setcaps
   dec a
   ld (_curCol),a
   dec hl
   inc b
   jr loopforkeys




;explosions:





