;
;                                     
;                         
;                               
;                             
;                          
;                            ZKart Wanna-Be V1.1
;                         Programmed By Mike Tryczak
;                           Last edited 04/13/2000
;
;Usgard is the best shell for using and/or programming!
;I recommend it to everyone!
;
;Thanx to the Usgard crew and every one else who helped make TI assembly so
;convenient.  

#INCLUDE USGARD.H               ;LOT OF NIFTY STUFF IN HERE

;VARIABLES
B_LEFT  =TEXT_MEM               ;LEFT BORDER
B_RIGHT =TEXT_MEM+1             ;RIGHT BORDER
K_POS   =TEXT_MEM+2             ;KART POSITION
TOTAL   =TEXT_MEM+3             ;RUNNING TOTAL
TOPS    =TEXT_MEM+5             ;TOP SCORE

.ORG 0
.DB "Chunky "
TITLE:
.DB "ZKart Wanna-Be V1.1",0

        LD A,4                  ;SET PAGE TO 4 FOR FIND_PIXEL
        OUT (5),A               ;
                        
        LD D,0                  ;COUNTING VARIABLE
OPEN_LOOP:
        LD BC,2                 ;WAIT FOR 1/100 OF A SECOND
        #FNCALL DELAY           ;

        PUSH DE                 ;
        CALL CLEARLCD           ;CLEAR THE SCREEN
        POP DE                  ;

        LD B,D                  ;
        LD C,10                 ;DRAW h
        LD HL,&h_DATA           ;
        #FNCALL PSPR_W          ;

        LD A,16                 ;
        ADD A,B                 ;
        LD B,A                  ;DRAW n
        LD HL,&n_DATA           ;
        #FNCALL PSPR_W          ;

        LD A,15                 ;
        ADD A,B                 ;
        LD B,A                  ;DRAW y
        LD HL,&y_DATA           ;
        #FNCALL PSPR_W          ;

        LD A,118                ;
        SUB D                   ;
        LD B,A                  ;DRAW k
        LD HL,&k_DATA           ;
        #FNCALL PSPR_W          ;

        LD A,B                  ;
        LD B,16                 ;
        SUB B                   ;DRAW u
        LD B,A                  ;
        LD HL,&u_DATA           ;
        #FNCALL PSPR_W          ;

        LD A,B                  ;
        LD B,16                 ;
        SUB B                   ;DRAW C
        LD B,A                  ;
        LD HL,&C_DATA           ;
        #FNCALL PSPR_W          ;

        INC D                   ;
        LD A,D                  ;MAKE 'EM SCROLL TOGETHER
        CP 48                   ;
        JR NZ,OPEN_LOOP         ;

        LD BC,200               ;WAIT FOR A SECOND
        #FNCALL DELAY           ;

        LD HL,$0103             ;
        LD (CURSOR_ROW),HL      ;DISPLAY TITLE
        LD HL,&TITLE            ;
        CALL D_ZT_STR           ;

        LD HL,$0304             ;
        LD (CURSOR_ROW),HL      ;DISPLAY MY NAME
        LD HL,&MY_NAME          ;           
        CALL D_ZT_STR           ;

        LD HL,$0006             ;
        LD (CURSOR_ROW),HL      ;
        LD HL,&HI_STRING        ;
        CALL D_ZT_STR           ;
                                ;
        LD HL,$1006             ;DISPLAY HI SCORE
        LD (CURSOR_ROW),HL      ;
        LD IX,&HI_SCORE         ;
        LD H,(IX+0)             ;
        LD L,(IX+1)             ;
        LD (TOPS),HL            ;
        CALL D_HL_DECI          ;

        CALL &PAUSE             ;
        BIT EXIT,B              ;WAIT FOR CERTAIN KEYS
        RET Z                   ;
        CALL CLEARLCD           ;

        LD A,255                ;
        LD IX,$FC6F             ;
        LD B,5                  ;
FILL:                           ;
        INC IX                  ;
        LD (IX+0),A             ;
        LD (IX+11),A            ;FILL EDGE OF SCREEN FOR ROAD APPEARANCE
        DJNZ FILL               ;
                                ;
        LD BC,896               ;
        LD HL,$FC70             ;
        LD DE,$FC80             ;
        LDIR                    ;

        LD A,39                 ;
        LD (B_LEFT),A           ;
        LD A,88                 ;BORDER AND KART SETUP
        LD (B_RIGHT),A          ;
        LD A,63                 ;
        LD (K_POS),A            ;

        LD HL,$0002             ;
        LD (CURSOR_X),HL        ;
        LD HL,&HI_STRING        ;
        CALL D_ZM_STR           ;
                                ;DISPLAY HI SCORE
        LD HL,$0034             ;
        LD (CURSOR_X),HL        ;
        LD HL,(TOPS)            ;
        CALL DM_HL_DECI         ;

        LD HL,$0055             ;
        LD (CURSOR_X),HL        ;DISPLAY "SCORE:"
        LD HL,&SCORE_STRING     ;
        CALL D_ZM_STR           ;

KEY_LOOP:
        LD HL,$006B             ;
        LD (CURSOR_X),HL        ;DISPLAY SCORE
        LD HL,(TOTAL)           ;
        CALL DM_HL_DECI         ;

        LD HL,(TOTAL)           ;
        INC HL                  ;
        LD (TOTAL),HL           ;
        LD A,H                  ;
        CP 28                   ;DETERMINE IF TRACK SHOULD BE SMALLER
        JR NC,STAY              ;
        LD A,L                  ;
        OR A                    ;
        JR NZ,STAY              ;

        LD A,(B_RIGHT)          ;
        DEC A                   ;
        LD (B_RIGHT),A          ;
                                ;
        LD A,(B_RIGHT)          ;
        LD B,A                  ;MAKE TRACK SMALLER
        LD C,56                 ;
        CALL FIND_PIXEL         ;
        LD DE,VIDEO_MEM         ;
        ADD HL,DE               ;
        XOR (HL)                ;
        LD (HL),A               ;
STAY:
        CALL OTH_ARROW          ;CHECK FOR KEYS PRESSED
        LD B,A                  ;

        BIT F1,B                ;PAUSE (AND SHUTDOWN) IF F1 IS PRESSED
        CALL Z,&PAUSE           ;

        BIT MORE,B              ;PAUSE IF MORE IS PRESSED
        CALL Z,&PAUSE           ;

        BIT EXIT,B              ;LEAVE PROGRAM IF EXIT KEY IS PRESSED
        CALL Z,&END             ;
        
        LD HL,(TOTAL)           ;
        LD A,L                  ;ONLY MOVE KART EVERY OTHER TIME
        AND 1                   ;FOR ADDED HANDLING
        JR NZ,NOT_LEFT          ;

        BIT RIGHT,B             ;
        JR NZ,NOT_RIGHT         ;
        LD A,(K_POS)            ;IF RIGHT ARROW PRESSED, MOVE CAR RIGHT
        INC A                   ;
        LD (K_POS),A            ;
NOT_RIGHT:                      ;

        BIT LEFT,B              ;
        JR NZ,NOT_LEFT          ;
        LD A,(K_POS)            ;IF LEFT ARROW PRESSED, MOVE CAR LEFT
        DEC A                   ;
        LD (K_POS),A            ;
NOT_LEFT:                       ;

        CALL &START             ;START MAIN PROGRAM
        JR KEY_LOOP             ;LOOP INDEFINATELY

START:
        LD A,R                  ;
        ADD A,A                 ;
        BIT 2,A                 ;
        JR NZ,SKIP_LARGE        ;
                                ;
        ADD A,A                 ;
        ADD A,A                 ;
SKIP_LARGE:                     ;A=RANDOM NUMBER FROM 0 TO 1
                                ;
        LD HL,0                 ;
        LD D,H                  ;
        LD E,A                  ;
        ADD HL,DE               ;
        ADD HL,DE               ;
        LD A,H                  ;

        OR A                    ;
        JR Z,SHIFT_LEFT         ;IF A=0 OR
                                ;RIGHT BORDER IS ON THE EDGE OF THE SCREEN
        LD A,(B_RIGHT)          ;SHIFT LEFT
        CP 127                  ;
        JR Z,SHIFT_LEFT         ;
                        
SHIFT_RIGHT:                    ;
        LD A,(B_LEFT)           ;
        INC A                   ;
        LD (B_LEFT),A           ;
                                ;
        LD A,(B_LEFT)           ;
        LD B,A                  ;
        LD C,56                 ;
        CALL FIND_PIXEL         ;
        LD DE,VIDEO_MEM         ;
        ADD HL,DE               ;
        XOR (HL)                ;
        LD (HL),A               ;SHIFT ROAD TO THE RIGHT
                                ;
        LD A,(B_RIGHT)          ;
        LD B,A                  ;
        CALL FIND_PIXEL         ;
        ADD HL,DE               ;
        XOR (HL)                ;
        LD (HL),A               ;
                                ;
        LD A,(B_RIGHT)          ;
        INC A                   ;
        LD (B_RIGHT),A          ;
        JR SHIFT_DONE           ;

SHIFT_LEFT:                     ;
        LD A,(B_LEFT)           ;IF LEFT BORDER IS ON THE EDGE OF THE SCREEN
        CP 0                    ;SHIFT RIGHT
        JR Z,SHIFT_RIGHT        ;
                                
        LD A,(B_RIGHT)          ;
        DEC A                   ;
        LD (B_RIGHT),A          ;
                                ;
        LD A,(B_RIGHT)          ;
        LD B,A                  ;
        LD C,56                 ;
        CALL FIND_PIXEL         ;
        LD DE,VIDEO_MEM         ;
        ADD HL,DE               ;
        XOR (HL)                ;
        LD (HL),A               ;SHIFT ROAD TO THE LEFT
                                ;
        LD A,(B_LEFT)           ;
        LD B,A                  ;
        CALL FIND_PIXEL         ;
        ADD HL,DE               ;
        XOR (HL)                ;
        LD (HL),A               ;
                                ;
        LD A,(B_LEFT)           ;
        DEC A                   ;
        LD (B_LEFT),A           ;
                                
SHIFT_DONE:                     ;
        LD BC,896               ;TRANSFER (JUST ABOUT) EVERY SCREEN LOCATION
        LD HL,$FFEF             ;TO THE ONE BELOW IT 
        LD DE,$FFFF             ;
        LDDR                    ;

        LD A,(K_POS)            ;
        LD B,A                  ;
        LD C,61                 ;DRAW KART
        LD HL,&KART_DATA        ;
        #FNCALL PSPR_W          ;

        LD A,(K_POS)            ;
        LD B,A                  ;
        LD C,1                  ;
        CALL FIND_PIXEL         ;CHECK FOR COLLISION TO THE LEFT
        LD DE,VIDEO_MEM         ;
        ADD HL,DE               ;
        AND (HL)                ;
        JP NZ,&END              ;

        LD A,(K_POS)            ;
        ADD A,4                 ;
        LD B,A                  ;
        CALL FIND_PIXEL         ;CHECK FOR COLLISION TO THE RIGHT
        ADD HL,DE               ;
        AND (HL)                ;
        JP NZ,&END              ;

        RET                     ;RETURN TO KEY LOOP

END:                            ;
        LD HL,(TOPS)            ;
        LD DE,(TOTAL)           ;CHECK FOR HIGH SCORE
        DEC DE                  ;
        CALL CP_HL_DE           ;
        CALL M,&TOP_SCORE       ;

        LD HL,$0604             ;
        LD (CURSOR_ROW),HL      ;IF NOT, DISPLAY "GAME OVER"
        LD HL,&GAME_OVER        ;
        CALL D_ZT_STR           ;

        LD BC,50                ;
        #FNCALL DELAY           ;EXIT PROGRAM
        CALL &PAUSE             ;
        CALL OTH_EXIT           ;

TOP_SCORE:                      ;
        LD HL,$0303             ;
        LD (CURSOR_ROW),HL      ;DISPLAY "NEW HIGH SCORE!"
        LD HL,&NEW_HIGH         ;
        CALL D_ZT_STR           ;

        LD HL,$0105             ;
        LD (CURSOR_ROW),HL      ;DISPLAY "ENTER INITIALS: "
        LD HL,&INITIALS         ;
        CALL D_ZT_STR           ;

        LD B,3                  ;
        LD IX,&HI_STRING        ;SETUP FOR ENTERING INTITIALS
        LD D,'A'                ;

INIT_LOOP:                      ;
        LD A,D                  ;
        CALL TX_CHARPUT         ;DISPLAY CURRENT LETTER
        LD A,(CURSOR_COL)       ;
        DEC A                   ;
        LD (CURSOR_COL),A       ;

        CALL GET_KEY            ;STORE KEY PRESS
        LD C,A                  ;

        CP K_UP                 ;
        JR NZ,NOT_UP            ;
        INC D                   ;
        LD A,'Z'+1              ;IF UP IS PRESSED INCREASE LETTER
        CP D                    ;SET TO 'A' IF TOO LARGE
        JR NZ,INIT_LOOP         ;
        LD D,'A'                ;
NOT_UP:                         ;

        LD A,C                  ;
        CP K_DOWN               ;
        JR NZ,NOT_DOWN          ;
        DEC D                   ;IF DOWN IS PRESSED DECREASE LETTER
        LD A,'A'-1              ;SET TO 'Z' IF TOO SMALL
        CP D                    ;
        JR NZ,INIT_LOOP         ;
        LD D,'Z'                ;
NOT_DOWN:                       ;

        LD A,C                  ;
        CP K_SECOND             ;
        JR NZ,INIT_LOOP         ;
        LD A,D                  ;
        LD (IX+10),A            ;IF SECOND IS PRESSED STORE INITIAL IN MEMORY
        INC IX                  ;LOOP FOR THREE INITIALS
        LD A,(CURSOR_COL)       ;
        INC A                   ;
        LD (CURSOR_COL),A       ;
        DJNZ INIT_LOOP          ;

        LD IX,&HI_SCORE         ;
        LD HL,(TOTAL)           ;
        DEC HL                  ;STORE SCORE IN MEMORY
        LD (IX+0),H             ;
        LD (IX+1),L             ;

        CALL OTH_EXIT           ;EXIT PROGRAM

PAUSE:                          ;
        CALL OTH_ARROW          ;CHECK FOR KEYS PRESSED
        LD B,A                  ;

        BIT EXIT,B              ;RETURN (AND EXIT) IF EXIT IS PRESSED
        RET Z                   ;

        BIT SECOND,B            ;RETURN IF SECOND IS PRESSED
        RET Z                   ;

        BIT F1,B                ;SHUTDOWN IF F1 IS PRESSED
        CALL Z,OTH_SHUTDOWN     ;

        JR PAUSE                ;LOOP INDEFINATELY

;STRINGS
MY_NAME:
        .DB "By Mike Tryczak",0
SCORE_STRING:
        .DB "Score:",0
HI_STRING:
        .DB "Hi Score: MST -",0
HI_SCORE:
        .DW $0000
GAME_OVER:
        .DB "Game Over",0
NEW_HIGH:
        .DB "New High Score!",0
INITIALS:
        .DB "Enter Initials: ",0

;SPRITE DATA
KART_DATA:
        .DB 5,3
        .DB %00100000
        .DB %01110000
        .DB %11111000
C_DATA:
        .DB 7,9
        .DB %01111100
        .DB %11000110
        .DB %10111010
        .DB %10101110
        .DB %10100000
        .DB %10101110
        .DB %10111010
        .DB %11000110
        .DB %01111100
h_DATA:
        .DB 7,9
        .DB %11100000
        .DB %10100000
        .DB %10111100
        .DB %10100110
        .DB %10011010
        .DB %10111010
        .DB %10101010
        .DB %10101010
        .DB %11101110
u_DATA:
        .DB 7,9
        .DB %00000000
        .DB %00000000
        .DB %11101110
        .DB %10101010
        .DB %10101010
        .DB %10111010
        .DB %10110010
        .DB %11001010
        .DB %01111110
n_DATA:
        .DB 7,9
        .DB %00000000
        .DB %00000000
        .DB %11111100
        .DB %10100110
        .DB %10011010
        .DB %10111010
        .DB %10101010
        .DB %10101010
        .DB %11101110
k_DATA:
        .DB 6,9
        .DB %11100000
        .DB %10100000
        .DB %10111100
        .DB %10110100
        .DB %10101100
        .DB %10011000
        .DB %10101100
        .DB %10110100
        .DB %11111100
y_DATA:
        .DB 7,9
        .DB %00000000
        .DB %00000000
        .DB %11101110
        .DB %10101010
        .DB %10111010
        .DB %11000010
        .DB %01111010
        .DB %01000110
        .DB %01111100

.END
