#include "asm86.h"
#Include "ti86abs.inc"
#Include "ti86asm.inc"
#include "ti86ops.inc"
#include "ti86math.inc"

;cymbol equates
PlusMinus       = $D750         ;display +/- at current menu text position
ReduceOP1       = $D753         ;reduce sqrt(OP1) to OP4 and OP6
PrintReal       = $D756         ;display in menu text real number OP1
                                ;if A and %10000000 sign always shown
                                ;if A and %01000000 justify center or right
                                ;if A and %00100000 justify right
PrintString     = $D759         ;display menu text HL, possibly justified
                                ;if A and %10000000 sign always shown
                                ;if A and %01000000 justify center or right
                                ;if A and %00100000 justify right
AllowBreak      = $D75C         ;include this command in the middle of a long
                                ;routine. it will allow the user to press ON
                                ;to break out of the calculation.

;rom equates
#define pop_op(x) call ( $47BB - ( x * 4 ) )    ;pops the OP given by x
#define push_op(x) call ( $4817 - ( x * 4 ) )   ;pushes the OP given by x
#define exec_pg2(x) ld a,x\ call $4B1B          ;execs x on ROM page 2
;The first argument goes in OP1, push the rest onto the OP stack
;know x values:
; $1F - greatest common factor of OP1 and first op on the stack

#define add_op1_1 call $45EB                    ;OP1 ++
#define cp_op1_op2 call $41FB                   ;OP1 == OP2?
#define cp_op1_0 call $449B                     ;OP1 == 0?
#define neg_op1 call $5494                      ;OP1 = -OP1
#define int_op1 call $5468                      ;OP1 = int(OP1)
#define sub_op1_1 call $5470                    ;OP1 --
#define add_op1_op2 call $5478                  ;OP1 += OP2
#define sub_op1_op2 call $5474                  ;OP1 -= OP2
#define mlt_op1_half call $5484                 ;OP1 *= 0.5
#define mlt_op1_op1 call $5488                  ;OP1 *= OP1
#define mlt_op1_op2 call $548C                  ;OP1 *= OP2
#define fpart_op1 call $549C                    ;OP1 = fpart(OP1)
#define oneover_op1 call $54A4                  ;OP1 = 1/OP1
#define div_op1_op2 call $54A8                  ;OP1 /= OP2
#define sqrt_op1 call $54AC                     ;OP1 = sqrt(OP1)
#define ln_op1 call $54C4                       ;OP1 = ln(OP1)
#define log_op1 call $54CC                      ;OP1 = log(OP1)
#define e_raise_op1 call $54D4                  ;OP1 = e^OP1
#define ten_raise_op1 call $54D8                ;OP1 = 10^OP1
#define sin_op1 call $54E0                      ;OP1 = sin(OP1)
#define cos_op1 call $54E4                      ;OP1 = cos(OP1)
#define tan_op1 call $54E8                      ;OP1 = tan(OP1)
#define asin_op1 call $5514                     ;OP1 = asin(OP1)
#define acos_op1 call $5508                     ;OP1 = acos(OP1)
#define atan_op1 call $5510                     ;OP1 = atan(OP1)
#define op1_raise_op2 call $5538                ;OP1 = OP1^OP2

