#include "cymbol.h"
#define FP_ZERO $00,$00,$FC,$00,$00,$00,$00,$00,$00,$00

.org $8FFE
.dw $CB07               ;identifier

; Quardratic Formula Applet
; A*x^2+B*x+C=0, x=?
        .db 3                   ;number of inputs
        .db 3                   ;selected input
        .dw applet_data         ;title bar for this applet, followed by a
                                ;routine to be run upon applet change
        ;1st input (A)
        .db %00000000           ;flags
        .dw $1100               ;x,y coordinates
input_1:
        .db FP_ZERO             ;default value
        .db 'x',$12,0           ;any suffixes
        ;2nd input (B)
        .db %10000000           ;flags - always show sign
        .dw $0000               ;x,y coordinates - same
input_2:
        .db FP_ZERO             ;default value
        .db 'x',0               ;any suffixes
        ;3rd input (C)
        .db %10000000           ;flags - always show sign
        .dw $0000               ;x,y coordinates - same
input_3:
        .db FP_ZERO             ;default value
        .db "=0",0              ;any suffixes
applet_data:
        .db "  Quadratic Formula  ",0
        ld (iy+$26),0
        ld hl,input_2
        rst 20h
        int_op1
        ld de,input_2
        call _MOVFROP1
        ld hl,input_3
        rst 20h
        call _INTGR
        ld de,input_3
        call _MOVFROP1
        ld hl,input_1
        rst 20h                 ;copy input-A into OP1
        int_op1
        ld de,input_1
        call _MOVFROP1
        call $449B              ;check if 0
        ret z                   ;if so, we can't divide by 0
        ld hl,$1808
        ld (_penCol),hl
        ld hl,input_2
        rst 20h                 ;copy input-B into OP1
        call $449B              ;check if 0 and save result
        jr z,bnotzero
        set 3,(iy+$26)
bnotzero:
        neg_op1
        push_op(1)
        ld hl,input_3
        rst 20h                 ;copy input-C into OP1
        ld hl,input_2
        rst 20h                 ;copy input-B into OP1
        call _FPSQUARE          ;OP1=(input-B)^2
        push_op(1)
        call _OP2SET4           ;OP2 = 4
        ld hl,_OP2              ;OP2 = -4
        set 7,(hl)
        ld hl,input_1
        rst 20h                 ;copy input-A into OP1
        call _FPMULT            ;- 4 * A
        ld hl,input_3
        call _MOV10TOOP2        ;copy input-C into OP2
        call _FPMULT            ;- 4 * A * C
        pop_op(2)
        call _FPADD             ;B ^ 2 - 4 * A * C
        call $449B              ;check if 0
        jr z,radicalnot0
        set 2,(iy+$26)
radicalnot0:
        jr nz,quad_form_b
        bit 3,(iy+$26)
        jp z,quad_form_c
quad_form_b:
        ld hl,_OP1              ;test if B ^ 2 - 4 * A * C
        bit 7,(hl)
        jr z,quad_form_dnot
        set 1,(iy+$26)
quad_form_dnot:
        res 7,(hl)              ;make + for sqrt function

        call $4813              ;push OP1
        ld hl,input_1
        rst 20h                 ;copy input-A into OP1
        call _OP2SET2
        call _FPMULT            ;2 * A
        pop_op(2)
        push_op(1)
                                ;OP2 = abs ( B ^ 2 - 4 * A * C )
        call _OP2TOOP1
        call ReduceOP1
        call _OP4TOOP1
        call _OP6TOOP1
        call _OP2SET1
        cp_op1_op2
        jr z,quad_form_anot
        set 0,(iy+$26)
quad_form_anot:
        pop_op(2)          ;now we have OP2 = 2 * A
        pop_op(1)          ;now we have OP1 = - B
        push_op(6)
        ld hl,_OP2
        bit 7,(hl)              ;if 2 * A is negative then
        call nz,$5490           ;negate both OP1 and OP2
        push_op(1)
        push_op(2)
        push_op(2)
                                ;now we have GCD of (-B) and (sqrt)
        ld hl,_OP1
        res 7,(hl)
        exec_pg2($1F)
                                ;now we have GCD of (-B) (sqrt) and (2 * A)

        push_op(4)
        exec_pg2($1F)           ;gcd, param are OP1 and 1st op on stack
        call _OP1TOOP2
        call _OP4TOOP1
        push_op(2)
        call _FPDIV
        call _OP2SET2
        cp_op1_op2
        rl (iy+$26)

        ;OP1 = outside rad
        ;stack = divisor, 2 * A, - B, inside rad

        pop_op(2)
        pop_op(5)
        pop_op(3)
        pop_op(4)
        push_op(5)
        push_op(2)
        push_op(4)
        push_op(1)
        call _OP3TOOP1
        call _FPDIV
        bit 4,(iy+$26)
        jr z,quad_form_e
        xor a
        call PrintReal          ;finally, we show -B!
quad_form_e:
        pop_op(1)
        bit 3,(iy+$26)
        jr z,quad_form_f
        call PlusMinus
        bit 1,(iy+$26)
        jr z,quad_form_y
        bit 0,(iy+$26)
        jr nz,quad_form_f
        jr quad_form_z
quad_form_y:
        bit 2,(iy+$26)
        jr nz,quad_form_f
quad_form_z:
        xor a
        call PrintReal          ;outside radical

quad_form_f:
        bit 2,(iy+$26)
        jr z,quad_form_d
        ld a,'i'
        call _vputmap
quad_form_d:
        pop_op(1)
        bit 1,(iy+$26)
        jr z,quad_form_g
        ld a,$10
        call _vputmap
        xor a
        call PrintReal          ;inside radical
quad_form_g:
        pop_op(2)
        pop_op(1)
        call _FPDIV
        call _OP2SET1
        cp_op1_op2
        jr z,quad_no_frac
        ld bc,$0820
        ld a,(_penCol)
        sub 2
        ld d,a
        push af
        ld e,c
        ld h,1
        call _iline
        pop af
        add a,8
        srl a
        ld h,$20
        ld l,a
        ld (_penCol),hl
        ld a,$40                ;centered text
        call PrintReal          ;on the bottom
        ld hl,$1C00
        ld (_penCol),hl
        jr quad_some_frac

quad_form_c:
        call $47B7              ;pop OP1
        ld a,'0'
        call _vputmap
quad_no_frac:
        ld hl,$1800
        ld (_penCol),hl
quad_some_frac:
        ld a,'x'
        call _vputmap
        ld a,'='
        jp _vputmap

.end
