;------------------------------------------------------------------------
;By John Kempen
;
;If you use source from this program, please give me credit.
;
;Thanks to Clem for info on installing custom fonts from Font
;
;Please e-mail improvements or bug reports to:
;
;saywhat97@hotmail.com
;
;------------------------------------------------------------------------



#include "asm86.h"
#include "ti86asm.inc"
#include "ti86abs.inc"
morefree = _asm_exec_ram+8000
menurow = morefree+10
rowl = morefree+11
r = morefree+12
mr = morefree+16
symlocate = morefree+20
xlevelsnum = morefree+22
xtableloc = morefree+23
chrleft = morefree+25
drawingmenu = morefree+26
regmenu = morefree+27
curmenu = morefree+28
next = morefree+30


.org _asm_exec_ram
	nop
	jp start
	.dw $0000
	.dw name
installed_fixed			;(findsym returned)+12
	.db 0,"fxedname",0
installed_var			;(findsym returned)+22
	.db 0,"var.name",0
start
	call $49DC
	set 3,(iy+8) 	
	res 0,(iy+18)
	res 2,(iy+13)
Firstmenu
	ld a,(curversion)
	ld (vercheck),a
	ld hl,menu1
	ld (curmenu),hl
	call _clrScrn
	call Bydraw
	jp Selectlevs


startselvarvar
	ld hl,Installfontvar
	ld (vargoto),hl

	ld hl,variablebytes
	ld (checkbytes),hl
	ld hl,vartablemenu
	ld (curmenu),hl
	call _clrScrn
	call FindVariables
	call Bydraw
	jp Selectlevs

startselvarfxd
	ld hl,Installfont
	ld (vargoto),hl

	ld hl,fixedbyts
	ld (checkbytes),hl
	ld hl,vartablemenu
	ld (curmenu),hl
	call _clrScrn
	call FindVariables
	call Bydraw
	jp Selectlevs
End
	ld a,0
	ld (_curRow),a
	call _clrScrn
	set 0,(iy+18)
	set 2,(iy+13)
	res 3,(iy+8)
	ld a,$3c
	out (0),a
	ld a,$20
	ld ($c011),a
	ret



write_fixed_installed
	ld hl,Filename
	ld de,installed_fixed
	ld bc,10
	ldir
	ld hl,cstnfont-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	jp write_end
	ret


write_var_installed
	ld hl,Filename
	ld de,installed_var
	ld bc,10
	ldir
	ld hl,cstnfont-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
write_end
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_DEST_ADDR
	ld hl,10
	ld a,0
	call _SET_MM_NUM_BYTES
	ld hl,Filename
	ld a,0
	call _SET_ABS_SRC_ADDR
	call _mm_ldir
	ret



about
	call _clrScrn
	call Bydraw

	ld a,0
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	ld hl,bytext
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,report
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,5
	ld (_curRow),a
	ld hl,email
	call _puts


	call _getkey
	jp start


Help
	call _clrScrn
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,nametext
	call _puts
	ld a,0
	call Invbar
	ld hl,textfiledata
	ld de,$c068
	ld bc,13
	ldir
	ld hl,variable-1
	rst 20h
	rst 10h
	jr c,noHelp
	set 2,(iy+$1F)
	ld hl,variable-1
	rst 20h
	call $5730	;_exec_assembly
	jp start
noHelp
	ld a,1
	ld (_curRow),a
	ld (_curCol),a
	ld hl,nohelpviewer
	call _puts
	call _getkey
	jp start

Re_Installfontvar_1
	ld hl,Filename
	ld de,Filenamebckup
	ld bc,10
	ldir
	call Re_Installfontvar_1a
	ld de,Filename
	ld hl,Filenamebckup
	ld bc,10
	ldir
	ret
Re_Installfontvar_1a
	ld hl,installed_var
	ld de,Filename
	ld bc,10
	ldir
	ld a,(Filename)
	cp 0
	ret z
	call findtotalchars
	ld a,(totalchars)
	cp 0
	ret z
	call Installfontvar_1
	ret

Installfontvar
	call findtotalchars
	ld a,(totalchars)
	cp 0
	jp z,start
	call Installfontvar_1
	jp start

Installfontvar_1
	ld hl,Filename-1
	rst 20h
	rst 10h
	ret c
	ld a,b
	ex de,hl


	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/


	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl




	ld ($d2f0),a
	ld ($d2f0+1),hl



	set 1,(iy+35)
	call write_var_installed
	ret


Re_Installfontfixed_1
	ld a,(fixedorvar)
	cp 1
	jp z,Re_Installfontvar_1


	ld hl,Filename
	ld de,Filenamebckup
	ld bc,10
	ldir
	call Re_Installfontfixed_1a
	ld hl,Filenamebckup
	ld de,Filename
	ld bc,10
	ldir
	ret

Re_Installfontfixed_1a
	ld hl,installed_fixed
	ld de,Filename
	ld bc,10
	ldir
	ld a,(Filename)
	cp 0
	ret z
	call findtotalchars
	ld a,(totalchars)
	cp 0
	ret z
	call Installfont_1
	ret

Installfont
	call findtotalchars
	ld a,(totalchars)
	cp 0
	jp z,start
	call Installfont_1
	jp start

Installfont_1
	ld hl,Filename-1
	rst 20h
	rst 10h
	ret c
	ld a,b
	ex de,hl


	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/

	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl




	ld ($d2ed),a
	ld ($d2ed+1),hl


	set 0,(iy+35)
	call write_fixed_installed
	ret
Uninstall:
	res 0,(iy+35)
	ld a,0
	ld hl,0
	ld ($d2ed),a
	ld ($d2ed+1),hl
	ld a,0
	ld (Filename),a
	call write_fixed_installed
	jp start

uninstallvar
	res 1,(iy+35)
	ld a,0
	ld hl,0
	ld ($d2f0),a
	ld ($d2f0+1),hl
	ld a,0
	ld (Filename),a
	call write_var_installed
	jp start

selectedlevjp
	ld hl,(curmenu)
	ld de,7
	add hl,de
	call $4010
	jp (hl)
Menuback
	ld hl,(curmenu)
	ld de,5
	add hl,de
	call $4010
	jp (hl)
mEnd
	ld hl,(curmenu)
	inc hl
	inc hl
	inc hl
	call $4010
	jp (hl)
Selectlevs
	ld hl,(curmenu)
	ld a,(hl)
	ld c,a
	ld (regmenu),a
	inc hl
	ld a,(hl)
	ld (menuminrow),a
	inc hl
	ld a,(hl)
	ld (menumaxrow),a
	call drawmenustart
	ld a,(menuminrow)
	ld (r),a
	ld (rowl),a
	ld a,1
	ld (mr),a
	call menudrawchoicenum
	call choiceauthordisp
	jp Selectlevdraw
selectlevloop
	call _getkey
	cp kF2
	jp z,Menuback
	cp kEnter
	jp z,endmenu
	cp kExit
	jp z,mEnd
	cp kUp
	jr z,Selectlevup
	cp kDown
	jr z,Selectlevdown
	jr selectlevloop
Selectlevup
	ld a,(mr)
	cp 1
	jr z,Selectlevdraw
	dec a
	ld (mr),a
	ld a,(menuminrow)
	ld b,a
	ld a,(r)
	cp b
	jr z,selectscrlup
	dec a
	ld (r),a
	jr Selectlevdraw
Selectlevdown
	ld a,(xlevelsnum)
	ld b,a
	ld a,(mr)
	cp b
	jr z,Selectlevdraw
	inc a
	ld (mr),a
	ld a,(menumaxrow)
	ld b,a
	ld a,(r)
	cp b
	jr z,selectscrldown
	inc a
	ld (r),a
	jr Selectlevdraw
selectscrldown
	ld a,(menumaxrow)
	dec a
	ld (rowl),a
	call menuscrolldown
	jr Selectlevdraw
selectscrlup
	ld a,(menuminrow)
	inc a
	ld (rowl),a
	call menuscrollup
	jr Selectlevdraw
Selectlevdraw
	call Putvarinfo
	call drawoutofnum
	call choiceauthordisp
	jp selectlevloop
drawoutofnum
	set 3,(iy+5)
	ld a,0
	ld (_curRow),a
	ld a,12
	ld (_curCol),a
	ld a,(mr)
	ld l,a
	ld h,0
	ld a,0
	call $4a33
	res 3,(iy+5)
	ret
Putvarinfo
	call getselectedtext
	ld a,(drawingmenu)
	cp 1
	jr z,nobardraw
	ld a,(rowl)
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld b,21
drawlastselectedloop
	push bc
	call findundercur
	call _putmap
	ld a,(_curCol)
	inc a
	ld (_curCol),a
	pop bc
	djnz drawlastselectedloop
	ld a,(r)
	call Invbar
nobardraw
	ld a,(r)
	ld (rowl),a
	ret
selectlevloopend								; loads selected world into savelev for saved games
	ret
getselectedtext
	ld hl,PTZWRLD
	ld a,$20
	ld (hl),a
	ld de,PTZWRLD+1
	ld bc,20
	ldir
	ld a,(regmenu)
	cp 1
	jp z,Selectlevhlcalc2
	cp 2
	jp z,Selectlevhlcalc2
	ld a,(mr)
	ld hl,xlevelstable-9
	ld de,9
Selectlevhlcalc
	or a
	add hl,de
	dec a
	cp 0
	jr nz,Selectlevhlcalc
	ld de,PTZWRLD
	ld bc,9
	ldir
	ld hl,PTZWRLD-1
	rst 20h
	rst 10h
	jr c,notafile
	ret
notafile
	pop hl
	jp Selectlevup
Selectlevhlcalc2
	ld hl,(curmenu)
	ld de,7
	or a
	add hl,de
	ld a,(hl)
	inc hl
	ld (xlevelsnum),a
	ld a,(mr)
	ld de,4
	or a
	sbc hl,de
Selectlevhlcalc2loop
	or a
	add hl,de
	dec a
	cp 0
	jr nz,Selectlevhlcalc2loop
	call $4010
	ld de,PTZWRLD+1
	ld b,20
Selectlevhlcalcloopend
	ld a,(hl)
	ex de,hl
	cp 0
	ret z
	ld (hl),a
	ex de,hl
	inc de
	inc hl
	djnz Selectlevhlcalcloopend
	ret
menuscrollup
	ld a,1
	ld (drawingmenu),a
	ld a,(menuminrow)
	ld (menurow),a
	call Drawmenusloop
	ld a,(menuminrow)
	ld (r),a
	ld a,(menuminrow)	
	ld b,a
	ld a,(menumaxrow)
	sub b
	ld b,a
	inc b
	ld a,(mr)
	sub b
	ld (mr),a
	ret
menuscrolldown
	ld a,1
	ld (drawingmenu),a
	ld a,(menuminrow)
	ld (menurow),a
	ld (r),a
	ld b,a
	ld a,(menumaxrow)
	sub b
	ld b,a
	ld a,(mr)
	sub b
	ld (mr),a
	call Drawmenusloop
	ld a,(menumaxrow)
	ld (r),a
	ld a,(mr)
	dec a
	ld (mr),a
	ret
drawmenustart
	ld a,1
	ld (drawingmenu),a
	ld (mr),a
	ld a,(menuminrow)
	ld (menurow),a
	ld (r),a
Drawmenusloop
	call Putvarinfo
	ld a,(r)
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld b,21
drawspaceloop
	push bc
	ld a,$20
	call _putmap
	ld a,(_curCol)
	inc a
	ld (_curCol),a
	pop bc
	djnz drawspaceloop
	ld a,(r)
	ld (_curRow),a
	ld a,1
	ld (_curCol),a
	ld hl,PTZWRLD+1								; displays world name
	call _puts
	ld a,(r)
	inc a
	ld (r),a
	ld a,(mr)
	inc a
	ld (mr),a
	ld a,(menumaxrow)
	inc a
	ld c,a
	ld a,(xlevelsnum)
	inc a
	ld b,a
	ld a,(menurow)
	inc a
	ld (menurow),a
	cp b
	jr z,Drawmenusloopend
	cp c
	jr nz,Drawmenusloop
Drawmenusloopend
	ld a,0
	ld (drawingmenu),a
	ret
endmenu
	ld a,(regmenu)
	cp 0
	jp nz,endmenua
	ld hl,PTZWRLD
	ld de,Filename
	ld bc,9
	ldir
	jp selectedlevjp
endmenua
	ld hl,(curmenu)
	ld de,10
	add hl,de
	ld a,(mr)
	ld de,4
	or a
	sbc hl,de
menuendhlcalc2loop
	or a
	add hl,de
	dec a
	cp 0
	jr nz,menuendhlcalc2loop
	ld a,(regmenu)
	cp 2
	jr z,menuend2
menuend1
	call $4010
	jp (hl)
menuend2
	call $4010
	ld (curmenu),hl
	jp Selectlevs




	
FindVariables
	call _clrScrn
	ld hl,_textShadow
	ld de,xlevelstable
	ld bc,162
	ldir
	call $47f3									; load RAM page 7
	ld a,$bf
	ld h,a
	ld a,$ff
	ld l,a
	ld (symlocate),hl
	ld a,0
	ld (xlevelsnum),a
Symsearch
	call $47f3									; load RAM page 7
	ld hl,(symlocate)
	ld de,($d29b)
	or a
	sbc hl,de
	jp z,Findlevsdone	

	ld hl,(symlocate)
	ld a,(hl)
	cp $0c
	jr z,Stringfound	

Symsearchnot
	call $47f3									; load RAM page 7
	ld hl,(symlocate)
	ld de,5
	or a
	sbc hl,de
	ld a,0
	ld d,a
	ld a,(hl)
	inc a
	ld e,a
	or a
	sbc hl,de
	ld (symlocate),hl
	jr Symsearch
Stringfound
	ld hl,(symlocate)
	ld de,4
	or a
	sbc hl,de
	ld a,(hl)
	cp 0
	jr nz,Symsearchnot
	ld hl,(symlocate)
	dec hl
	ld a,(hl)
	ld e,a
	dec hl
	ld a,(hl)
	ld d,a
	dec hl
	ld a,(hl)
	ld b,a
	ld h,d
	ld l,e
	ld a,b
checkstring
	call $4637												; ahl+1
	call $4637												; ahl+1
	ld (leva),a
	ld (levhl),hl
	ld a,0
	ld (checkbytenum),a
checkstringloop
	ld a,(leva)
	ld hl,(levhl)
	call $46c3												; a,(ahl)
	ld b,a
	ld hl,checkbytes


	push af
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	pop af


	ld a,(checkbytenum)
	ld e,a
	ld a,0
	ld d,a
	or a
	add hl,de
	ld a,(hl)
	cp b
	jr nz,Symsearchnot
	ld a,(hl)
	cp 0
	jr z,versioncheck
	ld a,(leva)
	ld hl,(levhl)
	call $4637
	ld (leva),a
	ld (levhl),hl
	ld a,(checkbytenum)
	inc a
	ld (checkbytenum),a
	jr checkstringloop
versioncheck
	ld a,(leva)
	ld hl,(levhl)
	call $4637
	call $46c3												; a,(ahl)
	ld b,a
	ld a,(vercheck)
	cp b
	jp nz,Symsearchnot
itsPtzlev
	call $47f3
	ld a,(xlevelsnum)
	cp 16
	jr z,Findlevsdone
	inc a
	ld (xlevelsnum),a
	ld hl,xlevelstable-9
	ld de,9
itsPtzlev1									;world found, next few lines write name to table
	add hl,de
	dec a
	cp 0
	jr nz,itsPtzlev1
	ld (xtableloc),hl
	ld hl,(symlocate)
	ld de,5
	or a
	sbc hl,de
	ld (symlocate),hl
	ld a,(hl)
	ld hl,(xtableloc)
	ld (hl),a
	ld (chrleft),a
itsPtzlevloop
	ld a,(chrleft)
	cp 0
	jr z,itsPtzlevloopend
	ld hl,(symlocate)
	dec hl
	ld (symlocate),hl
	ld a,(hl)
	ld hl,(xtableloc)
	inc hl
	ld (hl),a
	ld (xtableloc),hl
	ld a,(chrleft)
	dec a
	ld (chrleft),a
	jr itsPtzlevloop
itsPtzlevloopend
	ld hl,(symlocate)
	dec hl
	ld (symlocate),hl
	jp Symsearch
Findlevsdone
	call $47e3
	ld a,(xlevelsnum)
	cp 0									; checks if worlds were found
	jp z,not_a_lev_fnd
	ret
not_a_lev_fnd								; no worlds found on calculator
	call _clrLCD
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,nolevsfnd
	call _puts
	call _getkey
	pop hl
	jp start
findundercur
	ld a,(_curRow)
	ld b,a
	inc b
	ld de,21
	ld hl,-21
findunderloop
	add hl,de
	djnz findunderloop
	ld a,(_curCol)
	ld e,a
	ld d,0
	add hl,de
	ld de,$c0f9
	add hl,de
	ld a,(hl)
	cp 214
	ret nz
	ld a,$20
	ret
Bydraw
	ld a,0
	ld (_curCol),a
	ld a,7
	ld (_curRow),a
	ld hl,versionnum
	call _puts

	ld a,7
	ld (_curRow),a
	ld a,16
	ld (_curCol),a
	ld a,(installed_fixed)
	cp 0
	jr z,installed_fixedno
	ld a,1
installed_fixedno
	add a,$30
	call _putmap
	ld a,20
	ld (_curCol),a
	ld a,(installed_var)
	cp 0
	jr z,installed_varno
	ld a,1
installed_varno
	add a,$30
	call _putmap
	ld a,7
	call Invbar

Namedraw
	ld a,0
	ld (_curRow),a
	ld (_curCol),a
	ld hl,nametext
	call _puts
	ld a,0
	call Invbar
	ret

menudrawchoicenum
	set 3,(iy+5)
	ld a,0
	ld (_curRow),a
	ld a,16
	ld (_curCol),a
	ld a,(xlevelsnum)
	ld l,a
	ld a,0
	ld h,a
	call $4a33
	ld a,0
	ld (_curRow),a
	ld a,17
	ld (_curCol),a
	ld a,47
	call _putmap
	res 3,(iy+5)
	ret



choiceauthordisp
	ld a,(vercheck)
	ld b,a
	ld a,(curversion)
	cp b
	ret nz
	ld a,(regmenu)
	cp 0
	ret nz

	ld hl,PTZWRLD
	ld de,Filename
	ld bc,9
	ldir

	ld de,bytxt+4
	ld hl,bytxt+3
	ld (hl),$20
	ld bc,17
	ldir

	call findauthorname
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld l,a
	ld h,0
	ld a,0
	call _SET_MM_NUM_BYTES
	pop hl
	pop af
	call $4637					;inc ahl
	call _SET_ABS_SRC_ADDR
	ld a,0
	ld hl,bytxt+4 
	call _SET_ABS_DEST_ADDR
	call _mm_ldir




	ld a,7
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,bytxt
	call _puts
	ld a,7
	call Invbar
	ret



Invbar
	set 3,(iy+5)
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld b,21
drawselectedinvloop
	push bc
	call findundercur
	call _putmap
	ld a,(_curCol)
	inc a
	ld (_curCol),a
	pop bc
	djnz drawselectedinvloop
	res 3,(iy+5)
	ret


newfixed
	ld a,0
	ld (fixedorvar),a
newfont
	call _clrScrn
	ld a,0
	ld (_curCol),a
	ld (_curRow),a
	ld hl,nametext
	call _puts
	ld a,0
	call Invbar
	ld a,0
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	ld hl,fontnametxt
	call _puts
	ld a,3
	ld (_curRow),a
	ld a,-1
	ld (_curCol),a
	ld a,0
	ld (Keystringmode),a
	ld a,8
	ld (charmax),a
	ld hl,newfontname+1				;load address of string to store to
	call KeyString
	cp 0
	jp z,start	

	ld hl,newfontname-1
	rst 20h
	rst 10h
	jr nc,newfixedoverwrite
newfixed_can_overwrite
	ld hl,newfontname-1
	rst 20h
	rst 10h
	jr c,newfixed_nodelete
	call _delvar
newfixed_nodelete
	ld hl,newfontname-1
	rst 20h
	ld hl,21
	call $472f
	ld hl,newfontname
	ld de,Filename
	ld bc,10
	ldir
	ld hl,newfontname-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4c3f					;inc ahl, inc ahl
	call _SET_ABS_DEST_ADDR
	ld a,(fixedorvar)
	cp 0
	jr z,newfontfinishfixed
	jr newfontfinishvar

newfontfinishfixed
	ld a,0
	ld hl,newfixeddata
	call _SET_ABS_SRC_ADDR
	ld a,0
	ld hl,13
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	jp newfontend

newfontfinishvar
	ld a,0
	ld hl,newvardata
	call _SET_ABS_SRC_ADDR
	ld a,0
	ld hl,13
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	jp newfontend

newfontend
	ld a,0
	ld hl,newfontenddata
	call _SET_ABS_SRC_ADDR
	ld a,0
	ld hl,8
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	jp editvarstart



newfixedoverwrite
	ld a,4
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,fontnameexists
	call _puts
	ld a,6
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,fontnameoverwrite
	call _puts
	ld a,7
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,fontnamecancel
	call _puts
newfixedoverwrite_loop
	call _getkey
	cp k1
	jp z,newfixed_can_overwrite
	cp k2
	jp z,newfixed
	jr newfixedoverwrite_loop

newvar
	ld a,1
	ld (fixedorvar),a
	jp newfont



editfixed
	ld a,0
	ld (fixedorvar),a
	ld hl,editfixedstart
	ld (vargoto),hl

	ld hl,fixedbyts
	ld (checkbytes),hl
	ld hl,vartablemenu
	ld (curmenu),hl
	call _clrScrn
	call FindVariables
	call Bydraw
	jp Selectlevs

editvarfont
	ld a,1
	ld (fixedorvar),a
	ld hl,editvarstart
	ld (vargoto),hl

	ld hl,variablebytes
	ld (checkbytes),hl
	ld hl,vartablemenu
	ld (curmenu),hl
	call _clrScrn
	call FindVariables
	call Bydraw
	jp Selectlevs

editfixedstart
	call getpassword
	ld a,(passwordsaved)
	cp 0
	jp nz,typepassword
passwordcorrect
	ld a,7
	ld (cureditcol),a

	ld a,(fixedorvar)
	cp 1
	jr z,editvar1start

	ld a,6
	ld (cureditmaxrow),a
	ld a,0
	ld (cureditminrow),a
	ld a,7
	ld (cureditmaxcol),a
	ld a,2
	ld (cureditmincol),a
	ld a,0
	ld (cureditrow),a
	jr editvar1end
editvar1start
	ld a,5
	ld (cureditmaxrow),a
	ld a,1
	ld (cureditminrow),a
	ld a,7
	ld (cureditmaxcol),a
	ld a,0
	ld (cureditmincol),a
	ld a,1
	ld (cureditrow),a
editvar1end

	ld a,1
	ld (add_char),a
	ld a,0
	ld (curchar),a
editfixed_restart
	call findtotalchars
	ld a,(totalchars)
	cp 0
	jp z,editfixed_addchar_called_start
editfixed_addchar_startend
	call loadcurcharinfofixed
	call editfixedfndmncol
	call editfixedredrawscreen
	jp editfixedkeyloop
end_editfixedstart
	jp End




editfixedposrst
	ld a,7
	ld (cureditcol),a

	ld a,(fixedorvar)
	cp 1
	jr z,editvarposrst
	ld a,0
	ld (cureditrow),a
	ret
editvarposrst
	ld a,1
	ld (cureditrow),a
	ret



editfixed_addchar_called_start
	ld a,0
	ld (totalchars),a
	ld (curchar),a
	jp editfixed_addchar




findtotalchars
	ld hl,Filename-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $521d					;ld de,(ahl)
	push de

	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/



	call $4637					;inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $46c3					;ld a,(ahl)
	ld (totalchars),a
	pop hl
	ld (stringsize),hl
	ret


loadcurcharinfofixed
	ld hl,Filename-1
	rst 20h
	rst 10h
	ld c,b
	ex de,hl
	ld a,(curchar)
	ld b,a
	ld a,c
	inc b
	push bc
	call $4c3f					;inc ahl: inc ahl

	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/

	pop bc
loadcurcharinfofixedloop
	push bc
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	pop bc
	djnz loadcurcharinfofixedloop





	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (curcharnum),a

	ld a,(fixedorvar)
	cp 0
	jr z,endloadcurcharinfovar


	pop hl
	pop af
	call $4637					;inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (savedcharsize),a
	ld (editingcharsize),a
endloadcurcharinfovar
	pop hl
	pop af
	call $4637					;inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (savedchar+0),a
	ld (editingchar+0),a
	pop hl
	pop af
	call $4637					;inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (savedchar+1),a
	ld (editingchar+1),a
	pop hl
	pop af
	call $4637					;inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (savedchar+2),a
	ld (editingchar+2),a
	pop hl
	pop af
	call $4637					;inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (savedchar+3),a
	ld (editingchar+3),a
	pop hl
	pop af
	call $4637					;inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (savedchar+4),a
	ld (editingchar+4),a
	pop hl
	pop af
	call $4637					;inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld (savedchar+5),a
	ld (editingchar+5),a

	ld a,(fixedorvar)
	cp 1
	jr z,endloadcurcharinfovar1

	pop hl
	pop af
	call $4637					;inc ahl
	call $46c3					;ld a,(ahl)
	ld (savedchar+6),a
	ld (editingchar+6),a
	
	ret


endloadcurcharinfovar1
	pop hl
	pop af
	ld a,0
	ld (savedchar+6),a
	ld (editingchar+6),a
	ret



editfixedfndmncol
	ld a,(fixedorvar)
	cp 0
	jr z,editfixedfndmncol1
	ld a,(editingcharsize)
	ld b,a
	ld a,8
	sub b
	ld (cureditmincol),a
	ret
editfixedfndmncol1
	ld a,2
	ld (cureditmincol),a
	ret



editfixedkeyloop
	call _getkey
	cp kExit
	jp z,End
	cp kRight
	jp z,editfixed_right	
	cp kLeft
	jp z,editfixed_left	
	cp kUp
	jp z,editfixed_up	
	cp kDown
	jp z,editfixed_down	
	cp kEnter
	jp z,editfixed_enter
	cp kF4
	jp z,editfixed_next
	cp kF3
	jp z,editfixed_prev
	cp kF5
	call z,editfixed_savechar
	cp kF1
	jp z,Help
	cp kF2
	jp z,start
	cp kDel
	call z,editfixed_delchar
	cp kIns
	jp z,editfixed_addchar
	cp kNext
	jp z,editvar_changewidth
	cp kMode
	jp z,editvar_refreshchar
	cp kVarx
	jp z,edit_passwordchange
	cp kGrMenu
	jp z,edit_authornamechange
	jp editfixedkeyloop


editfixed_savechar
	ld bc,8
	ld hl,editingcharsize
	ld de,savedcharsize
	ldir
	ld hl,Filename-1
	rst 20h
	rst 10h
	ld c,b
	ex de,hl
	ld a,(curchar)
	ld b,a
	ld a,c
	inc b
	push bc
	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/


	call $4637					;inc ahl
	call $4c3f					;inc ahl: inc ahl
	pop bc
editfixed_savecharloop
	push bc
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	pop bc
	djnz editfixed_savecharloop

	call _SET_ABS_DEST_ADDR
	ld hl,7
	ld a,0
	call _SET_MM_NUM_BYTES

	ld a,(fixedorvar)
	cp 1
	jr z,editvar_savecharstart

	ld a,0
	ld hl,editingchar
	call _SET_ABS_SRC_ADDR
	jr editvar_savecharend
editvar_savecharstart
	ld a,0
	ld hl,editingcharsize
	call _SET_ABS_SRC_ADDR
editvar_savecharend
	call _mm_ldir
	call editfixedredrawscreen_1
	ret


editfixed_delchar
	call editfixed_delchar_called
	pop hl
	jp editfixed_restart

editfixed_delchar_called
	ld a,(Filename)
	ld (Tempname),a
	ld hl,Tempname-1
	rst 20h
	ld hl,(stringsize)
	ld de,8
	or a 
	sbc hl,de
	ld (stringsize),hl
	call _CREATESTRNG
	ld hl,Tempname-1
	rst 20h
	rst 10h
	ex de,hl
	ld a,b
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_DEST_ADDR
	ld hl,Filename-1
	rst 20h
	rst 10h
	ex de,hl
	ld a,b
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_SRC_ADDR
	ld hl,5
	ld de,8
	ld a,(curchar)
	ld b,a
	inc b
editfixed_delcharloop
	add hl,de
	djnz editfixed_delcharloop
	ld a,0
	push hl
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	pop hl
	ex de,hl
	ld hl,(stringsize)
	sbc hl,de
	ld a,0
	call _SET_MM_NUM_BYTES
	ld a,($c392)
	ld hl,($c393)
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_SRC_ADDR
	call _mm_ldir

	ld hl,Filename-1
	rst 20h
	rst 10h
	call _delvar


	ld a,(totalchars)
	ld hl,curchar
	dec a
	cp (hl)
	call z,editfixed_delchar_deccurchar
	ld a,(totalchars)
	dec a
	ld (totalchars),a


	ld hl,Tempname-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4637

	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/

	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $462f					;page,hl=ahl
	ld a,(totalchars)
	ld (hl),a


	call rename_tempvar
	call editfixedposrst
	call Re_Installfontfixed_1
	ret

editfixed_delchar_deccurchar
	ld a,(curchar)
	dec a
	ld (curchar),a
	ret



rename_tempvar
	ld hl,Tempname-1
	rst 20h
	rst 10h
	ld (symlocate),hl
	ld de,5
	or a
	sbc hl,de
	ld (symlocate),hl
	ld a,(Filename)
	ld (chrleft),a
	ld hl,Filename
	ld (xtableloc),hl
	call $47f3
renameloop
	ld a,(chrleft)
	cp 0
	ret z
	ld hl,(xtableloc)
	inc hl
	ld a,(hl)
	ld (xtableloc),hl
	ld hl,(symlocate)
	dec hl
	ld (symlocate),hl
	ld (hl),a
	ld a,(chrleft)
	dec a
	ld (chrleft),a
	jr renameloop



editfixed_addchar
	call editfixed_addchar_called
	ld a,(add_char)
	cp 0
	jp z,start
	jp editfixed_restart

editfixed_addchar_called
	call _clrScrn
	ld a,0
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,nametext
	call _puts
	ld a,0
	ld (_curRow),a
	ld a,13
	ld (_curCol),a
	ld hl,Filename+1
	call _puts
	ld a,0
	call Invbar

	ld a,(fixedorvar)
	cp 1
	jr z,editvar_addcharlvlstart

	ld a,236
	ld (maxlevs),a
	jr editvar_addcharlvlend
editvar_addcharlvlstart
	ld a,230
	ld (maxlevs),a
editvar_addcharlvlend
	ld a,0
	ld (_curCol),a
	ld a,3
	ld (_curRow),a
	ld hl,Levud
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,charnumbertxt
	call _puts

	ld a,1
	ld (curcharnum_1),a

	call Levelchange
	ld a,(curcharnum_1)
	ld (curcharnum),a
	ld a,(add_char)
	cp 0
	ret z
	call editfixed_addchar_checkdup
	ld a,(dupchar)
	cp 255
	jp nz,editfixed_addchar_dupexist

	ld a,(Filename)
	ld (Tempname),a
	ld hl,Tempname-1
	rst 20h
	ld hl,(stringsize)
	ld de,8
	or a 
	add hl,de
	call _CREATESTRNG

	ld hl,Tempname-1
	rst 20h
	rst 10h
	ex de,hl
	ld a,b
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_DEST_ADDR
	ld hl,Filename-1
	rst 20h
	rst 10h
	ex de,hl
	ld a,b
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_SRC_ADDR
	ld hl,5
	ld de,8
	ld a,(curchar)
	ld b,a
	inc b
editfixed_addcharloop
	add hl,de
	djnz editfixed_addcharloop
	ld a,0
	push hl						;stack+2 ;num of bytes transfered
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	ld a,($c392)
	ld hl,($c393)
	push af
	push hl
	ld a,0
	ld hl,curcharnum
	call _SET_ABS_SRC_ADDR
	ld a,0
	ld hl,1
	call _SET_MM_NUM_BYTES
	call _mm_ldir

	ld a,(fixedorvar)
	cp 1
	jr z,editvar_addcharnewstart


	ld a,0
	ld hl,newchar
	call _SET_ABS_SRC_ADDR
	jr editvar_addcharnewend
editvar_addcharnewstart
	ld a,0
	ld hl,newcharsize
	call _SET_ABS_SRC_ADDR
editvar_addcharnewend
	ld a,0
	ld hl,7
	call _SET_MM_NUM_BYTES
	call _mm_ldir





	pop hl
	pop af
	call _SET_ABS_SRC_ADDR
	pop de						;stack
	ld hl,(stringsize)
	or a
	sbc hl,de
	ld a,0

	call _SET_MM_NUM_BYTES
	call _mm_ldir


	ld a,(totalchars)
	inc a
	ld (totalchars),a
	ld hl,(stringsize)
	ld de,8
	add hl,de
	ld (stringsize),hl

	ld hl,Tempname-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4637

	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/

	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $462f					;page,hl=ahl
	ld a,(totalchars)
	ld (hl),a

	ld hl,Filename-1
	rst 20h
	rst 10h
	call _delvar
	call rename_tempvar
editfixed_addchar_finish
	call editfixedposrst
	call Re_Installfontfixed_1
	call editfixedredrawscreen
	ret


editfixed_addchar_dupexist
	ld a,(dupchar)
	ld (curchar),a
	jr editfixed_addchar_finish



Levelchange
	call $47e3
	ld a,(_curCol)
	dec a
	ld (_curCol),a
	jr Levelnumdraw
Levelchangeloop
	call _getkey
	cp kExit
	jp z,editfixed_addchar_failed
	cp kF2
	jp z,editfixed_addchar_failed
	cp kEnter
	jp z,Levelchangeend
	cp kUp
	jr z,Levelgoesup
	cp kDown
	jr z,Levelgoesdown
	jr Levelchangeloop	
Levelgoesup
	ld a,(curcharnum_1)
	cp 1
	jr z,Levelloopup
	ld a,(curcharnum_1)
	dec a
	ld (curcharnum_1),a
	jr Levelnumdraw
Levelgoesdown
	ld a,(curcharnum_1)
	ld b,a
	ld a,(maxlevs)
	cp b
	jr z,Levelloopdown
	ld a,(curcharnum_1)
	inc a
	ld (curcharnum_1),a
	jr Levelnumdraw
Levelloopup
	ld a,(maxlevs)
	ld (curcharnum_1),a
	jr Levelnumdraw
Levelloopdown
	ld a,1
	ld (curcharnum_1),a
	jr Levelnumdraw
Levelnumdraw
	res 1,(iy+35)
	res 0,(iy+35)


	ld a,(widthon)
	cp 1
	jr z,Levelnumdrawvarend
	ld a,(fixedorvar)
	cp 1
	jr z,Levelnumdrawvarstart


	ld a,3
	ld (_curRow),a
	ld a,15
	ld (_curCol),a
	ld a,(curcharnum_1)
	call _putmap
	jr Levelnumdrawvarend
Levelnumdrawvarstart
	ld a,24
	ld (_penRow),a
	ld a,89
	ld (_penCol),a
	ld hl,spaces
	call _vputs


	ld a,24
	ld (_penRow),a
	ld a,89
	ld (_penCol),a
	ld a,(curcharnum_1)
	call _vputmap

Levelnumdrawvarend
	ld a,16
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld a,(curcharnum_1)
	ld l,a
	ld a,0
	ld h,a
	call $4a33



	set 0,(iy+35)
	set 1,(iy+35)
	jp Levelchangeloop


Levelchangeend
	ld a,1
	ld (add_char),a
	ret



editfixed_addchar_failed
	ld a,0
	ld (add_char),a
	call editfixedredrawscreen
	ret

editfixed_addchar_next
	call editfixed_addchar_called
	ld a,(add_char)
	cp 1
	jp z,editfixed_restart
	ld a,(curchar)
	dec a
	ld (curchar),a
	jp editfixedkeyloop

editfixed_next
	ld a,(curchar)
	inc a
	ld (curchar),a
	ld hl,totalchars	
	cp (hl)
	jp z,editfixed_addchar_next
	call loadcurcharinfofixed
	call editfixedfndmncol
	call editfixedposrst
	call editfixedredrawscreen_1
	jp editfixedkeyloop
editfixed_prev
	ld a,(curchar)
	cp 0
	jp z,editfixedkeyloop
	dec a
	ld (curchar),a
	call loadcurcharinfofixed
	call editfixedfndmncol
	call editfixedposrst
	call editfixedredrawscreen_1
	jp editfixedkeyloop

editvar_changewidth
	ld a,(fixedorvar)
	cp 0
	jp z,editfixedkeyloop
	ld a,1
	ld (widthon),a



	call _clrScrn
	ld a,0
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,nametext
	call _puts
	ld a,0
	ld (_curRow),a
	ld a,13
	ld (_curCol),a
	ld hl,Filename+1
	call _puts
	ld a,0
	call Invbar

	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,charwidthtxt
	call _puts


	ld a,8
	ld (maxlevs),a

	ld a,(editingcharsize)
	ld (curcharnum_1),a

	call Levelchange
	ld a,(add_char)
	cp 0
	jr z,editvar_changewidthend

	ld a,(editingcharsize)
	ld b,a
	ld a,(curcharnum_1)
	cp b
	jr nc,editvar_changewidthupdate


	ld a,(curcharnum_1)
	dec a
	ld hl,width_mask
	ld e,a
	ld d,0
	add hl,de
	ld a,(hl)
	ld c,a
	ld hl,editingchar
	ld b,7
editvar_changewidthloop
	ld a,c
	and (hl)
	ld (hl),a
	inc hl
	djnz editvar_changewidthloop	





editvar_changewidthupdate
	ld a,(curcharnum_1)
	ld (editingcharsize),a
	ld a,0
	ld (widthon),a


editvar_changewidthend
	call editfixedfndmncol
	call editfixedposrst
	call editfixedredrawscreen
	jp editfixedkeyloop



editvar_refreshchar
	call loadcurcharinfofixed
	call editfixedfndmncol
	call editfixedposrst
	call editfixedredrawscreen
	jp editfixedkeyloop




editfixed_right	
	ld a,(cureditmaxcol)
	ld b,a
	ld a,(cureditcol)
	cp b
	jp z,editfixedkeyloop
	inc a
	ld (cureditcol),a
	call redraweditingchar
	jp editfixedkeyloop
editfixed_left
	ld a,(cureditmincol)
	ld b,a
	ld a,(cureditcol)
	cp b
	jp z,editfixedkeyloop
	dec a
	ld (cureditcol),a
	call redraweditingchar
	jp editfixedkeyloop
editfixed_up	
	ld a,(cureditminrow)
	ld b,a
	ld a,(cureditrow)
	cp b
	jp z,editfixedkeyloop
	dec a
	ld (cureditrow),a
	call redraweditingchar
	jp editfixedkeyloop
editfixed_down
	ld a,(cureditmaxrow)
	ld b,a
	ld a,(cureditrow)
	cp b
	jp z,editfixedkeyloop
	inc a
	ld (cureditrow),a
	call redraweditingchar
	jp editfixedkeyloop

editfixed_enter
	ld d,0
	ld a,(cureditrow)
	ld e,a
	ld hl,editingchar
	add hl,de
	ld a,(cureditcol)
	
	cp 7
	jr z,editenterbit0
	cp 6
	jr z,editenterbit1
	cp 5
	jr z,editenterbit2
	cp 4
	jr z,editenterbit3
	cp 3
	jr z,editenterbit4
	cp 2
	jr z,editenterbit5
	cp 1
	jr z,editenterbit6
	jr editenterbit7
editenterbit0
	bit 0,(hl)
	jr z,editenterbit0set
	res 0,(hl)
	jr endeditenterbit
editenterbit0set
	set 0,(hl)
	jr endeditenterbit

	
editenterbit1
	bit 1,(hl)
	jr z,editenterbit1set
	res 1,(hl)
	jr endeditenterbit
editenterbit1set
	set 1,(hl)
	jr endeditenterbit

	
editenterbit2
	bit 2,(hl)
	jr z,editenterbit2set
	res 2,(hl)
	jr endeditenterbit
editenterbit2set
	set 2,(hl)
	jr endeditenterbit

	
editenterbit3
	bit 3,(hl)
	jr z,editenterbit3set
	res 3,(hl)
	jr endeditenterbit
editenterbit3set
	set 3,(hl)
	jr endeditenterbit

	
editenterbit4
	bit 4,(hl)
	jr z,editenterbit4set
	res 4,(hl)
	jr endeditenterbit
editenterbit4set
	set 4,(hl)
	jr endeditenterbit

	
editenterbit5
	bit 5,(hl)
	jr z,editenterbit5set
	res 5,(hl)
	jr endeditenterbit
editenterbit5set
	set 5,(hl)
	jr endeditenterbit

	
editenterbit6
	bit 6,(hl)
	jr z,editenterbit6set
	res 6,(hl)
	jr endeditenterbit
editenterbit6set
	set 6,(hl)
	jr endeditenterbit

	
editenterbit7
	bit 7,(hl)
	jr z,editenterbit7set
	res 7,(hl)
	jr endeditenterbit
editenterbit7set
	set 7,(hl)
	jr endeditenterbit



endeditenterbit
	call redraweditingchar
	jp editfixedkeyloop




redraweditingchar
	ld b,7
	call editdraweditingchar
	ld b,7
	ld a,(editingcharsize)
	ld hl,editingchar
	ld de,$ff80
	call putmap1
	ret

editfixedredrawscreen
	call _clrScrn
	ld a,0
	ld (_curRow),a
	ld a,0
	ld (_curCol),a
	ld hl,nametext
	call _puts
	ld a,0
	ld (_curRow),a
	ld a,13
	ld (_curCol),a
	ld hl,Filename+1
	call _puts
	ld a,0
	call Invbar
editfixedredrawscreen_1

	ld a,16
	ld (_curCol),a
	ld a,1
	ld (_curRow),a
	ld a,(curcharnum)
	ld l,a
	ld a,0
	ld h,a
	call $4a33


	call redraweditingchar
	ld b,7
	ld a,(savedcharsize)
	ld hl,savedchar
	ld de,$fd89
	call putmap1



	ld a,0
	ld (_curCol),a
	ld a,1
	ld (_curRow),a
	ld hl,charnumbertxt
	call _puts

	ld a,0
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	ld hl,defaultchartxt
	call _puts









	ld a,12
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	ld hl,savedchartxt
	call _puts

	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,installedchartxt
	call _puts



	ld a,0
	ld (_curCol),a
	ld a,6
	ld (_curRow),a
	ld hl,curchartxt
	call _puts


	ld a,(fixedorvar)
	cp 0
	jr z,editfixedredrawscreen_endfxd

	ld a,16
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld a,(editingcharsize)
	ld l,a
	ld a,0
	ld h,a
	call $4a33

	ld a,12
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,widthtxt
	call _puts
	ld a,0
	ld (_penCol),a
	ld a,40
	ld (_penRow),a
	ld a,(curcharnum)
	call _vputmap
	ld a,0
	ld (_penCol),a
	ld a,24
	ld (_penRow),a
	res 1,(iy+35)
	ld a,(curcharnum)
	call _vputmap
	set 1,(iy+35)
	ret

editfixedredrawscreen_endfxd
	ld a,0
	ld (_curCol),a
	ld a,5
	ld (_curRow),a
	ld a,(curcharnum)
	call _putmap
	ld a,0
	ld (_curCol),a
	ld a,3
	ld (_curRow),a
	res 0,(iy+35)
	ld a,(curcharnum)
	call _putmap
	set 0,(iy+35)
	ret


editdrawchar0
	ld a,1
	jp editdrawchar0_end


editdraweditingchar		;a=col, b=row
	xor a				;ld a,0
editdraweditingcharloop



	ld e,b
	dec e
	ld d,0
	ld hl,editingchar
	add hl,de
	ld e,0

	push bc
	push af
	push hl

	ld hl,cureditcol
	cp (hl)
	jr nz,editdrawnotselected
	ld a,b
	dec a
	ld hl,cureditrow
	cp (hl)
	jr nz,editdrawnotselected1
	ld e,1
editdrawnotselected1
	pop hl
	pop af
	pop bc
	push bc
	push af
	jr editdrawnotselectedend
editdrawnotselected
	pop hl
	jr editdrawnotselectedend
editdrawnotselectedend
	ld c,a
	add a,a
	add a,c
	add a,90
	ld (_penCol),a
	ld c,b
	ld a,b
	add a,a
	add a,c
	add a,34
	ld (_penRow),a
	pop af
	push af

	cp 0
	jr z,editbit7
	cp 1
	jr z,editbit6
	cp 2
	jr z,editbit5
	cp 3
	jr z,editbit4
	cp 4
	jr z,editbit3
	cp 5
	jr z,editbit2
	cp 6
	jr z,editbit1
	jr editbit0

editbit0
	bit 0,(hl)
	jr z,editdrawchar0
	jr editdrawchar1
editbit1
	bit 1,(hl)
	jr z,editdrawchar0
	jr editdrawchar1
editbit2
	bit 2,(hl)
	jr z,editdrawchar0
	jr editdrawchar1
editbit3
	bit 3,(hl)
	jr z,editdrawchar0
	jr editdrawchar1
editbit4
	bit 4,(hl)
	jr z,editdrawchar0
	jr editdrawchar1
editbit5
	bit 5,(hl)
	jp z,editdrawchar0
	jr editdrawchar1
editbit6
	bit 6,(hl)
	jp z,editdrawchar0
	jr editdrawchar1
editbit7
	bit 7,(hl)
	jp z,editdrawchar0
	jr editdrawchar1

editdrawchar1
	ld a,3
editdrawchar0_end
	add a,e
	dec a
	call PutMap
	pop af
	pop bc
	inc a
	cp 8
	jp nz,editdraweditingcharloop
	djnz editdraweditingchar1
	ret

editdraweditingchar1
	jp editdraweditingchar

PutMap
	ld b,a
	inc b
	ld hl,-3
	ld de,3
putmap_findmaploop
	add hl,de
	djnz putmap_findmaploop
	ex de,hl
	ld hl,chartable
	add hl,de
	push hl
	ld b,3
putmap_putitloop
	ld a,(_penRow)
	add a,8
	sub b
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ld a,(_penCol)
	ld c,0
putmap_addloop
	cp 8
	jr c,putmap_addloopend
	sub 8
	inc c
	jr putmap_addloop
putmap_addloopend
	push af
	ld e,c
	ld d,0
	add hl,de
	ld de,$fc00
	add hl,de
	ld e,%11111111
	ld d,%00011111
putmap_maskloop
	cp 0
	jr z,putmap_maskloopend
	dec a
	scf
	rr d
	rr e
	jr putmap_maskloop
putmap_maskloopend
	ld a,d
	and (hl)
	ld (hl),a
	inc hl
	ld a,e
	and (hl)
	ld (hl),a
	dec hl
	ex de,hl
	pop af
	pop hl
	ld c,a
	ld a,(hl)
	inc hl
	push hl
	ex de,hl
	ld e,0
	ld d,a
	ld a,c
putmap_maskloop2
	cp 0
	jr z,putmap_maskloopend2
	dec a
	rr d
	rr e
	jr putmap_maskloop2
putmap_maskloopend2
	ld a,d
	or (hl)
	ld (hl),a
	inc hl
	ld a,e
	or (hl)
	ld (hl),a
	djnz putmap_putitloop
	pop hl
	ret


editvarstart
	jp editfixedstart



putmap1
putmap1loop
	push af
	ld c,b
	inc a
	ld b,a

	
	ld a,(hl)
	ex de,hl

putmapshiftloop
	rr a
	djnz putmapshiftloop
	ld (hl),a

	ld b,16
putmapaddloop
	inc hl
	djnz putmapaddloop
	ld b,c
	ex de,hl
	inc hl
	pop af
	djnz putmap1loop
	ret








; from assembly 86 list, posted by Joshua J Seagoe, modified by me
KeyString
	ld a,0
	ld (keystringstop),a
	ld a,-1
	ld (charcount),a
	set 2,(iy+12)
	push hl
keyloop:
	ld a,(charcount)
	inc a
	ld b,a
	ld (charcount),a
	ld a,(_curCol)
	inc a
	ld (_curCol),a
	ld a,(charmax)
	cp b
	jp z,keystop
keyloop1
	ld a,Lspace
	call _putmap				;draw cursor
keyloop2
	push hl						;_getkey kills hl
	call _getkey				;get keypress
	pop hl
	cp kEnter					;enter key?
	jp z, key_done1				;then we're done
	cp kExit					;exit key?
	jp z, key_quit				;if so, then quit
	cp kF2
	jp z, key_quit
	cp kDel
	jr z,key_Del

	push af
	ld a,(keystringstop)
	cp 1
	jp z,keyloop2a
	ld a,(Keystringmode)
	cp 1
	jr z,key_add1
	pop af

	cp kSpace					;is it space?
	jr z, key_space				;if it is a space
	sub $1C						;k0
	jr c, keyloop1				;it's not a known key if negative
	sub $0A						;difference between (k9+1) and k0
	jr c, key_number			;if neg, assumed to be a number key
	sub $02						;difference between kCapA and (k9+1)
	jr c, keyloop1				;it's not a known key if negative
	sub $1A						;difference between (kCapZ+1) and kCapA
	jr c, key_capletter			;if negative, then assume capital letter
	sub $1B						;difference between (kz+1) and (kCapZ+1)
	jr c, key_lowletter			;if neg, assume lower case letter
	jr keyloop1					;must be an unknown key at this point
key_Del
	ld a,(charcount)
	cp 0
	jr z,keyloop1
	ld a,Lspace
	call _putmap
	ld a,(charcount)
	dec a
	ld (charcount),a
	dec hl
	ld (hl),a
	ld a,(_curCol)
	dec a
	ld (_curCol),a
	ld a,(keystringstop)
	cp 1
	jp z,keyrestart
    jr keyloop1
key_space:
	ld a,(Keystringmode)
	cp 0
	jr z,key_space1
	ld a, Lspace				;char code for space
	jr key_add
key_space1
	ld a,227
	jr key_add
key_number:
	push af
	ld a,(Keystringmode)
	cp 0
	jr nz,key_numberendcheck
	ld a,(charcount)
	cp 0
	jr z,keyloop1a
key_numberendcheck
	pop af
	add a, 20+$26				;keycode-->char code
	jr key_add
key_capletter:
	add a, 25+$42				;keycode-->char code
	jr key_add
key_lowletter:
	add a, 31+$5d				;keycode-->char code
	jr key_add
key_add1
	pop af
key_add:
	ld (hl), a					;store
	inc hl						;inc string pointer
	push af
	ld a,(Keystringmode)
	cp 1
	jr nz,key_addendcheck
	pop af
	ld a,42
	push af
key_addendcheck
	pop af
	call _putmap				;display the key
    jp keyloop
key_quit:
	pop hl
	ld a,0							;and clear the cursor
	ld (hl),a
	res 2,(iy+12)
	jr key_done_finish				
key_done1
	ld a,(Keystringmode)
	cp 1
	jp z,keyloop2
key_done:
	ld (hl), 0					;zero-terminate string
	ld a,(charcount)
	pop hl
	dec hl
	ld (hl),a
	res 2,(iy+12)
	ld a,1
key_done_finish
	res 3,(iy+18)
	res 4,(iy+18)
	res 5,(iy+18)
	res 6,(iy+18)
	res 7,(iy+18)
	ret							;quit
keyloop1a
	pop af
	jp keyloop1

keyloop2a
	pop af
	jp keyloop2

getpassword
	ld hl,Filename-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_SRC_ADDR
	ld hl,passwordsaved
	ld a,0
	call _SET_ABS_DEST_ADDR
	ld a,0
	ld hl,5
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	ret

keystop
	ld a,(Keystringmode)
	cp 1
	jr z,key_done
	ld a,1
	ld (keystringstop),a
	res 2,(iy+12)
	ld a,231
	call _putmap
	jp keyloop2

keyrestart
	ld a,0
	ld (keystringstop),a
	set 2,(iy+12)
	jp keyloop1








typepassword
	call _clrScrn
	call Bydraw
	ld a,0
	ld (_curCol),a
	ld a,1
	ld (_curRow),a
	ld hl,Filename+1
	call _puts
	ld a,0
	ld (_curCol),a
	ld a,3
	ld (_curRow),a
	ld hl,enterpasstxt
	call _puts
	
	ld a,1
	ld (Keystringmode),a
	ld a,4
	ld (charmax),a
	ld hl,newpassword+1
	call KeyString
	cp 0
	jp z,start

	ld a,(passwordsaved)
	ld hl,newpassword
	ld (hl),a
	call passwordmake



	ld hl,passwordsaved
	ex de,hl
	ld hl,newpassword
	call passwordcheck
	cp 0
	jp z,typepassword
	jp passwordcorrect




passwordcheck
	ld a,5
	ld c,a
passwordcheckloop
	ld a,c
	cp 0
	jr z,endpasswordcheck
	dec c
	ld a,(hl)
	ld b,a
	ex de,hl
	ld a,(hl)
	cp b
	jr nz,passwordnopass
	inc hl
	inc de
	jr passwordcheckloop
passwordnopass
	ld a,0
	ret
endpasswordcheck
	ld a,1
	ret



edit_passwordchange
	call _clrScrn
	call Bydraw
	ld a,0
	ld (_curCol),a
	ld a,3
	ld (_curRow),a
	ld hl,enternewpasstxt
	call _puts
	ld a,1
	ld (Keystringmode),a
	ld a,4
	ld (charmax),a
	ld hl,newpassword+1
	call KeyString
	cp 0
	jp z,editfixed_restart

	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	ld hl,reenternewpasstxt
	call _puts
	ld a,1
	ld (Keystringmode),a
	ld a,4
	ld (charmax),a
	ld hl,newpasswordcheck+1
	call KeyString
	cp 0
	jp z,editfixed_restart






	ld a,0
 	call $4613
	ld a,254
	call $4617
 	call $5544
	call _CONVOP1  
	inc a
	ld (passwordsaved),a


;	ld a,(passwordsaved)
	ld hl,newpassword
	ld (hl),a
	call passwordmake

	ld a,(passwordsaved)
	ld hl,newpasswordcheck
	ld (hl),a
	call passwordmake



	ld hl,newpasswordcheck
	ex de,hl
	ld hl,newpassword
	call passwordcheck
	cp 0
	jp z,edit_passwordchange


	ld hl,newpassword
	ld de,passwordsaved
	ld bc,5
	ldir

	ld hl,Filename-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_DEST_ADDR
	ld hl,passwordsaved
	ld a,0
	call _SET_ABS_SRC_ADDR
	ld a,0
	ld hl,5
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	jp editfixed_restart	



edit_authornamechange
	call _clrScrn
	call Bydraw
	ld hl,curnametxt
	ld a,0
	ld (_curCol),a
	ld a,1
	ld (_curRow),a
	call _puts
	ld hl,newnametxt
	ld a,0
	ld (_curCol),a
	ld a,4
	ld (_curRow),a
	call _puts

	ld de,bytxt+4
	ld hl,bytxt+3
	ld (hl),$20
	ld bc,17
	ldir

	call findauthorname
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld l,a
	ld h,0
	ld a,0
	call _SET_MM_NUM_BYTES
	pop hl
	pop af
	push af
	push hl
	call $4637					;inc ahl
	call _SET_ABS_SRC_ADDR
	ld a,0
	ld hl,bytxt+4 
	call _SET_ABS_DEST_ADDR
	call _mm_ldir

	ld hl,bytxt+4
	ld a,0
	ld (_curCol),a
	ld a,2
	ld (_curRow),a
	call _puts

	ld a,-1
	ld (_curCol),a
	ld a,5
	ld (_curRow),a
	ld a,2
	ld (Keystringmode),a
	ld a,17
	ld (charmax),a
	ld hl,newby+1
	call KeyString
	cp 0
	jp z,editfixed_restart

	pop hl
	pop af
	call $46c3					;ld a,(ahl)
	ld l,a
	ld h,0
	ex de,hl
	ld hl,(stringsize)
	or a
	sbc hl,de
	ld a,(newby)
	ld e,a
	ld d,0
	or a
	adc hl,de
	ld (stringsize),hl
	push hl
	ld a,(Filename)
	ld (Tempname),a
	ld hl,Tempname-1
	rst 20h
	pop hl
	call _CREATESTRNG




	ld hl,Tempname-1
	rst 20h
	rst 10h
	ex de,hl
	ld a,b
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_DEST_ADDR
	ld hl,Filename-1
	rst 20h
	rst 10h
	ex de,hl
	ld a,b
	call $4c3f					;inc ahl: inc ahl
	call _SET_ABS_SRC_ADDR

	ld a,(newby)
	inc a
	ld e,a
	ld d,0
	ld hl,(stringsize)
	or a
	sbc hl,de
	ld a,0
	call _SET_MM_NUM_BYTES
	call _mm_ldir

	ld hl,newby
	ld a,0
	call _SET_ABS_SRC_ADDR
	ld a,(newby)
	inc a
	ld l,a
	ld h,0
	ld a,0
	call _SET_MM_NUM_BYTES
	call _mm_ldir


	ld hl,Filename-1
	rst 20h
	rst 10h
	call _delvar

	call rename_tempvar
	call Re_Installfontfixed_1
	jp editfixed_restart



passwordmake
; stuff to make the password
; you can understand why I would take this out
	ret




editfixed_addchar_checkdup
	ld a,0
	ld (dupchar),a
	ld hl,Filename-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4c3f												;inc ahl: inc ahl
	call $4c3f					;inc ahl: inc ahl	;\
	call $4c3f					;inc ahl: inc ahl	;---added to advance past password
	call $4637					;inc ahl			;/


	push af
	push hl
editfixed_addchar_checkdup_loop
	pop hl
	pop af
	call $4c3f												;inc ahl: inc ahl
	call $4c3f												;inc ahl: inc ahl
	call $4c3f												;inc ahl: inc ahl
	call $4c3f												;inc ahl: inc ahl
	push af
	push hl
	call $46c3												; a,(ahl)
	ld b,a
	ld a,(curcharnum)
	cp b
	jr z,editfixed_addchar_checkdup_fnd
	ld a,(dupchar)
	ld b,a
	ld a,(totalchars)
	cp b
	jr z,editfixed_addchar_checkdup_none
	ld a,(dupchar)
	inc a
	ld (dupchar),a
	jr editfixed_addchar_checkdup_loop
editfixed_addchar_checkdup_none
	pop hl
	pop af
	ld a,255
	ld (dupchar),a
	ret
editfixed_addchar_checkdup_fnd
	pop hl
	pop af
	ret





findauthorname
	ld hl,Filename-1
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	push af
	push hl
	call $46c3					;ld a,(ahl)
	ld b,a
	cp 0
	jr z,findauthorname_endloop
	pop hl
	pop af
findauthorname_loop
	push bc
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	call $4c3f					;inc ahl, inc ahl
	pop bc
	djnz findauthorname_loop

findauthorname_setsrcaddr
	call $4637					;inc ahl

;	ld a,0
;	ld hl,newfontenddata

	ret

findauthorname_endloop
	pop hl
	pop af
	jr findauthorname_setsrcaddr



menu1
.db 1
.db 1
.db 6
.dw End
.dw Firstmenu
.db 11
.dw loadtxt
.dw startselvarfxd
.dw uninstalltxt
.dw Uninstall
.dw editfixedtxt
.dw editfixed
.dw newfixedtxt
.dw newfixed
.dw loadvartxt
.dw startselvarvar
.dw uninstallvartxt
.dw uninstallvar
.dw editvarfonttxt
.dw editvarfont
.dw newvartxt
.dw newvar
.dw abouttxt
.dw about
.dw helptxt
.dw Help
.dw endtxt
.dw End



;Keystring vars
Keystringmode
.db 0				;0=var name, 1=password, 2=author or description text
charcount
.db 0
charmax
.db 8
keystringstop
.db 0
;end Keystring vars


nohelpviewer
.db "Need file: HelpView",0
variable
.db 8,"HelpView"

textfiledata
.db 7
.db 1
.db 20
.db 0
textvariable
.db 8,"CstmHelp"
fixedorvar		;0=fixed, 1=var
.db 0
curchar
.db 0
curcharnum_1
.db 0
curcharnum
.db $21
charlocation
.dw 0
cureditmaxrow
.db 6
cureditminrow
.db 0
cureditmaxcol
.db 7
cureditmincol
.db 3
cureditrow
.db 0
cureditcol
.db 0
stringsize
.dw 0
totalchars
.db 0
add_char
.db 0						;0 failed, 1 successful
savedcharsize
.db 6
savedchar
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
editingcharsize
.db 6
editingchar
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
newcharsize
.db 6
newchar
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
chartable
.db %00000000
.db %00000000
.db %00000000

.db %00000000
.db %01000000
.db %00000000

.db %11100000
.db %11100000
.db %11100000

.db %11100000
.db %10100000
.db %11100000

vercheck:
.db 2
curversion
.db 2
Levud
.db "Character ",6,"/",7,"  ",0
maxlevs
.db 236
newfontname
.db 7,"NewFont",0,0
loadtxt
.db "Install Fixed Font",0
uninstalltxt
.db "Uninstall Fixed Font",0
editfixedtxt
.db "Edit Fixed Font",0
loadvartxt
.db "Install Var. Font",0
uninstallvartxt
.db "Uninstall Var. Font",0
editvarfonttxt
.db "Edit Variable Font",0
abouttxt
.db "About Custom Font",0
helptxt
.db "Custom Font Help",0
endtxt
.db "Exit Program",0
newfixedtxt
.db "New Fixed Font",0
newvartxt
.db "New Var. Font",0






widthtxt
.db "Width:",0
menuminrow
.db 1
menumaxrow
.db 4
leva
.db 0
levhl
.db 0,0
checkbytenum
.db 0
fixedbyts
.db "Fnt0",0
variablebytes
.db "Fnt1",0
checkbytes			;pointer
.db 0,0
nolevsfnd
.db "No files found",0
name
.db "Custom Font v1.00 by John Kempen",0
cstnfont
.db 8,"CstmFont",0
Tempname
.db 8,"T/e/M/p/",0
Filename
.db 8,"12345678",0
Filenamebckup
.db 8,"12345678",0
PTZWRLD
.db 8,"12345678901234567890",0
report
.db "Report bugs to:",0
email
.db "saywhat97@hotmail.com",0
bytext
.db "By John Kempen",0
versionnum
.db "Version 1.00  F:  V: ",0
nametext
.db "Custom Font",0
charnumbertxt
.db "Current char.:",0
defaultchartxt
.db "Default:",0
savedchartxt
.db "Saved:",0
installedchartxt
.db "Installed:",0
curchartxt
.db "Current:",0
fontnametxt
.db "Enter variable name:",0
fontnameexists
.db "Variable name exists",0
fontnameoverwrite
.db "Overwrite: Press 1",0
fontnamecancel
.db "Cancel:    Press 2",0
newfixeddata
.db "Fnt0",0
.db 2
.db 0,0,0,0,0
.db $6f,0
newvardata
.db "Fnt1",0
.db 2
.db 0,0,0,0,0
.db $64,0
newfontenddata
.db 7
.db "Unknown"
spaces
.db "          ",0
widthon
.db 0							;1-on, 0-off
dupchar
.db 0
checkchar
.db 0
charwidthtxt
.db "New char. width:",0
width_mask
.db %00000001			;width=1
.db %00000011			;width=2
.db %00000111			;width=3
.db %00001111			;width=4
.db %00011111			;width=5
.db %00111111			;width=6
.db %01111111			;width=7
.db %11111111			;width=8
passwordsaved
.db 0,0,0,0,0
newpassword
.db 0,0,0,0,0
newpasswordcheck
.db 0,0,0,0,0
.db 0
enterpasstxt
.db "Enter Password:",0
enternewpasstxt
.db "New Password:   ",0
reenternewpasstxt
.db "Retype Password:",0
curnametxt
.db "Current name:",0
newnametxt
.db "Enter new name:",0
newby
.db 0,"                 ",0
bytxt
.db "By:                  ",0
vartablemenu
.db 0
.db 1
.db 6
.dw End
.dw Firstmenu
vargoto
.dw 0
Varmenutable
xlevelstable
.end

