#include "asm86.h"
#include "ti86asm.inc"

    .org _asm_exec_ram
    ld a,               ; Fill here the length of the string name
    ld hl, namestring
    ld bc, carrs
    ld de, 544          ; (16 sprites with 34 bytes each)
    call CreateString
    ret

namestring:
    .db "Name"          ; Fill here the name of the string you want to create

;==========================================================
; Create String routine
; by Andreas Finne <a_finne@hotmail.com>
; date: 10 Dec 1999
;
; Size: 40 bytes
;
; Input:
; de = length of data
; a  = length of name <=8
; hl = pointer to filename
; bc = pointer to start of data (Must be on ram page 0 or 1)
;==========================================================

CreateString:
    push bc                     ;Save the pointer to start of data
    push de                     ;Save the length of data twice
    push de
    ld de,_OP1+1                ;Point de to OP1+1
    ld (de),a                   ;Load length of string name to OP1+1
    ld c,a                      ;
    xor a                       ;Load length of string name to bc
    ld b,a                      ;
    inc de                      ;de = OP1+2
    ldir                        ;Copy the name into OP1+2->
    pop hl                      ;hl = length of data
    call _createstrng           ;create a string with namelength=OP1+1, name=OP1+2->, hl=number of bytes
    ld a,b                      ;_createstrng returns the ABS address of the created string to bde
    ex de,hl                    ;bde to ahl
    call _ahl_plus_2_pg3        ;Skip size bytes of the string (ahl=ahl+2)
    call _set_abs_dest_addr     ;Set destination address of _mm_ldir to ahl
    pop hl                      ;hl = length of data
    xor a                       ;a=0
    call _set_mm_num_bytes      ;Number of bytes to copy = ahl
    pop hl                      ;hl = pointer to start of data
    call _set_abs_src_addr      ;Set source address of _mm_ldir to ahl
    call _mm_ldir               ;Copy _mm_num_bytes from _abs_src_addr to _abs_dest_addr
    jp _ram_page_1              ;_mm_ldir changes ram pages, this loads page #1 and returns


carrs: 
carr0:
.db 16, 16
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111
.db %11111111, %11111111

carr1: 
.db 16, 16
.db %00000000, %00000000
.db %01111111, %11111111
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000

carr2: 
.db 16, 16
.db %00000000, %00000000
.db %11111111, %11111111
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000

carr3: 
.db 16, 16
.db %00000000, %00000000
.db %11111111, %11111110
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010

carr4: 
.db 16, 16
.db %00000000, %00000000
.db %01111111, %11111111
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000

carr5: 
.db 16, 16
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000

carr6: 
.db 16, 16
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000

carr7: 
.db 16, 16
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010

carr8: 
.db 16, 16
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000

carr9: 
.db 16, 16
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000

carr10: 
.db 16, 16
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000

carr11: 
.db 16, 16
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010

carr12: 
.db 16, 16
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01000000, %00000000
.db %01111111, %11111111
.db %00000000, %00000000

carr13: 
.db 16, 16
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %11111111, %11111111
.db %00000000, %00000000

carr14: 
.db 16, 16
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %11111111, %11111111
.db %00000000, %00000000

carr15: 
.db 16, 16
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %00000000, %00000010
.db %11111111, %11111110
.db %00000000, %00000000

.end