; Clickers v2.0
; par Thibaut Chevalier
; J'ai comment en francais les passages les plus interressants
; surtout celui sur l'utilisation du vat pour rechercher des images au format du jeu
; si vous voulez d'autres explications, n'hsitez pas  me le demander par e-mail (moitib_calliope@hotmail.com)

#include "asm86.h" 
#include "ti86asm.inc" 

_Set_ABS_Scr_Addr = $4647
_Set_ABS_Dest_Addr = $5285
_Set_MM_Num_Bytes = $464f
_MM_Ldir = $52ed
_ahl_Plus_2_Pg3 = $4c3f
cur_vat = $f200
vat_empty = $f202
cur_strng = $f203

.org _asm_exec_ram     
    
    nop
    jp intro
    .dw 0
    .dw ShellTitle
ShellTitle:
    .db "Clickers v2.0 by Thibaut Chevalier",0

intro:
    ld hl, format_string_16
    ld hl, carrs
    
    call _runindicoff
    call _clrLCD    

    ld b, 26
    ld d, 102
    ld c, 0
    call DrawHoriz  
    ld b, 26
    ld c, 63
    call DrawHoriz
    ld c, 26
    ld b, 0
    call DrawVert
    ld c, 102
    ld b, 0
    call DrawVert

    ld b, 32
    ld c, 3
    ld hl, invite0
    call PutSprite16
    ld b, 48
    ld hl, invite01
    call PutSprite16
    ld b, 64
    ld hl, invite02
    call PutSprite16
    ld b, 80
    ld hl, invite03
    call PutSprite16    ; affiche "Clickers" en monotype Corsiva (sprites)

    ld a,17
    ld (_penRow),a
    ld a,46
    ld (_penCol),a
    ld hl, invite1
    call _vputs         ; Affiche "version 1.0"

    ld a,24
    ld (_penRow),a
    ld a,31
    ld (_penCol),a
    ld hl, invite2
    call _vputs         ; Affiche "par Thibaut Chevalier"

    ld a,34
    ld (_penRow),a
    ld a,35
    ld (_penCol),a
    ld hl, invite10
    call _vputs         ; Affiche "Facile"
    ld a,41
    ld (_penRow),a
    ld a,35
    ld (_penCol),a
    ld hl, invite11
    call _vputs         ; Affiche "Moyen"
    ld a,48
    ld (_penRow),a
    ld a,35
    ld (_penCol),a
    ld hl, invite12
    call _vputs         ; Affiche "Dur"
    ld a,55
    ld (_penRow),a
    ld a,35
    ld (_penCol),a
    ld hl, invite14
    call _vputs         ; Affiche "Quit."

getdebut:
    call GET_KEY  
    cp K_F1
    jr z, partie_facile
    cp K_F2
    jr z, partie_moyen
    cp K_F3
    jr z, partie_dur
    cp K_F5
    jp z, fin
    cp K_EXIT
    jp z, fin

    jr getdebut

partie_facile:
    ld hl, counter2
    ld (hl), 20         ; partie facile = 20 mlanges
    jr maarche
partie_moyen:
    ld hl, counter2
    ld (hl), 40         ; partie moyen = 40 mlanges
    jr maarche
partie_dur:
    ld hl, counter2
    ld (hl), 60         ; partie dur = 60 mlanges
    jr maarche

no_string_found:
    ret

maarche:
    call _clrLCD        ; dessine le cadre dans la partie gauche de l'cran
    ld b, 2
    ld d, 60
    ld c, 0
    call DrawHoriz      ; dessine une ligne horizontale entre les points (b,c) et (d,c)
    ld b, 2    
    ld c, 1             ; d n'est pas modifi pendant la routine
    call DrawHoriz
    ld b, 2    
    ld c, 62
    call DrawHoriz
    ld b, 2    
    ld c, 63
    call DrawHoriz
    ld b, 2    
    ld c, 11
    call DrawHoriz
    ld b, 2    
    ld c, 13
    call DrawHoriz
    ld b, 2    
    ld c, 32
    call DrawHoriz
    ld b, 2    
    ld c, 34
    call DrawHoriz    
    ld c, 0
    ld b, 0
    ld d, 63
    call DrawVert
    ld c, 1
    ld b, 0
    call DrawVert
    ld c, 61
    ld b, 0
    call DrawVert
    ld c, 62
    ld b, 0
    call DrawVert
    
                        ; VOICI la partie la + interressante je pense : recherche de strings au bon format dans le VAT (variable allocation table)
                        ; Regarder http://guide.ticalc.org pour des informations precises, ici vous avez un exemple prcis
    ld bc, (256*3)+6
    ld (_penCol),bc
    ld hl, invite21
    call _vputs         ; affiche invite 21
    ld a, 1
    ld (vat_empty), a   ; vat_empty = 1 (vous verrez l'utilit + tard)
new_recherch:
    ld hl, $bfff
    ld (cur_vat), hl    ; cur_vat = adresse du dbut du vat   
su_recherch:
    ld a, $0c           ; on va chercher des STRINGs ; format string = $0c
    ld hl, (cur_vat)    ; adresse du dbut de la recherche ($bfff la 1ere fois et l'adresse sauvegarde en fin d'une recherche precedente les autres fois
    call vatsrch        ; routine contenue dans le fichier inclus
    jp c, check_emptyness   ; si carry est set, pas de string trouv a partir de cette adresse (cur_vat)
    ld (cur_vat), hl    ; donc, ici, on a trouv un string ; sauvegarde de l'adresse ou l'on s'est arret pour les scrutages ultrieurs
    ld de, _OP1         
    call copy_to_op1    ; cette routine fait aussi partie du fichier inclus : elle copie le nom du string trouv qui tait stock en arriere a l'adresse hl en avant  l'adresse de = _OP1 dans l'OP1
    call check_comp     ; contrle du format : si il est bon, continue, sinon jump a su_recherch apres avoir pop l'adresse de dpart du call
    ld hl, _OP1         ; hl pointe sur : 'format'-'longueur du nom'-'nom
    inc hl              ; hl pointe sur : 'longueur du nom'-'nom
    ld b, (hl)          ; b = longueur du nom a afficher (pour la routine _vputsn)
    inc hl              ; hl pointe sur le 1er caractre du nom
    call put_blank      ; efface la zone ou on va afficher le nom du string
    call _vputsn        ; affiche le nom du string (valide) : longueur = b
    ld e, 64            ; e est la valeur du dcalage horizontal pour l'affichage de l'image
    call aff_ordonn    ; routine qui affiche l'image selectionne
    ld bc, (256*40)+11
    ld (_penCol),bc
    ld hl, invite22
    call _vputs         ; affiche "2nd - select"
    ld bc, (256*48)+10
    ld (_penCol),bc
    ld hl, invite23
    call _vputs         ; affiche "Enter - Play!"
    jp search_key_loop  ; vers la platemorme directionnelle "accepter cette image" ou "voir la suivante"

put_blank:
    push hl             ; efface la zone ou l'on veut afficher le nom de l'image
    ld hl, blank
    ld de,(256*20)+5  
    ld (_penCol),de
    call _vputs
    ld de,(256*20)+16
    ld (_penCol),de
    pop hl              ; hl et b ne sont pas modifis
    ret

check_comp:
    ld de, $f206        ; un petit bloc de mmoire a partir de $f206 sert de mmoire transitoire
    ld hl, _OP1
    ld bc, 11
    ldir
    ld hl, $f205
    ld de,_OP1      
    ld bc,11        
    ldir                ; on dcale le contenu de l'OP1 un octet en avant pour qu'il pointe sur la longueur du nom et nom le format de la variable (string = $0c)   
    rst 10h             ; pareil que 'call _FindSym'
    ex de, hl
    ld a, b
    call _ahl_Plus_2_Pg3
    call $4647          ;_Set_ABS_Src_Addr 
    ld a, 0
    ld hl, carrs
    call _Set_ABS_Dest_Addr
    ld a, 0
    ld hl, 544
    call _Set_MM_Num_Bytes  ; copie de 544 octets de long
    call _MM_Ldir       ; copie du contenu du string (enfin!, et meme si le format est mauvais) a l'adresse "carrs", en fin de programme (il y a assez de place libre derrire)
    ld hl, carrs
    ld de, 33
    ld b, 16
format_string_16:       ; cette routine contrle si tous les 34 octets, on a la squence 16,16 indispensable pour la routine PutSprite16 
    ld a, (hl)
    cp 16
    jr nz, wrong_format
    inc hl
    ld a, (hl)
    cp 16
    jr nz, wrong_format
    add hl, de
    djnz format_string_16
    ret             ; si le format est bon, l'image est bien copie a l'adresse "carrs" (retour aprs call check_comp)
wrong_format:       ; le string n'est pas au format "Clickers"
    pop bc          ; pope l'adresse du dernier 'call' (call check_comp)
    jp su_recherch  ; et jumpe
    
check_emptyness:    ; un passage ici indique que l'on a atteint la fin du vat
    ld a, (vat_empty)
    cp 1
    jr z, no_pic    ; si vat_empty vaut tjrs 1, c'est que l'on a atteint la fin du vat et trouv aucune image (si on en avait trouv une, vat_empty serait  0)
    jp new_recherch ; sinon, c'est qu'il y a au moins une image dans la calc, et on a atteint la fin du vat : on relance donc une nouvelle recherche

no_pic:             ; pas d'image trouve, affichage des messages d'erreur et sortie du prog
    ld bc, (256*20)+5
    ld (_penCol),bc
    ld hl, nothing_found
    call _vputs
    ld bc, (256*40)+9
    ld (_penCol),bc
    ld hl, invite24
    call _vputs
    ld bc, (256*48)+10
    ld (_penCol),bc
    ld hl, invite25
    call _vputs
    call _pause         ; cette commande est la meme que la commande basic 'PAUSE', interressant, non ??
    jp fin

search_key_loop:
    xor a               ; pareil que ld a, $00
    ld (vat_empty), a   ; on a trouv au moins une image, donc on reset vat_empty pour le montrer
    call GET_KEY
    cp K_EXIT
    jp z, fin
    cp K_SECOND
    jp z, su_recherch   ; recherche de l'image suivante
    cp K_ENTER
    jr nz, search_key_loop
      
go_go_go:               ; debut du jeu avec l'image choisie   
    ld hl, posx
    ld (hl), 0
    ld hl, posy
    ld (hl), 0
    ld hl, deboupas
    ld (hl), 0
    ld hl, preced
    ld (hl), 0

    call _clrLCD

    ld b, 65
    ld c, 4
    ld hl, invite0
    call PutSprite16
    ld b, 81
    ld hl, invite01
    call PutSprite16
    ld b, 97
    ld hl, invite02
    call PutSprite16
    ld b, 113
    ld hl, invite03
    call PutSprite16        ; affiche "Clickers" en monotype Corsiva

; remplissage du tableau qui indique quel bout d'image contient chacune des 16 zones de l'cran
    xor a           ; reset a
    ld hl, cases
tabl_fill:
    ld (hl), a
    inc hl
    inc a 
    cp 16
    jr nz, tabl_fill    

    ld e, 0                     ; e est la valeur du dcalage horizontal pour l'affichage de l'image
    call aff_ordonn            ; routine qui affiche l'image dans le bon ordre
    
drawdecor:

    ld b, 65
    ld d, 127
    ld c, 0
    call DrawHoriz
    ld b, 65    
    ld c, 1
    call DrawHoriz
    ld b, 65    
    ld c, 62
    call DrawHoriz
    ld b, 65    
    ld c, 63
    call DrawHoriz
    ld c, 65
    ld b, 0
    ld d, 63
    call DrawVert
    ld c, 66
    ld b, 0
    call DrawVert
    ld c, 126
    ld b, 0
    call DrawVert
    ld c, 127
    ld b, 0
    call DrawVert

    ld b, 66
    ld d, 125
    ld c, 20
    call DrawHoriz
    ld b, 66
    ld c, 22
    call DrawHoriz

    ld a,24
    ld (_penRow),a
    ld a,68
    ld (_penCol),a
    ld hl, invite5
    call _vputs         ; Affiche "En mlange..."
    
    ld b, 71
    ld d, 79
    ld c, 46
    call DrawHoriz
    ld b, 84
    ld d, 92
    call DrawHoriz
    ld b, 98
    ld d, 106
    call DrawHoriz
    ld b, 112
    ld d, 120
    call DrawHoriz
    ld c, 79
    ld b, 38
    ld d, 46
    call DrawVert
    ld c, 92
    ld b, 38
    call DrawVert
    ld c, 106
    ld b, 38
    call DrawVert
    ld c, 120
    ld b, 38
    call DrawVert

    ld b, 66
    ld d, 125
    ld c, 32
    call DrawHoriz
    ld b, 66
    ld c, 34
    call DrawHoriz

    ld b, 71
    ld c, 38
    ld hl, flecheg
    call PutSprite
    ld b, 84
    ld hl, fleched
    call PutSprite
    ld b, 98
    ld hl, flecheh
    call PutSprite
    ld b, 112
    ld hl, flecheb
    call PutSprite

    ld b, 66
    ld d, 125
    ld c, 50
    call DrawHoriz
    ld b, 66
    ld c, 52
    call DrawHoriz

    ld a,54
    ld (_penRow),a
    ld a,68
    ld (_penCol),a
    ld hl, counter2
    ld a, (hl)
    cp 20
    jr z, write_facile
    cp 40
    jr z, write_moyen
    ld hl, invite19
    jr avant_loopnanan
write_facile:
    ld hl, invite17
    jr avant_loopnanan
write_moyen:
    ld hl, invite18
avant_loopnanan:
    call _vputs         ; Affiche le niveau : facile, moyen ou dur
    
loopnanan:              ; C'est la mme routine qui gre le mlange automatique du dbut et la manipulation des carrs par vous aprs

    ld hl, counter2
    ld a, (hl)
    inc a
    ld (hl), a          ; Incremente counter2 car aucun sprite n'a t dplac

loop:

    ld hl, deboupas     ; contrle si c'est le melange initial (deboupas = 0 <=> mlange initial)
    ld a, (hl)
    cp 1
    jp z, inverted      ; Si non, va au getkey
    
    ld hl, counter2
    ld a, (hl)
    dec a
    ld (hl), a  
    cp 0                ; Teste si le jeu a t mlang le bon nombre de fois
    jr nz, looop        ; Si non, va gnrer une direction alatoire
    ld hl, deboupas     ; ici donc le mlange est fini
    ld (hl), 1          ; Change la variable "mlange initial ou pas" indiquant la fin du mlange
    
looop:                  ; cette partie est peu commente car c'est de la logique alatoire pour mlanger le jeu le mieux possible donc elle prsente peu d'intert pour vous
    ld hl, posx 
    ld a, (hl)
    ld hl, posy
    ld b, (hl)
    sla b
    sla b
    add a, b
    cp 0
    jp z, coinhg
    cp 3
    jp z, coinhd
    cp 12
    jp z, coinbg
    cp 15
    jp z, coinbd
normal:
    ld a,4
    call Random        ; Nombre alatoire entre 0 et 3
    inc a              ; Incremente pour avoir un nombre 1-4    

    cp 1               ;
    jp z, droitetrans  ;
    cp 2               ; Va au contrle de la direction prcedente
    jp z, gauchetrans  ; suivant la direction definie au "hasard"
    cp 3               ;
    jp z, hauttrans    ;
    cp 4               ;
    jp z, bastrans     ;
droitetrans:            
    ld hl, preced
    ld a, (hl)
    cp 2
    jr z, normal
    ld hl, preced
    ld (hl), 1
    jp droite
gauchetrans:            
    ld hl, preced
    ld a, (hl)
    cp 1
    jr z, normal
    ld hl, preced
    ld (hl), 2
    jp gauche
hauttrans:          
    ld hl, preced
    ld a, (hl)
    cp 4
    jr z, normal
    ld hl, preced
    ld (hl), 3
    jp haut
bastrans:           
    ld hl, preced
    ld a, (hl)
    cp 3
    jr z, normal
    ld hl, preced
    ld (hl), 4
    jp bas
coinhg:
    ld hl, preced
    ld a, (hl)
    cp 1
    jr z, met_3
    cp 4
    jr z, met_2
coinhd:
    ld hl, preced
    ld a, (hl)
    cp 2
    jr z, met_3
    cp 4
    jr z, met_1
coinbg:
    ld hl, preced
    ld a, (hl)
    cp 3
    jr z, met_2
    cp 1
    jr z, met_4
coinbd:
    ld hl, preced
    ld a, (hl)
    cp 3
    jr z, met_1
    cp 2
    jr z, met_4
met_1:
    ld hl, preced
    ld (hl), 1
    jp droite
met_2:
    ld hl, preced
    ld (hl), 2
    jp gauche
met_3:
    ld hl, preced
    ld (hl), 3
    jp haut
met_4:
    ld hl, preced
    ld (hl), 4
    jp bas


inverted:
    ld b, 71
    ld c, 38
    ld hl, flecheg
    call PutSprite
    ld b, 84
    ld hl, fleched
    call PutSprite
    ld b, 98
    ld hl, flecheh
    call PutSprite
    ld b, 112
    ld hl, flecheb
    call PutSprite      ; Redessine les flches (dans le menu a droite) en noir sur blanc)
                        ; on inverse ensuite les flches appropries
    ld hl, posx 
    ld a, (hl)
    cp 0
    call nz, invertd    ; Inverse droite si le curseur n'est pas a gauche de l'cran
    ld hl, posx 
    ld a, (hl)
    cp 3
    call nz, invertg    ; Inverse gauche si le curseur n'est pas a droite de l'cran

    ld hl, posy
    ld a, (hl)
    cp 0
    call nz, invertb    ; Inverse bas si le curseur n'est pas en haut de l'cran
    ld hl, posy
    ld a, (hl)
    cp 3
    call nz, inverth    ; Inverse haut si le curseur n'est pas en bas de l'cran

    ld de, 0
    ld hl, reussite
    ld (hl), 0
incit:                  ; Calcule le nombre de carrs bien placs
    inc e
    ld a, e
    cp 16
    jr z, affichit
    ld hl, cases
    add hl, de
    ld a, (hl)
    cp e
    jr nz, incit
    ld hl, reussite
    ld a, (hl)
    inc a
    ld (hl), a
    cp 15
    jp z, c_gagne       ; si 15 sont bien placs, c'est gagn
    jr incit        

affichit:
    ld a,24
    ld (_penRow),a
    ld a,68
    ld (_penCol),a
    ld hl, invite6  
    call _vputs         ; Affiche "Rsolus :"
    ld b, 118
    ld c, 24
    ld hl, pourct
    call PutSprite      ; Affiche "%"
    ld a, 109   
    ld (_penCol),a

    ld hl, reussite
    ld c, (hl)
    ld a, c 
    cp 0
    jr z, posdroite
    cp 1
    jr z, posdroite
    cp 15
    jr z, posgauche
affichit2:
    ld b, 0
    ld hl, tableau
    add hl, bc
    ld c, (hl)
    ld h, 0
    ld l, c
    call DisplayHL      ; Affiche le bon pourcentage de reussite
    jr reloop
posdroite:
    ld a, 113   
    ld (_penCol),a
    jr affichit2        ; Pour afficher 0 ou 7 %
posgauche:
    ld a, 105   
    ld (_penCol),a      ; Pour afficher 100 %
    jr affichit2

reloop:

    call GET_KEY

    cp  K_EXIT
    jp  z,fin   
    cp  K_UP
    jp  z,haut
    cp  K_DOWN
    jp  z,bas
    cp  K_LEFT
    jp  z,gauche
    cp  K_RIGHT
    jp  z,droite
    cp  K_MORE  
    jp  z, menu
    cp  K_PLUS  
    jp  z, contrastplus
    cp  K_MINUS
    jp  z, contrastmoins

    ld a,%00111111      
    out (1),a           
    nop                 
    nop
    in a,(1)                   
    bit 5,a
    jr nz, reloop   ; Retourne  reloop si enter n'est pas press
    jp initpic      ; Affiche l'image de dpart si enter est press 

reduce:
    push bc
    push bc
    
    ld a, b
    ld d, c
    sla d           ;
    sla d           ;
    add a, d        ;
    ld hl, kelcase  ;
    ld (hl), a      ; Calcule la valeur de la "case"

    pop bc          ; rcupere bc
    ld h, b
    ld l, 16
    call mlt_hl     ; rcupre en e la position du sprite a dplacer en x
    ld hl, spriteposx   ; la store
    ld (hl), e

    pop bc          ; rcupere bc
    ld h, c
    ld l, 16
    call mlt_hl     ; rcupre en e la position du sprite a dplacer en y
    ld hl, spriteposy   ; la store
    ld (hl), e

    ld hl, kelsens
    ret

gauche:
    ld hl, posx     ;
    ld a, (hl)      ;
    cp 3            ;
    jp z, loopnanan ; Teste si deplacement impossible
    
    ld b, (hl)      ; Charge posx
    inc b           ; coord en x de la case a dplacer
    ld hl, posy
    ld c, (hl)      ; Charge posy = coord en y de la case a dplacer
    ld hl, possx        
    ld (hl), b      ; Sauvegarde la valeur de posx modifie
    ld hl, possy
    ld (hl), c      ; Sauvegarde la valeur de posy modifie
    
    call reduce
    
    ld (hl), 1      ; Indique dans quel sens il faut deplacer le sprite (vers la gauche car on a appuy a gauche)

    call deplacit
    jp loop

droite:
    ld hl, posx     ;
    ld a, (hl)      ;
    cp 0            ;
    jp z, loopnanan ; Teste si deplacement impossible
    
    ld b, (hl)      ; Charge posx
    dec b           ; coord en x de la case a dplacer
    ld hl, posy     ;
    ld c, (hl)      ; Charge posy = coord en y de la case a dplacer
    ld hl, possx        
    ld (hl), b      ; Sauvegarde la valeur de posx modifie
    ld hl, possy
    ld (hl), c      ; Sauvegarde la valeur de posy modifie
    
    call reduce
    
    ld (hl), 2      ; Indique dans quel sens il faut deplacer le sprite (vers la droite car on a appuy a droite)

    call deplacit
    jp loop


haut:
    ld hl, posy     ;
    ld a, (hl)      ;
    cp 3            ;
    jp z, loopnanan ; Teste si deplacement impossible
    
    ld hl, posx
    ld b, (hl)      ; Charge posx = coord en x de la case a dplacer
    ld hl, posy     ;
    ld c, (hl)      ; Charge posy = coord en y de la case a dplacer
    inc c           ; coord en y de la case a dplacer
    ld hl, possx        
    ld (hl), b      ; Sauvegarde la valeur de posx modifie
    ld hl, possy
    ld (hl), c      ; Sauvegarde la valeur de posy modifie 

    call reduce

    ld (hl), 3      ; Indique dans quel sens il faut deplacer le sprite (vers le haut car on a appuy en haut)

    call deplacit
    jp loop

bas:
    ld hl, posy     ;
    ld a, (hl)      ;
    cp 0            ;
    jp z, loopnanan ; Teste si deplacement impossible
    
    ld hl, posx
    ld b, (hl)      ; Charge posx = coord en x de la case a dplacer
    ld hl, posy     ;
    ld c, (hl)      ; Charge posy = coord en y de la case a dplacer
    dec c           ; coord en y de la case a dplacer
    ld hl, possx        
    ld (hl), b      ; Sauvegarde la valeur de posx modifie
    ld hl, possy
    ld (hl), c      ; Sauvegarde la valeur de posy modifie
    
    call reduce
    
    ld (hl), 4      ; Indique dans quel sens il faut deplacer le sprite (vers le bas car on a appuy en bas)

    call deplacit
    jp loop



deplacit:

    ld a, 16
    ld hl, counter
    ld (hl), a          ; Charge la valeur initiale du counter
    
    ld hl, spriteposx   
    ld b, (hl)          ; Charge la coordonne en x du sprite
    ld hl, spriteposy
    ld c, (hl)          ; Charge la coordonne en y du sprite

reboucle:
    ld hl, carroff
    call PutSprite16

    call le_bon_sens    ; s'occupe de changer les coordones du sprite
    call le_bon_sprite  ; S'occupe d'enregistrer la bonne adresse du sprite dans hl pour le dbut de la routine Putsprite
    ld hl, spriteposx
    ld b, (hl)
    ld hl, spriteposy
    ld c, (hl)          ; Recharge les coordonnes du Sprite pour l'affichage
    ld h, d
    ld l, e
    call PutSprite16    ; Raffiche le sprite  l'cran

    ld hl, deboupas 
    ld a, (hl)
    cp 0
    jr z, apres_halt    ; Saute les "halt" si c'est le melange initial
    halt                ; ralentit  
    halt                ; ralentit

apres_halt:
    ld hl, counter      ; Charge la valeur du counter
    ld a, (hl)          ;
    dec a               ; teste si le sprite est arriv au bout de son chemin
    jr z, fin_de_slide  ; si oui, va au label
    ld (hl), a          ; sinon, recharge la valeur de counter dans counter
    jr reboucle         ; reboucle
fin_de_slide
    ld hl, kelcase      ; Charge la valeur du dcalage
    ld c, (hl)
    ld hl, cases        ; Fait pointer  l'adresse de dpart de la colonne
    or a                ; force carry  0
    ld b, 0
    adc hl, bc          ; Fait l'addition pour determiner la colonne
    ld d, (hl)          ; Charge la valeur qui s'y trouve dans d
    ld (hl), 0          ; Met 0 dans la nouvelle case noire pour permettre le bon comptage des carrs bien placs

    ld hl, posx
    ld a, (hl)
    ld hl, posy
    ld b, (hl)
    sla b
    sla b
    add a, b            ; place de l'ancienne case blanche en a
    ld c, a             ; maintenant en c
    ld hl, cases        ; Fait pointer  l'adresse de dpart de la colonne
    or a                ; force carry  0
    ld b, 0
    adc hl, bc          ; Fait l'addition pour determiner la place dans la colonne
    ld (hl), d          ; sauvegarde la valeur de la case qui s'est deplace dans l'ancienne case noire

    

    ld hl, possx        ;
    ld b, (hl)          ;
    ld hl, possy        ;
    ld c, (hl)          ;
    ld hl, posx     
    ld (hl), b          ; Met a jour posx apres modification
    ld hl, posy
    ld (hl), c          ; Met a jour posy apres modification

    ret                 ; Fin de dplacit




le_bon_sens:
    ld hl, kelsens      ;
    ld a, (hl)          ;
    cp 1                ;
    jr z, slideleft     ;
    ld a, (hl)          ;
    cp 2                ;
    jr z, slideright    ; Plateforme directionelle vers slideleft, slideright, slideup ou slidedown suivant la valeur de kelsens
    ld a, (hl)          ;
    cp 3                ;
    jr z, slideup       ;
    ld a, (hl)          ;
    cp 4                ;
    jr z, slidedown     ;
slideleft:
    ld hl, spriteposx   ; Met  jour le pointeur
    ld a, (hl)          ; Charge spriteposx pour opration
    dec a               ; opration
    ld (hl), a          ; Charge la nouvelle valeur de spriteposx en spriteposx
    jr fin_du_bon_sens  ; Met fin  la routine "le_bon_sens" en allant au label
slideright:
    ld hl, spriteposx   ; Met  jour le pointeur
    ld a, (hl)          ; Charge spriteposx pour opration
    inc a               ; opration
    ld (hl), a          ; Charge la nouvelle valeur de spriteposx en spriteposx
    jr fin_du_bon_sens  ; Met fin  la routine "le_bon_sens" en allant au label
slideup:
    ld hl, spriteposy   ; Met  jour le pointeur
    ld a, (hl)          ; Charge spriteposy pour opration
    dec a               ; opration
    ld (hl), a          ; Charge la nouvelle valeur de spriteposy en spriteposy
    jr fin_du_bon_sens  ; Met fin  la routine "le_bon_sens" en allant au label
slidedown:
    ld hl, spriteposy   ; Met  jour le pointeur
    ld a, (hl)          ; Charge spriteposxy pour opration
    inc a               ; opration
    ld (hl), a          ; Charge la nouvelle valeur de spriteposxy en spriteposxy
    jr fin_du_bon_sens  ; Met fin  la routine "le_bon_sens" en allant au label
fin_du_bon_sens:
    ret


le_bon_sprite:
    ld hl, kelcase      ; Charge la valeur du dcalage
    ld c, (hl)
    ld hl, cases        ; Fait pointer  l'adresse de dpart de la colonne
    or a                ; force carry  0
    ld b, 0
    adc hl, bc          ; Fait l'addition pour determiner la colonne
    ld a, (hl)          ; Charge la valeur qui s'y trouve dans a

    ld h, a
    ld l, 34
    call mlt_hl
    ld hl, carrs       ; dbut des adresses des carrs
    add hl, de          ; L'adresse du bon carr
    ld d, h
    ld e, l
    ret


invertg:                ; inversion de la fleche gauche
    ld b, 7
    ld hl, $FE79
lblg:
    ld a, (hl)
    xor $FE
    ld (hl), a
    ld de, $10
    add hl, de
    djnz lblg
    ret

invertd:
    ld b, 7
    ld hl, $FE7A
lbld:
    ld a, (hl)
    xor $07
    ld (hl), a
    inc l
    ld a, (hl)
    xor $F0
    ld (hl), a
    ld de, $F
    add hl, de
    djnz lbld
    ret

inverth:
    ld b, 7
    ld hl, $FE7C
lblh:
    ld a, (hl)
    xor $1F
    ld (hl), a
    inc l
    ld a, (hl)
    xor $C0
    ld (hl), a
    ld de, $F
    add hl, de
    djnz lblh
    ret

invertb:
    ld b, 7
    ld hl, $FE7E
lblb:
    ld a, (hl)
    xor $7F
    ld (hl), a
    ld de, $10
    add hl, de
    djnz lblb
    ret

c_gagne:
    ld a,24 
    ld (_penRow),a
    ld a,105    
    ld (_penCol),a
    ld h, 0
    ld l, 100
    call DisplayHL      ; Affiche 100%

inversion_suivante:         ; inversion de la zone "complete : 100%"
    ld hl, $FD78
    ld d, 9
ligne_suivante:
    ld a, (hl)
    xor $1F
    ld (hl), a
    inc l
    ld a, (hl)
    ld b, 6
inv_loop
    xor $FF
    ld (hl), a
    inc l
    ld a, (hl)
    djnz inv_loop
    xor $FC
    ld (hl), a              ; Inverse la ligne

    ld bc, 9
    add hl, bc              ; passe  la ligne suivante
    dec d
    jr nz, ligne_suivante   ; Reboucle si il reste encore des lignes a inverser

    call GET_KEY
    cp  K_ENTER
    jp  z, intro    
    cp  K_EXIT
    jp  z, intro

    ld b, 18        
loop_gris:
    halt                    ; Rallentissement
    djnz loop_gris
    jr inversion_suivante


aff_ordonn:                ; affiche l'image ordonne (input : e est le dcalage horizontal 0 <= e <= 64)
    ld b, 0
    ld c, 0
    ld d, 0
for_bp:
    push bc
    sla b
    sla b
    sla b
    sla b           
    ld a, e
    add a, b
    ld b, a             ; b=16b+e
    sla c
    sla c
    sla c
    sla c               ; c=16c   --> (b,c) = coordones du sprite
    push bc
    push de
    ld h, d
    ld l, 34
    call mlt_hl
    ld hl, carrs       ; dbut des adresses des carrs
    add hl, de          ; L'adresse du bon carr
    pop de
    pop bc              ; Recupre b,c
    push de
    call PutSprite16    ; Affiche le sprite
    pop de
    pop bc
    inc d
    inc b               ; passe  la colonne suivante
    ld a, b
    cp 4
    jr z, next_bp       ; si la colonne = 4, passe  la ligne suivante
    jr for_bp
next_bp:
    ld b, 0
    inc c
    ld a, c
    cp 4
    ret z
    jr for_bp

initpic: 
    ld e, 0
    call aff_ordonn   
    
getview:
    ld a,%00111111
    out (1),a 
    nop
    nop
    in a,(1)
    bit 5,a
    jp z, reloop        ; Va au label tant que 2nd est press. Quand 2nd est relach, passe  affichage dsordonn
    call affichage_desordonne
    jp reloop

affichage_desordonne:
    ld b, 0
    ld c, 0
    ld d, 0             ; Counter de 0  15
for_b3:
    push bc
    sla b
    sla b
    sla b
    sla b               ; b=16b+32
    sla c
    sla c
    sla c
    sla c               ; c=16c --> (b,c) = coordones du sprite
    push bc

    push de
    ld hl, cases        ; Additionne l'adresse de depart de cases avec counter (=d) 
    ld b, 0
    ld c, d
    add hl, bc
    ld d, (hl)          ; d est la valeur de 0  15 du sprite  afficher

    ld h, d
    ld l, 34
    call mlt_hl
    ld hl, carrs       ; dbut des adresses des carrs
    add hl, de          ; L'adresse du bon carr
    pop de
    pop bc              ; Recupre b,c
    push de
    call PutSprite16    ; Affiche le sprite

    pop de
    pop bc
    inc d
    inc b
    ld a, b
    cp 4
    jr z, next_b3
    jr for_b3

next_b3:
    ld b, 0
    inc c
    ld a, c
    cp 4
    ret z
    jr for_b3

;-------------------- Gestion du contraste -----------------------

contrastplus:
    ld a, ($C008)   ; recupre la valueur du contraste
    inc a           ; l'incremente
    ld ($C008), a   ; la sauvegarde
    out (2), a      ; envoie la nouvelle valeur au port 2 (qui gre le contraste) : $C008 est juste une valeur image de contraste
    jp reloop

contrastmoins:
    ld a, ($C008)   ; c'est la mme chose
    dec a
    ld ($C008), a
    out (2), a
    jp reloop

;---------------------- Gestion des menus ------------------------

efface_menu:
    ld hl, $FC00
    ld b, 64
effaceg:
    ld (hl), 0
    inc l
    ld a, l
    and $0F
    cp 8
    jr nz, effaceg
    ld de, 8
    add hl, de
    dec b
    ld a, b
    jr nz, effaceg
    
    ld b, 1
    ld d, 62
    ld c, 1
    call DrawHoriz
    ld b, 1
    call DrawVert
    ld b, 1
    ld c, 62
    call DrawHoriz
    ld b, 1
    call DrawVert
    ret

menu:
    call efface_menu    
    
    ld b, 8
    ld c, 4
    ld hl, invite80
    call PutSprite16
    ld b, 24
    ld hl, invite81
    call PutSprite16
    ld b, 40
    ld hl, invite82
    call PutSprite16

    ld a,22
    ld (_penRow),a
    ld a,5
    ld (_penCol),a
    ld hl, invite9
    call _vputs         ; Affiche "F1 - Nouveau jeu"

    ld a,29
    ld (_penRow),a
    ld a,5
    ld (_penCol),a
    ld hl, invite20
    call _vputs         ; Affiche "F3 - Calc off"

    ld a,36
    ld (_penRow),a
    ld a,5
    ld (_penCol),a
    ld hl, invite13
    call _vputs         ; Affiche "F4 - retour" 

    ld a,43
    ld (_penRow),a
    ld a,5
    ld (_penCol),a
    ld hl, invite14
    call _vputs         ; Affiche "F5 - quitter"    


getmenu:        
    call GET_KEY
    cp K_F1
    jp z, menu_nouveau_jeu
    cp K_F3
    jr nz, suite_getmenu
; Ceci teint la calculette pendant le programme; celui ci se continue au mme endroite quand elle rallume
;-----------------------------------------------------------------------------------------------------------
    ld a,$01
    out ($03),a      ; teint calc
    halt
    ld a,$0B
    out ($03),a
    res 4,(iy+$09)
;-----------------------------------------------------------------------------------------------------------
suite_getmenu:    
    cp K_F4
    jr z, menuretour
    cp K_F5
    jr z, fin
    cp K_EXIT
    jr z, menuretour

    jr getmenu

menu_nouveau_jeu:
    
    call efface_menu
    
    ld a,3
    ld (_penRow),a
    ld a,10
    ld (_penCol),a
    ld hl, invite16
    call _vputs         ; Affiche "- Nouveau jeu -"

    ld a,20
    ld (_penRow),a
    ld a,3 
    ld (_penCol),a
    ld hl, invite10
    call _vputs         ; Affiche "F1 - niveau facile"

    ld a,27
    ld (_penRow),a
    ld a,3 
    ld (_penCol),a
    ld hl, invite11
    call _vputs         ; Affiche "F2 - niveau moyen"

    ld a,34
    ld (_penRow),a
    ld a,3
    ld (_penCol),a
    ld hl, invite12
    call _vputs         ; Affiche "F3 - niveau dur" 

    ld a,41
    ld (_penRow),a
    ld a,3
    ld (_penCol),a
    ld hl, invite15
    call _vputs         ; Affiche "F4 - precedent"  

getmenu2:       
    call GET_KEY
    cp K_F1
    jp z, partie_facile
    cp K_F2
    jp z, partie_moyen
    cp K_F3
    jp z, partie_dur
    cp K_F4
    jp z, menu
    cp K_EXIT
    jp z, menu

    jr getmenu2


menuretour:
    call affichage_desordonne   ; Recompose l'cran
    jp reloop                   ; Retourne


fin:    
    call _clrLCD
    ret         ; Fin du programme


; =============================================================
; Dan Eble & James Yopp FindPixel routine
; Input:  D = y, E = x
; Output: HL= addr in vid mem, A = bitmask, C is modified
; =============================================================
FindPixel:
        ld hl,FP_Bits
        ld a,e
        and $07         ; a = bit offset
        add a,l
        ld l,a
        adc a,h
        sub l
        ld h,a
        ld c,(hl)       ; c = bitmask for (hl)
;48 t-states up to this point
        ld hl,FP_RLD
        ld (hl),d
        ld a,e          ; a = x/8 (byte offset within row)
        rrca
        rrca   
        rrca
        rld
        or $FC 
        ld l,(hl)
        ld h,a          ; hl -> byte in vid mem
        ld a,c          ; now a = bitmask for (hl)
;121 t-states up to this point
        ret

FP_RLD:  .db $00
FP_Bits: .db $80,$40,$20,$10,$08,$04,$02,$01


PutSprite:

 push bc                        ; Save BC (X, Y) 
 push de                        ; Save DE
 push hl                        ; Save HL (Start of Sprite Data)
 push hl                        ; Save HL (Start of Sprite Data)

 push bc
 ld d, c
 ld e, b
 call FindPixel                 ; Finds pixel at E, D
 pop bc
                                ; PutSprite needs pixel at B, C
  
                                ; A = Bitmask with one bit set; this will be the bit (pixel) "counter"

 ex de,hl                       ; DE = Address in Display of Sprite
 pop hl                         ; HL = Start of Sprite Data
 ld b,(hl)                      ; B = X width of Sprite 
 inc hl                         ; Next byte
 ld c,(hl)                      ; C = Y width of Sprite
 inc hl                         ; Next byte (now pointing at actual sprite data)
 push hl                        ; Save the twice incremented HL into stack
 pop ix                         ; IX = The recently twice incremented HL

 ex de,hl                       ; HL = Address in Display of Sprite

PS_NwRow:
 push bc                        ; Save X width of Sprite and Y width of Sprite
 ld d,(ix)                      ; D = (IX), so D = First byte from Sprite
 inc ix                         ; IX points to next row
 push af                        ; Save Bitmask 
 push hl                        ; Save HL, Address in Display of Sprite

PS_NwCol:                       ; Now the fun begins, remember A is the bitmask, D = the Left Column Byte from Sprite
 rl d                           ; Rotate D left through carry, Leftmost pixel of Sprite Byte is carry
 ld e,a                         ; E = bitmask
 jr nc,PS_NPixel                ; Check pixel from sprite to see if it is set
 or (hl)                        ; Sets Pixel at the "current bit" (Bitmask is the "bit counter")
 ld (hl),a                      ; (HL) = A, Save changes to
 jr PS_NxtPixel

PS_NPixel:
 cpl                            ; Invert Bitmask
 and (hl)                       ; Clears pixel at the "current bit" (Bitmask is the "bit counter")
 ld (hl),a                      ; (HL) = A Save changes
PS_NxtPixel:
 ld a,e                         ; A = Bitmask
 rrca                           ; A is rotated right *through* carry
 jr nc,PS_SmeByte               ; If the carry was set, that means that one bit set in A (bit counter) 
                                ;  rotated all the way to the end right into carry and recycles back into Bit 7
                                ;  so it can be used for the next byte

 inc hl                         ; Go to the next byte in the display
PS_SmeByte:
 djnz PS_NwCol                  ; B = X (width of sprite), so it loops to PS_NewCol X times. This means that is X = 6, 
                                ; it will Shift Right the bitmask (move the bit counter to the right) 6 times, comparing 
                                ; each bit of the bitmask and the sprite and setting or clearing the pixel in that
                                ; particular bit. It then moves on the the next pixel.

                                ; Move on to the next row
 pop hl                         ; Recover HL, the Address in Display of the Sprite
 pop af                         ; Recover AF, A = Bitmask
 ld de,16                       ; DE = 16
 add hl,de                      ; HL = HL + 16, this moves down ONE row in the Display Area (128 width / (8 bits/pixel) = 16 bytes)
 pop bc                         ; Recover X_width and Y_height of Sprite
 dec c                          ; C = Y_height of Sprite, subract one, which means one row of the Sprite has been drawn

 jr nz,PS_NwRow                 ; If there are more rows to be drawn, go back to PS_NewRow

; No more rows. Since there were "effectively" 3 pushes before PS_NewRow, there must be three pops that way the
; ret statement will retrieve the correct address when it returns to the calling program.

 pop hl                                         
 pop de
 pop bc
 ret


PutSprite16:

 push bc                        ; Save BC (X, Y) 
 push de                        ; Save DE
 push hl                        ; Save HL (Start of Sprite Data)
 push hl                        ; Save HL (Start of Sprite Data)

 push bc
 ld d, c
 ld e, b
 call FindPixel                 ; Finds pixel at E, D
 pop bc
                                ; PutSprite16 needs pixel at B, C
  
                                ; A = Bitmask with one bit set; this will be the bit (pixel) "counter"

 ex de,hl                       ; DE = Address in Display of Sprite
 pop hl                         ; HL = Start of Sprite Data
 ld b,(hl)                      ; B = X width of Sprite 
 inc hl                         ; Next byte
 ld c,(hl)                      ; C = Y width of Sprite
 inc hl                         ; Next byte (now pointing at actual sprite data)
 push hl                        ; Save the twice incremented HL into stack
 pop ix                         ; IX = The recently twice incremented HL

 ex de,hl                       ; HL = Address in Display of Sprite

PS_NewRow:
 push bc                        ; Save X width of Sprite and Y width of Sprite
 ld d,(ix)                      ; D = (IX), so D = First byte from Sprite
 inc ix
 ld e,(ix)                      ; E = (IX), so E = Second byte from Sprite
 inc ix                         ; IX points to next row

 push af                        ; Save Bitmask 
 push hl                        ; Save HL, Address in Display of Sprite

PS_NewCol:                      ; Now the fun begins, remember A is the bitmask, D = the Left Column Byte from Sprite, E = the Right Column Byte from Sprite
 sla e                          ; 16-bit rotation DE
 rl  d

 push af                        ; Save Bitmask
 jr nc,PS_NoPixel               ; Check pixel from sprite to see if it is set
 
 or (hl)                        ; Sets Pixel at the "current bit" (Bitmask is the "bit counter")
 ld (hl),a                      ; (HL) = A, Save changes to
 jr PS_NextPixel

PS_NoPixel:
 cpl                            ; Invert Bitmask
 and (hl)                       ; Clears pixel at the "current bit" (Bitmask is the "bit counter")
 ld (hl),a                      ; (HL) = A Save changes
PS_NextPixel:
 pop af                         ; Restore Bitmask
 rrca                           ; A is rotated right *through* carry
 jr nc,PS_SameByte              ; If the carry was set, that means that one bit set in A (bit counter) 
                                ;  rotated all the way to the end right into carry and recycles back into Bit 7
                                ;  so it can be used for the next byte

 inc hl                         ; Move on to next byte

PS_SameByte:
 djnz PS_NewCol                 ; B = X (width of sprite), so it loops to PS_NewCol X times. This means that is X = 6, 
                                ; it will Shift Right the bitmask (move the bit counter to the right) 6 times, comparing 
                                ; each bit of the bitmask and the sprite and setting or clearing the pixel in that
                                ; particular bit. It then moves on the the next pixel.

                                ; Move on to the next row
 pop hl                         ; Recover HL, the Address in Display of the Sprite
 pop af                         ; Recover AF, A = Bitmask
 ld de,16                       ; DE = 16
 add hl,de                      ; HL = HL + 16, this moves down ONE row in the Display Area (128 width / (8 bits/pixel) = 16 bytes)
 pop bc                         ; Recover X_width and Y_height of Sprite
 dec c                          ; C = Y_height of Sprite, subract one, which means one row of the Sprite has been drawn

 jr nz,PS_NewRow                ; If there are more rows to be drawn, go back to PS_NewRow

; No more rows. Since there were "effectively" 3 pushes before PS_NewRow, there must be three pops that way the
; ret statement will retrieve the correct address when it returns to the calling program.

 pop hl                                         
 pop de
 pop bc
 ret





;Russian Peasants' Algorithm
;Dux Gregis

;input= h and l
;output= de is h*l (all reg destroyed but c)

mlt_hl:
 ld de,0        ;clear de initially
 ld a,h
 cp l           ;check to see which is the greater of h and l
 jr c,mlt_start
 ld h,l
 ld l,a
mlt_start:
 ld b,h
 ld h,d         ;b is now smaller of the two, hl is the greater
mlt_loop:
 srl b          ;if bit 0 is set, add hl to de
 call c,collect_de
 ret z          ;return when b is zero (still set from srl)
 add hl,hl      ;shift hl left
 jr mlt_loop

collect_de:     ;store addition in de
 ex de,hl
 add hl,de
 ex de,hl
 ret


;====================================================================
; DisplayHL:  (idea from SCaBBy/Mardell)    [Assembly Coder's Zenith]
;  Display HL as a 5-digit decimal number with no leading zeros
;  out: AF, HL, BC, DE destroyed
;====================================================================
DisplayHL:
 ld c,'0'           ; save ascii value for zero
 ld de,_OP1+5           ; point to end of the buffer
 xor a              ; zero terminate string
 ld (de),a          ; set last byte to zero
DisplayHLl:
 call UNPACK_HL         ; next digit
 dec de             ; next position
 add a,c            ; convert to ascii
 ld (de),a          ; save digit
 ld a,h             ; load upper byte
 or l               ; check with lower byte for zero
 jr nz,DisplayHLl       ; loop
 ex de,hl           ; point to buffer
 call _vputs            ; print number
 ret                ; we're done


Random:            ; Creates a random number 0 <= x < A
 push bc
 push de
 push hl
 ld b,a
 ld a,r
 add a,a
 ld hl,0
 ld d,0
 ld e,a
RMul:
 add hl,de
 djnz RMul
 ld a,h
 pop hl
 pop de
 pop bc
 ret


; =============================================================
; Draw a line between points (b,c) and (d,c)
; =============================================================
DrawHoriz:
    push bc
    push de
    ld e, b
    ld d, c
    call FindPixel
    or (hl)            
    ld (hl), a
    pop de
    pop bc
    ld a, b
    cp d
    ret z
    inc b
    jr DrawHoriz

; =============================================================
; Draw a line between points (c,b) and (c,d)
; =============================================================
DrawVert:
    push bc
    push de
    ld e, c
    ld d, b
    call FindPixel
    or (hl)            
    ld (hl), a
    pop de
    pop bc
    ld a, b
    cp d
    ret z
    inc b
    jr DrawVert

#include "vatsrch.inc"


fleched:
.db 8, 8
.db %11111111
.db %10000000
.db %10001000
.db %10011100
.db %10011110
.db %10011100
.db %10001000
.db %10000000

flecheg:
.db 8, 8
.db %11111111
.db %10000000
.db %10001000
.db %10011100
.db %10111100
.db %10011100
.db %10001000
.db %10000000

flecheb:
.db 8, 8
.db %11111111
.db %10000000
.db %10000000
.db %10011100
.db %10111110
.db %10011100
.db %10001000
.db %10000000

flecheh:
.db 8, 8
.db %11111111
.db %10000000
.db %10001000
.db %10011100
.db %10111110
.db %10011100
.db %10000000
.db %10000000

pourct:
.db 8, 8
.db %01000000
.db %10100100
.db %01001000
.db %00010000
.db %00100100
.db %01001010
.db %00000100
.db %00000000

invite0:
.db 16,14
.db %00000000,%00000000
.db %00000000,%00111000
.db %00000000,%11000110
.db %00000001,%10000010
.db %00000011,%00000010
.db %00000110,%00000000
.db %00000110,%00000000
.db %00000110,%00000000
.db %00000110,%00000000
.db %00000110,%00000001
.db %00000110,%00001001
.db %00000011,%00010000
.db %00000000,%11100000
.db %00000000,%00000000

invite01:
.db 16,14
.db %00011100,%00000000
.db %00100001,%00000000
.db %01000000,%00000000
.db %01000000,%00000000
.db %01000110,%00001100
.db %10011010,%00110110
.db %10000100,%01000000
.db %10000100,%01000000
.db %10001100,%11000000
.db %00101000,%11001101
.db %11001110,%01110001
.db %00000000,%00000000
.db %00000000,%00000000
.db %00000000,%00000000

invite02:
.db 16,14
.db %00011110,%00000000
.db %00100000,%00000000
.db %01000000,%00000000
.db %01000000,%00000000
.db %01001100,%00111000
.db %11110100,%01001011
.db %11001100,%10001000
.db %11110000,%11110000
.db %10100001,%10000000
.db %10010001,%10011001
.db %00011000,%11100001
.db %00001000,%00000000
.db %00001100,%01000000
.db %00000111,%10000000
invite03:
.db 16,14
.db %00000000,%00000000
.db %00000000,%00000000
.db %00000000,%00000000
.db %00000000,%00000000
.db %10011001,%10000000
.db %10100010,%01000000
.db %11000010,%00000000
.db %10000011,%00000000
.db %10000001,%10000000
.db %00001000,%10000000
.db %00001111,%00000000
.db %00000000,%00000000
.db %00000000,%00000000
.db %00000000,%00000000

invite80:
.db 16,10
.db %00000000,%11111000
.db %00000011,%00011000
.db %00000100,%00011000
.db %00000100,%00111000
.db %00000010,%00111001
.db %11000000,%00101010
.db %11000000,%01001100
.db %00000000,%11001100
.db %00000001,%10001001
.db %00001110,%00000001
invite81:
.db 16,10
.db %00010000,%00000000
.db %00110000,%00000000
.db %01100000,%00000000
.db %11100001,%11000100
.db %01000010,%01011101
.db %01000100,%11000110
.db %11000111,%00000100
.db %10001100,%00001000
.db %10001100,%11001000
.db %11100111,%00011000
invite82:
.db 16,10
.db %00000000,%00000000
.db %00000000,%00000000
.db %00000000,%00000000
.db %00000000,%00000000
.db %11001110,%00100000
.db %01000010,%00100011
.db %11000100,%01000011
.db %10000100,%01000000
.db %10101101,%11010000
.db %11001110,%01100000

invite1:  .db "version 1.0",0
invite2:  .db "by Thibaut Chevalier",0
invite5:  .db "Blending...",0
invite6:  .db "Complete:                     ",0
invite9:  .db "F1 - New game",0
invite10: .db "F1 - level easy",0
invite11: .db "F2 - level medium",0
invite12: .db "F3 - level hard",0
invite13: .db "F4 - Resume",0
invite14: .db "F5 - Quit",0
invite15: .db "F4 - back",0
invite16: .db "- New Game -",0
invite17: .db "      - Level easy -",0
invite18: .db " - Level medium -",0
invite19: .db "     - Level hard -",0
invite20: .db "F3 - Calc off",0
invite21: .db "Select a picture", 0
invite22: .db "2nd - Select", 0
invite23: .db "Enter - Play !", 0
invite24: .db "Send pictures", 0
invite25: .db "to your calc !", 0
nothing_found: .db "No picture found", 0
blank: .db "                                                       ", 0

tableau: .db 0,7,13,20,27,34,40,47,53,60,66,73,80,87,93,100
     .db 0
cases:   .db 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15   
     .db 0
posx: .db 0
posy: .db 0
possx: .db 0
possy: .db 0
spriteposx: .db 0
spriteposy: .db 0
kelsens: .db 0
kelcase: .db 0
counter: .db 0
counter2: .db 0
    .db 0
preced: .db 0
reussite : .db 0
      .db 0
deboupas: .db 0
      .db 0

carroff: 
.db 16, 16
.db %11111111, %11111111
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %10000000, %00000001
.db %11111111, %11111111

carrs:         ; temporary picture storage

.end

 