#include asm86.h
#include ti86asm.inc

.org _asm_exec_ram

 nop              ;Identifies the table
 jp Init
.dw $0000   	;Version # of Table
.dw TitleStr      ;Absolute pointer to program description


Init:
	call _clrLCD
	set 3,(iy+$05)
	xor a
	ld (SPos),a
	call SetText
	ld hl,TitleStr
	call _puts
	ld a,5
	call SetText
	ld hl,ChaserStr
	call _puts
	res 3,(iy+$05)
	ld a,6
	call SetText
	ld hl,ChasedStr
	call _puts
	ld a,2
	call SetText
	ld hl,AuthorStr
	call _puts
	ld a,2
	ld (_curCol),a
	ld a,3
	ld (_curRow),a	
	ld hl,EMailStr
	call _puts
	
TitleLoop:
	call _getkey
	cp kUp
	jr z,MenuSelectUp
	cp kDown
	jr z,MenuSelectDown
	cp kExit
	ret z
	cp kEnter
	jr z,ItemSelect
	jr nz,TitleLoop
      
MenuSelectUp:
	ld a,(SPos)
	or a
	jr z,TitleLoop
	res 3,(iy+$05)
	ld a,6
	call SetText
	ld hl,ChasedStr
	call _puts
      set 3,(iy+$05)
	ld a,5
	call SetText
	ld hl,ChaserStr
	call _puts
	res 3,(iy+$05)
	xor a
	ld (SPos),a
	jr TitleLoop

MenuSelectDown:
	ld a,(SPos)
	cp 1
	jr z,TitleLoop
	res 3,(iy+$05)
	ld a,5
	call SetText
	ld hl,ChaserStr
	call _puts
      set 3,(iy+$05)
	ld a,6
	call SetText
	ld hl,ChasedStr
	call _puts
	res 3,(iy+$05)
	ld a,1
	ld (SPos),a
	jr TitleLoop

ItemSelect:
	ld a,(SPos)
	or a
	jp z,Chaser
	
Chased:
	call _clrLCD
	ld a,175
	ld (Timer),a
	ld (TimerX),a
	ld a,8
	ld (BallX),a
	ld (BallY),a
	ld a,50
	ld (BoxY),a
	ld (BoxX),a
	ld a,90
	ld (Ticks),a
	call DispBall
	call DispBox

ChasedLoop:
	jp DecTimer

ChasedLLoop:
	call GET_KEY
	cp K_RIGHT
	jp z,M_Right
	cp K_LEFT
	jp z,M_Left
	cp K_UP
	jp z,M_Up
	cp K_DOWN
	jp z,M_Down
	cp K_EXIT
	ret z
	jr NoKey

NoKey:
	ld a,(Ticks)
	dec a
	ld (Ticks),a
	or a
	jp z,BoxMove
	jp nz,ChasedLoop

M_Right:
	ld a,(BallX)
	cp 120
	jp z,NoKey
	call DispBall
	ld a,(BallX)
	add a,4
	ld (BallX),a
	call DispBall
	ld (Ticks),a
	jp NoKey

M_Left:
	ld a,(BallX)
	or a
	jp m,NoKey
	jp z,NoKey
	call DispBall
	ld a,(BallX)
	sub 4
	ld (BallX),a
	call DispBall
	ld a,1
	ld (Ticks),a
	jp NoKey

M_Up:
	ld a,(BallY)
	or a
	jp m,NoKey
	jp z,NoKey
	call DispBall
	ld a,(BallY)
	sub 4
	ld (BallY),a
	call DispBall
	ld a,1
	ld (Ticks),a
	jp NoKey

M_Down:
	ld a,(BallY)
	cp 56
	jp z,NoKey
	call DispBall
	ld a,(BallY)
	add a,4
	ld (BallY),a
	call DispBall
	ld a,1
	ld (Ticks),a
	jp NoKey

BoxMove:
	ld a,4
	call Random
	cp 1
	jp z,MoveXCoord
	cp 2
	jp z,MoveXCoord
	jp nz,MoveYCoord

MoveXCoord:
	ld a,(BallX)	
	ld b,a
	ld a,(BoxX)
	sub b
	or a
	jp m,IncXCoord
	jp z,FinishBoxMove
	jp DecXCoord

IncXCoord:
	ld a,4
	call Random
	cp 1
	jp z,IncX1
	cp 2
	jp z,IncX1
	jp nz,IncX2

DecXCoord:
	ld a,4
	call Random
	cp 1
	jp z,DecX1
	cp 2
	jp z,DecX1
	jp nz,DecX2

DecX1:
	call DispBox
	ld a,(BoxX)
	dec a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove

DecX2:
	call DispBox
	ld a,(BoxX)
	dec a
	dec a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove

IncX1:
	call DispBox
	ld a,(BoxX)
	inc a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove

IncX2:
	call DispBox
	ld a,(BoxX)
	inc a
	inc a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove


MoveYCoord:
	ld a,(BallY)	
	ld b,a
	ld a,(BoxY)
	sub b
	or a
	jp m,IncYCoord
	jp z,FinishBoxMove
	jp DecYCoord

IncYCoord:
	ld a,4
	call Random
	cp 1
	jp z,IncY1
	cp 2
	jp z,IncY1
	jp nz,IncY2

DecYCoord:
	ld a,4
	call Random
	cp 1
	jp z,DecY1
	cp 2
	jp z,DecY1
	jp nz,DecY2

DecY1:
	call DispBox
	ld a,(BoxY)
	dec a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

DecY2:
	call DispBox
	ld a,(BoxY)
	dec a
	dec a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

IncY1:
	call DispBox
	ld a,(BoxY)
	inc a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

IncY2:
	call DispBox
	ld a,(BoxY)
	inc a
	inc a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

FinishBoxMove:
	ld a,90
	ld (Ticks),a
	ld a,(BallX)
	ld b,a
	ld a,(BoxX)
	sub b
	jp z,CheckBoxY
	jp nz,ChasedLoop

CheckBoxY:
	ld a,(BallY)
	ld b,a
	ld a,(BoxY)
	sub b
	jp nz,ChasedLoop
	jp YouChasedLose

DecTimer:
	ld a,(Timer)
	dec a
	ld (Timer),a
	or a
	jp z,DecTimerX
	jp nz,ChasedLLoop

DecTimerX:
	ld a,(TimerX)
	dec a
	ld (TimerX),a
	or a
	jp z,GameWinner
	ld a,175
	ld (Timer),a
	jp nz,ChasedLoop

YouChasedLose:
	call _clrLCD
	ld hl,0*256+0
	ld (_penCol),hl
	ld hl,Loser
	call _vputs
	jp GameOverText



;------------------------
;|Begin the Chaser Part
;------------------------

Chaser:
	call _clrLCD
	ld a,250
	ld (Timer),a
	ld a,250
	ld (TimerX),a
	ld a,8
	ld (BallX),a
	ld (BallY),a
	ld a,50
	ld (BoxY),a
	ld (BoxX),a
	ld a,50
	ld (Ticks),a
	call DispBall
	call DispBox

ChaserLoop:
	jp DecTimerY

ChaserLLoop:
	call GET_KEY
	cp K_RIGHT
	jp z,M_BoxRight
	cp K_LEFT
	jp z,M_BoxLeft
	cp K_UP
	jp z,M_BoxUp
	cp K_DOWN
	jp z,M_BoxDown
	cp K_EXIT
	ret z
	jr NoChaserKey

NoChaserKey:
	ld a,(Ticks)
	dec a
	ld (Ticks),a
	or a
	jp z,BallMove
	jp nz,ChaserLoop
	jp ChaserLoop

M_BoxRight:
	ld a,(BoxX)
	cp 120
	jp z,NoChaserKey
	cp 121
	jp z,NoChaserKey
	cp 122
	jp z,NoChaserKey
	cp 123
	jp z,NoChaserKey
	cp 124
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxX)
	add a,4
	ld (BoxX),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

M_BoxLeft:
	ld a,(BoxX)
	or a
	jp z,NoChaserKey
	cp 1
	jp z,NoChaserKey
	cp 2
	jp z,NoChaserKey
	cp 3
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxX)
	sub 4
	ld (BoxX),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

M_BoxUp:
	ld a,(BoxY)
	or a
	jp z,NoChaserKey
	cp 1
	jp z,NoChaserKey
	cp 2
	jp z,NoChaserKey
	cp 3
	jp z,NoChaserKey
	cp 4
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxY)
	sub 4
	ld (BoxY),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

M_BoxDown:
	ld a,(BoxY)
	cp 56
	jp z,NoChaserKey
	cp 55
	jp z,NoChaserKey
	cp 54
	jp z,NoChaserKey
	cp 53
	jp z,NoChaserKey
	cp 52
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxY)
	add a,4
	ld (BoxY),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

BallMove:
	ld a,(BallX)
	ld b,a
	ld a,(BoxX)
	sub b
	or a
	jp m,ReverseX
	ld (TempVar),a
	
CheckBallY:
	ld a,(BallY)
	ld b,a
	ld a,(BoxY)
	sub b
	or a
	jp m,ReverseY
	ld (TempVar1),a
	jr CompareDist

ReverseX:
	ld a,(BoxX)
	ld b,a
	ld a,(BallX)
	sub b
	ld (TempVar),a
	jr CheckBallY

ReverseY:
	ld a,(BoxY)
	ld b,a
	ld a,(BallY)
	sub b
	ld (TempVar1),a
	

CompareDist:
	ld a,(TempVar)
	ld b,a
	ld a,(TempVar1)
	sub b
	or a
	jp m,MoveBallY

MoveBallX:
	ld a,(BallX)
	or a
	jp z,IncreaseBallX
	cp 1
	jp z,IncreaseBallX
	cp 2
	jp z,IncreaseBallX
	cp 3
	jp z,IncreaseBallX
	cp 120
	jp z,DecreaseBallX
	cp 123
	jp z,DecreaseBallX
	cp 122
	jp z,DecreaseBallX
	cp 121
	jp z,DecreaseBallX
	cp 119
	jp z,DecreaseBallX
	cp 124
	jp z,DecreaseBallX
	ld a,(BallX)
	ld b,a
	ld a,(BoxX)
	sub b
	or a
	jp m,IncreaseBallX

DecreaseBallX:	
	call DispBall
	ld a,5
	call Random
	inc a
	ld b,a

DecLoopX:
	ld a,(BallX)
	dec a
	ld (BallX),a
	djnz DecLoopX
	call DispBall
	jp DoneWithBall

IncreaseBallX:
	call DispBall
	ld a,5
	call Random
	inc a
	ld b,a

IncLoopX:
	ld a,(BallX)
	inc a
	ld (BallX),a
	djnz IncLoopX
	call DispBall
	jp DoneWithBall

MoveBallY:
	ld a,(BallY)
	cp 3
	jp z,IncreaseBallY
	cp 2
	jp z,IncreaseBallY
	cp 1
	jp z,IncreaseBallY
	or a
	jp z,IncreaseBallY
	cp 4
	jp z,IncreaseBallY
	cp 5
	jp z,IncreaseBallY
	cp 51
	jp z,DecreaseBallY
	cp 52
	jp z,DecreaseBallY
	cp 53
	jp z,DecreaseBallY
	cp 54
	jp z,DecreaseBallY
	cp 55
	jp z,DecreaseBallY
	cp 56
	jp z,DecreaseBallY

	ld a,(BallY)
	ld b,a
	ld a,(BoxY)
	sub b
	or a
	jp m,IncreaseBallY

DecreaseBallY:
	call DispBall	
	ld a,5
	call Random
	inc a
	ld b,a

DecLoopY:
	ld a,(BallY)
	dec a
	ld (BallY),a
	djnz DecLoopY
	call DispBall
	jp DoneWithBall


IncreaseBallY:
	call DispBall
	ld a,5
	call Random
	inc a
	ld b,a

IncLoopY:
	ld a,(BallY)
	inc a
	ld (BallY),a
	djnz IncLoopY
	call DispBall
	jp DoneWithBall

DoneWithBall:
CheckWinner:
	ld a,(BallX)			
	add a,4			
	ld b,a			
	ld a,(BoxX)		
	cp b				
	jp c,ContinueCheck		
      jp ChaserLoop                 
       
ContinueCheck:
	ld a,(BoxX)			
	add a,4			
	ld b,a			
	ld a,(BallX)			
	cp b				
	jp c,CheckYHit		
	jp ChaserLoop

CheckYHit:
	ld a,(BallY)			
	add a,4			
	ld b,a			
	ld a,(BoxY)		
	cp b				
	jp c,ContinueCheckY	
      jp ChaserLoop              
       
ContinueCheckY:
	ld a,(BoxY)		
	add a,4			
	ld b,a			
	ld a,(BallY)			
	cp b				
	jp c,GameWinner			
	jp ChaserLoop

GameWinner:
	call _clrLCD
	ld hl,0*256+0
	ld (_penCol),hl
	ld hl,Winner
	call _vputs
	jp GameOverText
		
DecTimerY:
	ld a,(Timer)
	dec a
	ld (Timer),a
	or a
	jp z,DecTimerY1
	jp ChaserLLoop

DecTimerY1:
	ld a,(TimerX)
	dec a
	ld (TimerX),a
	or a
	jp z,ChaserLost
	ld a,175
	ld (Timer),a
	jp ChaserLLoop	

ChaserLost:
	call _clrLCD
	ld hl,0*256+0
	ld (_penCol),hl
	ld hl,Loser
	call _vputs
	jp GameOverText


;---------------------------
;|General Routines for Game
;---------------------------

DispBox:
	ld a,(BoxY)
	ld e,a
	ld a,(BoxX)
	ld hl,Box
	call PutSprite
	ret

DispBall:
	ld a,(BallY)
	ld e,a
	ld a,(BallX)
	ld hl,Ball
	call PutSprite
	ret

SetText:
	ld (_curRow),a
	ld a,4
	ld (_curCol),a
	ret

GameOverText:
	ld b,4
	ld hl,GameOver
	call WriteNextRow
	call _getkey	
	call _clrLCD
	ret

WriteNextRow:
 push hl
 call LD_HL_MHL
 ld ($C37C),hl
 pop hl
 inc hl
 inc hl
 call _vputs
 djnz WriteNextRow
 ret

Random:			
   ld b,a
   ld a,r
   add a,a
   ld hl,0
   ld d,0
   ld e,a
RMul:
   add hl,de
   djnz RMul
   ld a,h
   ret

;------------------------
; Sprite Routine [XOR]
;------------------------

;------------------------------------------------------
;This Routine was converted by AVD from Movax's 83
;Special thanks to ScaBBy for making it XOR Routine!
;------------------------------------------------------

;hl = image
;a = x coord
;e = y coord

PutSprite:
       push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
        ex	    de,hl
        add	    hl,hl
	  add	    hl,hl
	  add     hl,hl
	  add     hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$FC00
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp	    0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP
        pop     de

        ld      a,b             ; Write line to graphbuf
        xor     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        xor     (hl)
        ld      (hl),a

        ld      bc,15           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP        ; Next line

        jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        xor     (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,16
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
        ret
; SPRITE 


;-----------------
;|Variables
;-----------------

BallX:	.db 0
BallY:	.db 0
BoxX:		.db 0
BoxY:		.db 0
Ticks:	.db 0
SPos:		.db 0
TempVar:	.db 0
TempVar1:	.db 0

Timer:	.db 0
TimerX:	.db 0

;------------------
;|Text
;------------------
TitleStr:	.db	"The Chase 1.0",0
AuthorStr:	.db	"Ahmed El-Helw",0
EMailStr:	.db	"<ahmedre@msn.com>",0
ChaserStr:	.db	" The  Chaser ",0
ChasedStr:	.db	" The  Chased ",0

Winner:	.db	"You Won!!!!",0
Loser:	.db	"You Lost :(",0

GameOver:
.db 0,10,"The Chase 1.0, by AE",0
.db 0,17,"Thanks to Quran Kareem who",0
.db 0,24,"created the game idea.",0
.db 0,50,"Press a key...",0

;------------------
;|Sprites
;------------------
Ball:
 .db	%00000000
 .db	%00011000
 .db	%00100100
 .db	%00100100
 .db	%00011000
 .db	%00000000
 .db	%00000000

Box: 
 .db  %00000000
 .db	%00000000
 .db	%00111100
 .db	%00111100
 .db	%00111100
 .db	%00111100
 .db	%00000000
 .db	%00000000


.end
END