;+------------------------------------------------------+
;|			Box World v1.0			|
;|		     by Joe Wingbermuehle		|
;|			  12-08-1997			|
;+------------------------------------------------------+
; TI-86
#define getkey		$55AA
#define clrscr		$4A7E
#define	putc		$4A2B
#define	putmap		$4A27
#define	putps		$4A3B
#define	currow		$C00F
#define	curcol		$C010
#define	rindoff		$4AB1

#define	num_of_levels	$04	; duh

;---------- Variables ----------
#define	loc		sram+$00	; location of '+'
#define lev		sram+$02	; current level
#define	posc		sram+$03	; temporary curcol var
#define	posr		sram+$04	; temporary currow var
#define level		sram+$05	; current level matrix ($80 bytes)

	.org		$D748		; jump offset

;---------- Setup the game -----------
	call		rindoff
	call		clrscr
	ld		hl,$0402
	ld		(currow),hl
	ld		hl,info1
	call		putps
	ld		hl,$0703
	ld		(currow),hl
	ld		hl,info2
	call		putps
	ld		hl,$0404
	ld		(currow),hl
	ld		hl,info3
	call		putps
	call		getkey
	ld		hl,$0000
	ld		(loc),hl
	ld		a,1
	ld		(lev),a

;---------- Decompress/Load a level ----------
start:	ld		hl,level1
	ld		a,(lev)
	cp		1
	jr		z,sdcl
	ld		b,a
	dec		b
slp1:	inc		hl
	ld		a,(hl)
	cp		$FF
	jr		nz,slp1
	inc		hl
	inc		hl
	inc		hl
	djnz		slp1
sdcl:	ld		de,level
	ld		a,$E7
	ld		(posc),a
dclp1:	ld		a,(hl)
	cp		$FF
	jr		z,dcdone
	cp		''
	jr		z,dcone
	cp		':'
	jr		z,dcone
	cp		$00
	jr		z,dclp2d
	ld		b,a
	ld		a,(posc)
dclp2:	ld		(de),a
	inc		de
	djnz		dclp2
dclp2d:	ld		a,(posc)
	cp		$E7
	jr		z,dccn1
	ld		a,$E7
	jr		dccn
dccn1:	ld		a,' '
dccn:	ld		(posc),a
	inc		hl
	jr		dclp1
dcone:	ld		(de),a
	inc		de
	jr		dclp2d
dcdone:	inc		hl
	ld		a,(hl)
	ld		(posc),a
	ld		d,a
	inc		hl
	ld		a,(hl)
	ld		(posr),a
	ld		b,a
	ld		e,$15
	ld		a,$00
lsl3:	add		a,e
	djnz		lsl3
	add		a,d
	ld		(loc),a

;---------- Draw the level ----------
	ld		hl,$0000
	ld		(currow),hl
	ld		hl,level
	ld		b,$A7
dloop:	push		bc
	ld		a,(hl)
	call		putc
	dec		b
	inc		hl
	pop		bc
	djnz		dloop
	ld		a,(hl)
	call		putmap
	ld		a,(posr)
	ld		(currow),a
	ld		a,(posc)
	ld		(curcol),a
	ld		a,'+'
	call		putmap

;---------- Main program loop ----------
main:	call		getkey
	cp		$07
	jp		z,exit
	cp		$02
	jp		z,mLeft
	cp		$03
	jp		z,mUp
	cp		$04
	jp		z,mDown
	cp		$08
	jp		z,start
	cp		$0C
	jp		z,levup
	cp		$0D
	jp		z,levdwn
	cp		$01
	jr		nz,main

;---------- Move right ----------
mRight:	ld		a,(curcol)
	cp		13h
	jp		z,main
	call		align
	inc		de
	ld		(loc),de
	ld		a,(hl)
	call		putc
	ld		a,'+'
	call		putmap
	call		align
	ld		a,(hl)
	cp		$E7
	jp		z,mLeft
	cp		''
	jr		z,mor
	jp		main
mor:	call		align
	inc		hl
	ld		a,(hl)
	cp		$E7
	jp		z,mLeft
	cp		''
	jp		z,mLeft
	cp		':'
	jr		z,mrcn1
	ld		a,''
	ld		(hl),a
mrcn1:	dec		hl
	ld		a,' '
	ld		(hl),a
	ld		a,(curcol)
	inc		a
	ld		(curcol),a
	call		align
	inc		hl
	ld		a,(hl)
	cp		':'
	jr		z,mrcn2
	ld		a,''
	call		putmap
mrcn2:	ld		a,(curcol)
	dec		a
	ld		(curcol),a
	jp		winc

;---------- Move left ----------
mLeft:	ld		a,(curcol)
	cp		1
	jp		z,main
	dec		a
	ld		(curcol),a
	ld		a,'+'
	call		putc
	call		align
	dec		de
	ld		(loc),de
	ld		a,(hl)
	call		putmap
	ld		a,(curcol)
	dec		a
	ld		(curcol),a
	call		align
	ld		a,(hl)
	cp		$E7
	jp		z,mRight
	cp		''
	jr		z,mol
	jp		main
mol:	call		align
	dec		hl
	ld		a,(hl)
	cp		$E7
	jp		z,mRight
	cp		''
	jp		z,mRight
	cp		':'
	jr		z,mlcn1
	ld		a,''
	ld		(hl),a
mlcn1:	inc		hl
	ld		a,' '
	ld		(hl),a
	ld		a,(curcol)
	dec		a
	ld		(curcol),a
	call		align
	dec		hl
	ld		a,(hl)
	cp		':'
	jr		z,mlcn2
	ld		a,''
	call		putmap
mlcn2:	ld		a,(curcol)
	inc		a
	ld		(curcol),a
	jp		winc

;---------- Move up ----------
mUp:	ld		a,(currow)
	cp		1
	jp		z,main
	call		align
	ld		a,(hl)
	call		putmap
	ld		a,(currow)
	dec		a
	ld		(currow),a
	ld		hl,(loc)
	ld		bc,$0015
	sbc		hl,bc
	ld		(loc),hl
	ld		a,'+'
	call		putmap
	call		align
	ld		a,(hl)
	cp		$E7
	jp		z,mDown
	cp		''
	jr		z,moup
	jp		main
moup:	call		align
	ld		bc,$0015
	sbc		hl,bc
	ld		a,(hl)
	cp		$E7
	jp		z,mDown
	cp		''
	jp		z,mDown
	cp		':'
	jr		z,mucn1
	ld		a,''
	ld		(hl),a
mucn1:	ld		bc,$0015
	add		hl,bc
	ld		a,' '
	ld		(hl),a
	ld		a,(currow)
	dec		a
	ld		(currow),a
	ld		bc,$002A
	sbc		hl,bc
	ld		a,(hl)
	cp		':'
	jr		z,mucn2
	ld		a,''
	call		putmap
mucn2:	ld		a,(currow)
	inc		a
	ld		(currow),a
	jp		winc

;---------- Move down ----------
mDown:	ld		a,(currow)
	cp		6
	jp		z,main
	call		align
	ld		a,(hl)
	call		putmap
	ld		a,(currow)
	inc		a
	ld		(currow),a
	ld		hl,(loc)
	ld		bc,$0015
	add		hl,bc
	ld		(loc),hl
	ld		a,'+'
	call		putmap
	call		align
	ld		a,(hl)
	cp		$E7
	jp		z,mUp
	cp		''
	jr		z,modwn
	jp		main
modwn:	call		align
	ld		bc,$0015
	add		hl,bc
	ld		a,(hl)
	cp		$E7
	jp		z,mUp
	cp		''
	jp		z,mUp
	cp		':'
	jr		z,mdcn1
	ld		a,''
	ld		(hl),a
mdcn1:	call		align
	ld		a,' '
	ld		(hl),a
	ld		a,(currow)
	inc		a
	ld		(currow),a
	ld		bc,$002A
	add		hl,bc
	ld		a,(hl)
	cp		':'
	jr		z,mdcn2
	ld		a,''
	call		putmap
mdcn2:	ld		a,(currow)
	dec		a
	ld		(currow),a
	jp		winc

;---------- Point hl to level matrix element ----------
align:	ld		de,(loc)
	ld		hl,level
	add		hl,de
	ret

;---------- Move up/down a level ----------
levdwn:	; move down a level
	ld		a,(lev)
	cp		1
	jr		z,levx
	dec		a
	jr		levx
levup:	; move up a level
	ld		a,(lev)
	cp		num_of_levels
	jr		z,levx
	inc		a
levx:	ld		(lev),a
	jp		start

;---------- Winner? ----------
winc:	ld		hl,level
	ld		b,$A8
wincl:	ld		a,(hl)
	cp		''
	inc		hl
	jp		z,main
	djnz		wincl
	ld		a,(lev)
	inc		a
	ld		(lev),a
	cp		num_of_levels+1
	jp		nz,start
	call		clrscr
	ld		hl,$0403
	ld		(currow),hl
	ld		hl,won
	call		putps
	call		getkey
exit:	ret		; exit the program

;---------- Constants ----------
info1:	.db		$0D,"BoxWorld v1.0"
info2:	.db		$06,"by Joe"
info3:	.db		$0D,"Wingbermuehle"
won:	.db		$08,"You Won!"

;---------- Variables ----------
; Where else could I put this???????
sram:	.db		0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.db		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;---------- Levels ----------
; (level data) - (top+x)(left+x)

level1:	.db		$1D,$03,$12,'',$00,$02,$12,$02,'',$00,$10,$02,'',$01,'',$01
	.db		$01,$04,$07,$04,$01,$01,$02,$01,$01,$04,$07,$01,'',$03,'',$07
	.db		':',$00,$19,$FF
	.dw		$0609
level2:	.db		$1E,$02,$01,$02,$0F,$03,$01,$02,$0F,'',$00,$01,'',$01,'',$01
	.db		$0F,$01,'',$00,$02,$02,$0F,$01,'',$01,$01,$01,$0E,':',$00,$06
	.db		$1D,$FF
	.dw		$0609
level3:	.db		$1C,':',$00,$04,$11,$03,'',$00,$0F,$02,'',$00,$01,'',$00,$01
	.db		'',$01,$0D,$01,'','',$00,$02,$01,'',$00,$01,$0D,$04,$01,$03
	.db		$10,$03,$1E,$FF
	.dw		$060A
level4:	.db		$1C,':',$00,$02,$01,$03,$0D,$03,'',$03,'',$01,$0B,$01,'',$00
	.db		$01,'',$00,$01,$02,$04,$0A,$04,$02,$01,'',$00,$01,'',$00,$01
	.db		$0B,$01,'',$03,'',$03,$0D,$03,$01,$03,$1C,$FF
	.dw		$060B

.end
END