;Blockbuster v4.61 for the TI-86
;ZoomLabs Software
;Doug Torrance
;profzoom@hotmail.com
	
	#include "asm86.h"
	#include "ti86asm.inc"
	#include "ti86math.inc"
	#include "ti86ops.inc"
	#include "ti86abs.inc"
	.org _asm_exec_ram 
	
; - Variables -

string = _plotSScreen
lilguyx = _plotSScreen+6
lilguyy = _plotSScreen+7
score = _plotSScreen+8
otherlilguyy = _plotSScreen+9
yetanotherlilguyy = _plotSScreen+11
initial = _plotSScreen+12
Board = _plotSScreen+51

; - AShell compatability - (doesn't require Ashell, though)

	nop         ;Identifies the table
	jp Start
	.dw $0000   ;Version # of Table
	.dw Title   ;Absolute pointer to program description

; - Title screen -

Start:

	call _runindicoff
	ld a,(UR_C1Save)
	ld (UR_C1+1),a

Beginning:
	call DrawTitlePic			;"Blockbuster v4.6"
	ld hl,TitleScreenInfo
	ld de,$200a
  	ld bc,$272e
  	ld a,$35
  	call vputs3
	ld a,(HighScore)				
	call DM_A_DECI			;prints high score
	ld de,Help
	
; Key loop de=addr Help (optimized by Dines)
KeyLoop:
	push de
	call GET_KEY
	pop de
	cp 9
        jr z,goto_de
	sub $36
        jr z,goto_de                            ;go on if 2nd or ENTER is pressed
	dec a					;cp G_MODE
	jr z,EndGame					;exit if MODE is pressed
	jr KeyLoop
goto_de:
        ex de,hl
        jp (hl)

EndGame:					;write back, clear the screen, set cursor to upper left hand corner before quitting
	ld a,(UR_C1+1)				;make sure supposedly random boards don't look familiar next time we play
	ld (UR_C1Save),a
	ld hl,ProgName-1				;adapted writeback routine by Jonah Cohen
	rst 20h
	rst 10h
	ld a,b
	ld hl,HighScoreBuffer-_asm_exec_ram+4
	add hl,de
	adc a,0
	call _SET_ABS_DEST_ADDR
	xor a
	ld hl,HighScoreBuffer
	call _SET_ABS_SRC_ADDR
	ld hl,9
	call _SET_MM_NUM_BYTES
	call _mm_ldir
	ld de,0
	ld (_curRow),de
	call _clrLCD
	ret

; - Help screen -
Help:
	call DrawTitlePic
	ld hl,HelpScreenInfo
	ld de,$1d0a
	ld bc,$242b
	ld a,$39
	call vputs3

	ld de,$3210
	call vputs

	ld de,StartGame
        jr KeyLoop

; - Draw board -

StartGame:
	ld e,0
	ld hl,Board

WriteBoard:
	push hl
UR_C1:					;thanks to Dines Justesen for random routine
    	ld a,$a6
UR_C2:
   	ld hl,$8243
  	dec h
	inc l 
	add a,(hl) 
	ld (UR_C2+1),hl    
	rlca  
	rlca   
	sub h   
	add a,l   
	ld (UR_C1+1),a  
	srl a  
	pop hl 
	rla
	          
	ld (hl),a
	inc hl
	inc e
	ld a,e
	cp 16
	jr nz,WriteBoard

LetsGetStarted:	
	call _clrLCD
	ld de,0
	ld hl,Board

DrawRowOfBlocks:				;optimized by Kouri
	ld a,(hl)
	ld b,8
DrawRowLoop:
	rra
	push af
	jr nc,AfterDraw
DrawBlock:
	push bc
	push hl
	ld hl,Block
	call ZoomSprite
	pop hl
	pop bc
AfterDraw:
	ld a,d
	add a,8
	ld d,a
	pop af
	djnz DrawRowLoop
	inc hl
	ld d,b
	inc e
	ld a,e
	cp 16
	jr nz,DrawRowOfBlocks

DrawManAndDoor:
	ld hl,Board
	res 0,(hl)
	ld hl,Board+15
	res 7,(hl)
	ld de,0
	call DrawManSprite
	ld de,$380f
	ld hl,Exit
	call ZoomSprite

	xor a
	ld (score),a
	ld (lilguyx),a
	ld (otherlilguyy),a
	inc a
	ld (lilguyy),a
	ld a,%11111110
	ld (yetanotherlilguyy),a
	
Gravity:
	ld a,(otherlilguyy)
	ld d,a
	ld a,(lilguyx)
	ld e,a
	call DrawManSprite
	
	ld a,(otherlilguyy)
	cp 56
	jr z,WaitForKey
	call ColumnIntoHL
	ld a,(lilguyy)
	rlca
	ld b,(hl)
	and b
	or a
	jr nz,WaitForKey
	call EraseLilGuy
	ld a,(lilguyy)
	rlca
	ld (lilguyy),a
	ld a,(otherlilguyy)
	add a,8
	ld (otherlilguyy),a
	ld a,(yetanotherlilguyy)
	rlca
	ld (yetanotherlilguyy),a
	jr Gravity

WaitForSecond:
	ld a,$bf
	out (1),a
	in a,(1)
	bit 5,a
	jp z,SecondIsPressed
	bit 4,a
	jp z,YEqualsIsPressed	

WaitForKey:
	call GET_KEY
	dec a
	dec a
	jr z,LeftKeyIsPressed
	dec a
	jr z,RightKeyIsPressed
	cp $34
	jp z,Beginning
	ld a,(lilguyy)
	cp %10000000
	jr nz,WaitForSecond
	jp AreYouFinished

LeftKeyIsPressed:
	ld a,(lilguyx)
	or a
	jr z,WaitForKey
	call ColumnIntoHL
	dec hl
	ld b,(hl)
	ld a,(lilguyy)
	and b
	or a
	jr nz,WaitForKey
	call EraseLilGuy
	ld hl,lilguyx
	dec (hl)
	jp Gravity
	

RightKeyIsPressed:
	ld a,(lilguyx)
	cp 15
	jr z,WaitForKey
	call ColumnIntoHL
	inc hl
	ld a,(lilguyy)
	and (hl)
	or a
	jr nz,WaitForKey
	call EraseLilGuy
	ld hl,lilguyx
	inc (hl)
	jp Gravity

YEqualsIsPressed:
	ld a,$fe
	out (1),a
	in a,(1)
	bit 1,a
	jr z,YEqualsLeftIsPressed
	bit 2,a
	jr z,YEqualsRightIsPressed
	jp WaitForSecond

YEqualsRightIsPressed:
	ld a,(lilguyx)
	cp 15
	jr z,WaitForKey
	ld a,(otherlilguyy)
	or a
	jp z,WaitForKey
	call ColumnIntoHL
	inc hl
	ld a,(lilguyy)
	rrca
	and (hl)
	or a
	jp nz,WaitForKey
	call EraseLilGuy
	ld hl,lilguyx
	inc (hl)
	jr YEqualsBlahIsPressed
	
YEqualsLeftIsPressed:
	ld a,(lilguyx)
	or a
	jp z,WaitForKey
	ld a,(otherlilguyy)
	or a
	jp z,WaitForKey
	call ColumnIntoHL
	dec hl
	ld a,(lilguyy)
	rrca
	and (hl)
	or a
	jp nz,WaitForKey
	call EraseLilGuy
	ld hl,lilguyx
 	dec (hl)

YEqualsBlahIsPressed:
	ld a,(lilguyy)
	rrca
	ld (lilguyy),a
	ld a,(otherlilguyy)
	sub 8
	ld (otherlilguyy),a
	ld a,(yetanotherlilguyy)
	rrca
	ld (yetanotherlilguyy),a
	jp GiveTime

SecondIsPressed:
	ld a,$fe
	out (1),a
	in a,(1)
	bit 1,a
	jr z,SecondLeftIsPressed
	bit 2,a
	jr z,SecondRightIsPressed
	bit 0,a
	jr z,SecondDownIsPressed
	jp WaitForSecond

SecondLeftIsPressed:
	ld a,(lilguyx)
	or a
	jp z,WaitForKey
	call ColumnIntoHL
	dec hl
	ld a,(lilguyy)
	and (hl)
	or a
	jp z,WaitForKey
	ld a,(yetanotherlilguyy)
	and (hl)
	ld (hl),a
	ld a,(otherlilguyy)
	ld d,a
	ld a,(lilguyx)
	dec a
	jr SecondBlahIsPressed
	
SecondRightIsPressed:
	ld a,(lilguyx)
	cp 15
	jp z,WaitForKey
	call ColumnIntoHL
	inc hl
	ld a,(lilguyy)
	and (hl)
	or a
	jp z,WaitForKey
	ld a,(yetanotherlilguyy)
	and (hl)
	ld (hl),a
	ld a,(otherlilguyy)
	ld d,a
	ld a,(lilguyx)
	inc a
SecondBlahIsPressed:
	call DispNothing
	ld hl,score
 	inc (hl)
	jp WaitForKey

SecondDownIsPressed:
	ld a,(otherlilguyy)
	cp 56
	jp z,WaitForKey
	call ColumnIntoHL
	ld a,(lilguyy)
	rlca
	and (hl)
	or a
	jp z,WaitForKey
	ld a,(yetanotherlilguyy)
	rlca
	and (hl)
	ld (hl),a
	ld a,(otherlilguyy)
	add a,8
	ld d,a
	ld a,(lilguyx)
	call DispNothing
	ld hl,score
 	inc (hl)

GiveTime:
	ld bc,0

GiveTimeLoop:
	inc b
	ld a,b
	cp $ff
	jr nz,GiveTimeLoop
	inc c
	ld a,c
	cp $80
	jr nz,GiveTimeLoop
	jp Gravity

AreYouFinished:
	ld a,(lilguyx)
	cp 15
	jp nz,WaitForSecond
	
YouAreFinished:
	ld de,$c2e
	ld hl,YourScore
	call vputs
	ld a,(score)
	call DM_A_DECI
	ld hl,HighScore
	ld a,(score)
	cp (hl)
	jr z,Loop
	jr nc,YouGotTheHighScore
	
Loop:
	call GET_KEY
	cp 9
	jp z,Beginning
	cp $37
	jp z,Beginning
	jr Loop

YouGotTheHighScore:
	ld de,$130e
	ld hl,CongratulationsHighScore
	call vputs
	ld de,$1921
	call vputs
	ld hl,HighScore
	ld a,(score)
	ld (hl),a
	ld de,0
	
	
NewInitial:
	ld hl,$0804
	ld (_curRow),hl
	ld hl,HighScoreBuffer
	add hl,de
	push hl
	ld hl,HighScoreBuffer-1
	call SAM
	pop hl
	push hl
	ld a,e
	or a
	call z,HighlightFirst
	dec a
	call z,HighlightSecond
	dec a
	call z,HighlightThird
	pop hl
	
	
EnterInitials:
	push hl
	push de
	call GET_KEY
	pop de
	pop hl
	dec a
	jr z,EI_DownIsPressed
	dec a
	jr z,EI_LeftIsPressed
	dec a
	jr z,EI_RightIsPressed
	dec a
	jr z,EI_UpIsPressed
	cp 5
	jr nz,EnterInitials
	jp Beginning	

EI_UpIsPressed:
	inc (hl)
	ld a,(hl)
	cp $5b
	jr nz,NewInitial
	ld (hl),$41
	jr NewInitial

EI_DownIsPressed:
	dec (hl)
	ld a,(hl)
	cp $40
	jr nz,NewInitial
	ld (hl),$5a
	jr NewInitial

EI_RightIsPressed:
	ld a,e
	cp 2
	jr z,NewInitial
	inc e
	jr NewInitial

EI_LeftIsPressed:
	ld a,e
	or a
	jr z,EnterInitials
	dec e
	jr NewInitial
	
; - Calls -

DrawTitlePic:	
	call _clrLCD				;optimized by Sam Heald and OBD
	ld hl,Titlepic	  			;big "Blockbuster" picture
	ld de,VIDEO_MEM
	ld bc,256
	ldir
	ld hl,VIDEO_MEM+256
	ld (hl),b
	ld bc,767
	ldir
	ld de,$1404
	call DrawManSprite
	ld de,$1405
	call ZoomSprite			;draw block
	ld de,$1002
        ld hl,Version
	ld (_curRow),de
	call _puts				;"v4.5"
	ret

HighlightFirst:
	call SAM_INVERT
	inc hl
	call SAM
	inc hl
	jr SAM
	
HighlightSecond:
	dec hl
	call SAM
	inc hl
	call SAM_INVERT
	inc hl
	call SAM
	inc hl
	ret

HighlightThird:
	dec hl
	dec hl
	call SAM
	inc hl
	call SAM
	inc hl
	call SAM_INVERT
	inc hl
	inc hl
	ret

SAM:
	ld a,(hl)
	call _putc
	ret

SAM_INVERT:
	set 3,(iy+5)
	call SAM
	res 3,(iy+5)
	ret

ColumnIntoHL:
	ld d,0
	ld a,(lilguyx)
	ld e,a
	ld hl,Board
	add hl,de
	ret

DrawManSprite:
	ld hl,Man
	jr ZoomSprite

EraseLilGuy:
	ld a,(otherlilguyy)
	ld d,a
	ld a,(lilguyx)

DispNothing:
	ld e,a
	ld hl,Nothing

ZoomSprite:
	push de
	push hl
	ld h,0
	ld l,d
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ld a,e
	ex de,hl
	ld h,0
	ld l,a
	add hl,de
	ex de,hl
	pop hl
	ld b,8

ZS_Draw:
	push hl
	ld a,(hl)
	ld hl,VIDEO_MEM
	add hl,de
	ld (hl),a
	ld hl,16
	add hl,de
	ex de,hl
	pop hl
	inc hl
	djnz ZS_Draw
	pop de
	ret

;--- Jimmy Mardell's DM_HL_DECI Code
DM_A_DECI:
	ld l,a
 	ld h,0
	ld de, string+5
	xor a
	ld (de), a
DM_A_DECI_Repeat:
	call UNPACK_HL
	add a, '0'
	dec de
	ld (de), a
	ld a, h
	or l
	jr nz, DM_A_DECI_Repeat
	ex de, hl
	jr vputs2

vputs3:          ; display 4 strings at de,be,ce,ae
        push af
        call vputs
        ld d,b
        call vputs
        ld d,c
	call vputs
	pop af
        ld d,a

vputs:
	ld (_penCol),de			;set cursor position
vputs2:
	call _vputs				;write text
	ret

; - Strings -
Title:
	.db "Blockbuster "
Version:
	.db "v4.62",0

ProgName:
	.db 8,"blkbustr",0

TitleScreenInfo:	
	.db "Doug Torrance",0
	.db "Z80 Assembly Coders",0
	.db "profzoom@hotmail.com",0
	.db "High Score - "
	
HighScoreBuffer:
	.db "DAT - ",0

HighScore:
	.db 0

UR_C1Save:					;for random routine--keep random by writing back to the program
	.db $a6

HelpScreenInfo:
	.db "[",$cf,"]&","[",5,"]-move",0
	.db "[F1]+","[",$cf,"]&","[",5,"]-jump",0
	.db "[2nd]+","[",$cf,"],","[",5,"]&","[",7,"]-",0
	.db "[EXIT]-exit",0
	.db "break block",0
	
YourScore:
	.db "Score-",0

CongratulationsHighScore:
	.db "Congratulations!  High Score!",0
	.db "Enter your initials..."



; - Sprites -

Nothing:	;just a blank 8x8 sprite, and since first 8 bytes of Titlepic are 0, I can save some space!			
Titlepic:	;Created with the Assembly Toolbox by Spooky
	.db %00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
	.db %00000000,%00000000,%00000001,%00000000,%00000000,%00000000,%00000110,%00000000,%00100000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
	.db %00001111,%11111110,%00000111,%10000000,%00000000,%00000000,%00001110,%00000000,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
	.db %00001111,%11111111,%00000011,%11000000,%00000000,%00000000,%00001111,%00000000,%01111000,%00000000,%00000000,%00000000,%00000010,%00000000,%00000000,%00000000
	.db %00000111,%10000111,%10000011,%11000000,%00000000,%00000000,%00001111,%00000000,%01111000,%00000000,%00000000,%00000000,%00000110,%00000000,%00000000,%00000000
	.db %00000111,%10000111,%11000011,%11000000,%00000000,%00000000,%00001111,%00000000,%01111000,%00000000,%00000000,%00000000,%00000111,%10000000,%00000000,%00000000
	.db %00000111,%10000111,%11000011,%11000111,%11110000,%00111111,%00001111,%00111000,%01111111,%11000011,%00001110,%00011111,%10011111,%10001111,%11100001,%11111100
	.db %00000111,%11011111,%11000011,%11001100,%00111100,%01100011,%11001111,%11110000,%01111111,%11100011,%10001111,%00111001,%10001111,%10011100,%11110001,%11111110
	.db %00000111,%11111111,%10000011,%11011110,%00011110,%11100011,%11001111,%11000000,%01111111,%11110111,%11001111,%00111100,%10001111,%10011111,%11111001,%11111100
	.db %00000111,%11001111,%11000011,%11011110,%00001111,%11100000,%00001111,%11100000,%01111000,%11110111,%11001111,%00111111,%00001111,%00011111,%11111001,%11110000
	.db %00000111,%10000011,%11100011,%11111110,%00001111,%11100000,%00001111,%11100000,%01111000,%11111111,%11001111,%00011111,%10001111,%00011110,%00000001,%11100000
	.db %00000111,%10000011,%11100011,%11111110,%00001111,%11110000,%00001111,%11110000,%01111000,%11111111,%11001111,%00000111,%11001111,%00011110,%00010001,%11100000
	.db %00000111,%10000011,%11100011,%11011110,%00011111,%11111001,%10001111,%11111000,%01111000,%11110111,%11001111,%10000001,%11101111,%10011111,%00110001,%11100000
	.db %00001111,%11001111,%11100111,%11001111,%00111110,%11111111,%10001111,%11111100,%01111111,%11100011,%11111111,%10111011,%11101111,%11011111,%11110001,%11100000
	.db %00001111,%11111111,%10000111,%11000111,%11110000,%00111111,%10001111,%00111110,%00111111,%00000001,%11111111,%10111111,%11000111,%11001111,%11110011,%11100000
	.db %00000011,%10000000,%00000000,%00000000,%00000000,%00001111,%00000000,%00000100,%00000000,%00000000,%11100000,%00000000,%00000001,%10000001,%11100000,%00000000
 

Man:	;new grafx thanx to Blackbelt, make the game look a bit nicer (from 83 version)
	.db %01111100
	.db %10101010
	.db %00010000
	.db %00111000
	.db %01111100
	.db %10111010
	.db %00010000
	.db %01101100
		
Block:
	.db %01111110
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011
	.db %11010101
	.db %10101011

Exit:	
	.db %01111110
	.db %11111111
	.db %11000011
	.db %11000011
	.db %11000011
	.db %11000011
	.db %11000011
	.db %11000011

	.end
	.end