#include "82port2.inc"
#include "ZCPdecod.asm"

curspos = TEXT_MEM
outs = TEXT_MEM+2
strikes = TEXT_MEM+3
balls = TEXT_MEM+4
innings = TEXT_MEM+5
player1score = TEXT_MEM+6
player2score = TEXT_MEM+7
Turn = TEXT_MEM+8
SPEED = TEXT_MEM+9
option = TEXT_MEM+10
numop = TEXT_MEM+11

string = TEXT_MEM+15
sprY = TEXT_MEM+22
sprX = TEXT_MEM+23
ballX = TEXT_MEM+24
ballY = TEXT_MEM+25

;Flags

Base1Flag = TEXT_MEM+26
Base2Flag = TEXT_MEM+27
Base3Flag = TEXT_MEM+28
players = TEXT_MEM+29
DerbyFlag = TEXT_MEM+30 
BallFlag  = TEXT_MEM+31

;Counters

HitCounter = TEXT_MEM+32
player1name = TEXT_MEM+33
player2name = TEXT_MEM+38

ProgStart:
 call BUSY_OFF
 res 1,(iy+13)
 res 2,(iy+13) 

 ld hl,TEXT_MEM
 ld (hl),0
 ld de,TEXT_MEM+1
 ld bc, 127
 ldir

 call ClearG
 call _grbufclr

        ld      DE,Title1           ; HL = address of ZCP compressed data
        ld      HL,$c9fa         ; DE = address of where uncompressed
                                      ;      data will come
        Call DecodeZCP
 ROM_CALL(DISP_GRAPH)
 call OTH_PAUSE2

 call ClearG

 ld a,(SGAME)
 or a
 jp nz,ReStart

 ld a,1
 ld (innings),a
 ld (Base1Flag),a
 ld (Base2Flag),a
 ld (Base3Flag),a

Title:
        ROM_CALL(CLEARLCD)

         ld hl,GRAPH_MEM+128
         ld (hl),$ff
         ld de,GRAPH_MEM+129
         ld bc,15
         ldir


         ld       de,$0200
         ld       hl,ProgDesc
	   call DTX

         ld       de,$0925
         call DMX
         
         ld       de,$102F
         call DMX

         ld       de,$202C
         call DMX

         ld       de,$282C
         call DMX

         ld       de,$302C
         call DMX

         ld de,$0604
         ld a,2
	   call Menu

         ld       a,(option)
         or       a
         jr       z,HomeRunDerby_Mode
         dec      a
         jr       z,Exhibition_Mode
	   jp       Season_Mode

ReStart:
 ld de,outs
 ld hl,Resume
 ld bc,42
 ldir
 xor a
 ld (SGAME),a
 call DisplayInfo
 call LoadSprData
 ld hl,Batter
 call PutSprite
 
 jp Wait

HomeRunDerby_Mode:
 ld a,2
 ld (DerbyFlag),a
 dec a
 ld (SeasonFlag),a
 jr PROGSTART
Exhibition_Mode:
 ld a,1
 ld (DerbyFlag),a
 ld (SeasonFlag),a
PROGSTART:
 ROM_CALL(CLEARLCD)
 ld de,$101F
 ld hl,PlayerChoose
 call DMX              ; "Choose player mode"
 ld de,$0704
 call DTX              ; "1 player"
 inc e
 call DTX              ; "2 players"

 ld de,$0604
 ld a,1
 call Menu
 ld a,(option)
 inc a
 ld (players),a
 jp G_Start

WriteName:
 ROM_CALL(CLEARLCD)
 ld hl,seasonname
 call Write
 xor a
 ld (wins),a
 ld (losses),a
 ld (runs),a
 ld (homeruns),a
 ld a,50
 ld (games),a
 jr SeasonStart

StartSeasonOver:
 ld a,1
 ld (SeasonFlag2),a
Season_Mode:
 ROM_CALL(CLEARLCD)
 ld a,1
 ld (players),a
 ld (DerbyFlag),a
 ld a,(SeasonFlag2)
 dec a
 jr z,WriteName
 ROM_CALL(CLEARLCD)
 ld de,$1027
 ld hl,Season_2
 call DMX
 ld de,$0904
 call DTX             
 inc e
 call DTX       
 ld de,$0804
 ld a,1
 call Menu
SeasonStarter:
 ld a,(option)
 dec a
 jp z,StartSeasonOver

SeasonStart:
 call ShowSeasonInfo
 call OTH_PAUSE2
 ld a,2
 ld (SeasonFlag2),a
 ld (SeasonFlag),a
 ld a,(seasonname)
 ld (player1name),a
 ld a,(seasonname+1)
 ld (player1name+1),a
 ld a,(seasonname+2)
 ld (player1name+2),a
 jr SeasJump
Quitter:
 ld a,1
 ld (SeasonFlag),a
 ret

G_Start:
 ROM_CALL(CLEARLCD)
 ld hl,player1name
 call Write
 ld a,(players)
 dec a
 jr nz,Write2
SeasJump:
 ld a,25
 call RANDOM
 ld h,4
 ld l,a
 ROM_CALL(MUL_HL)  ;32 teams times 4 gaps per team
 ld d,h
 ld e,l
 ld hl,Teams
 add hl,de
 ld de,player2name
 ld bc,3
 ldir
 jr GameStart
Write2:
 ROM_CALL(CLEARLCD)
 ld hl,P2
 ld de,$142F
 call DMX
 ld hl,player2name
 call Write
GameStart:
 call DisplayInfo
 ld b,$51
 ld c,$33
 ld a,b
 ld (sprX),a
 ld a,c
 ld (sprY),a
 ld hl,Runner
 call PutSprite
 
 ld b,3
Intro:
 push bc
 call DELAY
 call DELAY
 call LoadSprData
 ld hl,Runner
 call PutSprite
 ld a,c
 inc a
 ld (sprY),a
 ld c,a
 ld a,b
 add a,-4
 ld (sprX),a
 ld b,a
 call PutSprite
 
 pop bc
 djnz Intro

 call DELAY
 call DELAY
 call LoadSprData
 ld hl,Runner
 call PutSprite
 ld a,c
 add a,3
 ld c,a
 ld (sprY),a
 ld a,b
 add a,-11
 ld (sprX),a
 ld b,a
 ld hl,Batter
 call PutSprite
 
Wait:
 call GET_KEY
 cp G_ENTER
 jp z,StartPitch
 cp G_DEL
 jr z,Save
 cp G_MODE
 jr nz,Wait
 ld a,(SeasonFlag)
 dec a
 jr nz,Save

quit2:
 ld hl,ProgName        ; All this stuff is to make sure the hiscore table
 rst 20h	       ; and resume stuff are stored in the variable
 rst 10h
 ex de,hl	       ; HL -> start of variable
 ld a,b
 ld de,SGAME-$D748+4  ; DE = relative offset to stuff to store (-4)
 add hl,de
 adc a,0	       ; Next block if necessary
 ld de,SGAME ;Resume	       ; DE = start of bytes to copy
 ld b,54	       ; 156 bytes to copy
RepCopy:
 push af
 push hl
 call $46C3
 ld a,(de)	       ; Read
 ld (hl),a	       ; And save it in the real variable
 pop hl
 pop af
 call $4637
 inc de
 djnz RepCopy

 call BUSY_ON
 set 1,(iy+$0D)        ; Restoring the 'update textshadow' flag
 res 0,(iy+$03)        ; Clear the ON-pressed flag
 call $4A82	       ; Clear screen and the textshadow
 ld hl,0
 ld ($C00F),hl	       ; Moving the cursor to top left corner
 set 2,(iy+13)
 ret 


Save:
 ld hl,outs
 ld de,Resume
 ld bc,42
 ldir
 ld a,1
 ld (SGAME),a
 jr quit2

StartPitch:
 ld a,80
 ld (HitCounter),a
 call RAND3
 inc a
 ld (SPEED),a
 ld b,$3F
 ld a,b
 ld (ballX),a
 ld c,$2C
 ld a,c
 ld (ballY),a
 ld hl,ball
 call PutSprite
 ld b,17
Move_Pitch:
 push bc
 call LoadBallData
 call PutSprite
 ld a,c
 inc a
 ld c,a
 ld (ballY),a
 ld hl,ball
 call PutSprite
 
 call DELAY2
 call DELAY2
 call DELAY2
 call DELAY2
 call DELAY2

Pitch_Cont:
 pop bc
 djnz Move_Pitch
 call RAND3
 or a
 jp z,Ball
 jp Strike

SwingBat:
 pop bc
 inc sp
 inc sp
 inc sp
 inc sp
 call LoadSprData
 ld hl,Batter
 call PutSprite
 ld hl,PlayerSwing1
 call PutSprite
 

SwingCont:
 ld a,(HitCounter)
 dec a
 jp z,Out_2_First
 dec a
 jp z,Triple_2_Right
 dec a
 jp z,Out_2_Right 
 dec a
 jp z,Single_2_Right
 dec a
 jp z,Out_2_Second
 dec a
 jp z,HomeRun
 dec a
 jp z,Out_2_Short 
 dec a
 jp z,Single_2_Left
 dec a
 jp z,Out_2_Left
 dec a
 jp z,Double_2_Left 
 dec a
 jp z,Out_2_Third
 jp Strike

SwingEnd:
 call OTH_PAUSE
 call DisplayInfo
 call LoadSprData
 ld hl,Batter
 call PutSprite
 
 jp Wait
  
Out_2_Short:
 ld b,9
Out1Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 ld b,a
 ld (ballX),a
 call O_Mid
 pop bc
 djnz Out1Move
 jp Out 

Out_2_Second: 
 ld b,9
Out2Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 ld b,a
 ld (ballX),a
 call O_Mid
 pop bc
 djnz Out2Move
 jp Out  

O_Mid:
 ld a,c
 dec a
 dec a
 dec a
 ld c,a
 ld (ballY),a
 call PutSprite
 
 call DELAY
 ret


Out_2_Third: 
 ld b,11
Out3Move:
 call Left_Move
 jp Out  

Left_Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 dec a
 ld b,a
 ld (ballX),a
 call Trip
 pop bc
 djnz Left_Move
 ret

Move_Right:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 inc a
 ld b,a
 ld (ballX),a
 call Trip
 pop bc
 djnz Move_Right
 ret

Trip:
 ld a,c
 dec a
 dec a
 ld c,a
 ld (ballY),a
 call PutSprite
 
 call DELAY
 ret

Out_2_First: 
 ld b,11
 call Move_Right
 jp Out  

Single_2_Left: 
 ld b,11
Single1Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 dec a
 ld b,a
 ld (ballX),a
 call Sing
 pop bc
 djnz Single1Move
 jp Single 


Single_2_Right: 
 ld b,11
Single2Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 inc a
 ld b,a
 ld (ballX),a
 call Sing
 pop bc
 djnz Single2Move
 jp Single  

Sing:
 ld a,c
 dec a
 dec a
 dec a
 dec a
 ld c,a
 ld (ballY),a
 call PutSprite
 
 call DELAY
 ret


Ball:
 call DerbyCheck
 ld a,(balls)
 inc a
 ld (balls),a
 cp 4
 jr c,ContBall
 call ClearStats
 call Single
ContBall:
 ld de,$1439
 ld hl,I2
 call DMX
 jp SwingEnd


Out_2_Left:
 ld b,12
Out5Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 dec a
 ld b,a
 ld (ballX),a
 call Pop_Out
 pop bc
 djnz Out5Move
 jp Out  

Out_2_Right:
 ld b,12
Out6Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 inc a
 ld b,a
 ld (ballX),a
 call Pop_Out
 pop bc
 djnz Out6Move
 jp Out  

Pop_Out:
 ld a,c
 add a,-3
 ld c,a
 ld (ballY),a
 call PutSprite
 
 call DELAY
 ret

Strike:
 call DerbyCheck
 ld a,(strikes)
 inc a
 ld (strikes),a
 cp 3
 jr c,ContStrike
 call ClearStats
 ld a,(outs)
 inc a
 ld (outs),a
 cp 3
 jp nc,ChangeTurn
ContStrike:
 ld de,$1436
 ld hl,InfoTxt
 call DMX
 jp SwingEnd


Out:
 call ClearStats
 call DerbyCheck
 ld a,(outs)
 inc a
 ld (outs),a
 cp 3
 jr nc,ChangeTurn
OutDisp:
 ld de,$143B
 ld hl,I3
 call DMX
 jp SwingEnd

ClearStats:
 xor a
 ld (strikes),a
 ld (balls),a
 ret

;
; Scoring and Inning Routines
;


ChangeTurn:
 
 ld de,$143B
 ld hl,I3
 call DMX
 call OTH_PAUSE
 xor a
 ld (outs),a 
 inc a
 ld (Base1Flag),a
 ld (Base2Flag),a
 ld (Base3Flag),a
 ld a,(Turn)
 inc a
 ld (Turn),a
 cp 1
 call nc,CheckTwoWin
 ld a,(Turn)
 inc a
 dec a
 cp 2
 jr nc,IncInn
 ROM_CALL(CLEARLCD)
 ld a,(players)
 dec a
 jr z,RandomScore
 ld de,$0703
 ld hl,P2
 call DTX
 call OTH_PAUSE
 jp GameStart

RandomScore:
 xor a
 ld (Turn),a
 call RAND3
 cp 1
 jr c,IncInn  ;1/3 chace of no score

 call RAND2
 jr nz,LoadScore ;1/3 chance of one run
 call RAND3
 inc a        ;1/3 chace of 2-4 runs
 inc a
LoadScore:
 ld b,a
 ld       a,(player2score)
 add      a,b
 ld       (player2score),a
 jr IncInn

CheckTwoWin:
 ld a,(innings)
 cp 9
 ret c  ;Return if not 9th
 call LoadScores
 call CP_HL_DE
 jr c,twowin2
 ret

twowin2:
 inc sp
 inc sp  ;Update Stack
 jp twowin

LoadScores:
 ld hl,player2score
 ld e,(hl)
 ld d,0
 ld hl,player1score
 ld l,(hl)
 ld h,0
 ret

IncInn:
 ld a,(DerbyFlag)
 dec a
 jr nz,Quit
 xor a
 ld (Turn),a
 ld a,(innings)
 inc a
 ld (innings),a
 cp 10
 jr nc,Quit
Inn2:
 ROM_CALL(CLEARLCD)
 ld de,$0B03
 ld hl,innings
 call DCX2 
 ld de,$0603
 ld hl,Itxt
 call DTX
 call OTH_PAUSE
 jp GameStart

;*
;*  Winning Routines
;*

Quit:
 call LoadScores
 call CP_HL_DE
 jr nc,onewin
twowin:
 ld a,(SeasonFlag)
 dec a
 call nz,AddLoss
 call ShowFinal
 ld de,$0403
 ld hl,P2
 call DTX
 ld de,$0D03
 ld hl,info_text2+9
 call DTX
 call OTH_PAUSE
 jp quit2

OTH_PAUSE:
 call GET_KEY
 cp G_ENTER
 jr nz,OTH_PAUSE
 ret

onewin:
 call LoadScores
 inc e

 call CP_HL_DE
 jp c,Inn2
 ld a,(SeasonFlag)
 dec a
 call nz,AddWin
 call ShowFinal
 ld de,$0403
 ld hl,info_text2
 call DTX
 call OTH_PAUSE
 jp quit2

ShowFinal:
 call DisplayInfo
 ld de,$142F
 ld hl,Final
 call DMX
 call OTH_PAUSE
 ROM_CALL(CLEARLCD)
 ret

AddWin:
 ld a,(wins)
 inc a
 ld (wins),a
 ld a,(games)
 dec a
 ld (games),a
 jr z,SeasonEnd
 ret

AddLoss:
 ld a,(losses)
 inc a
 ld (losses),a
 ld a,(games)
 dec a
 ld (games),a
 jr z,SeasonEnd
 ret

YouLose:
 set 3,(iy+5)
 ld de,$0503
 ld hl,lost
 call DTX
 res 3,(iy+5)
 call OTH_PAUSE
 jr Ending2
 

SeasonEnd:
 call ShowSeasonInfo
 call OTH_PAUSE
 ROM_CALL(CLEARLCD)
 ld a,(wins)
 cp 32
 jr c,YouLose
SEA:
 ld de,0
 ld hl,Ending_1
 call DTX
 inc e
 inc e
 ld hl,e2
 call DTX
 ld de,$0203
 ld hl,ProgDesc
 call DTX
 inc e
 ld hl,Seas
 call DTX
 ld de,$0006
 ld hl,e3
 call DTX
 call OTH_PAUSE
Ending2:
 ROM_CALL(CLEARLCD)
 ld de,$0D23
 ld hl,Ending_2
 call DMX
 ld hl,aut
 ld de,$142E
 call DMX
 ld hl,e4
 ld de,$1B1B
 call DMX
 ld de,$2618
 call DMX
 ld de,$2C10
 call DMX
 ld de,$3330
 call DMX
 ld b,255
 call D_WAIT
 ld b,150
 call D_WAIT

 ROM_CALL(CLEARLCD)
 ld de,$0C2C
 ld hl,Ending_3
 call DMX
 ld de,$141E
 call DMX
 ld de,$1C1C
 call DMX
 ld b,255
 call D_WAIT
 ld b,150
 call D_WAIT
 ld a,1
 ld (SeasonFlag2),a
 jp quit2

DerbyCheck:
 ld a,(DerbyFlag)
 dec a
 ret z
 inc sp
 inc sp
 ld a,(outs)
 inc a
 ld (outs),a
 cp 15
 jp nc,ChangeTurn
 jp OutDisp
 
 

Single:
 call ClearStats
 call DerbyCheck
 ld a,(Base3Flag)
 dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
 dec a
 call nz,MoveSecond1
 ld a,(Base1Flag)
 dec a
 call nz,MoveFirst1
 call SetFirst
 ld de,$1438
 ld hl,I4
 call DMX
 jp SwingEnd

SetFirst:
 ld a,2
 ld (Base1Flag),a
 ret

SetSecond:
 ld a,2
 ld (Base2Flag),a
 ret
 
SetThird:
 ld a,2
 ld (Base3Flag),a
 ret

MoveFirst1:
 ld a,1
 ld (Base1Flag),a
 inc a
 ld (Base2Flag),a
 ret
 
MoveSecond1:
 ld a,1
 ld (Base2Flag),a
 inc a
 ld (Base3Flag),a
 ret

MoveThird1:
 ld a,1
 ld (Base3Flag),a
 jp ScoreRun

MoveFirst2:
 ld a,1
 ld (Base1Flag),a
 inc a
 ld (Base3Flag),a
 ret
 
MoveSecond2:
 ld a,1
 ld (Base2Flag),a
 jp ScoreRun

MoveFirst3:
 ld a,1
 ld (Base1Flag),a
 jp ScoreRun

ShowFirst:
 ld b,$57
 ld c,$28
 ld hl,Base1
 call PutSprite
 ret

ShowSecond:
 ld b,$3D
 ld c,$19
 ld hl,Base2
 call PutSprite
 ret

ShowThird:
 ld b,$25
 ld c,$28
 ld hl,Base3
 call PutSprite
 ret

Double:
 call ClearStats
 call DerbyCheck
 ld a,(Base3Flag)
 dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
 dec a
 call nz,MoveSecond2
 ld a,(Base1Flag)
 dec a
 call nz,MoveFirst2
 call SetSecond
 ld de,$1438
 ld hl,I5
 call DMX
 jp SwingEnd

Double_2_Left:
 call RAND2
 jp z,Out_2_Third 
 ld b,17
Double1Move:
 call Left_Move
 call RAND2
 jr z,Double
 jr Triple 

Triple_2_Right:
 call RAND2
 jp z,Out_2_First 
 ld b,17
TripleMove:
 call Move_Right
 call RAND2
 jp z,Double

Triple:
 call ClearStats
 call DerbyCheck
 ld a,(Base3Flag)
  dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
  dec a
 call nz,MoveSecond2
 ld a,(Base1Flag)
  dec a
 call nz,MoveFirst3
 call SetThird
 ld de,$1438
 ld hl,I6
 call DMX
 jp SwingEnd


PopOut:
 ld b,15
 jr HomeMove

HomeRun:
 call ClearStats
 call RAND2
 inc a
 push af
 dec a
 jr nz,PopOut
 ld b,20
HomeMove:
 push bc
 call LoadBallData
 call PutSprite
 ld a,c
 add a,-3
 ld c,a
 ld (ballY),a
 call PutSprite
 
 call DELAY
 pop bc
 djnz HomeMove
 pop af
 dec a
 jp nz,Out
 ld a,(Base3Flag)
  dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
  dec a
 call nz,MoveSecond2
 ld a,(Base1Flag)
  dec a
 call nz,MoveFirst3
 ld a,(SeasonFlag)
 dec a
 call nz,IncHome
 call ScoreRun
 ld de,$1432
 ld hl,I7
 call DMX
 jp SwingEnd

IncHome:
 ld a,(homeruns)
 inc a
 ld (homeruns),a
 ret

IncRun:
 ld a,(runs)
 inc a
 ld (runs),a
 ret

ScoreRun:
 ld a,(Turn)
 dec a
 jr z,Score2
 ld a,(SeasonFlag)
 dec a
 call nz,IncRun
 ld a,(player1score)
 inc a
 ld (player1score),a
 ret

Score2:
 ld a,(player2score)
 inc a
 ld (player2score),a
 ret

;
;Misc Routines
;


PutSprite:
	push    BC
	push    DE
	ld      DE, GRAPH_MEM
convdone:
	ld      A, 63
	sub     C
	ld      C, A
	push    HL
	push    HL
	call    FIND_PIXEL
	add     HL, DE
	ex      DE, HL
	pop     HL
	ld      B, (HL)
	inc     HL
	ld      C, (HL)
	inc     HL
	push    HL
	pop     IX
	ex      DE, HL
PS_NewRow:
	push    BC
	ld      D, (IX)
	inc     IX
	push    AF
	push    HL
PS_NewCol:
	rl      D
	ld      E, A
	jr      nc, PS_NextPixel
	xor     (HL)
	ld      (HL), A
PS_NextPixel:
	ld      A, E
	rrca
	jr      nc, PS_SameByte
	inc     HL
PS_SameByte:
	djnz    PS_NewCol
	pop     HL
	pop     AF
	ld      DE, 16
	add     HL, DE
	pop     BC
	dec     C
	jr      nz, PS_NewRow
	pop     HL
	pop     DE
	pop     BC
      ret

Write:
 push hl
 ld de,$0200
 ld hl,EnterN
 call DTX            ;Added to save bytes
 ld hl,$0804
 ld (CURSOR_ROW),hl
 pop hl

 ld b,0 	       ; B = number of letters entered so far

WaK:		       ; A simple string input routine follows
 push hl
 push bc	       ; GET_KEY destroys B. It doesn't on the TI-85 :-/
 call GET_KEY
 pop bc
 cp $02
 jr z,BackSpace
 cp $09
 jr z,NameDone
 cp $11
 jr nz,CheckLetter
 ld a,32
 pop hl
 jr PutLetter
CheckLetter:
 ld hl,Letters
 push bc
 ld bc,26
 cpir
 ld d,c
 pop bc
 pop hl
 jr nz,WaK
 ld a,65
 add a,d
PutLetter:
 ld c,a
 ld a,b
 cp 3
 jr z,WaK
 ld (hl),c
 inc hl
 inc b
 ld a,c
 ROM_CALL(TX_CHARPUT)
 jr WaK
BackSpace:
 pop hl
 ld a,b
 or a
 jr z,WaK
 dec b
 dec hl
 push hl
 ld (hl),32
 ld hl,$C010
 dec (hl)
 ld a,32
 ROM_CALL(TX_CHARPUT)
 dec (hl)
 pop hl
 jr WaK
NameDone:
 pop hl
 ret

chartable:
         .db      ":WRMH."
         .DB      "..0VQLG!..ZUPKFC"
         .DB      "..YTOJEBX.>SNIDA"
         .DB      ".12345.."

DisplayInfo:
 ld de,field
 ld hl,$c9fa
 call DecodeZCP
 ld hl,$c9fa
 ld de,$fc00
 ld bc,1024
 ldir
 ld a,(Base3Flag)
  dec a
 call nz,ShowThird
 ld a,(Base2Flag)
  dec a
 call nz,ShowSecond
 ld a,(Base1Flag)
  dec a
 call nz,ShowFirst
 ld de,$3258
 ld hl,player1name
 call DMX
 ld de,$3858
 ld hl,player2name
 call DMX
 ld de,$2C18
 ld hl,strikes
 ld b,1
 call DM_HL_DECI
 ld de,$3218
 ld hl,balls
 ld b,1
 call DM_HL_DECI
 ld de,$3818
 ld hl,outs
 ld b,1
 call DM_HL_DECI
 ld de,$3826
 ld hl,innings
 ld b,2
 call DM_HL_DECI
 ld de,$3267
 ld hl,player1score
 ld b,2
 call DM_HL_DECI
 ld de,$3867
 ld hl,player2score
 ld b,2
 call DM_HL_DECI
 ld a,(DerbyFlag)
 dec a
 call nz,DispDerbyInfo
 ret

ShowSeasonInfo:
 ROM_CALL(CLEARLCD)
 ld de,$0B04
 ld a,(wins)
 call DCX2 

 ld de,$0B05
 ld a,(losses)
 call DCX2

 ld de,$0B07
 ld a,(games)
 call DCX2
 ld de,$0B01
 ld a,(homeruns)
 call DCX2

 ld de,$0B02
 ld a,(runs)
 call DCX2

 set 3,(iy+5) ;inverse text
 ld de,$0200
 ld hl,Season_1
 call DTX
 res 3,(iy+5)
 ld de,$0301
 call DTX
 ld de,$0302
 call DTX
 ld de,$0304
 call DTX
 ld de,$0305
 call DTX
 ld de,$0306
 call DTX
 ld de,$0207
 call DTX
 ld a,(wins)
 ld b,a
 ld a,(losses)
 add a,b
 or a
 jr z,no_stats
 ld l,b
 ld h,100
 push af
 ROM_CALL(MUL_HL)  	; wins*100
 pop af
 call $4048   ; (100*wins)/total
 ld de,$0B06
 call DCX3

 ld a,$25
 ROM_CALL(TX_CHARPUT)
no_stats:
 ret

DTX:
         ld       (CURSOR_ROW),de
	   ROM_CALL(D_ZT_STR)
         ret


DispDerbyInfo:
 ld de,$3812
 ld hl,derbyT
 call DMX
 ld de,$3818
 ld hl,outs
 ld b,2
 call DM_HL_DECI
 ld de,$382A
 ld hl,innings
 ld b,1

DM_HL_DECI:
 ld (CURSOR_X),de
 ld l,(hl)            ;Stuff added to save bytes
 ld h,0

;Routine Starts here
 ld de,string+5
 xor a
 ld (de),a
RepUnp:
 dec de
 call UNPACK_HL
 add a,48
 ld (de),a
 djnz RepUnp
 ex de,hl
 jr DMX2


DMX:
         ld       (CURSOR_X),de
DMX2:
         ROM_CALL(D_ZM_STR)
         ret

DCX2:
 ld l,a
 ld h,0
DCX3:
 ld (CURSOR_ROW),de
 ld a,0
 ROM_CALL(D_HL_DECI)
 ret

LoadSprData:
 ld a,(sprX)
 ld b,a
 ld a,(sprY)
 ld c,a
 ret

LoadBallData:
 ld a,(ballX)
 ld b,a
 ld a,(ballY)
 ld c,a
 ld hl,ball
 ret

DELAY:
 ld b,13
D_WAIT:
 EI
 HALT
 DJNZ D_WAIT
 RET




Medium:
 ld a,9
 jr PitchSpeedSet

SortaFast:
 ld a,6
 jr PitchSpeedSet

DELAY2:
 ld a,(HitCounter)
 dec a                ;UpdateHitCOunter
 ld (HitCounter),a
 ld a,(DerbyFlag)
 dec a
 jr nz,Medium
 ld a,(SPEED)
 dec a
 jr z,Medium
 dec a
 jr z,SortaFast
 ld a,3
PitchSpeedSet:
 ld b,a
delay22:
 push bc   
 ld b,65 
 call delaya  
d2:
 pop bc   
 djnz delay22 
 ret

delaya:
      inc sp
      inc sp
delay3:
        push bc  ;temp storage of bc
        pop bc   ;recall bc
        
       call OTH_ARROW

        bit 5,a
        jp z,SwingBat

        djnz delay3 ;b-l->b if b=0 return else do it again
        jr d2

OTH_ARROW:

        PUSH    BC
        LD      A,$fe
        OUT     ($01),A ; Port 1 Keypad
        NOP \ NOP \ NOP \ NOP     
        IN      A,($01) ; Port 1 Keypad
        LD      B,A
        LD      A,$ff
        IN      A,($01) ; Port 1 Keypad
        LD      A,B
        LD      A,$bf
        OUT     ($01),A ; Port 1 Keypad
        IN      A,($01) ; Port 1 Keypad
        OR      $0f
        AND     B
        POP     BC
 ret


OTH_PAUSE2:
 call GET_KEY
 cp G_ENTER
 ret z
 cp G_MODE
 jr nz,OTH_PAUSE2
 inc sp
 inc sp
 jp quit2




RAND2:
 ld a,2
 call RANDOM
 or a
 ret

RAND3:
 ld a,3
RANDOM:
	ld b,a 				; Create a Random number
 	ld a,r
 	add a,a
 	ld hl,0
 	ld d,0
 	ld e,a
RMul:
 	add hl,de
 	djnz RMul
 	ld a,h				
	ret	


;
;  Text Strings
;

ProgDesc:   .db      "Baseball '99 v0.7",0
            .db 0
Copy:
         .db      "Copyright 1999 by:",0
aut:
         .db      "Sam Heald",0
Modes:
         .db      "HomeRun Derby",0
         .db      "Exhibition Mode",0
Seas:
         .db      "Season Mode",0
PlayerChoose:

 .db "Choose player mode",0
 .db "1 player",0
 .db "2 players",0
EnterN:
 .db "Enter your name:",0


P2:
 .db "Player 2",0

Final:
 .db "Final Score",0

lost:
 .db "Game Over!"

InfoTxt:
 .db "Strike",0
I2:
 .db "Ball",0
I3:
 .db "Out",0
I4:
 .db "Single",0
I5:
 .db "Double",0
I6:
 .db "Triple",0
I7:
 .db "Home Run!",0

Itxt:
 .db "Inning:",0

info_text2: .db "Player 1 "
            .db "Wins!",0

derbyT:
 .db "O:00 IN:  ",0

Season_1:
 .db  "'99 Season Stats",0
 .db 0
 .db "HomeRuns:",0
 .db "RBIs:",0
 .db "Wins:",0
 .db "Losses:",0
 .db "Win Pct:",0
 .db "Games Left:",0

Season_2:
 .db "Continue season?",0
 .db "Yes",0
 .db "No",0

Ending_1:
 .db  "Congratulations!",0
e2:
 .db  "You have beaten ",0
e3:
 .db  " Now watch the  "
 .db  "   credits...   ",0

Ending_2:
 .db  "Programmed by:",0
e4:
 .db  "evil_sam@hotmail.com",0
 .db  "WebSite: (Both lines)",0
 .db  "www.cswnet.com/",0
 .db  "/~ddward/the82/",0
Ending_3:
 .db  "Graphics by:",0
 .db  "Bill Nagel",0
 .db  "ManjiLump",0

Teams:
 .db "SAM",0  ;The Sam Heald Sox
 .db "ATL",0  ;Braves
 .db "BOS",0  ;Red Sox
 .db "NYY",0  ;Yankees
 .db "NYM",0  ;Mets
 .db "STL",0  ;Cardinals
 .db "FLA",0  ;Marlins
 .db "CUB",0  ;Cubs
 .db "CHI",0  ;White Sox
 .db "DET",0  ;Tigers
 .db "TOR",0  ;BlueJays
 .db "MIN",0  ;Twins
 .db "ARZ",0  ;DiamondBacks
 .db "TEX",0  ;Rangers
 .db "HOU",0  ;Astros
 .db "CLE",0  ;Indians
 .db "LAD",0  ;Dodgers
 .db "ANH",0  ;Angels
 .db "COL",0  ;Rockies
 .db "PHI",0  ;Phillies
 .db "BAL",0  ;Orioles
 .db "MON",0  ;Expos
 .db "KAN",0  ;Royals
 .db "SFG",0  ;Giants
 .db "SDP",0  ;Padres
 .db "SEA",0  ;Mariners
 .db "TBD",0  ;Devil-Rays
 .db "OAK",0  ;A's
 .db "CIN",0  ;Reds
 .db "MIL",0  ;Brewers
 .db "PIT",0  ;Pirates



;
;Sprites
;
ball:
 .db 2,2
 .db %11000000
 .db %11000000

Runner:
 .db 3,6
 .db %01000000
 .db %10100000
 .db %01000000
 .db %11100000
 .db %01000000
 .db %10100000

Base1:
 .db 4,6
 .db %00100000
 .db %01010000
 .db %00100000
 .db %11110000
 .db %01000000
 .db %01000000
Base2:
 .db 4,6
 .db %01000000
 .db %10100000
 .db %01000000
 .db %11100000
 .db %01110000
 .db %01100000

Base3:
 .db 4,6
 .db %01000000
 .db %10100000
 .db %01000000
 .db %11110000
 .db %00100000
 .db %00100000

Batter:
 .db 4,6
 .db %001000000
 .db %110100000
 .db %001000000
 .db %000100000
 .db %001100000
 .db %010100000

PlayerSwing1:
 .db 6,6
 .db %01000000
 .db %10100000
 .db %01011110
 .db %10101110
 .db %01110000
 .db %10100000 

Letters:
 .db $19,$21,$0A,$12,$1A,$22,$0B,$13,$1B,$23,$2B
 .db $0C,$14,$1C,$24,$2C,$0D,$15,$1D,$25,$2D,$0E
 .db $16,$1E,$26,$2E


Title1:
 .db $1C,$FF,$3F,$17,$49,$A0,$3F,$10,$4B,$A0,$3F,$0E,$4C,$90,$3F,$0D,$4A,$81
 .db $3F,$10,$49,$82,$C0,$36,$F0,$0B,$50,$90,$35,$E2,$0D,$51,$A0,$34,$C1,$0D
 .db $53,$39,$C0,$C0,$81,$51,$A0,$33,$C0,$C0,$81,$52,$B0,$33,$C0,$C0,$83,$52
 .db $90,$33,$C0,$C0,$86,$BF,$F8,$FC,$37,$C1,$0A,$E3,$FD,$FE,$3A,$C0,$C0,$84
 .db $BF,$49,$3C,$C1,$0A,$C7,$F8,$9C,$3B,$C1,$0A,$C8,$83,$98,$3B,$C2,$0A,$E0
 .db $82,$A0,$3B,$C2,$0B,$C0,$82,$3F,$91,$0B,$F0,$FB,$3F,$88,$C0,$8C,$F0,$93
 .db $3F,$91,$80,$C1,$BF,$82,$3F,$A4,$84,$82,$88,$88,$3F,$C8,$90,$87,$C0,$90
 .db $3E,$CE,$C2,$81,$08,$C0,$3D,$D2,$84,$87,$F0,$C0,$13,$53,$B9,$10,$48,$88
 .db $90,$91,$18,$D2,$23,$C3,$92,$87,$F2,$C0,$12,$CC,$48,$B9,$15,$C1,$C9,$8F
 .db $F9,$C0,$11,$C3,$90,$1E,$C3,$F5,$9F,$48,$17,$F9,$F0,$20,$E0,$BF,$FE,$82
 .db $16,$CC,$9E,$E8,$1A,$C6,$8F,$F8,$84,$15,$C6,$90,$21,$C9,$8F,$F0,$88,$16
 .db $C4,$C0,$21,$EF,$FF,$09,$C0,$14,$CA,$28,$DC,$8B,$C1,$E0,$16,$F8,$28,$F0
 .db $A0,$FC,$A0,$36,$49,$81,$F1,$9F,$E7,$FE,$48,$81,$E0,$BE,$87,$F0,$08,$4A
 .db $81,$F3,$9F,$E7,$FE,$49,$83,$E0,$FC,$8F,$E0,$81,$CF,$FC,$9E,$AF,$FE,$FD
 .db $F3,$DE,$8F,$81,$E0,$9F,$0A,$F3,$EF,$87,$CB,$F7,$DE,$DC,$F3,$C3,$E0,$B8
 .db $83,$C0,$83,$EF,$BC,$BE,$AF,$CE,$F9,$B3,$CE,$8F,$81,$E0,$8E,$0A,$FB,$EF
 .db $8F,$EB,$F3,$DE,$B8,$F3,$C3,$F0,$B8,$83,$C0,$83,$EF,$BC,$BF,$AF,$CC,$F9
 .db $D3,$CE,$8F,$C1,$E0,$8E,$0B,$E7,$FC,$9F,$F7,$F9,$BF,$E5,$EE,$8D,$F0,$F0
 .db $87,$10,$FF,$83,$BC,$48,$9F,$F9,$BF,$C3,$BC,$9C,$81,$E0,$0B,$48,$86,$F8
 .db $48,$9F,$F1,$FF,$86,$F8,$B8,$83,$C0,$0A,$49,$98,$F0,$FF,$9F,$F1,$F3,$CC
 .db $B8,$B8,$83,$C0,$0A,$F9,$F7,$FE,$C7,$F7,$D8,$9C,$FB,$FE,$8E,$80,$F0,$0C
 .db $F9,$F7,$FE,$E7,$F7,$DB,$9C,$FB,$FE,$8E,$8C,$F0,$E0,$83,$E7,$4B,$B5,$FB
 .db $E5,$CE,$BF,$FF,$87,$86,$B8,$B0,$81,$F7,$FE,$9D,$E7,$EF,$9E,$F9,$FE,$8E
 .db $9C,$B9,$E1,$C0,$87,$4C,$9D,$49,$BE,$49,$9F,$E1,$E3,$C7,$BE,$98,$81,$49
 .db $BF,$4E,$9F,$4F,$BC,$FD,$54,$09,$48,$8F,$BF,$9F,$C7,$50,$9E,$BE,$49,$BF
 .db $FC,$12,$E3,$C0,$12,$EC,$39,$E6,$19,$E4,$10,$E7,$C7,$C0,$13,$E6,$1B,$E8
 .db $0F,$EC,$EC,$E0,$10,$F9,$C0,$17,$E6,$0E,$EC,$EC,$E0,$0F,$E3,$C0,$18,$FC
 .db $C0,$0B,$E6,$E6,$12,$E1,$C0,$19,$FE,$A0,$0B,$FC,$FC,$11,$FE,$E0,$1A,$4C
 .db $10,$E0,$E0,$0D,$49,$20,$C1,$FF,$0D,$E0,$E0,$0D,$C3,$F0,$1C,$FC,$81,$09
 .db $E6,$E6,$11,$E0,$A0,$21,$49,$09,$F8,$F8,$0A,$00




field:
.db $D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA
.db $CA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5
.db $AD,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$57,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D2,$D5
.db $AA,$D5,$AA,$D5,$AA,$DF,$E0,$0F,$48,$AA,$D5,$AA,$D5,$AA,$D5,$AD,$AA,$D5
.db $AA,$D5,$AA,$DF,$E0,$A0,$0F,$C0,$BF,$D5,$AA,$D5,$AA,$D5,$A9,$AA,$D5,$AA
.db $D5,$AF,$F0,$09,$C0,$0E,$C0,$80,$48,$AA,$D5,$AA,$D5,$AD,$AA,$D5,$AA,$D5
.db $B8,$0F,$C0,$0E,$C0,$0D,$F5,$AA,$D5,$AA,$D4,$D5,$AA,$D5,$AA,$F2,$11,$C0
.db $0E,$C0,$0D,$DA,$D5,$AA,$D5,$AB,$AA,$D5,$AA,$D7,$C2,$0E,$5C,$10,$C7,$AA
.db $D5,$AA,$D4,$D5,$AA,$D5,$AC,$82,$08,$FE,$1B,$FF,$09,$C1,$F5,$AA,$D5,$AB
.db $AA,$D5,$AA,$F0,$82,$9F,$C0,$23,$FE,$90,$86,$D5,$AA,$D5,$95,$AA,$D5,$E0
.db $81,$F8,$32,$FC,$80,$F5,$AA,$D5,$B5,$AA,$D5,$C0,$83,$3F,$E0,$86,$D5,$AA
.db $D2,$D5,$AB,$C0,$83,$21,$C0,$1B,$E0,$87,$AA,$D5,$B5,$AA,$D8,$08,$E0,$1D
.db $D0,$1E,$E0,$82,$D5,$AA,$AA,$D5,$C0,$8E,$24,$C0,$1F,$E0,$87,$AA,$D6,$D5
.db $AC,$81,$C0,$21,$F0,$22,$E0,$86,$D5,$A5,$AA,$E0,$98,$27,$C0,$23,$E0,$8D
.db $AA,$EA,$D6,$83,$2B,$D0,$26,$E0,$9A,$D4,$D5,$B0,$B0,$3F,$19,$E0,$B5,$AD
.db $AA,$86,$3F,$20,$E0,$EA,$CA,$D8,$E0,$14,$C0,$2C,$C0,$11,$E2,$D5,$D5,$AC
.db $18,$D0,$2C,$D0,$14,$ED,$A9,$AB,$A0,$17,$C0,$2C,$C0,$14,$D5,$AD,$AA,$C0
.db $15,$F0,$2C,$F0,$15,$DA,$D2,$D6,$C0,$16,$C0,$2C,$C0,$14,$D5,$AD,$AA,$C0
.db $15,$D0,$2C,$D0,$14,$CD,$A9,$AB,$A0,$3F,$24,$C5,$AB,$AA,$CC,$28,$C0,$0C
.db $C0,$21,$C3,$AA,$AA,$E1,$28,$D0,$98,$82,$C0,$1F,$C1,$AA,$EA,$D0,$B0,$23
.db $C1,$CC,$82,$23,$E0,$B5,$A5,$AC,$82,$24,$F3,$81,$C3,$C0,$1C,$C0,$95,$AD
.db $AA,$80,$E0,$1F,$C9,$CC,$C2,$20,$E0,$9A,$D4,$D5,$B0,$84,$20,$D8,$98,$9A
.db $C0,$19,$C0,$BA,$D5,$D5,$AE,$81,$C0,$1B,$C0,$0A,$C0,$1A,$E0,$95,$AA,$CA
.db $D5,$A0,$88,$0F,$C0,$83,$12,$E0,$18,$C0,$95,$AA,$DA,$D5,$A8,$83,$0F,$D0
.db $86,$15,$E0,$88,$0E,$C0,$95,$AA,$D2,$D5,$AA,$08,$C0,$09,$C0,$90,$16,$C0
.db $D0,$0A,$E0,$8A,$D5,$AB,$AA,$D5,$A0,$86,$0B,$F0,$B0,$18,$E0,$C0,$08,$C0
.db $8A,$D5,$AA,$AA,$D5,$AC,$80,$C0,$81,$86,$0F,$C0,$09,$E7,$0B,$E0,$8D,$AA
.db $D5,$B5,$AA,$D5,$E0,$88,$80,$D2,$10,$D0,$0C,$C8,$08,$C0,$8D,$AA,$D5,$A5
.db $AA,$D5,$A8,$83,$0B,$E0,$0E,$C0,$0C,$E8,$83,$08,$F5,$AA,$D5,$B5,$AA,$D5
.db $AC,$81,$09,$C0,$0E,$F0,$0F,$C0,$90,$82,$D5,$AA,$D5,$95,$AA,$DF,$4A,$8C
.db $8C,$12,$F8,$11,$E0,$C0,$9A,$D5,$AA,$D5,$D5,$AA,$D0,$08,$C1,$99,$12,$D6
.db $11,$CD,$C0,$9A,$D5,$AA,$D5,$95,$AA,$D9,$C0,$90,$98,$90,$0E,$F8,$0F,$C1
.db $09,$EA,$D5,$AA,$D5,$D5,$AA,$D4,$A0,$A0,$88,$C0,$24,$CC,$81,$EA,$D5,$AA
.db $D5,$95,$AA,$D9,$09,$C0,$8E,$2B,$E0,$85,$AA,$D5,$AA,$D5,$D5,$AA,$D1,$A0
.db $B8,$81,$2B,$C0,$8D,$AA,$D5,$AA,$D5,$95,$AA,$DB,$09,$DC,$81,$C0,$22,$DF
.db $55,$AA,$D5,$B5,$AA,$D4,$0A,$EA,$08,$C0,$1F,$E4,$16,$EA,$D5,$A5,$AA,$D6
.db $E0,$85,$AC,$81,$C0,$1C,$C2,$17,$D5,$AA,$DA,$D5,$AA,$D4,$86,$D6,$08,$C0
.db $1A,$C1,$18,$EA,$D5,$A5,$AA,$D6,$E0,$85,$AB,$C0,$98,$19,$E0,$A0,$13,$D5
.db $AA,$DA,$D5,$AA,$D4,$86,$D5,$B0,$84,$18,$C0,$90,$14,$EA,$D5,$A5,$AA,$D6
.db $E0,$87,$4F,$84,$15,$E0,$8C,$16,$D5,$AA,$DA,$D5,$AA,$1C,$C1,$C0,$0E,$C0
.db $9A,$17,$EA,$D5,$A5,$AA,$D6,$F0,$8E,$E0,$80,$C0,$A0,$0C,$E0,$8D,$C0,$12
.db $D5,$AA,$DA,$D5,$AA,$D4,$84,$D4,$80,$C0,$98,$0B,$C0,$8D,$A0,$13,$EA,$D5
.db $A5,$AA,$D6,$D0,$84,$D0,$80,$F0,$84,$BF,$88,$81,$D6,$17,$D5,$AA,$DA,$D5
.db $AA,$D4,$84,$D4,$80,$D8,$83,$A1,$B0,$83,$AA,$17,$EA,$D5,$A5,$AA,$D6,$F0
.db $8E,$D0,$80,$EC,$80,$E1,$C0,$8E,$D6,$17,$D5,$AA,$DA,$D5,$AA,$1C,$D7,$09
.db $C8,$80,$D5,$A8,$15,$EA,$D5,$A5,$AA,$D7,$5E,$AB,$08,$E0,$86,$D5,$BF,$55
.db $AA,$D5,$A0,$00

;
; Data
;

ProgName:
 .db $12,8,"baseball"


SGAME:
 .db 0  ;Saved Game flag
Resume:
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0   ;Back up buffer for SaveGame


wins:
 .db 0
losses:
 .db 0
games:
 .db 50
homeruns:
 .db 0
runs:
 .db 0
SeasonFlag:
 .db 1  ;SeasonGame 1=No ,2=Yes

SeasonFlag2:
 .db 1  ;Default one ;2=Season in Progress

seasonname:
 .db "   ",0

Menu:
 ld (curspos),de
 ld (numop),a    ;store the number of options
 xor a
 ld (option),a   ;highlight first 
MenStart:
 call ShowArrow  ;Draw arrow for the first time
menukeys:
 call GET_KEY
 cp G_DOWN
 jr z,go_down
 cp G_UP
 jr z,go_up
 cp G_ENTER
 ret z
 cp G_MODE
 jr nz,menukeys
 inc sp
 inc sp
 ret
 

go_down:
 call ClearArrow
 ld a,(numop)
 ld b,a
 ld a,(option)
 cp b
 call z,gotop
 inc a
 ld (option),a
 jr MenStart

gotop:
 ld a,255
 ret

go_up:
 call ClearArrow
 ld a,(option)
 or a
 call z,gobot
 dec a
 ld (option),a
 jr MenStart

gobot:
 ld a,(numop)
 inc a
 ret
 

ShowArrow:
 ld de,(curspos)
 ld a,(option)
 or a
 jr z,disparrow
 ld b,a       ;go to the right row
arrowlop
 inc e
 djnz arrowlop
disparrow:
 ld a,5
DCX:
 ld (CURSOR_ROW),de
 ROM_CALL(TX_CHARPUT)
 ret

ClearArrow
 ld de,(curspos)
 ld a,(option)
 or a
 jr z,dispblank
 ld b,a       ;go to the right row
blanklop
 inc e
 djnz blanklop
dispblank:
 ld a,32
 jr DCX

ClearG:
 ld hl,$c9fa
 ld (hl),0
 ld de,$c9fa+1
 ld bc,1023
 ldir
 ret


.end


