;------------------------------------------
;|Archery 86z
;|By: Ahmed El-Helw
;|Copyright (C) 1997
;|Version 1.0
;|
;|Date Started : December 23, 1997
;|Date Completed : December 24, 1997
;|ahmed3@worldnet.att.net
;|http://asm86.home.ml.org
;|
;|Please use this source and learn from
;|it.  It is fully commented, except for 
;|the sprite routine and that is it.
;|If you use anything, please give
;|me and anyone else whom I credited in
;|this source credit.  If you have any
;|ideas, suggestions, comments, etc.
;|please contact me.  Any ideas would
;|be appreciated.  Thank You.
;|
;|This is best viewed with EditPad
;|http://www.tornado.be/~johnfg
;|or get it from any TUCOWS server.
;------------------------------------------

#include asm86.h
#include ti86asm.inc

.org _asm_exec_ram


Initialize:
	call _runindicoff		;Run Indicator Off
	call _clrLCD			;Clears the Screen
	call TitleScreen		;Title Screen
	call GraphBufClear		;Clear the Graph Buffer
	call VariableSetup		;Sets up Variables
	call ScreenSetup		;Sets up the Screen
	jr GameLoop			;Goto GameLoop

;---------------------------
;|GetKey Loop and Movement
;---------------------------

GameLoop:
	ld 	a,0ffh			;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0feh			;Load desired port
	out     (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp	251			;If key is right
	jp 	z,M_Right		;Goto Right
	cp 	253			;If key is left
	jp 	z,M_Left		;Goto Left
	ld 	a,0ffh			;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0bfh			;Load desired port
	out     (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp 	223			;Is it 2nd
	jp 	z,Fire			;Fire if so
	cp	191			;Is it Exit [Note - would result in Key Delete on 83]
	jp 	z,Quit			;Goto Quit
	jp	nz,NoKeyLoop		;Goto NoKeyLoop if no key

NoKeyLoop:
	call MoveTarget			;Move the Target
	call CheckFire			;Checks the FireBall
	jr GameLoop			;Goto GameLoop

M_Right:				;Move Right
	ld a,(ShipX)			;Ship X into A
	cp 118				;Is it 118 [Line]
	jr z,GameLoop			;ReLoop, don't move
	cp 119				;Is it 119 [Line]
	jr z,GameLoop			;ReLoop, don't move
	call DispShip			;Clear Ship
	ld a,(ShipX)			;Ship X back into A
	inc a				;Increment it
	inc a				;Increment it
	ld (ShipX),a			;A back into ShipX
	call DispShip			;RePut Ship
	jr NoKeyLoop			;Goto NoKeyLoop

M_Left:					;Move Left
	ld a,(ShipX)			;Ship X into A
	cp 1				;Is it 1 [Line]
	jr z,GameLoop			;ReLoop, don't move
	cp 2				;Is it 2 [Line]
	jr z,GameLoop			;ReLoop, don't move
	call DispShip			;Clear Ship
	ld a,(ShipX)			;Ship X back into A
	dec a				;Decrement it
	dec a				;Decrement it
	ld (ShipX),a			;A back into ShipX
	call DispShip			;RePut Ship
	jr NoKeyLoop			;Goto NoKeyLoop

DispShip:				;XORs the Ship Sprite on/off the screen
	ld a,(ShipY)			;Ship Y into A
	ld e,a				;A goes into E, E = Y Coord
	ld a,(ShipX)			;Ship X into A
	ld hl,PlayerShip		;Sprite name into HL
	call PutSprite			;XOR it!
	ret				;Return to call

DispTarget:				;XORs the Target Sprite on/off the screen
	ld a,(TargetY)			;Target Y into A
	ld e,a				;A into E , E = Y Coord
	ld a,(TargetX)			;Target X Coord into A
	ld hl,TargetShip		;Sprite Name into HL
	call PutSprite			;XOR it!
	ret				;Return to Call

DispFire:				;XORs the Ship Sprite on/off the screen
	ld a,(FireY)			;Fire Y into A
	ld e,a				;A goes into E, E = Y Coord
	ld a,(FireX)			;Fire X into A
	ld hl,FireBall			;Sprite name into HL
	call PutSprite			;XOR it!
	ret				;Return to call


;----------------------
;|Fire Routine
;----------------------

Fire:
	ld a,(FireZ)			;Loads FireZ into A
	or a				;If it is 0 [No Fire]
	jr z,NewFire			;Put a new fireball
	jp nz,NoKeyLoop			;NoKeyLoop otherwise

NewFire:				;Creates new FireBall
	ld a,1				;1 into A
	ld (FireZ),a			;A into FireZ
	ld a,(ShipX)			;Ship X into A
	ld (FireX),a			;Loads A into FireX
	ld a,(ShipY)			;ShipY into A
	ld (FireY),a			;A into FireY
	call DispFire			;Display FireBall
	jp NoKeyLoop			;Goto NoKeyLoop

CheckFire:
	call Delay			;Creates a Short Delay
	ld a,(FireZ)			;FireZ into a
	or a				;If it is 0 [No Fire]
	ret z				;Return, no need to bother
	ld a,(FireY)			;FireY into A
	or a				;If it is 0
        jr z,CheckHit                   ;Check for Hit
	call DispFire			;Clear Fire
	ld a,(FireY)			;Fire Y into A again
	dec a				;Decrease it
	ld (FireY),a			;A into FireY
	call DispFire			;RePut Fire
	ret				;Return

CheckHit:                               ;Checks if you hit target
	ld a,(FireX)			;Loads Fire X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(TargetX)			;Loads TargetX into A
	cp b				;Compares a to b
	jp c,ContinueCheck		;Continue Checking if a>b
        jr MissFire                     ;Missed Otherwise
       
ContinueCheck:
	ld a,(TargetX)			;Target X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(FireX)			;Fire X into A
	cp b				;Compare A to B
	jp c,HitTarget			;If b>a then you hit it
	jr MissFire			;You missed otherwise

HitTarget:
	call ResetFire			;Reset the Fire
	ld a,(Hits)			;Load Hits into a
	inc a				;Increase it
	ld (Hits),a			;Load a back
	ld hl,54*256+65			;Load Coords into HL
	ld (_penCol),hl			;Loads PenCol into HL
	ld hl,BlankStr			;Blank String into HL
	call _vputs			;Display it
	ld hl,54*256+65			;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld a,(Hits)			;Variable into HL
	call DispA			;Display HL
	ret				;Return from Call

MissFire:				;You missed :(
	call ResetFire			;Reset the Fire
	ld a,(Misses)			;Load Misses
	inc a				;Increase it
	ld (Misses),a			;Load a back
	ld hl,54*256+110		;Load Coords into HL
	ld (_penCol),hl			;Loads PenCol into HL
	ld hl,BlankStr			;Blank String into HL
	call _vputs			;Display it
	ld hl,54*256+110		;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld a,(Misses)			;Variable into HL
	call DispA			;Display HL
	ret				;Return from Call

ResetFire:				;Reset the Fire
	call DispFire			;Clears the Fire
	xor a				;Loads 0 into A
	ld (FireZ),a			;Reset FireZ
	ld (FireX),a			;Reset FireX
	ld (FireY),a			;Reset FireY
	ret				;Return from Call

;--------------------------------
;|Target Routine, to Move Target
;--------------------------------

MoveTarget:
	call DispTarget			;XOR the Target Ship on the Screen
	ld a,(TargetD)			;Target Direction into A
	or a				;Is it 0
	jr z,M_T_Right			;Move Target Right
	jr nz,M_T_Left			;Otherwise Move Left

M_T_Right:
	ld a,(TargetX)			;Target X into A
	cp 119				;Is it 119
	jr z,ResetTargetMove		;Reset Target to Move Other Direction
	cp 118				;Is it 118
	jr z,ResetTargetMove		;Reset Target to Move Other Direction
	inc a				;Increase it again
	ld (TargetX),a			;Into TargetX
	call DispTarget			;Replace Target on Screen
	ret				;Return

M_T_Left:
	ld a,(TargetX)			;Target X into A
	cp 2				;Is it 2
	jr z,ResetTargetMove		;Reset Target to Move Other Direction
	cp 1				;Is it 1
	jr z,ResetTargetMove		;Reset Target to Move Other Direction
	dec a				;Decrease it
	ld (TargetX),a			;Into TargetX
	call DispTarget			;Replace Target on Screen
	ret				;Return

ResetTargetMove:
	ld a,(TargetD)			;Load Target Direction into A
	or a				;Is it 0?
	jr z,ResetLeft			;Reset it to go left!
	xor a				;Loads 0 into a
	ld (TargetD),a			;Loads A into Direction 
	jr M_T_Right			;Move Right

ResetLeft:
	ld a,1				;Load 1 into A
	ld (TargetD),a			;Loads A into Target Direction
	jr M_T_Left			;Move Left

;----------------------
;|Screen Setup
;----------------------

ScreenSetup:				;Draws a box around the screen
	ld b,0				;Sets Coordinates
	ld c,0				;Setting Coords
	ld d,0				;Setting Coords
	ld e,64				;Setting Coords
	ld h,1				;h = 1 for shading
	call _ILine			;Draw a line!
	ld b,126			;Set Coord for line
	ld c,0				;Set Coords
	ld d,126			;Set Coords
	ld e,64				;Set Coords
	ld h,1				;H = 1 for shading
	call _ILine			;Draw the Line!
	ld b,0				;Setting Coords
   	ld c,63				;Set Coords
   	ld d,128			;Set Coords
   	ld e,63				;Set Coords
  	ld h,1				;H = 1 for Shading [2 = Unshade, 3 = XOR]
  	call  _ILine			;Draw the Line!
	ld b,0				;Setting Coords
   	ld c,1				;Set Coords
   	ld d,128			;Set Coords
   	ld e,1				;Set Coords
  	ld h,1				;H = 1 for Shading
  	call  _ILine			;Draw the line!
	call DispTarget			;Display Target
	call DispShip			;Display Ship
	set 3,(iy+5) 			;Set text to inverse
	ld hl,54*256+2			;Set Coordinates
	ld (_penCol),hl			;Put them into HL
	ld hl,TitleStr			;Load Title String	
	call _vputs			;Display it!
	ld hl,54*256+63         	;Set Coordinates
	ld (_penCol),hl			;Put them into HL
	ld hl,BlankStr			;Load Title String	
	call _vputs			;Display it!
	ld hl,54*256+70         	;Set Coordinates
	ld (_penCol),hl			;Put them into HL
	ld hl,BlankStr			;Load Title String	
	call _vputs			;Display it!
	ld hl,54*256+80         	;Set Coordinates
	ld (_penCol),hl			;Put them into HL
	ld hl,ScoreStr			;Load Title String	
	call _vputs			;Display it!
	ld hl,54*256+110         	;Set Coordinates
	ld (_penCol),hl			;Put them into HL
	ld hl,BlankStr			;Load Title String	
 	call _vputs			;Display it!
	ld hl,54*256+115         	;Set Coordinates
	ld (_penCol),hl			;Put them into HL
	ld hl,BlankStr			;Load Title String	
 	call _vputs			;Display it!
	ret				;Return!

VariableSetup:				;Sets up the Variables
	ld a,46				;46 into A
	ld (ShipY),a			;A into Ship's Y Coord
	xor a				;Loads 0 into A
	ld (TargetD),a			;Loads A into Target Direction
	ld (Hits),a			;Loads A into Hits
	ld (Misses),a			;Loads A into Misses
	ld a,2				;Loads 2 into A
	ld (TargetY),a			;Loads A into Target Y
	ld a,43				;43 into A
	ld (ShipX),a			;A into ShipX
	ld (TargetX),a			;A into TargetX
	ret

;-----------------------
;|Title Screen
;-----------------------
TitleScreen:
	xor a				;Load 0 into A
	ld (_curRow),a			;Into Cursor Row
	ld (_curCol),a			;Into Cursor Col
	ld hl,TitleText			;Paragraph into HL
	call _puts			;Display it!
	call _getkey			;Wait for a keypress
	call _clrLCD			;Clear the Screen
	ret				;Return

;------------------------
;|Exit Routine
;------------------------
Quit:
	call _clrLCD			;Clear the Screen
	ld hl,10*256+0			;Set Coords
	ld (_penCol),hl			;Load Coords into PenCol
	ld hl,ExitStr			;Load String Name into HL
	call _vputs			;Display it!
	ld hl,10*256+100		;Set Coords
	ld (_penCol),hl			;Load HL into PenCol
	ld a,(Hits)			;Load Hits into A
	call DispA			;Display it!
	ld hl,20*256+0			;Set Coords
	ld (_penCol),hl			;Load Coords into PenCol
	ld hl,ExitStr1			;Load String Name into HL
	call _vputs			;Display it!
	ld hl,20*256+100		;Set Coords
	ld (_penCol),hl			;Load HL into PenCol
	ld a,(Misses)			;Load Misses into A
	call DispA			;Display it!
	ld hl,40*256+0			;Set Coords
	ld (_penCol),hl			;Load Coords into PenCol
	ld hl,ExitStr2			;Load String Name into HL
	call _vputs			;Display it!
	ld hl,47*256+0			;Set Coords
	ld (_penCol),hl			;Load Coords into PenCol
	ld hl,ExitStr3			;Load String Name into HL
	call _vputs			;Display it!
	call _getkey			;Wait for KeyPress
	res 3,(iy+5) 			;Set text to normal
	ret				;Return




;------------------------
;|Misc. Routines
;------------------------

DispA:					;Routine to Display A [By: Matthew Shepcar]
 ld l,a					;Loads a into l
 ld h,0					;0 into H
DispHL:					;Displays HL [By: Matthew Shepcar]
 xor a					;Loads 0 into A
 ld de,-1				;Loads -1 into DE
 ld (_curRow),de			;Loads de into CurRow
 call 4A33h				;Calls 4A33h
 dec hl					;Decrease it
 jp _vputs				;Put on screen and return


Delay:					;Delay Loop, converted from Dan Eble's 85 Bounce
	PUSH AF				;hide current AF value
	PUSH BC				;hide current BC value 
	LD BC,$1000			;dlay length->bc
delayLoop:
	DEC BC				;bc-1->bc
	LD A, B				;Loads b into a
	OR C				;Checks if c=0
	JR NZ, delayLoop		;if not, continue loop	
	POP BC				;unhide current BC value
	POP AF				;unhide current AF value 
	ret				;Return to Call

GraphBufClear:		     		;Clears the graph buffer, so _ILine doesn't mess up
	ld hl,GRAPH_MEM	     		;GraphMem into HL
	ld (hl),0            		;Loads 0 into it
	ld de,GRAPH_MEM+1    		;Loads GraphMem+1 into de
	ld bc,1024	     		;Loads the 1024 into bc
	ldir		     		;Draws on screen
	set graphdraw,(iy+graphflags)	;Sets Flag
	ret				;Return from Call


;---------------------------------------------
;|Sprites [8x8] 0 = No Point, 1 = Point On
;---------------------------------------------

TargetShip:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

PlayerShip:
	.db %11111111
	.db %10000001
	.db %10000001
	.db %11111111
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

FireBall:
	.db %00000000
	.db %00011000
	.db %00111100
	.db %01111110
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000


;----------------------
;|Sprite Routine [XOR]
;----------------------
;------------------------------------------------------
;|This Routine was converted by AVD from Movax's 83
;|Special thanks to ScaBBy for making it XOR Routine!
;------------------------------------------------------

;hl = image
;a = x coord
;e = y coord

PutSprite:
       push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$FC00
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp	0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP
        pop     de

        ld      a,b             ; Write line to graphbuf
        xor     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        xor     (hl)
        ld      (hl),a

        ld      bc,15           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP        ; Next line

        jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        xor      (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,16
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
        ret
; SPRITE 


;------------------------------------
;|Begin Data [Text, Variables, Etc.]
;------------------------------------

TitleStr:	.db	" Archery 1.0     Hits:   ",0		;This is text in game
ScoreStr:	.db	" Misses:                 ",0		;Another text for the game bar
BlankStr:	.db	"           ",0				;A blank String [Clearing Text]

TitleText:	.db	"Archery 86z ver. 1.0 "			;The text for title screen
		.db	"  By: Ahmed El-Helw  "			;Warps text around since in
		.db	" Copyright (C) 1997  "			;big text mode, until it
		.db	"  asm86.home.ml.org  ",0		;reaches the ",0"

ExitStr:	.db	"Good Job!  You hit :   ",0		;Exit Messages
ExitStr1:	.db	"and missed:            ",0		;   "      "
ExitStr2:	.db	"Send any comments to   ",0		;   "      "
ExitStr3:	.db	"ahmed3@worldnet.att.net",0		;   "      "

ShipX:		.db	0			;Ship's X Coord
ShipY:		.db	0			;Ship's Y Coord [Constant]
FireX:		.db	0			;Weapon's X Coord
FireY:		.db	0			;Weapon's Y Coord
FireZ:		.db	0			;Weapon Fired or No?
TargetX:	.db	0			;Target's X Coord
TargetY:	.db	0			;Target's Y Coord
TargetD:	.db	0			;Target's Direction

Hits:		.db	0			;Amount of Targets Hit
Misses:		.db	0			;Amount of Targets Missed

.end
END
