;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Variable Declarations                                   ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;

; Variable      Location    Size  Description
Ammo            = vars     ; 2    Number of bullets
Keys            = vars+2   ; 1    Number of keys
KeyTable        = vars+3   ; 3    Table for numbered keys
Health          = vars+6   ; 1    Health level (0-10)
Lives           = vars+7   ; 1    Number of lives
Credits         = vars+8   ; 2    Amount of credits
Score           = vars+10  ; 2    Score
Rows            = vars+12  ; 1    Number of rows in level-1
Columns         = vars+13  ; 1    Number of columns in level-1
Destruction     = vars+14  ; 1    Determines if mission objectives complete and if destruction sequence on
Time            = vars+15  ; 1    Time left before level blows up
BlockPutX       = vars+16  ; 1    XCoord of block to put when closing Queen room
BlockPutY       = vars+17  ; 1    YCoord of block to put when closing Queen room
BlockTakeX      = vars+18  ; 1    XCoord of block to take when Queen dead
BlockTakeY      = vars+19  ; 1    YCoord of block to take when Queen dead
BlockType       = vars+20  ; 1    Type of tile to put at (BlockTakeX, BlockTakeY) when Queen dead
StartTable      = vars+21  ; 4    Two start positions in level (X,Y), depends on which level coming from
FinishTable     = vars+25  ; 6    Three finish positions in level (X,Y), although many levels only have one
Invincible      = vars+31  ; 1    Invincibility counter, 0 = Not invincible, >0 = Invincible
AlienHoleTable  = vars+32  ; 30   Table of stats for Alien Holes (3 bytes * 10 entries - Counter, X, Y)
WeaponTable     = vars+62  ; 4    Table of which weapons are owned, 0 = Not owned, 1 = Owned
RadarScanner    = vars+66  ; 1    0 = No map, 1 = Have map
FrameCnt        = vars+67  ; 1    Main frame counter
QHealth         = vars+68  ; 1    Queen Health
QX              = vars+69  ; 2    Queen XCoord
QY              = vars+71  ; 2    Queen YCoord
QFlag           = vars+73  ; 1    0 = Queen Moving Down, 1 = Queen Moving Up
QCnt            = vars+74  ; 1    Counter for Queen up/down movement
Walking         = vars+75  ; 1    0 = Not walking this frame, 1 = Walking this frame
MenuItem        = vars+76  ; 1    Which menu item selected at Main Menu/Intex Console
#ifdef TI83
TempFile        = vars+77  ; 2    Pointer to TATMP file (created at start of program execution)
#endif
System          = vars+79  ; 256  Save 256 bytes after gbuf here so we have a 1024 byte block to use for HuffExtr
Direction       = vars+335 ; 1    Direction player facing
Level           = vars+336 ; 1    Level player currently on
LevelsDone      = vars+337 ; 1    Number of levels done since player last received a passcode
SGCnt           = vars+338 ; 1    Counter for Security Guards to see if they should regenerate this frame
StringDat       = vars+339 ; 16   Storage for entered passcode or name to be entered to high score table
Time2           = vars+355 ; 1    Secondary counter for Time
StartNumber     = vars+356 ; 1    Determines which start position to use for level
MenuType        = vars+357 ; 1    For Main Menu, 0 = Selection screen, 1 = Show high scores
RefreshX        = vars+358 ; 1    Used in RefreshScreen, X Coord of tile to display
RefreshY        = vars+359 ; 1    Used in RefreshScreen, Y Coord of tile to display
CheckX          = vars+360 ; 1    Absolute XCoord of tile to get in GetTileAbs
CheckY          = vars+361 ; 1    Absolute YCoord of tile to get in GetTileAbs
Difficulty      = vars+362 ; 1    Difficulty level
MenuCnt         = vars+363 ; 1    Counter for Main Menu, when it gets to a certain value, change MenuType
QSpr            = vars+364 ; 1    Counter used for which sprite to display for Queen
RandData        = vars+365 ; 2    Used in fixRandom
Weapon          = vars+367 ; 1    Currently selected weapon
Mode            = vars+368 ; 1    0 = No Queen, 1 = Queen
Dead            = vars+369 ; 1    0 = Alive, 1 = Dead
TextCnt         = vars+370 ; 1    Counter for flashing text on Main Menu
Rows2Put        = vars+371 ; 1    Temp byte for ASCR83
ClipMask        = vars+372 ; 1    Temp byte for ASCR83
BitMask         = vars+373 ; 1    Temp byte for ASCR83
X               = vars+374 ; 2    X Coord of player
Y               = vars+376 ; 2    Y Coord of player
StartX          = vars+378 ; 2    X Coord of top-left pixel on screen
StartY          = vars+380 ; 2    Y Coord of top-left pixel on screen
TempX           = vars+382 ; 2    Temp storage
TempY           = vars+384 ; 2    Temp storage
BulletTable     = vars+386 ; 60   Bullet data (6 bytes * 10 entries - Type, Direction, X, Y)
AnimationTable  = vars+446 ; 30   Animation data (6 bytes * 5 entries - Type, Counter, X, Y)
EBulletTable    = vars+476 ; 6    Enemy Bullet data (Enemy Shooting, Direction, X, Y)
SGTable         = vars+482 ; 14   Security Guard Trigger Table (2 bytes * 7 entries - X, Y)
StartLvl        = vars+496 ; 1    Which level to start on when player selects "START GAME"
ScrSkip         = vars+497 ; 2    Used in scrolling routines
ScrBits         = vars+499 ; 1    Used in scrolling routines
ScrMask         = vars+500 ; 1    Used in scrolling routines
ScrPtr          = vars+501 ; 2    Used in scrolling routines
QTemp           = vars+503 ; 2    Temp spot used in Queen routines
EnemyTable      = vars+505 ; 135  Enemy stats (9 bytes * 15 entries - Type, Direction, X, Y, Counter, Energy, SpeedCnt)
