;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Screen Scrolling Routines                               ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;

ScrollUp:
 ld hl,gbuf+12
 ld de,gbuf
 ld bc,756
 ldir
 ld hl,gbuf+756
 ld de,gbuf+757
 ld bc,11
 ld (hl),0
 ldir
; Now, draw tiles at bottom of screen
 ld hl,(StartY)
 inc hl
 ld (StartY),hl
 ld de,63
 add hl,de
 ld (TempY),hl
 ld a,(StartX)
 and 7
 jr nz,SU1
 ld b,12
 xor a
 ld (TempX),a
 ld (ScrBits),a
 jr SU2
SU1:
 ld b,11
 sub 8
 neg
 ld (TempX),a
 ld (ScrBits),a
SU2:
 ld a,(TempY)
 and 7
 ld l,a
 ld h,0
 ld (ScrSkip),hl
 push bc
 ld hl,(StartX)
 ld de,(TempX)
 ld d,0
 add hl,de
 ld de,(TempY)
 call GetTile
 pop bc
SU3:
 push bc
 push hl
 ld a,(hl)
 ld c,0
 call CheckTriggers
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 push hl
 pop ix
 ld a,(TempX)
 ld hl,gbuf+(63*12)
 call PutScrollByte
 pop hl
 inc hl
 ld a,(TempX)
 add a,8
 ld (TempX),a
 pop bc
 djnz SU3
 ld a,(ScrBits)
 or a
 ret z
 push hl
 ld b,a
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 ld a,(hl)
SU4:
 srl a
 djnz SU4
 ld hl,gbuf+767
 or (hl)
 ld (hl),a
 pop hl
 ld de,-12
 add hl,de
 ld a,(ScrBits)
 sub 8
 neg
 ld b,a
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 ld a,(hl)
SU5:
 add a,a
 djnz SU5
 ld hl,gbuf+756
 or (hl)
 ld (hl),a
 ret

ScrollDown:
 ld hl,gbuf+755
 ld de,gbuf+767
 ld bc,756
 lddr
 ld hl,gbuf
 ld de,gbuf+1
 ld bc,11
 ld (hl),0
 ldir
; Now, draw tiles at top of screen
 ld hl,(StartY)
 dec hl
 ld (StartY),hl
 ld (TempY),hl
 ld a,(StartX)
 and 7
 jr nz,SD1
 ld b,12
 xor a
 ld (TempX),a
 ld (ScrBits),a
 jr SD2
SD1:
 ld b,11
 sub 8
 neg
 ld (TempX),a
 ld (ScrBits),a
SD2:
 ld a,(TempY)
 and 7
 ld l,a
 ld h,0
 ld (ScrSkip),hl
 push bc
 ld hl,(StartX)
 ld de,(TempX)
 ld d,0
 add hl,de
 ld de,(TempY)
 call GetTile
 pop bc
SD3:
 push bc
 push hl
 ld a,(hl)
 ld c,0
 call CheckTriggers
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 push hl
 pop ix
 ld a,(TempX)
 ld hl,gbuf
 call PutScrollByte
 pop hl
 inc hl
 ld a,(TempX)
 add a,8
 ld (TempX),a
 pop bc
 djnz SD3
 ld a,(ScrBits)
 or a
 ret z
 push hl
 ld b,a
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 ld a,(hl)
SD4:
 srl a
 djnz SD4
 ld hl,gbuf+11
 or (hl)
 ld (hl),a
 pop hl
 ld de,-12
 add hl,de
 ld a,(ScrBits)
 sub 8
 neg
 ld b,a
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 ld a,(hl)
SD5:
 add a,a
 djnz SD5
 ld hl,gbuf
 or (hl)
 ld (hl),a
 ret

ScrollLeft:
 ld hl,gbuf+(64*12)-1
 ld c,64
SL1:
 ld b,3
 or a
SL2:
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 rl (hl)
 dec hl
 djnz SL2
 dec c
 jr nz,SL1
; Now, draw tiles at right of screen
 ld hl,(StartX)
 inc hl
 ld (StartX),hl
 ld de,95
 add hl,de
 ld (TempX),hl
 ld a,l
 and 7
 ld hl,ExpTable+1
 ld e,a
 ld d,0
 add hl,de
 ld a,(hl)
 ld (ScrMask),a
 ld hl,(TempX)
 ld de,(StartY)
 call GetTile
 ld (ScrPtr),hl
 ld a,(StartY)
 and 7
 ld l,a
 ld h,0
 ld (ScrSkip),hl
 ld (ScrBits),a
 sub 8
 neg
 ld ix,gbuf+11
 ld c,a
 ld b,8
SL3:
 ld hl,(ScrPtr)
 push bc
 ld a,(hl)
 ld c,0
 call CheckTriggers
 pop bc
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 ld de,12
SL4:
 ld a,(ScrMask)
 and (hl)
 jr z,SL5
 set 0,(ix)
SL5:
 add ix,de
 inc hl
 dec c
 jr nz,SL4
 ld hl,0
 ld (ScrSkip),hl
 ld hl,(ScrPtr)
 ld de,(Columns)
 ld d,0
 inc de
 add hl,de
 ld (ScrPtr),hl
 ld c,8
 djnz SL3
 ld a,(ScrBits)
 or a
 ret z
 ld b,1
 ld c,a
 xor a
 ld (ScrBits),a
 jp SL3

ScrollRight:
 ld hl,gbuf
 ld c,64
SR1:
 ld b,3
 or a
SR2:
 rr (hl)
 inc hl
 rr (hl)
 inc hl
 rr (hl)
 inc hl
 rr (hl)
 inc hl
 djnz SR2
 dec c
 jr nz,SR1
; Now, draw tiles at left of screen
 ld hl,(StartX)
 dec hl
 ld (StartX),hl
 ld (TempX),hl
 ld a,l
 and 7
 ld hl,ExpTable+1
 ld e,a
 ld d,0
 add hl,de
 ld a,(hl)
 ld (ScrMask),a
 ld hl,(TempX)
 ld de,(StartY)
 call GetTile
 ld (ScrPtr),hl
 ld a,(StartY)
 and 7
 ld l,a
 ld h,0
 ld (ScrSkip),hl
 ld (ScrBits),a
 sub 8
 neg
 ld ix,gbuf
 ld c,a
 ld b,8
SR3:
 ld hl,(ScrPtr)
 push bc
 ld a,(hl)
 ld c,0
 call CheckTriggers
 pop bc
 ld l,(hl)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de
 ld de,(ScrSkip)
 add hl,de
 ld de,12
SR4:
 ld a,(ScrMask)
 and (hl)
 jr z,SR5
 set 7,(ix)
SR5:
 add ix,de
 inc hl
 dec c
 jr nz,SR4
 ld hl,0
 ld (ScrSkip),hl
 ld hl,(ScrPtr)
 ld de,(Columns)
 ld d,0
 inc de
 add hl,de
 ld (ScrPtr),hl
 ld c,8
 djnz SR3
 ld a,(ScrBits)
 or a
 ret z
 ld b,1
 ld c,a
 xor a
 ld (ScrBits),a
 jp SR3
