;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Version 1.4                                             ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;
;                                                         ;
;  You may use parts of the code from this source as long ;
; as you give me credit.                                  ;
;                                                         ;
;  Any changes to this source are to be for personal use  ;
; only. You are not allowed to release a modified source  ;
; without my permission.                                  ;
;                                                         ;
;  You are however welcome to port this game to any TI    ;
; calculator as long as you give me credit :)             ;
;                                                         ;
;*********************************************************;

#define EQU .equ
#define Move9() rst 20h
#define PUT_CLIPPED_SPRITE
#define PUT_CLIPPED_MASKED_SPRITE

; Get relevant include file(s) & define some constants, etc. relevant to specific calculators:
#ifdef TI83P

#include "ti83plus.inc"            ; TI-83+ defines
#include "mirage.inc"              ; TI-83+ version is for MirageOS
ExtractStuff    = tempswaparea     ; TI-83+ uses here to extract some stuff to
MEM_NEEDED      = 1619             ; Levels are 40x40 with 19 bytes of misc. data
BUVideo         = appbackupscreen  ; TI-83+ uses here for Backup Video memory
#define bcallnc(label) jr c,$+5 \ rst 28h \ .dw label
_homeup         = $4558
TempFile        = $9820
vars            = saferam1         ; Main variable pointer

#else

#include "ion.inc"                 ; TI-83 version is for Ion
ExtractStuff    = saferam2         ; TI-83 uses here to extract some stuff to
MEM_NEEDED      = 1630
BUVideo         = saferam1         ; TI-83 uses here for Backup Video memory

#endif

; A few quick defines to do with Ion libraries:
#ifdef TI83P
iGetPixel       = igetpix
#else
iFastCopy       = ionFastCopy
iRandom         = ionRandom
iGetPixel       = ionGetPixel
#endif

; First off, just some constants:
VerMajor        = '1'
VerMinor        = '4'
GET_KEY         = _getcsc
LEVELS          = 20
END_TEXT        = ((LEVELS)*2)
FINISH_FILE     = END_TEXT+1
TITLE_PIC       = FINISH_FILE+1
INI_TIME2       = 35
NO_ALIENS       = 15
MAX_SG_CNT      = 230


#ifdef TI83P
.org $9D93
.db $BB,$6D
#else
.org progstart
#endif

 ret
#ifdef TI83P
.db 1                              ; MirageOS identifier
.db %00000000, %00000000           ; Icon
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000100, %10000000
.db %00001000, %01000000
.db %00001000, %01000000
.db %00011011, %01100000
.db %00011011, %01100000
.db %00001011, %01000000
.db %00000111, %10000000
.db %00000011, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
#else
 jr nc,Start
#endif
; Shell description:
.db "Tower Assault v",VerMajor,".",VerMinor,0

Start:
#ifdef TI83
 res statsvalid,(iy+statflags)  ; TI-83 uses statmem :)
#endif
 set textwrite,(iy+sgrflags)    ; Write text to gbuf
 xor a                          ; Initialise vars
 ld (MenuType),a
 ld (MenuItem),a
 ld (TextCnt),a
 ld (Difficulty),a
 ld (StartLvl),a

 ld hl,gbuf+768                 ; Copy system pointers after gbuf to safe place because we need
 ld de,System                   ; a 1024 block of mem to use as lib space for HuffExtr
 ld bc,256
 ldir

#ifdef TI83P
 ld hl,MEM_NEEDED
 bcall(_enoughmem)              ; MirageOS library only available on 83+
 jr nc,MemOK
#else
 bcall(_memfree)                ; Check for enough free mem
 ld de,MEM_NEEDED
 sbc hl,de
 jr nc,MemOK                    ; If we have enough, don't quit
#endif

Quit:
#ifdef TI83                     ; Only TI-83 does this bit
 res textwrite,(iy+sgrflags)    ; _vputs will now write directly to LCD
 set statsvalid,(iy+statflags)  ; Finished with statmem
#endif
 ld hl,System                   ; Copy system pointers back
 ld de,gbuf+768
 ld bc,256
 ldir
; Flow into routine to check for temp file and delete it if it exists, then "ret" to OS
CheckTempFile:                  ; Checks for existing TATMP file and deletes it
#ifdef TI83
 ld hl,TempName                 ; (HL) = Name of prog to search for
 Move9()                        ; Copy 9 bytes from (HL) to (Op1)
 bcall(_chkfindsym)             ; Check for program
 bcallnc(_delvar)               ; If it exists, delete it!
#endif
 ret

MemOK:
#ifdef TI83
 call CheckTempFile             ; Call above routine
 ld hl,1619                     ; Storage space needed for new TATMP
 bcall(_createprog)             ; Create temp program for temp level storage
 inc de
 inc de                         ; (DE) = Start of TATMP data
 ld (TempFile),de               ; Save pointer to temp level storage
#endif

PreMainMenu:
 ld a,(MenuCnt)
 and $01                        ; Reset counter to either 0 or 1
 xor $01                        ; Toggle bit 0 to keep title flashing evenly
 ld (MenuCnt),a

MainMenu:
 bcall(_grbufclr)
 ld a,(MenuType)                ; Check which screen to show
 or a
 jp nz,ShowScores               ; If (MenuType)=1, show high score table

DoMenu:                         ; Otherwise, show title/selection screen
 ld a,(MenuCnt)
 bit 0,a                        ; Are we on an even frame?
 jr z,NoShowTitlePic            ; Don't show title pic on even frames to give it flashing effect
 ld hl,DataFile                 ; (HL) = Start of compressed data file
 ld b,TITLE_PIC                 ; B = File to extract
 ld de,gbuf                     ; (DE) = Where to extract to
 ld ix,(TempFile)               ; (IX) = Place for HuffExtr to build tree
 call HuffExtr                  ; Extract title picture
NoShowTitlePic:
 ld de,23*256+4
 ld hl,StrMain
 call VPuts                     ; "START GAME"
 ld de,31*256+4
 call VPuts                     ; "DIFFICULTY"
 ld de,39*256+4
 call VPuts                     ; "ENTER PASSCODE"
 ld de,47*256+4
 call VPuts                     ; "QUIT"
 ld de,57*256+81
 call VPuts                     ; Display version
 ld hl,(Difficulty)             ; L = (Difficulty)
 ld h,0
 add hl,hl                      ; HL = 2 * (Difficulty)
 ld de,DiffTable
 add hl,de                      ; (HL) = Pointer to difficulty text
 bcall(_ldhlind)                ; (HL) = Normal/Tough Text
 ld de,31*256+69                ; DE = penrow, pencol
 ld a,(Difficulty)
 or a                           ; Check if Normal or Tough
 jr z,MenuSkip                  ; If Normal, display text now
 ld e,73                        ; Otherwise, modify pencol to show text in correct place
MenuSkip:
 call VPuts                     ; Display difficulty
 ld hl,TextCnt                  ; TextCnt determines whether or not selected menu item is showing or not
 inc (hl)                       ; Increment counter
 ld a,(hl)
 cp 6                           ; Has (TextCnt) reached 6?
 jr nz,NoResetTextCnt           ; If not, don't reset it
 ld (hl),0
NoResetTextCnt:
 ld a,(hl)
 cp 3
 jr c,NoEraseText               ; If (TextCnt) < 3 don't erase text this frame
 ld hl,(MenuItem)               ; L = (MenuItem)
 ld h,96
 bcall(_htimesl)                ; (HL) = Offset to text in video memory
 ld de,gbuf+276                 ; (DE) = Where top line of text is in video memory
 add hl,de                      ; (HL) = Where to start erasing
 ld bc,84                       ; BC = Bytes to invert
 call ClearArea                 ; Erase text for flashing text effect ;)
NoEraseText:
 call InvertScreen              ; Invert the whole screen
 call iFastCopy

 bcall(GET_KEY)                 ; Get any key pressed
 ld hl,MenuItem
 cp 54                          ; [2nd]
 jr z,MenuDone
 cp 4                           ; [Up]
 jr z,MenuUp
 dec a                          ; [Down]
 jr z,MenuDown
 ld hl,MenuCnt
 inc (hl)                       ; Increment "no keypress" counter
 ld a,(hl)
 cp 50                          ; If no keypresses for 50 frames, prepare to show other menu
 jp z,ChangeMenuType
 jp MainMenu

MenuDown:                       ; Move to next menu item
 ld a,(hl)
 inc a
 cp 4
 jr nz,MenuChangeSkip           ; If not past bottom item, don't jump to the top one
 xor a                          ; Jump to top menu item

MenuChangeSkip:
 ld (hl),a                      ; Save menu item
 jp PreMainMenu                 ; Reset "no keypress counter" (because a key has been pressed) and restart Main Menu

MenuUp:                         ; Move to previous menu item
 ld a,(hl)
 dec a
 cp 255
 jr nz,MenuChangeSkip
 ld a,3
 jr MenuChangeSkip

MenuDone:
 ld a,(hl)                      ; Get selected menu item
 or a
 jp z,StartGame                 ; If 0, start game
 dec a
 jr z,ChangeDifficulty          ; If 1, toggle difficulty
 dec a
 jp nz,Quit                     ; If it wasn't 2, Quit

EnterPasscode:
 bcall(_clrscrnfull)            ; Otherwise, let's get a passcode from the user
#ifdef TI83P                    ; TI-83+ uses MirageOS library to save space, thx Detached Solutions :)
 bcall(_grbufclr)
 ld de,30*256+0
 ld hl,StrPasscode
 call VPuts
 ld hl,40*256+18
 ld (pencol),hl
 call iFastCopy
 ld hl,StringDat                ; (HL) = Where to store passcode
 ld bc,15*256+4                 ; B = 15 chars to get, C = Options byte (consult MirageOS docs for more info)
 call gettextv                  ; Use MirageOS routine to get passcode
#else
 ld de,0*256+2
 ld hl,StrPasscode
 call Puts                      ; "Enter Passcode:"
 ld de,0*256+4
 call Puts                      ; "_______________"
 ld hl,0*256+4
 ld (currow),hl                 ; Put cursor at start of blank line
 ld de,StringDat                ; (DE) = Where to store passcode
 ld b,15                        ; B = 15 characters to get
PasscodeLoop:
 call GetLetter                 ; Receive a letter from user and put it in A
 or a                           ; If user press [ENTER] to terminate string, get letter again
 jr z,PasscodeLoop
 cp 255                         ; 255 means [DEL] was pressed
 jr z,PasscodeBackspace         ; If so, backspace
 ld (de),a                      ; Otherwise, store letter
 inc de                         ; Inc. pointer to storage space
 djnz PasscodeLoop              ; And keep going
#endif
 call DecodePasscode            ; Decode the passcode that was entered
 jp PreMainMenu                 ; And return to the Main Menu

#ifdef TI83
PasscodeBackspace:
 ld a,b                         ; Get counter value
 cp 15                          ; Are we still at the first character?
 jr z,PasscodeLoop              ; If so, we can't backspace, so wait for a letter again
 ld a,'_'                       ; A = Character to display when backspacing
 call Backspace                 ; Go back a spot
 jr PasscodeLoop                ; Return to loop
#endif

ChangeDifficulty:
 ld hl,Difficulty               ; (HL) = Difficulty
 ld a,(hl)                      ; Get current difficulty
 xor $01                        ; Toggle bit 0
 ld (hl),a                      ; Save it..
 jp PreMainMenu                 ;         .. and jump to start of loop

ShowScores:                     ; This routine shows the high score table
 ld hl,StrAuthor
 ld de,7
 call VPuts                     ; "COPYRIGHT (c)2000-2001"
 ld de,7*256+14
 call VPuts                     ; "TCPA - tcpa.calc.org"
 ld de,14*256+21
 call VPuts                     ; "By James Vernon"
 ld de,22*256+29
 call VPuts                     ; "High Scores:"
;*********************************************************************
; Thanks to Jimmy Mrdell/Ahmed ElHelw for this routine out of ZTetris
 ld hl,HighScores               ; (HL) = Start of high score table
 ld b,5                         ; 5 high scores to show
 ld a,29                        ; Start displaying at row 29 of lcd
ShowScoresLoop:
 ld e,2                         ; Show name at column 2
 ld d,a
 add a,7                        ; Add 7 rows to A for next loop..
 push af                        ;                               .. and save it
 push bc
 call VPuts                     ; Show name of person that achieved high score
 ld a,75                        ; Show score at column 75
 ld (pencol),a
 ld b,5                         ; 5 characters to show
 push hl                        ; (HL) = Actual high score
 bcall(_ldhlind)                ; HL = Actual high score
 call ShowHL                    ; Show it
 pop hl                         ; (HL) = Actual high score again
 inc hl
 inc hl                         ; (HL) = Next entry in high score table
 pop bc
 pop af
 djnz ShowScoresLoop
;*********************************************************************
 call InvertScreen              ; Invert whole screen
 call iFastCopy
 bcall(GET_KEY)                 ; Check to see if any keys were pressed
 or a
 ld hl,MenuCnt                  ; (HL) = "No keypress" counter
 jr nz,ChangeMenuType           ; If a key was pressed, go back to title/selection screen
 inc (hl)                       ; Otherwise inc. counter
 ld a,(hl)
 cp 40                          ; If 40 frames have passed with no keys being pressed, change to other menu
 jp nz,MainMenu

ChangeMenuType:                 ; Input: (HL) = MenuCnt
 ld (hl),0                      ; Reset menu counter
 ld hl,MenuType
 ld a,(hl)
 xor $01                        ; Toggle menu type
 ld (hl),a
 jp MainMenu                    ; Start Menu again

StartGame:                      ; Start playing
 sbc hl,hl                      ; HL = 0
 ld (Score),hl                  ; Reset score
 xor a                          ; Reset some other vars
 ld (LevelsDone),a
 ld (Direction),a
 ld a,(StartLvl)                ; Get StartLvl (will be zero if no valid passcode has been entered)
 ld (Level),a                   ; Save it to level
 or a
 jr nz,NoIniVars                ; If we're not starting on level 0, a passcode has been entered,
 ld (Keys),a                    ;  so don't reset these vars
 ld (RadarScanner),a
 ld (WeaponTable+1),a
 ld (WeaponTable+2),a
 ld (WeaponTable+3),a
 ld (StartNumber),a
 ld (RadarScanner),a
 ld a,5
 ld (Lives),a
 ld (Credits),hl
 ld hl,30
 ld (Ammo),hl
NoIniVars:
 ld a,1                         ; Start with weapon 1
 ld (Weapon),a
 ld a,10                        ; Set Health to max
 ld (Health),a

LoadLevel:                      ; Let's load the level!
 ld hl,(TempFile)               ; (HL) = Start of temp storage
 push hl                        ; Chuck it on the stack
 ld e,l
 ld d,h
 inc de                         ; DE = HL + 1
 ld (hl),0                      ; Reset first byte of temp level storage
 ld bc,1618                     ; B = 1618 bytes left to reset
 ldir                           ; Reset temp level storage
 pop de                         ; (DE) = Start of temp level storage
 push de                        ; Put another copy of it back on the stack
 ld hl,DataFile                 ; (HL) = Start of compressed data file
 ld ix,gbuf                     ; (IX) = 1024 bytes for Huffman Library
 ld a,(Level)
 ld b,a                         ; B = File to extract from data file
 call HuffExtr                  ; Extract level to temp level storage
 call ClearAlienHoleTable       ; Clear Alien Hole table
 call ClearSGTable              ; And also Security Guard table

; Copy level info to vars and move level data to start of (TempFile)
 pop hl                         ; (HL) = Start of temp level storage (which is now current level info)
 push hl                        ; Leave another copy on the stack (again)
 ld de,Rows                     ; (DE) = Where to copy level info to
 ld bc,19                       ; BC = 19 bytes of level info to copy
 ldir                           ; Copy level info
 pop de                         ; (DE) = Start of temp level storage
 push de                        ; Leave a copy on the stack (for the final time)
 ld bc,1600                     ; BC = 1600 bytes of level data to copy
 ldir                           ; Copy level data to start of temp storage

; Now get the active alien holes & security guard triggers
 pop hl                         ; (HL) = Start of temp level storage
 di                             ; Disable interrupts because IY will be used here
 push iy                        ; Save IY (remember it's the pointer to the system flags)
 ld bc,1600                     ; BC = 1600 bytes of data to scan
 ld ix,AlienHoleTable           ; (IX) = Start of Alien Hole table
 ld iy,SGTable                  ; (IY) = Start of Security Guard table
GetAHSG:
 push bc                        ; Save counter
 push hl                        ; Save pointer to level data
 ld a,(hl)                      ; Get tile
 cp 22                          ; Is it an Alien Hole?
 jr nz,NotAH
 ld (ix),0                      ; If so, let's enter it into the Alien Hole table
 call GetXYCoords               ; Get it's coordinates
 ld (ix+1),a                    ; Save X coord (absolute value)
 ld (ix+2),l                    ; Save Y coord (abs)
 inc ix
 inc ix
 inc ix                         ; (IX) = Next entry in Alien Hole table
NotAH:
 pop hl
 push hl                        ; (HL) = Current tile, save it to stack again for later
 ld a,(hl)
 cp 26                          ; Is this tile a Security Guard?
 jr nz,NotSG
 call GetXYCoords               ; If so, get coordinates
 ld (iy),a                      ; Save them
 ld (iy+1),l
 inc iy
 inc iy                         ; (IY) = Next entry in Security Guard table
NotSG:
 pop hl
 inc hl                         ; (HL) = Next tile in level data
 pop bc
 dec bc                         ; Dec. counter
 ld a,b
 or c                           ; Is BC = 0?
 jr nz,GetAHSG                  ; If not, scan next tile
 pop iy                         ; Restore IY as a pointer to system flags
 ei                             ; We can let the interrupts run again now :)

; Get start X & Y coordinates
 ld hl,(StartNumber)
 ld h,0
 add hl,hl                      ; HL = 2 * (StartNumber)
 ld de,StartTable
 add hl,de
 ex de,hl                       ; (DE) = Start XCoord (abs), followed by start YCoord (abs)
 ld a,(de)
 ld l,a
 ld h,0                         ; HL = XCoord (abs)
 add hl,hl
 add hl,hl
 add hl,hl                      ; HL = Abs XCoord * 8 = XCoord
 ld (X),hl                      ; Save start XCoord
 inc de
 ld a,(de)                      ; Do the same for YCoord
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld (Y),hl

 xor a                          ; Reset these vars at the start of each level
 ld (Mode),a
 ld (Dead),a
 ld (Invincible),a
 ld (KeyTable),a
 ld (KeyTable+1),a
 ld (KeyTable+2),a
 ld (SGCnt),a
 ld a,INI_TIME2
 ld (Time2),a                   ; Initialise secondary time counter
 call ClearBulletTable
 call ClearEnemyTable
 call ClearAnimationTable
 call MissionInfo               ; Show mission info for this level
 ld hl,LevelsDone
 ld a,(hl)                      ; A = Number of levels completed since passcode last shown
 cp 2                           ; If two or more levels have been completed since last passcode,
 jr c,NoShowPasscode            ;  we should perhaps show a passcode here
 ld a,(Level)                   ; However, don't show passcode unless on level 5 or higher
 cp 5
 jr c,NoShowPasscode
 ld (hl),0                      ; Reset (LevelsDone)
 call MakePasscode              ; Create a passcode based on credits, ammo, level, etc.
 ld hl,StrShowPCode
 bcall(_vputs)                  ; "Passcode: "
 ld hl,StringDat
 bcall(_vputs)                  ; Show passcode
NoShowPasscode:
 call iFastCopy                 ; Copy text to screen
 call WaitKeyA                  ; Wait for a keypress other than the arrow keys

 call RefreshScreen             ; Display the level

; The MainLoop does the following (in order):
; 1.  Updates the frame counter
; 2.  Clear some vars
; 3.  If player is dead, update death spin
; 4.  If we're in Queen mode, skip to step 9
; 5.  Checks to see if level finished
; 6.  Updates alien holes that are about to open
; 7.  Creates new aliens from alien holes if time is right
; 8.  Regenerates security guards if we should this frame
; 9.  If invincible, update counter
; 10. Check movement & checks for new aliens if screen scrolls
; 11. Check for teacher key
; 12. Check if trying to use another weapon
; 13. Check if trying to view Radar Scanner
; 14. Check if trying to access an Intex Console
; 15. Check if shooting
; 16. Check for pause
; 17. Check for Pick Ups
; 18. Moves bullets
; 19. If we're in Queen mode, skip to step 22
; 20. Moves aliens
; 21. If there is an active Security Guard missile, update it, otherwise check to see
;     if a Security Guard should shoot
; 22. Save gbuf before sprites, etc. are drawn to it
; 23. Updates animations every 2nd frame
; 24. Draw bullets
; 25. If we're in Queen mode, skip to step 29
; 26. If Security Guard shooting, draw the missile
; 27. Draw aliens
; 28. We're not in Queen mode, so skip to step 33
; 29. Move Queen
; 30. Draw Queen & Queen health bar
; 31. Check to see if Queen is hurting player
; 32. Check to see if any bullets are hurting the Queen
; 33. Draw animations
; 34. If we're in Queen mode, skip to step 38
; 35. Check to see if any bullets are hurting any aliens
; 36. Check to see if any aliens are making contact with the player
; 37. Check to see if a Security Guard missile is hurting the player
; 38. Draw player to gbuf
; 39. If in destruction sequence, update time and show time left on gbuf
; 40. Copy gbuf to LCD
; 41. Restore gbuf without sprites on it
; 42. Check to see if a Queen trigger has been activated, if so, jump to the
;     initialisation routine
; 43. Check to make sure player isn't dead

MainLoop:
 ld hl,FrameCnt                 ; (HL) = Frame Counter
 inc (hl)                       ; Increment frame counter
 xor a
 ld (Walking),a                 ; Reset walking flag
 ld hl,Dead
 ld a,(hl)
 or a                           ; Is the player in the middle of the death spin?
 jr z,NotDead                   ; If not, don't update death spin
 dec (hl)                       ; Decrement (Dead) counter
 jr nz,NoEndDeathSpin           ; If death spin isn't over this frame, don't set invincibility yet!
 ld a,70
 ld (Invincible),a              ; The death spin is now over - make player invincible for a period of time
NoEndDeathSpin:
 bit 0,(hl)                     ; Only change player direction every second frame of death spin
 jr z,NotDead
 ld hl,(Direction)
 ld h,0                         ; L = (Direction)
 ld de,DirectionTable
 add hl,de
 ld a,(hl)                      ; A = New direction
 ld (Direction),a               ; Save new direction
NotDead:
; If in Queen mode, skip some stuff
 ld a,(Mode)
 or a
 jp nz,NoRegenerateSecurity

 ld a,(Destruction)
 cp 2
 jr nc,NotFinished              ; If (Destruction) is >= 2, not allowed to finish level yet!
 ld hl,(X)                      ; HL = XCoord
 inc hl
 inc hl
 inc hl                         ; HL = Center of player XCoord
 call DivHLby8                  ; L = Abs value of X
 ld b,l                         ; Chuck it in B
 ld hl,(Y)
 inc hl
 inc hl
 inc hl                         ; HL = Center of player YCoord
 call DivHLby8
 ld c,l                         ; C = Abs value of Y
 ld hl,FinishTable              ; (HL) = Start of finish positions
 ld e,0                         ; E will be a counter
CheckFinishes:
 ld a,b
 cp (hl)                        ; Compare X coords
 inc hl                         ; (HL) = YCoord of current finish position
 jr nz,CFLoop                   ; If not equal, try next finish position
 ld a,c
 cp (hl)                        ; Compare Y coords
 jp z,LevelFinished             ; If equal, level is finished!
CFLoop:
 inc hl                         ; (HL) = Next set of coordinates
 inc e                          ; Increment counter
 ld a,e
 cp 3                           ; Have we checked 3 sets of coordinates?
 jr nz,CheckFinishes            ; If not, check some more

NotFinished:
 ld hl,AlienHoleTable           ; (HL) = Start of Alien Hole table
 ld b,10                        ; B = 10 entries to check
UpdateAlienHoles:
 push bc                        ; Save counter
 push hl                        ; Save pointer
 ld a,(hl)
 cp 225                         ; If hole counter less than 225, hole might be active so try to update it
 jr c,UpdateAH
 inc (hl)                       ; Otherwise, hole has been walked over by player and is about to open up
 jr nz,EndUpdateAH              ; If counter hasn't reached 256 (or 0), don't activate it this frame
 inc hl                         ; (HL) = XCoord of hole
 ld a,(hl)
 ld (CheckX),a                  ; Save it to check var
 inc hl                         ; (HL) = YCoord of hole
 ld a,(hl)
 ld (CheckY),a                  ; Save it to check var
 call GetTileAbs                ; Get address in temp level storage of hole
 ld a,22                        ; A = 22 = Active Hole
 ld (hl),a                      ; Load active hole to level data
 call RemoveTile                ; Remove floor tile and put hole tile on screen
 jr EndUpdateAH                 ; We're finished with this hole for now ;)
UpdateAH:
 cp 220
 jr z,EndUpdateAH               ; If hole counter is 220, this entry is empty
 inc (hl)                       ; Otherwise, update the counter
 ld a,(hl)
 sub 180                        ; Has the hole counter reached 180?
 jr nz,EndUpdateAH              ; If not, we shouldn't create a new alien this frame
 ld (hl),a                      ; A = 0 (from the 'sub 180' command), reset counter
 inc hl                         ; (HL) = XCoord of hole
 ld a,(hl)
 call CheckOnScreen             ; Check if hole is currently on the screen
 jr c,EndUpdateAH               ; If it isn't, let's not create an alien (this prevents flooding)
 call GetTileAbs                ; Coords are already in check vars from 'CheckOnScreen' so let's get the address
 push hl                        ; (HL) = Where hole is located in level data, save it for after
 call GetXYTemp                 ; Get exact X and Y coords of hole and check to see if an enemy is already above it
 jr nc,AHError                  ; If so, we can't create an alien
 pop hl                         ; Restore pointer to hole in level data
 ld c,1                         ; C = 1, don't create trigger when creating an alien
 call NewAlien                  ; Create a new alien
 jr EndUpdateAH                 ; Finished with this entry
AHError:
 pop hl                         ; Clear useless value
EndUpdateAH:
 pop hl                         ; (HL) = Start of current entry
 inc hl
 inc hl
 inc hl                         ; (HL) = Start of next entry
 pop bc                         ; B = Counter
 djnz UpdateAlienHoles          ; Repeat for next alien hole

 ld hl,SGCnt                    ; (HL) = Security Guard counter
 inc (hl)                       ; Increment counter
 ld a,(hl)
 sub MAX_SG_CNT                 ; Has counter reached max amount?
 jp nz,NoRegenerateSecurity     ; If not, don't regenerate Security Guards this frame
 ld (hl),a                      ; Reset counter
 ld hl,SGTable                  ; (HL) = Start of Security Guard table
 ld b,7                         ; B = 7 entries to check
MakeSGLoop:
 push hl
 push bc
 ld a,(hl)                      ; Get XCoord
 or a                           ; Is it 0?
 jr z,EndMSGLoop                ; If so, no Security Guard at this entry!
 call CheckOnScreen             ; Check to see if trigger is on screen
 jr c,EndMSGLoop                ; If not, don't create a Security Guard
 call GetTileAbs                ; Get address in level data of trigger
 push hl
 call GetXYTemp                 ; Check to make sure no enemies are standing on the trigger
 jr nc,SGError                  ; If one is, can't create a Security Guard
 pop hl                         ; (HL) = Address of trigger
 ld c,1                         ; C = 1 = Don't erase trigger
 call NewSecurity               ; Create a new Security Guard
 jr EndMSGLoop                  ; Next entry
SGError:
 pop hl                         ; Clear useless value
EndMSGLoop:
 pop bc                         ; Restore counter
 pop hl
 inc hl
 inc hl                         ; (HL) = Next entry
 djnz MakeSGLoop                ; Repeat :)

NoRegenerateSecurity:
 ld hl,Invincible               ; (HL) = Invincibility counter
 ld a,(hl)
 or a
 jr z,NoDecInvincible           ; If it's 0, it doesn't need to be updated
 dec (hl)                       ; Otherwise, decrement it
NoDecInvincible:
 ld a,$FE
 call DirectIn                  ; MirageOS function - direct input handler
 push af
 bit 3,a                        ; Is [Up] being pressed?
 call z,MoveUp
 pop af
 push af
 bit 0,a                        ; Is [Down] being pressed?
 call z,MoveDown
 pop af
 push af
 bit 1,a                        ; Is [Left] being pressed?
 call z,MoveLeft
 pop af
 bit 2,a                        ; Is [Right] being pressed?
 call z,MoveRight

 ld a,$DF
 call DirectIn                  ; Get key presses from left-most row
 bit 6,a                        ; Is [MATH] being pressed?
 call z,TeacherKey              ; If so, turn off calculator

 ld a,$BF
 call DirectIn
 push af
 bit 4,a                        ; Is [Y=] being pressed?
 call z,GetLaser
 pop af
 push af
 bit 3,a                        ; Is [WINDOW] being pressed?
 call z,GetTwinMissile
 pop af
 push af
 bit 2,a                        ; Is [ZOOM] being pressed?
 call z,GetPlasma
 pop af
 push af
 bit 1,a                        ; Is [TRACE] being pressed?
 call z,GetRocket
 pop af
 push af
 bit 0,a                        ; Is [GRAPH] being pressed?
 call z,ViewRadarScanner
 pop af
 push af
 bit 7,a                        ; Is [DEL] being pressed?
 call z,IntexConsole
 pop af
 push af
 bit 5,a                        ; Is [2nd] being pressed?
 call z,Shoot
 pop af
 bit 6,a                        ; Is [MODE] being pressed?
 call z,Pause

; Check for pickups at all 4 corners of player
 ld hl,(X)
 ld de,(Y)
 call CheckPickups              ; Check top-left corner
 ld bc,7
 add hl,bc
 call CheckPickups              ; Check top-right corner
 push hl
 ld hl,7
 add hl,de
 ex de,hl
 pop hl
 call CheckPickups              ; Check bottom-right corner
 ld bc,-7
 add hl,bc
 call CheckPickups              ; Check bottom-left corner

 call MoveBullets               ; Update any active bullets (fired by the player)
; Skip some stuff if in Queen mode
 ld a,(Mode)
 or a
 jr nz,QSkip
 call MoveAliens                ; Move the enemies
 call SecurityMissile           ; If a Security Guard missile is active, update it, otherwise try and shoot one
QSkip:
 call SaveVideo                 ; Save gbuf to backup video
 call UpdateAnimations          ; Update all animations
 call DrawBullets               ; Draw bullets (fired by player) to gbuf
; If in Queen mode, jump to the stuff to be done
 ld a,(Mode)
 or a
 jr nz,DoQueenStuff
 call DrawMissile               ; Draw Security Guard missile (if there is one)
 call DrawAliens                ; Draw enemies
 jr QSkip2
DoQueenStuff:                   ; Queen specific code
 call MoveQueen                 ; Move the Queen
 call DrawQueen                 ; Draw the Queen to the gbuf
 call CheckQPHits               ; Check for collisions between the Queen and the player
 call CheckQBHits               ; Check for collisions between the Queen and any bullets
QSkip2:
 call DrawAnimations            ; Draw animations to gbuf
 ld a,(Mode)
 or a
 jr nz,QSkip3
 call CheckBulletHits           ; Check for collisions between enemies and bullets
 call CheckPACollisions         ; Check for collisions between enemies and player
 call CheckSGMissile            ; Check to see if Security Guard missile (if there is one) is hitting player
QSkip3:
 call DrawPlayer                ; Draw player to gbuf
 ld a,(Destruction)
 dec a                          ; Does (Destruction) = 1
 jr nz,NoUpdateTime             ; If not, don't update time counter
 ld de,Time                     ; (DE) = Main time counter
 ld hl,Time2                    ; (HL) = Secondary time counter
 dec (hl)                       ; Decrement secondary counter
 jr nz,NoDecTime                ; If it's not 0, don't decrement main counter
 ld a,(de)
 dec a                          ; Decrement main counter
 ld (de),a
 ld (hl),INI_TIME2              ; Reset secondary counter
NoDecTime:
 ld a,(de)                      ; Get time left
 ld hl,0
 ld (pencol),hl                 ; Put cursor at top-left
 ld l,a                         ; HL = Time left
 ld b,2                         ; Show 2 chars max
 call ShowHL                    ; Show HL

NoUpdateTime:
 call iFastCopy                 ; Copy gbuf to lcd
 ei                             ; Re-enable interrupts (ionFastCopy disables them)
 call RestoreVideo              ; Restore the backup of video mem to gbuf (before sprites were blitted)
 ld a,(Destruction)
 dec a
 jr nz,NoCheckTime              ; If not in destruction sequence, don't check to see if time is up
 ld a,(Time)
 or a                           ; Is the player out of time?
 jp z,BlowUp                    ; If so, show level blowing up!
NoCheckTime:
 ld de,(Y)
 inc de
 inc de                         ; DE = YCoord + 2
 ld hl,(X)                      ; HL = XCoord
 call GetTile                   ; Get tile at player position
 cp 74                          ; Is it a Queen trigger?
 jp z,IniQueen                  ; If so, initialise the Queen alien routine

 ld a,(Health)
 or a                           ; Is (Health) down to 0?
 jr z,StartDeathSpin            ; If so, begin the death spin
 cp 200
 jp c,MainLoop                  ; If (Health) isn't between 200-255, the player isn't dead

StartDeathSpin:
 ld a,40                        ; Player will turn 20 times (40 / 2)
 ld (Dead),a
 ld a,10                        ; Reset health
 ld (Health),a
 ld hl,Lives
 dec (hl)                       ; Decrement lives counter
 jp z,GameOver                  ; If player is out of lives, it's Game Over!
 jp MainLoop                    ; Back to start of main loop

BlowUp:
 call ClearEnemyTable           ; We'll use the EnemyTable to store the explosions
 ld b,80                        ; B = 80 frames of explosions to show
BULoop:
 push bc                        ; Save frame counter
 call SaveVideo                 ; Save gbuf to backup video - no sprites are on the gbuf at the moment
 ld hl,EnemyTable               ; (HL) = Start of ExplosionTable
 push hl                        ; Save a copy to the stack for later
 ld b,15                        ; B = 15 explosions to update
BUUpdate:
 ld a,(hl)                      ; A = Explosion counter
 or a                           ; Has it reached 0 yet?
 jr z,EndBUUpdate               ; If so, this explosion is finished
 dec (hl)                       ; Otherwise, decrement counter
EndBUUpdate:
 inc hl
 inc hl
 inc hl                         ; (HL) = Next explosion entry
 djnz BUUpdate                  ; Next entry
 pop hl                         ; (HL) = Start of ExplosionTable
 push hl                        ; Keep a copy on the stack for later
 ld b,15                        ; B = 15 entries to display
BUShow:
 push bc                        ; Save counter
 push hl                        ; And pointer
 ld a,(hl)
 or a                           ; Is there an explosion in this entry?
 jr z,EndBUShow                 ; If not, move to next entry
 inc hl                         ; (HL) = XCoord
 ld b,(hl)                      ; B = XCoord
 inc hl
 ld c,(hl)                      ; C = YCoord
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl                      ; HL = Offset to sprite
 ld de,SprExplosion
 add hl,de                      ; (HL) = Sprite to display
 push bc                        ; Put X & Y Coords on stack
; call StoreSprite               ; Store sprite and mask to (DrawSpr)
; ld hl,DrawSpr                  ; (HL) = Sprite to draw
 pop bc                         ; Restore X & Y Coords
 call putClippedSprite          ; Show explosion
EndBUShow:
 pop hl
 inc hl
 inc hl
 inc hl                         ; (HL) = Next entry
 pop bc                         ; Restore counter
 djnz BUShow                    ; Display next explosion
 pop hl                         ; (HL) = Start of ExplosionTable
 ld b,4                         ; B = 4 groups of entries to check
 ld de,9                        ; DE = 9 bytes to skip per group (each group contains 3 explosions)
BUGetSlot:
 ld a,(hl)
 or a                           ; Is this group being used?
 jr z,BUSlotFound               ; If not, let's make use of it :)
 add hl,de                      ; Otherwise, move to next group
 djnz BUGetSlot                 ; And check it!
BUSlotFound:
 ld b,3                         ; B = 3 new explosions to create
BUMakeNew:
 push bc                        ; Save new explosion counter
 ld (hl),4                      ; Set explosion counter to 4 for this entry
 inc hl                         ; (HL) = XCoord
 ld b,89                        ; We want a random number 0-88 inclusive
 call iRandom                   ; Get random number
 ld (hl),a                      ; Save random XCoord
 inc hl                         ; (HL) = YCoord
 ld b,57                        ; We want a random number 0-56 inclusive
 call iRandom                   ; Get random number
 ld (hl),a                      ; Save random YCoord
 inc hl                         ; (HL) = Next entry
 pop bc                         ; Restore new explosion counter
 djnz BUMakeNew                 ; Get another new explosion
 call iFastCopy                 ; Copy gbuf to lcd
 call RestoreVideo              ; Restore gbuf before explosions were drawn
 pop bc                         ; Restore main frame counter
 dec b                          ; Decrement it
 jp nz,BULoop                   ; If we're not finished yet, repeat whole process

GameOver:
 ld a,1
 ld (MenuType),a                ; After "Game Over" screen, we will show the high scores screen
 ld de,6*256+3
 ld hl,StrGameOver
 call Puts                      ; "GAME"
 ld de,6*256+4
 call Puts                      ; "OVER"
 call WaitKeyA                  ; Wait for a keypress (except for arrow keys)

 call GetScore                  ; Get score according to difficulty
 ex de,hl                       ; DE = Score
 ld hl,HighScores+14            ; (HL) = First high score in high score table
 ld b,5                         ; B = Up to 5 high scores to compare with
CheckHighScore:
 push hl                        ; Save pointer
 bcall(_ldhlind)                ; HL = Score at this entry
 bcall(_cphlde)                 ; Compare it with player's score
 pop hl                         ; Restore pointer
 jr c,NewHighScore              ; If player's score was higher, the player has a high score :)
 push de                        ; Save player's score
 ld de,16                       ; DE = 16 bytes to skip to next high score table entry
 add hl,de                      ; (HL) = High score at next entry
 pop de                         ; Restore player's score
 djnz CheckHighScore            ; Try next entry
 jp PreMainMenu                 ; Player hasn't got a high score, so go straight to menu

NewHighScore:
 ld a,b
 dec a                          ; (5 - A) = High Score entry to save high score to
 ld (TempX),a                   ; Save it
 jr z,AfterMoveScores           ; If it's the bottom entry, no need to rearrange to rest of the table
 ld hl,HighScores+51            ; (HL) = Start of second bottom entry
MoveScores:
 push hl                        ; Save a copy for after
 ld d,h
 ld e,l                         ; (DE) = Start of source entry
 ld bc,16
 add hl,bc                      ; (HL) = Start of destination entry
 ex de,hl                       ; (HL) = Source, (DE) = Destination
 ld bc,13                       ; BC = 13 bytes to copy
 ldir                           ; Copy entry from (HL) to (DE)
 pop hl                         ; Get pointer back
 ld de,-16
 add hl,de                      ; (HL) = Previous entry
 dec a                          ; Have we done all the necessary sorting?
 jr nz,MoveScores               ; If not, do another loop
AfterMoveScores:
 ld a,(TempX)
 sub 4                          ; -A = Entry to put high score in
 ld hl,HighScores+3             ; (HL) = First entry
 ld de,16                       ; DE = 16 bytes to skip per entry
 jr z,GetNewName                ; If we want the first entry, skip the entry finding loop
 neg                            ; Get positive value of entry to put high score in
FindNameSpot:
 add hl,de                      ; (HL) = Next entry
 dec a                          ; Are we there yet?
 jr nz,FindNameSpot             ; If not, do it again
GetNewName:
 push hl                        ; (HL) = Where to put name, save it
 ld b,10                        ; B = 10 bytes to clear
ClearOldName:
 ld (hl),' '                    ; Erase character
 inc hl                         ; Next character
 djnz ClearOldName              ; Repeat 10 times
 inc hl                         ; (HL) = High score for this entry
 ex de,hl                       ; (DE) = High score for this entry
 call GetScore                  ; HL = Player's score
 ex de,hl                       ; (HL) = High score in this entry, DE = Player's score
 ld (hl),e
 inc hl
 ld (hl),d                      ; Load player's high score to entry
#ifdef TI83P
 bcall(_grbufclr)
 ld de,10*256+15
 ld hl,StrNewHigh
 call VPuts                     ; "You got a high score!"
 ld de,17*256+21
 call VPuts                     ; "Enter your name: "
 ld hl,30*256+10
 ld (pencol),hl                 ; Set coordinates of where to receive input
 call iFastCopy
 pop hl                         ; (HL) = Where to put new name
 ld b,10                        ; B = 10 characters max to get
 call gettext                   ; MirageOS lib function, get new high score name
 ld (hl),' '                    ; Overwrite NULL terminator, otherwise causes problems later
 jp PreMainMenu                 ; Back to main menu
#else
 bcall(_clrscrnfull)            ; Clear screen
 ld de,0*256+1
 ld hl,StrNewHigh
 call Puts                      ; "You got a high score!"
 ld de,0*256+4
 call Puts                      ; "Enter your name:"
 ld b,10                        ; B = 10 characters to enter (max)
 pop de                         ; (DE) = Where to put new name
NewHighLoop:
 call GetLetter                 ; Get a letter
 or a
 jp z,PreMainMenu               ; If A = 0, [ENTER] was pressed, so we're finished here :)
 cp 255
 jr z,NameBackspace             ; If A = 255, [DEL] was pressed, so do a backspace
 ld (de),a                      ; Otherwise, save character
 inc de                         ; Increment string pointer
 djnz NewHighLoop               ; Repeat
 jp PreMainMenu                 ; We're done, back to main menu
NameEntered:
 ld a,(hl)                      ; Get final character..
 ld (de),a                      ;                     .. store it..
 jp PreMainMenu                 ;                                 .. and return to main menu
NameBackspace:
 ld a,b                         ; Get counter value
 cp 10                          ; Are we still at the first character?
 jr z,NewHighLoop               ; If so, we can't backspace, so wait for a letter again
 ld a,' '                       ; A = Character to erase with
 call Backspace                 ; Do a backspace
 ld a,' '
 ld (de),a
 jr NewHighLoop

Backspace:
 ld hl,curcol
 dec (hl)                       ; Decrement cursor position
 bcall(_putmap)                 ; Show erasing character
 inc b                          ; Increment character counter
 dec de                         ; Decrement string pointer
 ret
#endif

GetScore:
 ld hl,(Score)                  ; Get score
 ld a,(Difficulty)
 or a                           ; What difficulty are we on?
 ret z                          ; If NORMAL, return score
 add hl,hl                      ; If TOUGH, double score and return it ;)
 ret

Puts:
 ld (currow),de                 ; Save cursor position
 bcall(_puts)                   ; Display string
 ret

;########################################
; WaitKey - Wait for a key press, with APD
;
; Input:    None
; Output:   A = Key press, GET_KEY style
;########################################
WaitKey:
 ld hl,0                        ; High counter
 ld b,255                       ; Low counter
WKeyLoop:
 dec b                          ; Decrement low counter
 jr nz,NoIncHL                  ; If it's not 0 yet, don't increment high counter
 inc hl                         ; Otherwise, increment high counter
NoIncHL:
 ld a,h                         ; A = MSB of high counter
 cp 5                           ; Has MSB reached 5 yet?
 call z,PowerOff                ; If so, turn calc off to save power :D
 push bc
 push hl
 bcall(GET_KEY)                 ; Get key presses
 pop hl
 pop bc
 or a                           ; Has a key been pressed?
 ret nz                         ; If so, leave
 jr WKeyLoop                    ; Otherwise keep looping

;########################################
; WaitKeyA - Same as WaitKey, but ignores arrow keys
;
; Input:    None
; Output:   A = Key press, GET_KEY style
;########################################
WaitKeyA:
 call WaitKey                   ; Wait for a key press
 cp 5                           ; Was it an arrow key?
 ret nc                         ; If not, leave
 jr WaitKeyA                    ; Otherwise, wait for another key press

;########################################
; InvertScreen - Invert entire video memory
;
; Input:    None
; Output:   None
;########################################
InvertScreen:
 ld hl,gbuf                     ; (HL) = Place to invert
 ld bc,768                      ; BC = 768 bytes to invert

;########################################
; InvertArea - Invert a group of bytes
;
; Input:    (HL) = Where to start inverting
;           BC = Number of bytes to invert
; Output:   None
;########################################
InvertArea:
 ld a,(hl)                      ; Get byte
 cpl                            ; Take 2's complement
 ld (hl),a                      ; Save byte
 inc hl                         ; Increment pointer
 dec bc                         ; Decrement counter
 ld a,b
 or c                           ; Does BC = 0?
 jr nz,InvertArea
 ret

#ifdef TI83                     ; MirageOS version doesn't require this routine
;########################################
; GetLetter - Get a character
;
; Input:    (DE) = Where to store it
;           (HL) = Current position in CharSet
;           B = Counter value, not altered in this routine
; Output:   A = Character
;########################################
GetLetter:
 push de                        ; Save string pointer
 push bc                        ; Save counter
LetterLoop:
 call WaitKey                   ; Wait for a key press
 cp 56                          ; [DEL]
 jr z,LetterBackspace
 cp 9                           ; [ENTER]
 jr z,EndString
 dec a
 ld e,a
 ld d,0                         ; DE = Offset in CharTable
 ld hl,CharTable
 add hl,de
 ld a,(hl)                      ; A = Letter entered
 push af
 bcall(_putc)
 pop af
 pop bc                         ; Restore counter
 pop de                         ; Restore string pointer
 ret
EndString:
 pop bc                         ; Restore counter
 pop de                         ; Restore string pointer
 xor a                          ; A = 0, tell calling routine that [ENTER] was pressed
 ret
LetterBackspace:
 pop bc                         ; Restore counter
 pop de                         ; Restore string pointer
 ld a,255                       ; A = 255, tell calling routine that [DEL] was pressed
 ret
#endif

;########################################
; LevelFinished - Do end of level stuff and prepare for next level
;
; Input:    E = Finish position used
; Output:   None
;########################################
LevelFinished:
 ld hl,(Score)
 ld bc,100
 add hl,bc                      ; Add 100 points to score for finishing level ;)
 ld (Score),hl
 ld hl,LevelsDone
 inc (hl)                       ; Increment number of levels completed since last passcode shown
 ld a,e                         ; A = Finish position used
 ld (StartNumber),a             ; Save it
 ld hl,DataFile
 ld de,ExtractStuff
 ld ix,gbuf
 ld b,FINISH_FILE
 call HuffExtr                  ; Extract table to determine next level
 ld a,(Level)                   ; A = Level just finished
 ld c,a
 add a,a
 add a,c                        ; A = 3*A
 ld e,a
 ld d,0                         ; DE = 3 * Level just finished
 ld hl,ExtractStuff
 add hl,de                      ; (HL) = Table of 3 possible levels to do next
 ld a,(StartNumber)             ; Get finish position number again
 ld e,a                         ; DE = Finish position used
 and $01                        ; Must only be 0 or 1
 ld (StartNumber),a             ; Save it again in case the "and $01" changed it
GetNextLevel:
 add hl,de                      ; (HL) = Next level
 ld a,(hl)
 ld (Level),a                   ; Set next level
 cp LEVELS                      ; Has the game been completed?
 jp c,LoadLevel                 ; If not, load level and keep playing

GameFinished:
 ld b,END_TEXT                  ; B = Text file to extract
 call ShowText                  ; Extract and show game finished text
 call iFastCopy
 call WaitKeyA                  ; Wait for a key press
 jp GameOver                    ; Go to GameOver routine to check for high score, etc.

;########################################
; MissionInfo - Show objectives for a level
;
; Input:    None
; Output:   B = File number of file that contains objectives
;########################################
MissionInfo:
 ld a,(Level)                   ; Get level number
 add a,LEVELS                   ; Add to it the total number of levels to get the file number
 ld b,a                         ; B = File number

;########################################
; ShowText - Extract and show text from the data file
;
; Input:    B = File number
; Output:   None
;########################################
ShowText:
 ld de,ExtractStuff             ; (DE) = Where to extract text to
 ld ix,gbuf                     ; (IX) = 1024 bytes for hufflib
 ld hl,DataFile                 ; (HL) = Start of datafile
 call HuffExtr                  ; Extract text
 bcall(_grbufclr)
 ld hl,0
 ld (pencol),hl                 ; Cursor to top-left
 ld hl,ExtractStuff             ; (HL) = Start of text data
 ld b,(hl)                      ; B = Number of lines of text
 inc hl                         ; (HL) = First line
MILoop:
 push bc                        ; Save counter
 bcall(_vputs)                  ; Show line of text
 xor a
 ld (pencol),a                  ; Move cursor to start of line
 ld a,(penrow)
 add a,6                        ; Move cursor to next line
 ld (penrow),a
 pop bc                         ; Restore counter
 djnz MILoop                    ; Repeat
 ret

;########################################
; ClearArea - Clear an area of memory
;
; Input:    (HL) = Start of memory block
;           BC = Number of bytes to clear
; Output:   (HL) = Byte following the end of the memory block cleared
;########################################
ClearArea:
 ld (hl),0                      ; Reset byte
 inc hl                         ; (HL) = Next byte
 dec bc                         ; Decrement counter
 ld a,c
 or b                           ; Does BC = 0?
 jr nz,ClearArea                ; If not, repeat
 ret

;########################################
; RefreshScreen - Draw a level
;
; Input:    None
; Output:   None
;########################################
RefreshScreen:
 call GetStartX                 ; Get X coord of block of left side of screen
 call GetStartY                 ; Get Y coord of block at top of screen
 xor a
 ld (RefreshY),a

NextY:
 xor a
 ld (RefreshX),a
 ld a,(RefreshY)
 ld hl,StartY
 add a,(hl)
 ld hl,0
 or a
 jr z,RefreshSkip
 ld hl,(Columns)
 inc l
 ld h,a
 bcall(_htimesl)

RefreshSkip:
 ld de,(TempFile)
 add hl,de
 ld a,(StartX)
 ld e,a
 ld d,0
 add hl,de

NextX:
 ld a,(hl)
 push hl
 cp 23
 ld c,1
 call z,NewAlien
 cp 24
 call z,NewFaceHugger
 cp 25
 call z,NewWorm
 ld h,8
 ld l,a
 bcall(_htimesl)
 ld de,SprMain
 add hl,de
 ex de,hl
 ld a,(RefreshY)
 ld l,a
 ld a,(RefreshX)
 call PutSpriteNormal
 pop hl
 inc hl
 ld a,(RefreshX)
 inc a
 ld (RefreshX),a
 cp 12
 jr nz,NextX
 ld a,(RefreshY)
 inc a
 ld (RefreshY),a
 cp 8
 jr nz,NextY
 ld hl,(StartX)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld (StartX),hl
 ld hl,(StartY)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld (StartY),hl
 ld hl,(StartX)
 ld a,l
 or h
 jr z,NoScrollRight
 ld de,96
 add hl,de
 ld a,8
 bcall(_divhlbya)
 ld a,l
 ld hl,(Columns)
 inc l
 cp l
 jr z,NoScrollRight
 call ScrollRight
 call ScrollRight
 call ScrollRight
 call ScrollRight
NoScrollRight:
 ld hl,(StartY)
 ld a,h
 or l
 ret z
 ld de,64
 add hl,de
 ld a,8
 bcall(_divhlbya)
 ld a,l
 ld hl,(Rows)
 inc l
 cp l
 ret z
 call ScrollDown
 call ScrollDown
 call ScrollDown
 call ScrollDown
 ret

GetStartX:
 ld hl,(X)
 ld a,8
 bcall(_divhlbya)
 ld a,l
 sub 5
 or a
 jp m,StartLeft
 add a,11
 ld hl,(Columns)
 inc l
 cp l
 jp p,StartRight
 sub 11
 ld (StartX),a
 ret

GetStartY:
 ld hl,(Y)
 ld a,8
 bcall(_divhlbya)
 ld a,l
 sub 3
 or a
 jp m,StartUp
 add a,7
 ld hl,(Rows)
 inc l
 cp l
 jp p,StartDown
 sub 7
 ld (StartY),a
 ret

StartLeft:
 xor a
 ld (StartX),a
 ret

StartRight:
 ld a,(Columns)
 sub 11
 ld (StartX),a
 ret

StartUp:
 xor a
 ld (StartY),a
 ret

StartDown:
 ld a,(Rows)
 sub 7
 ld (StartY),a
 ret

PutSpriteNormal:
 push de
 ld h,96
 bcall(_htimesl)
 ld de,gbuf
 add hl,de
 ld e,a
 ld d,0
 add hl,de
 pop de
 ld b,8

PSNormalLoop:
 ld a,(de)
 ld (hl),a
 inc de
 push de
 ld de,12
 add hl,de
 pop de
 djnz PSNormalLoop
 ret

; (HL) = Row of gbuf to put byte to
; A = XCoord
; (IX) = Byte to put
PutScrollByte:
 ld d,0
 ld e,a
 and 7
 ld c,a
 srl e
 srl e
 srl e
 add hl,de
 ld d,(ix)
 ld e,0
 ld a,c
 or a
 jr z,PSBSkip
PSBLoop:
 srl d
 rr e
 dec a
 jr nz,PSBLoop
PSBSkip:
 ld a,(hl)
 or d
 ld (hl),a
 inc hl
 ld a,(hl)
 or e
 ld (hl),a
 ret

CheckTriggers:
 sub 23
 jp z,NewAlien
 dec a
 jp z,NewFaceHugger
 dec a
 jp z,NewWorm
 ret

GetTileAbs:
 ld hl,(CheckY)
 ld a,(Columns)
 ld h,a
 inc h
 bcall(_htimesl)
 ld de,(TempFile)
 add hl,de
 ld a,(CheckX)
 ld e,a
 ld d,0
 add hl,de
 ld a,(hl)
 ret

GetTileSave:
 push hl
 push de
 call GetTile
 pop de
 pop hl
 ret

GetTile:                      ; HL = XCoord, DE = YCoord
 push hl                      ; Save XCoord
 ex de,hl                     ; HL = YCoord
 call DivHLby8
 ld a,(Columns)
 ld h,a                       ; H = (Columns)
 inc h
 bcall(_htimesl)
 ld de,(TempFile)
 add hl,de                    ; (HL) = Row in level data that tile is located on
 ex (sp),hl                   ; HL = XCoord, (SP) = Row in level data
 ld a,8
 bcall(_divhlbya)             ; HL = Abs XCoord
 pop de                       ; DE = Row
 add hl,de                    ; (HL) = Tile
 ld a,(hl)
 ret

CheckTile:
 call GetTile
 cp 27
 jp z,ActivateAutoDestruct
 cp 21
 jp z,ActivateAH
 cp 141
 jr nc,OpenNormalDoor
 cp 139
 jr nc,OpenDoor3
 cp 137
 jr nc,OpenDoor2
 cp 135
 jr nc,OpenDoor1
 cp 133
 jr nc,OpenSecurityDoor
 cp 81
 jr c,MaybeEnergyShield
NoMove:
 ld a,1
 or a
 ret

OpenNormalDoor:
 sub 113
 ld (hl),a
 push hl
 call RemoveTile
 pop hl
 ld b,(hl)
 call GetXYCoords
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld a,b
 sub 26
 ld c,a
 ld b,2
 call NewAnimation
 jr OKToMove

MaybeEnergyShield:
 cp 77
 jr c,OKToMove
 sub 77
 ld hl,Direction
 cp (hl)
 jr nz,NoMove

OKToMove:
 xor a
 ret

OpenDoor3:
 ld a,(KeyTable+2)

OpenNumberDoor:
 or a
 jr z,NoMove
 ld a,(hl)
 and 1
 add a,32
 xor 1
 ld (hl),a
 push hl
 call RemoveTile
 pop hl
 ld b,(hl)
 call GetXYCoords
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld a,b
 sub 26
 ld c,a
 ld b,2
 call NewAnimation
 jr OKToMove

OpenDoor2:
 ld a,(KeyTable+1)
 jr OpenNumberDoor

OpenDoor1:
 ld a,(KeyTable)
 jr OpenNumberDoor

OpenSecurityDoor:
 ld a,(Keys)
 or a
 jr z,NoMove
 dec a
 ld (Keys),a
 ld a,(hl)
 sub 103
 ld (hl),a
 push hl
 call RemoveTile
 pop hl
 ld b,(hl)
 call GetXYCoords
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld a,b
 sub 26
 ld c,a
 ld b,2
 call NewAnimation
 jr OKToMove

ActivateAH:
 ld (hl),0
 ld de,AlienHoleTable
 ld b,10
AAHLoop:
 ld a,(de)
 cp 220
 jr z,AAHFound
 inc de
 inc de
 inc de
 djnz AAHLoop
 ret
AAHFound:
 ld a,225
 ld (de),a
 push de
 call GetXYCoords
 pop de
 inc de
 ld (de),a
 ld a,l
 inc de
 ld (de),a
 jp OKToMove

ActivateAutoDestruct:
 ld (hl),0
 call LowerDestruction
 jp OKToMove

CheckPickups:
 push hl
 push de
 call GetTile
 sub 11
 call z,GetKey1
 dec a
 call z,GetKey2
 dec a
 call z,GetKey3
 dec a
 call z,GetKey
 dec a
 call z,GetAmmo
 dec a
 call z,Get10Credits
 dec a
 call z,Get100Credits
 dec a
 call z,GetFirstAid
 dec a
 call z,GetInvincibility
 dec a
 call z,GetLife
 pop de
 pop hl
 ret

GetLife:
 call LdHL0RemoveItem
 ld hl,Lives
 inc (hl)
 jr GetPickupScore

GetInvincibility:
 call LdHL0RemoveItem
 ld hl,Invincible
 ld (hl),250
 jr GetPickupScore

GetFirstAid:
 call LdHL0RemoveItem
 push af
 ld a,(Health)
 add a,5
 cp 10
 jr c,SaveFA
 ld a,10
SaveFA:
 ld (Health),a
 pop af
 jr GetPickupScore

GetKey1:
 call LdHL0RemoveItem
 ld hl,KeyTable
 ld (hl),1
 jr GetPickupScore

GetKey2:
 call LdHL0RemoveItem
 ld hl,KeyTable+1
 ld (hl),1
 jr GetPickupScore

GetKey3:
 call LdHL0RemoveItem
 ld hl,KeyTable+2
 ld (hl),2
 jr GetPickupScore

GetKey:
 call LdHL0RemoveItem
 ld hl,Keys
 inc (hl)
 jr GetPickupScore

GetAmmo:
 call LdHL0RemoveItem
 ld hl,(Ammo)
 ld de,10
 add hl,de
 ld (Ammo),hl
 jr GetPickupScore

Get10Credits:
 call LdHL0RemoveItem
 ld hl,(Credits)
 ld de,10
 jr SaveCredits

Get100Credits:
 call LdHL0RemoveItem
 ld hl,(Credits)
 ld de,100
SaveCredits:
 add hl,de
 ld (Credits),hl

GetPickupScore:
 ld hl,(Score)
 ld de,10
 add hl,de
 ld (Score),hl
 ret

LdHL0RemoveItem:
 ld (hl),0
RemoveItem:
 push af
 push hl
 xor a
 call RemoveTile
 pop hl
 pop af
 ret

;########################################
; GetXYCoords - Get X & Y coordinates of a tile
;
; Input:    (HL) = Tile
; Output:   A = XCoord (block value)
;           L = YCoord (block value)
;########################################
GetXYCoords:                    ; Input : (HL) = Tile
 ld de,(TempFile)               ; Output : A = XCoord, L = YCoord (abs values)
 or a
 sbc hl,de
 ld a,(Columns)
 inc a
 bcall(_divhlbya)
 ret

RemoveTile:                     ; (HL) = Tile, A = Tile to draw
 push af
 call GetXYCoords
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,(StartY)
 or a
 sbc hl,de
 ld c,l                         ; C = Screen YCoord
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,(StartX)
 or a
 sbc hl,de
 ld b,l                         ; B = Screen XCoord
 pop af                         ; A = Tile to draw
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprMain
 add hl,de                      ; (HL) = Sprite data
 push hl
 push bc
 ld hl,SprBlank
 call putClippedMaskedSprite
 pop bc
 pop hl
 jp putClippedSprite

#ifdef TI83P
DrawPlayer:
 ld a,(Invincible)
 bit 0,a
 ret nz
 ld hl,(Direction)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprPlayer
 add hl,de
; call StoreSprite
; ld hl,DrawSpr
#else
DrawPlayer:
 ld a,(Invincible)
 bit 0,a
 ret nz
 ld hl,(Direction)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprPlayer
 add hl,de
 ld a,(Walking)
 or a
 jr z,NowDrawPlayer
 ld de,64
 ld a,(FrameCnt)
 bit 2,a
 jr z,NowDrawPlayer
 add hl,de
#endif
NowDrawPlayer:
; ld de,TempBG
 call GetPlayerScrCoords
;#ifdef TI83P
; jp putClippedSprite
;#else
 jp putClippedMaskedSprite
;#endif

GetPlayerScrCoords:
 push hl
 push de
 ld de,(StartX)
 ld hl,(X)
 or a
 sbc hl,de
 ld b,l
 ld de,(StartY)
 ld hl,(Y)
 or a
 sbc hl,de
 ld c,l
 pop de
 pop hl
 ret

PowerOff:
 ei
 ld a,1
 out (3),a
 halt
 ld a,11
 out (3),a
 ld hl,0
 ld b,255
 ret

TeacherKey:
 call PowerOff

Pause:
 bcall(_clrscrnfull)
 bcall(_homeup)
 res textwrite,(iy+sgrflags)
 ld hl,StrPaused
 set textinverse,(iy+textflags)
 bcall(_puts)
 res textinverse,(iy+textflags)
 ld b,6
 ld de,10*256+2
PauseDisp:
 push bc
 call VPuts
 ld a,(pencol+1)
 ld e,2
 add a,6
 ld d,a
 pop bc
 djnz PauseDisp
 ld de,51*256+18
 call VPuts
 ld de,57*256+19
 call VPuts
 call GetScore
 ld de,10*256+75
 call VDispHL
 ld de,16*256+75
 ld a,(Lives)
 call VDispA
 ld de,22*256+75
 ld a,(Health)
 call VDispA
 ld de,28*256+75
 ld hl,(Ammo)
 call VDispHL
 ld de,34*256+75
 ld a,(Keys)
 call VDispA
 ld de,40*256+75
 ld hl,(Credits)
 call VDispHL
 set textwrite,(iy+sgrflags)
PauseLoop:
 call WaitKey
 ld hl,Contrast
 cp 4
 jr z,ContrastUp
 cp 15
 jr z,PauseQuit
 cp 9
 ret z
 dec a
 jr z,ContrastDown
 jr PauseLoop

PauseQuit:
 pop hl                         ; Pop "ret" value to MainLoop
 call iFastCopy
 jp BlowUp

ContrastUp:
 ld a,(hl)
 cp $1F
 jr z,PauseLoop
 inc a

StoreContrast:
 ld (hl),a
 add a,$18
 or $C0
 out ($10),a
 jr PauseLoop

ContrastDown:
 ld a,(hl)
 or a
 jr z,PauseLoop
 dec a
 jr StoreContrast

VDispA:
 ld l,a
 ld h,0

VDispHL:
 ld (pencol),de
 bcall(_setxxxxop2)
 bcall(_op2toop1)
 ld a,5
 bcall(_dispop1a)
 ret

SaveVideo:
 ld hl,gbuf
 ld de,BUVideo
 jr DoVideo

RestoreVideo:
 ld hl,BUVideo
 ld de,gbuf
DoVideo:
 ld bc,768
 ldir
 ret

CheckPACollisions:
 ld ix,EnemyTable
 ld b,NO_ALIENS
 ld de,(Y)
PAC:
 push bc
 ld a,(ix)
 or a
 jr z,EndPAC
 ld bc,(X)
 ld l,(ix+2)
 ld h,(ix+3)
 or a
 sbc hl,bc
 ld a,l
 jr nc,PACAbsX
 neg
PACAbsX:
 cp 8
 jr nc,EndPAC
 ld l,(ix+4)
 ld h,(ix+5)
 push hl
 push de
 ld de,(StartY)
 or a
 sbc hl,de
 ld de,-8
 bcall(_cphlde)
 jr nc,PACOK
 ld de,64
 bcall(_cphlde)
 jr nc,NoPAC
PACOK:
 pop de
 pop hl
 or a
 sbc hl,de
 ld a,l
 jr nc,PACAbsY
 neg
PACAbsY:
 cp 8
 jr nc,EndPAC
 dec (ix+7)
 jr nz,AlienNotDead
 ld (ix),0
 ld l,(ix+2)
 ld h,(ix+3)
 ld e,(ix+4)
 ld d,(ix+5)
 ld bc,4*256+1
 call NewAnimation
AlienNotDead:
 ld a,(Dead)
 or a
 jr nz,EndPAC
 ld a,(Invincible)
 or a
 jr nz,EndPAC
 ld hl,Health
 dec (hl)
EndPAC:
 ld bc,9
 add ix,bc
 pop bc
 djnz PAC
 ret

NoPAC:
 pop de
 pop hl
 jr EndPAC

ViewRadarScanner:
 ld a,(RadarScanner)
 or a
 ret z
 call SaveVideo
 call ShowMap
 jp RestoreVideo

;########################################
; ShowMap - Show map of current level
;
; Input:    None
; Output:   None
;########################################
ShowMap:
 bcall(_grbufclr)
 xor a
 ld (TempY),a
 ld a,(Rows)
 ld b,a
 inc b
 ld hl,(TempFile)
MapLoop:
 push bc
 xor a
 ld (TempX),a
 ld a,(Columns)
 ld b,a
 inc b
MapLoop2:
 push bc
 ld a,(hl)
 cp 81
 jr c,NoPutPixel
 cp 133
 jr nc,NoPutPixel
 push hl
 ld a,(TempY)
 ld e,a
 ld a,(TempX)
 call iGetPixel
 or (hl)
 ld (hl),a
 pop hl
NoPutPixel:
 inc hl
 pop bc
 ld a,(TempX)
 inc a
 ld (TempX),a
 djnz MapLoop2
 ld a,(TempY)
 inc a
 ld (TempY),a
 pop bc
 djnz MapLoop
 call iFastCopy
MapLoop3:
#ifdef TI83P
 ld b,40
 call DelayB
#else
 ei
 ld b,40
MapLoop4:
 halt
 djnz MapLoop4
#endif
 ld bc,3
 ld hl,(Y)                      ; HL = YCoord
 add hl,bc                      ; HL = YCoord + 3
 call DivHLby8                  ; HL = YCoord (block value)
 ld e,l                         ; E = YCoord (block value)
 ld hl,(X)
 add hl,bc                      ; HL = XCoord + 3
 call DivHLby8
 ld a,l                         ; A = XCoord (block value)
 call iGetPixel                 ; (HL) = Byte in video memory, A = Bitmask
 xor (hl)                       ; Toggle pixel
 ld (hl),a                      ; Save it back to video memory
 call iFastCopy
 bcall(GET_KEY)                 ; Get keypresses
 or a
 jr z,MapLoop3                  ; If none, loop again
 cp 49                          ; [GRAPH]
 ret nz                         ; RET only if it wasn't [GRAPH] that was pressed
 jr MapLoop3

;########################################
; DivHLby8 - Divide HL by 8, fast!
;
; Input:    HL = Number to divide
; Output:   HL = HL / 8
;########################################
DivHLby8:
 srl h                          ; Rotate H right 1 bit, store the bit that falls off in the carry flag
 rr l                           ; Rotate L right 1 bit, get carry flag to the left-most bit, HL = HL / 2
 srl h                          ; Do this 3 times and HL will be divided by 8 :P
 rr l                           ; HL = HL / 4
 srl h
 rr l                           ; HL = HL / 8
 ret

LowerDestruction:
 ld a,(Destruction)             ; Get Destruction value
 or a
 ret z                          ; (Destruction) can't be lowered if it's already 0
 dec a
 ret z                          ; Can't be lowered if it's 1 either!
 ld (Destruction),a             ; Otherwise, store the decremented value
 ret

GetLaser:
 ld a,1                         ; Laser Gun is weapon 1
 ld (Weapon),a
 ret

GetTwinMissile:
 ld a,(WeaponTable+1)
 or a                           ; Does player have this weapon?
 ret z                          ; If not, they can't use it
 ld a,2
 ld (Weapon),a                  ; Twin Missile Launcher is weapon 2
 ret

GetPlasma:
 ld a,(WeaponTable+2)
 or a
 ret z
 ld a,3
 ld (Weapon),a                  ; Plasma Rifle is weapon 3
 ret

GetRocket:
 ld a,(WeaponTable+3)
 or a
 ret z
 ld a,4
 ld (Weapon),a                  ; Rocket Launcher is weapon 4
 ret

;########################################
; ShowHL - Show HL in small font, preceded by set number of zeros
;
; Input:    HL = Number to show
;           B = Number of characters to show
; Output:   None
;########################################
ShowHL:                         ; Displays HL in small font, other input - B = max. chars to show
 ld de,StringDat+5              ; End of string storage
 xor a
 ld (de),a                      ; Put in the NULL terminator
SHLLoop:
 dec de                         ; Move pointer back a byte
 bcall(_divhlby10)              ; Get smallest unit of HL to A
 add a,'0'                      ; Format it for display
 ld (de),a                      ; Store it
 djnz SHLLoop                   ; Next character
 ex de,hl                       ; (HL) = String to display
 bcall(_vputs)                  ; Show HL
 ret

;########################################
; CheckOnScreen - Check to see if an object is currently on the screen
;
; Input:    A = XCoord (block value)
;           (HL+1) = YCoord (block value)
; Output:   NC = Object on screen
;########################################
CheckOnScreen:                  ; Input - A = XCoord (abs)
 ld (CheckX),a                  ; Save abs X (used with some other routines)
 inc hl
 ex de,hl                       ; (DE) = abs Y
 ld hl,(StartX)                 ; HL = Exact XCoord of top-left of screen
 call DivHLby8                  ; L = abs X of top-left
 cp l                           ; Compare it with inputted XCoord
 ret c                          ; If not on screen, return the carry
 ld b,a                         ; B = abs X that was input
 ld a,l
 add a,11                       ; A = abs X of top-right
 cp b                           ; Compare them
 ret c                          ; If not on screen, return the carry
 ld a,(de)                      ; A = abs Y of object that we're checking
 ld (CheckY),a                  ; Save it (for some other routines)
 ld hl,(StartY)                 ; Go through same process as we did for XCoord
 call DivHLby8
 cp l
 ret c
 ld b,a
 ld a,l
 add a,7
 cp b
 ret                            ; If the object wasn't on the screen, a carry will be returned ;)

;########################################
; GetXYTemp - Get X & Y coords of a tile, save them to temp memory and check for collisions
;             between these coordinates and all enemies
;
; Input:    (HL) = Tile
; Output:   A = Number of collisions
;           Z = Only one collision found
;########################################
GetXYTemp:
 call GetXYCoords               ; Get block X & Y Coords to A and L respectively
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl                      ; HL = Exact YCoord
 ld (TempY),hl                  ; Save it
 ld l,a
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl                      ; HL = Exact XCoord
 ld (TempX),hl                  ; Save it
 call CheckAlienCollisions      ; Check for how many collisions there are between this enemy and all the others
 cp 1                           ; There should only be one (with itself)
 ret

;########################################
; StoreSprite - Store a sprite with mask to be displayed with PutSprite_MSB
;
; Input:    (HL) = Sprite to store
; Output:   None
;########################################
;StoreSprite:
; ld de,DrawSpr                  ; (DE) = Where to store sprite
; ld bc,8                        ; BC = 8 bytes to store
; push bc
; push de
; ldir                           ; Load sprite from (HL) to (DrawSpr)
; pop hl
; pop bc
; ldir                           ; Copy it!
; ret

ClearEnemyTable:
 ld hl,EnemyTable
 ld bc,NO_ALIENS*9-1
 ld (hl),0
 jr ClearTable                  ; Clear the EnemyTable

ClearAnimationTable:
 ld hl,AnimationTable
 ld bc,29
 ld (hl),0
 jr ClearTable                  ; Clear the AnimationTable

ClearBulletTable:
 xor a
 ld (EBulletTable),a            ; Clear Security Guard missile
 ld hl,BulletTable
 ld bc,59
 ld (hl),0
 jr ClearTable                  ; Clear the BulletTable

ClearSGTable:
 ld hl,SGTable                  ; (HL) = Where to start clearing from
 ld bc,13                       ; BC = 13 more bytes to clear
 ld (hl),0                      ; Clear first byte, rest will be filled with this value
 jr ClearTable                  ; Clear the rest

ClearAlienHoleTable:
 ld hl,AlienHoleTable           ; (HL) = Where to start clearing from
 ld bc,29                       ; BC = 29 more bytes to clear
 ld (hl),220                    ; Clear first byte, rest will be filled with this value

;########################################
; ClearTable - Clear a group of bytes
;
; Input:    (HL) = Start of group
;           BC = Number of bytes to clear
; Output:   None
;########################################
ClearTable:
 ld d,h
 ld e,l
 inc de                         ; DE = HL + 1
 ldir                           ; Load BC bytes from (HL) to (DE)
 ret

#ifdef TI83
;########################################
; DirectIn - Get keypresses from a specified keygroup
;
; Input:    A = Key group
; Output:   A = Key presses
;########################################
DirectIn:
 ld b,a                         ; Save key group
 ld a,$FF
 out (1),a                      ; Reset key port
 ld a,b
 out (1),a                      ; Open key group to check
 in a,(1)                       ; A = Key presses
 ret
#endif

#ifdef TI83P
VPuts = SetVPuts                ; MirageOS already has this routine built in
#else
VPuts:                          ; TI-83 doesn't, so here it is
 ld (pencol),de                 ; DE = penrow, pencol
 jp _vputs                      ; Display text
#endif

#include "taaliens.asm"         ; Main Alien management routines, including
                                ;  Security Guard shooting routines
#include "taanim.asm"           ; Main animation routines
#include "tabullet.asm"         ; Bullet management routines
#include "tacode.asm"           ; Passcode Encoding/Decoding Routines by Me :P
#include "taintex.asm"          ; Intex Console routines
#include "tamove.asm"           ; Player movement routines
#include "taqueen.asm"          ; Queen Alien routines
#include "tascroll.asm"         ; Screen scrolling routines

#include "sprite.asm"           ; Sprite routines
#include "huffextr.h"           ; Huffman extraction by Jimmy Mrdell :)


DirectionTable:                 ; Used with death-spin to determine the next direction player should face
.db 2,3,1,0

BCXTable:                       ; Collision detection table for X coords between
.db 5,5,8,8                     ; bullets & aliens
.db 6,6,8,8
.db 7,7,6,6
.db 6,6,7,7

BCYTable:                       ; Collision detection table for Y coords between
.db 8,8,5,5                     ; bullets & aliens
.db 8,8,6,6
.db 6,6,7,7
.db 7,7,6,6

IntexTableX:                    ; Offset table to work out XCoord of where to check for Intex Console
.db 3,4,0,7                     ; according to which direction player is facing

IntexTableY:
.db 0,7,4,3

BXTable:                        ; Offset table to work out initial bullet xcoord
.dw 0,0,-4,4

BYTable:                        ; Offset table to work out initial bullet ycoord
.dw -4,4,0,0

AnimSprTable:
.dw SprExplosion,SprVDOpen,SprHDOpen,SprVSOpen,SprHSOpen,SprVNOpen,SprHNOpen

PCValid:
.db 2,1,0,3,2,1,2,0,3,2,1,0,2,1,3,1

#ifdef TI83
CharTable:
.db ")<>(.....",$22
.db "WRMH].?",$3A,"VQ"
.db "LG",$C1,".:ZUPKF"
.db "C# YTOJEB|"
.db ".XSNIDA@54"
.db "321!*"
#endif

StrPaused:
.db "     PAUSED     ",0
.db "Score",0
.db "Lives",0
.db "Health",0
.db "Ammo",0
.db "Keys",0
.db "Credits",0
.db $C1,"ENTER] - Continue",0
.db $C1,"CLEAR] - Retreat",0

StrIntexMain:
.db "INTEX NETWORK SYSTEM",0
.db "WEAPON SUPPLIES",0
.db "MISCELLANEOUS SUPPLIES",0
.db "INTEX MAP",0
.db "MISSION OBJECTIVES",0
.db "EXIT INTEX SYSTEM",0

StrIntexWeapons:
.db "INTEX WEAPON SUPPLIES",0
.db "TWIN MISSILE",0,"1000 CR",0
.db "PLASMA RIFLE",0,"2700 CR",0
.db "ROCKET LAUNCHER",0,"4000 CR",0
.db "MAIN MENU",0

StrIntexOther:
.db "INTEX MISC SUPPLIES",0
.db "KEY PACK",0,"300 CR",0
.db "AMMO CLIPS",0,"600 CR",0
.db "FIRST AID",0,"1000 CR",0
.db "RADAR SCANNER",0,"1500 CR",0
.db "EXTRA LIFE",0,"3000 CR",0
.db "MAIN MENU",0

StrIntexCredits:
.db "CREDITS:",0

StrIntexPurchased:
.db "PURCHASED",0

StrMain:
.db "START GAME",0
.db "DIFFICULTY",0
.db "ENTER PASSCODE",0
.db "QUIT",0
.db "v",VerMajor,".",VerMinor,0

StrGameOver:
.db "GAME",0
.db "OVER",0

StrNormal:
.db "NORMAL",0

StrTough:
.db "TOUGH",0

DiffTable:
.dw StrNormal,StrTough

StrAuthor:
.db "COPYRIGHT (c)2000-2001",0
.db "TCPA - tcpa.calc.org",0
.db "By James Vernon",0
.db "High Scores:",0

StrPasscode:
.db "Enter "

StrShowPCode:
.db "Passcode: ",0
#ifdef TI83
.db "_______________",0
#endif

HighScores:                    ; Highscore table
.db "1. TCPA RULZ!",0
.dw 5000
.db "2. JamesV    ",0
.dw 4000
.db "3. Dan_E     ",0
.dw 3000
.db "4. Jason_K   ",0
.dw 2000
.db "5. ticalc.org",0
.dw 1000

StrNewHigh:
#ifdef TI83P
.db "You got a High Score!",0
.db "Enter your name:",0
#else
.db "   You got a    "
.db "  High Score!",0
.db "Enter your name:"
.db "   ",0
#endif

#ifdef TI83
TempName:
.db 5,"TATMP",0                 ; Name of temp file to be created on the TI-83
#endif

EnergyTable:                    ; Table to work out initial energy of an enemy
.db 0,0,0,0,0,1,1,1,1,2,2,3,2,3,1,1,3,3,4,5
.db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2
.db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
.db 0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,3,3,0,0

SpeedTable:                     ; Table to work out speed of an enemy
.db 1,3,2,2,1,2,3,1,2,2
.db 2,1,1,2,1,1,1,2,1,1
.db 3,3,2,3,2,3,3,3,2,3
.db 2,2,2,2,2,2,2,2,2,2

ExpTable:
.db $01,$80,$40,$20,$10,$08,$04,$02,$01

#ifdef TI83
vars83:
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; 100 bytes
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; 200 bytes
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; 300 bytes
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; 400 bytes
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; 500 bytes
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; 600 bytes
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; 640 bytes for variable storage, must be altered if variables are added or removed
vars            = vars83           ; Main variable pointer
#endif

#include "tavars.h"                ; Variable Declarations

#include "towergfx.h"           ; Graphics file

SprBlank:
.db $00,$00,$00,$00,$00,$00,$00,$00
.db $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

DataFile:                       ; Data file is copied here on compilation

.end
