;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Queen Alien Routines                                    ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;

IniQueen:
 ld a,250
 ld (QHealth),a
 xor a
 ld (hl),a
 ld (QCnt),a
 inc a
 ld (QSpr),a
 ld (QFlag),a
 ld (Mode),a
 ld a,(BlockPutX)
 ld (CheckX),a
 ld a,(BlockPutY)
 ld (CheckY),a
 call GetTileAbs
 ld a,86
 ld (hl),a
 call RemoveTile
 ld hl,(X)
 ld (QX),hl
 ld hl,8
 ld (QY),hl
 jp MainLoop

MoveQueen:
 ld hl,QSpr
 inc (hl)
 ld a,(hl)
 cp %00010000
 jr c,NoResetQSpr
 ld (hl),0
NoResetQSpr:
; Move Queen up/down
 ld a,(QFlag)
 or a
 ld hl,(QY)
 jr z,QueenUp
QueenDown:
 inc hl
 ld (QY),hl
 ld hl,QCnt
 inc (hl)
 ld a,(hl)
 sub 56
 jr nz,MoveQueenX
 ld (QFlag),a
 jr MoveQueenX
QueenUp:
 dec hl
 ld (QY),hl
 ld hl,QCnt
 dec (hl)
 jr nz,MoveQueenX
 inc a
 ld (QFlag),a

MoveQueenX:
 ld a,(QSpr)
 bit 0,a
 ret z

 ld hl,(QX)
 ld de,8
 add hl,de
 ex de,hl
 ld hl,(X)
 inc hl
 inc hl
 inc hl
 inc hl
 or a
 sbc hl,de
 ld b,0
 ld a,l
 jr nc,QAbsX
 neg
 inc b
QAbsX:
 cp 5
 ret c
 ld hl,(QX)
 ld a,b
 or a
 jr nz,QueenLeft
QueenRight:
 inc hl
 jr FinishQueenMove
QueenLeft:
 dec hl
FinishQueenMove:
 ld (QX),hl
 ret

DrawQueen:
 ld hl,(QSpr)
 ld h,0
 srl l
 srl l
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprQueen
 add hl,de
 ld (QTemp),hl
; call StoreSprite
 ld hl,(QY)
 ld de,(StartY)
 or a
 sbc hl,de
 ld c,l
 ld hl,(QX)
 ld de,(StartX)
 or a
 sbc hl,de
 ld b,l
 call DrawQueenStuff
 ld a,b
 add a,8
 ld b,a
 call DrawQueenStuff
 ld a,c
 add a,8
 ld c,a
 call DrawQueenStuff
 ld a,b
 sub 8
 ld b,a
 call DrawQueenStuff
; Draw Health bar for Queen
 ld hl,gbuf+(61*12)
 ld de,gbuf+(61*12)+1
 ld (hl),0
 ld bc,35
 ldir
 ld hl,(QHealth)
 ld h,0
 ld a,5
 bcall(_divhlbya)
 ld a,l
QHealthLoop:
 push af
 ld e,62
 call iGetPixel
 or (hl)
 ld (hl),a
 pop af
 dec a
 cp 255
 jr nz,QHealthLoop
 ret

DrawQueenStuff:
 push bc
; ld hl,DrawSpr
 ld hl,(QTemp)
 call putClippedSprite
 ld de,8
 ld hl,(QTemp)
 add hl,de
 ld (QTemp),hl
; call StoreSprite
 pop bc
 ret

CheckQBHits:
 ld ix,BulletTable
 ld b,10
QBHLoop:
 ld a,(ix)
 or a
 jr z,NextQBH
 ld e,(ix+2)
 ld d,(ix+3)
 ld hl,(QX)
 inc hl
 inc hl
 inc hl
 inc hl
 or a
 sbc hl,de
 ld a,l
 jr nc,QBHAbsX
 neg
QBHAbsX:
 cp 12
 jr nc,NextQBH
 ld e,(ix+4)
 ld d,(ix+5)
 ld hl,(QY)
 inc hl
 inc hl
 inc hl
 inc hl
 or a
 sbc hl,de
 ld a,l
 jr nc,QBHAbsY
 neg
QBHAbsY:
 cp 12
 jr nc,NextQBH
 push bc
 ld l,(ix+2)
 ld h,(ix+3)
 ld e,(ix+4)
 ld d,(ix+5)
 ld bc,4*256+1
 call NewAnimation
 ld a,(QHealth)
 ld b,(ix)
 srl b
 sub b
 ld (ix),0
 ld (QHealth),a
 jr c,QueenDead
 pop bc
NextQBH:
 ld de,6
 add ix,de
 djnz QBHLoop
 ret

QueenDead:
 pop bc
 pop hl
 call RestoreVideo
 xor a
 ld (Mode),a
 ld a,(BlockTakeX)
 ld (CheckX),a
 ld a,(BlockTakeY)
 ld (CheckY),a
 call GetTileAbs
 ld a,(BlockType)
 ld (hl),a
 call RemoveTile
 ld hl,(Score)
 ld de,1000
 add hl,de
 ld (Score),hl
 call LowerDestruction
 jp QSkip

CheckQPHits:
 ld a,(Invincible)
 or a
 ret nz
 ld a,(Dead)
 or a
 ret nz
 ld de,(X)
 ld hl,(QX)
 inc hl
 inc hl
 inc hl
 inc hl
 or a
 sbc hl,de
 ld a,l
 jr nc,QPHAbsX
 neg
QPHAbsX:
 cp 12
 ret nc
 ld de,(Y)
 ld hl,(QY)
 inc hl
 inc hl
 inc hl
 inc hl
 or a
 sbc hl,de
 ld a,l
 jr nc,QPHAbsY
 neg
QPHAbsY:
 cp 12
 ret nc
 ld hl,Health
 dec (hl)
 ret
