;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Passcode Encoding/Decoding Routine                      ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;

MakePasscode:
 ld bc,StringDat
 ld a,(Level)
 ld d,a
 call SRLAx3
; srl a
 ld (bc),a
 ld a,d
 add a,a
 and %00001110
 inc bc
 ld d,a
 ld a,(Lives)
 bit 7,a
 jr z,MPC1
 set 0,d
MPC1:
 ld e,a
 ld a,d
 ld (bc),a
 ld a,e
 call SRLAx3
 and %00001111
 inc bc
 ld (bc),a
 ld a,e
 add a,a
 and %00001110
 inc bc
 ld hl,(Credits)
 bit 7,h
 jr z,MPC2
 set 0,a
MPC2:
 ld (bc),a
 inc bc
 ld a,h
 call SRLAx3
 and %00001111
 ld (bc),a
 inc bc
 ld a,h
 add a,a
 and %00001110
 bit 7,l
 jr z,MPC3
 set 0,a
MPC3:
 ld (bc),a
 inc bc
 ld a,l
 call SRLAx3
 and %00001111
 ld (bc),a
 inc bc
 ld a,l
 add a,a
 and %00001110
 ld d,a
 ld a,(Keys)
 bit 7,a
 jr z,MPC4
 set 0,d
MPC4:
 ld e,a
 ld a,d
 ld (bc),a
 ld a,e
 inc bc
 call SRLAx3
 and %00001111
 ld (bc),a
 inc bc
 ld a,e
 add a,a
 and %00001110
 ld hl,(Ammo)
 bit 7,h
 jr z,MPC5
 set 0,a
MPC5:
 ld (bc),a
 inc bc
 ld a,h
 call SRLAx3
 and %00001111
 ld (bc),a
 inc bc
 ld a,h
 add a,a
 and %00001110
 bit 7,l
 jr z,MPC6
 set 0,a
MPC6:
 ld (bc),a
 inc bc
 ld a,l
 call SRLAx3
 and %00001111
 ld (bc),a
 inc bc
 ld a,l
 add a,a
 and %00001110
 ld d,a
 ld a,(WeaponTable+1)
 or a
 jr z,MPC7
 set 0,d
MPC7:
 ld a,d
 ld (bc),a
 inc bc
 ld d,0
 ld a,(WeaponTable+2)
 or a
 jr z,MPC8
 set 3,d
MPC8:
 ld a,(WeaponTable+3)
 or a
 jr z,MPC9
 set 2,d
MPC9:
 ld a,(RadarScanner)
 or a
 jr z,MPC10
 set 1,d
MPC10:
 ld a,(StartNumber)
 or a
 jr z,MPC11
 set 0,d
MPC11:
 ld a,d
 ld (bc),a
 dec bc
 ld a,(bc)
 ld e,a
 ld d,0
 ld hl,PCValid
 add hl,de
 ld a,(hl)
 ld hl,StringDat
 add a,a
 add a,a
 or (hl)
 ld (hl),a
 ld b,15
MPC12:
 ld a,'A'
 add a,(hl)
 ld (hl),a
 inc hl
 djnz MPC12
 ld (hl),0
 ret

SRLAx3:
 srl a
 srl a
 srl a
 ret

PCNotValid:
 xor a
 ld (StartLvl),a
 ret

DecodePasscode:
 ld de,StringDat
 ld h,d
 ld l,e
 ld b,15
DP0:
 ld a,(de)
 cp 'A'
 jr c,PCNotValid
 cp 'Q'
 jr nc,PCNotValid
 inc de
 djnz DP0
 ld b,15
DP1:
 ld a,(hl)
 sub 'A'
 ld (hl),a
 inc hl
 djnz DP1
 ld a,(StringDat)
 dec hl
 dec hl
 ld e,(hl)
 srl a
 srl a
 ld d,0
 ld hl,PCValid
 add hl,de
 cp (hl)
 jr nz,PCNotValid

 ld hl,StringDat
 ld a,(hl)
 and %00000011
 inc hl
 ld b,(hl)
 add a,a
 add a,a
 add a,a
 srl b
 or b
 ld (StartLvl),a
 ld a,(hl)
 rrca
 and %10000000
 ld b,a
 inc hl
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 or b
 inc hl
 ld b,(hl)
 srl b
 or b
 ld (Lives),a
 ld a,(hl)
 rrca
 and %10000000
 ld d,a
 inc hl
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 or d
 ld d,a
 inc hl
 ld a,(hl)
 ld e,0
 srl a
 rr e
 or d
 ld d,a
 inc hl
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 or e
 ld e,a
 inc hl
 ld a,(hl)
 srl a
 or e
 ld e,a
 ld (Credits),de
 ld a,(hl)
 rrca
 and %10000000
 ld b,a
 inc hl
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 or b
 inc hl
 ld b,(hl)
 srl b
 or b
 ld (Keys),a
 ld a,(hl)
 rrca
 and %10000000
 ld d,a
 inc hl
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 or d
 ld d,a
 inc hl
 ld a,(hl)
 ld e,0
 srl a
 rr e
 or d
 ld d,a
 inc hl
 ld a,(hl)
 add a,a
 add a,a
 add a,a
 or e
 ld e,a
 inc hl
 ld a,(hl)
 srl a
 or e
 ld e,a
 ld (Ammo),de
 ld a,1
 ld b,(hl)
 srl b
 jr nc,DPC1
 ld (WeaponTable+1),a
DPC1:
 inc hl
 ld b,(hl)
 srl b
 jr nc,DPC2
 ld (WeaponTable+2),a
DPC2:
 srl b
 jr nc,DPC3
 ld (WeaponTable+3),a
DPC3:
 srl b
 jr nc,DPC4
 ld (RadarScanner),a
DPC4:
 srl b
 ret nc
 ld (StartNumber),a
 ret
