;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Intex Console Routines                                  ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;

IntexConsole:
 ld de,(Direction)
 ld d,0
 ld hl,IntexTableX
 add hl,de
 ld c,(hl)
 ld b,0
 ld hl,IntexTableY
 add hl,de
 ld e,(hl)
 ld d,0
 ld hl,(Y)
 add hl,de
 ex de,hl
 ld hl,(X)
 add hl,bc
 call GetTile
 cp 122
 ret nz
 call SaveVideo

IntexMain:
 bcall(_grbufclr)
 ld de,2*256+10
 ld hl,StrIntexMain
 call VPuts          ; INTEX NETWORK SYSTEM
 ld de,10*256+20
 call VPuts          ; WEAPON SUPPLIES
 ld de,17*256+6
 call VPuts          ; MISCELLANEOUS SUPPLIES
 ld de,24*256+31
 call VPuts          ; INTEX MAP
 ld de,31*256+14
 call VPuts          ; MISSION OBJECTIVES
 ld de,38*256+17
 call VPuts          ; EXIT INTEX SYSTEM
 ld a,5
 call IntexMenu
 or a
 jp z,IntexWeapons
 dec a
 jp z,IntexOther
 dec a
 jp z,IntexMap
 dec a
 jp z,IntexMission

ExitIntex:
 xor a
 ld (MenuItem),a
 jp RestoreVideo

IntexWeapons:
 bcall(_grbufclr)
 ld de,2*256+7
 ld hl,StrIntexWeapons
 call VPuts          ; INTEX WEAPON SUPPLIES
 ld de,10*256+2
 call VPuts          ; TWIN MISSILE
 ld de,10*256+70
 call VPuts          ; 1000 CR
 ld de,17*256+2
 call VPuts          ; PLASMA RIFLE
 ld de,17*256+70
 call VPuts          ; 2700 CR
 ld de,24*256+2
 call VPuts          ; ROCKET LAUNCHER
 ld de,24*256+70
 call VPuts          ; 4000 CR
 ld de,31*256+32
 call VPuts          ; MAIN MENU
 ld a,4
 call IntexMenu
 or a
 jr z,BuyTwinMissile
 dec a
 jr z,BuyPlasma
 dec a
 jp nz,IntexMain

BuyRocket:
 ld bc,WeaponTable+3
 ld de,4000

BuyWeapon:
 ld a,(bc)
 or a
 jp nz,IntexWeapons
 ld hl,(Credits)
 sbc hl,de
 jr c,IntexWeapons
 ld (Credits),hl
 inc a
 ld (bc),a
 call IntexPurchased
 jp IntexWeapons

BuyTwinMissile:
 ld bc,WeaponTable+1
 ld de,1000
 jr BuyWeapon

BuyPlasma:
 ld bc,WeaponTable+2
 ld de,2700
 jr BuyWeapon

IntexPurchased:
 ld hl,StrIntexPurchased
 ld de,57*256+59
 call VPuts
 call iFastCopy
#ifdef TI83P
 ld b,150
 jp DelayB
#else
 ei
 ld b,150
IPLoop:
 halt
 djnz IPLoop
 ret
#endif

IntexOther:
 bcall(_grbufclr)
 ld de,2*256+13
 ld hl,StrIntexOther
 call VPuts          ; INTEX MISC SUPPLIES
 ld de,10*256+2
 call VPuts          ; KEY PACK
 ld de,10*256+74
 call VPuts          ; 300 CR
 ld de,17*256+2
 call VPuts          ; AMMO CLIPS
 ld de,17*256+74
 call VPuts          ; 600 CR
 ld de,24*256+2
 call VPuts          ; FIRST AID
 ld de,24*256+70
 call VPuts          ; 1000 CR
 ld de,31*256+2
 call VPuts          ; RADAR SCANNER
 ld de,31*256+70
 call VPuts          ; 1500 CR
 ld de,38*256+2
 call VPuts          ; EXTRA LIFE
 ld de,38*256+70
 call VPuts          ; 3000 CR
 ld de,45*256+32
 call VPuts          ; MAIN MENU
 ld a,6
 call IntexMenu
 or a
 jr z,BuyKeyPack
 dec a
 jr z,BuyAmmoClips
 dec a
 jr z,BuyFirstAid
 dec a
 jr z,BuyRadarScanner
 dec a
 jp nz,IntexMain

BuyExtraLife:
 ld hl,(Credits)
 ld de,3000
 sbc hl,de
 jp c,IntexOther
 ld (Credits),hl
 ld hl,Lives
 inc (hl)
 call IntexPurchased
 jp IntexOther

BuyKeyPack:
 ld hl,(Credits)
 ld de,300
 sbc hl,de
 jp c,IntexOther
 ld (Credits),hl
 ld a,(Keys)
 add a,5
 ld (Keys),a
 call IntexPurchased
 jp IntexOther

BuyAmmoClips:
 ld hl,(Credits)
 ld de,600
 sbc hl,de
 jp c,IntexOther
 ld (Credits),hl
 ld hl,(Ammo)
 ld de,40
 add hl,de
 ld (Ammo),hl
 call IntexPurchased
 jp IntexOther

BuyFirstAid:
 ld hl,(Credits)
 ld de,1000
 sbc hl,de
 jp c,IntexOther
 ld (Credits),hl
 ld a,10
 ld (Health),a
 call IntexPurchased
 jp IntexOther

BuyRadarScanner:
 ld a,(RadarScanner)
 or a
 jp nz,IntexOther
 ld hl,(Credits)
 ld de,1500
 sbc hl,de
 jp c,IntexOther
 ld (Credits),hl
 inc a
 ld (RadarScanner),a
 call IntexPurchased
 jp IntexOther

IntexMap:
 call ShowMap
 jp IntexMain

IntexMission:
 call MissionInfo
 call iFastCopy
 call WaitKey
 jp IntexMain

IntexMenu:
 ld (TempY),a
 cp 5
 jr z,AfterShowCredits
 ld de,57*256+0
 ld hl,StrIntexCredits
 call VPuts
 ld hl,(Credits)
 bcall(_setxxxxop2)
 bcall(_op2toop1)
 ld a,5
 bcall(_dispop1a)
AfterShowCredits:
 xor a
 ld (MenuItem),a
 ld hl,gbuf+(10*12)
 ld (TempX),hl
 ld bc,7*12
 call InvertArea
IMLoop:
 call iFastCopy
 call WaitKey
 cp 54
 jr z,IMDone
 cp 4
 jr z,IMUp
 dec a
 jr nz,IMLoop

 call IM1
 add hl,de
 inc a
 cp b
 jr nz,IM2
 xor a
 ld hl,gbuf+(10*12)
 jr IM2

IMUp:
 call IM1
 or a
 sbc hl,de
 dec a
 cp 255
 jr nz,IM2
 dec b
 ld a,b
 ld hl,gbuf+(10*12)
 ld de,7*12
IMBottomLoop:
 add hl,de
 djnz IMBottomLoop

IM2:
 ld (TempX),hl
 ld (MenuItem),a
 ld bc,7*12
 call InvertArea
 jr IMLoop

IM1:
 ld bc,84
 ld hl,(TempX)
 call InvertArea
 ld a,(TempY)
 ld b,a
 ld a,(MenuItem)
 ld hl,(TempX)
 ld de,7*12
 ret

IMDone:
 ld a,(MenuItem)
 ret
