;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Bullet Management Routines                              ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;

DrawBullets:
 ld ix,BulletTable
 ld b,10
DBLoop:
 push bc
 ld a,(ix)
 or a
 jr z,EndDB
 ld l,a
 dec l
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ld de,SprBullets
 add hl,de
 ex de,hl
 ld l,(ix+1)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,de                      ; (HL) = Sprite data of bullet to draw
; call StoreSprite
 push hl
 ld l,(ix+4)
 ld h,(ix+5)
 ld de,(StartY)
 or a
 sbc hl,de
 ld c,l
 ld l,(ix+2)
 ld h,(ix+3)
 ld de,(StartX)
 or a
 sbc hl,de
 ld b,l
; ld hl,DrawSpr
 pop hl
 push ix
 call putClippedSprite
 pop ix
EndDB:
 pop bc
 ld de,6
 add ix,de
 djnz DBLoop
 ret

Shoot:
 ld hl,FrameCnt
 bit 0,(hl)
 ret z
 ld hl,(Ammo)
 ld a,h
 or l
 ret z
 ld ix,BulletTable
 ld b,10
 ld de,6
FBS:
 ld a,(ix)
 or a
 jr z,BSFound
 add ix,de
 djnz FBS
 ret

BSFound:
 ld hl,(Ammo)
 dec hl
 ld (Ammo),hl
 ld a,(Weapon)
 ld (ix),a
 ld bc,(Direction)
 ld (ix+1),c
 ld a,c
 add a,a
 ld c,a
 ld b,0
 ld hl,BXTable
 add hl,bc
 ld e,(hl)
 inc hl
 ld d,(hl)
 ld hl,(X)
 add hl,de
 ld (ix+2),l
 ld (ix+3),h
 ld hl,BYTable
 add hl,bc
 ld e,(hl)
 inc hl
 ld d,(hl)
 ld hl,(Y)
 add hl,de
 ld (ix+4),l
 ld (ix+5),h
 ret

MoveBullets:
 ld ix,BulletTable
 ld b,10
MBLoop:
 push bc
 ld a,(ix)
 or a
 jr z,EndMB
 ld a,(ix+1)
 or a
 jp z,MoveBUp
 dec a
 jp z,MoveBDown
 dec a
 jp z,MoveBLeft
 jp MoveBRight
EndMB:
 ld de,6
 add ix,de
 pop bc
 djnz MBLoop
 ret

ShotEggPop:
 pop bc
ShotEgg:
 call GetTile
 xor a
 ld (hl),a
 call RemoveTile
 call LowerDestruction
 jr KillBullet

ShotPowerDomePop:
 pop bc
ShotPowerDome:
 call GetTile
 inc (hl)
 ld a,(hl)
 call RemoveTile
 call LowerDestruction

KillBullet:
 ld (ix),0
 jr EndMB

MoveBUp:
 ld e,(ix+4)
 ld d,(ix+5)
 ld a,d
 or e
 jr z,KillBullet
 dec de
 ld a,d
 or e
 jr z,KillBullet
 dec de
 ld l,(ix+2)
 ld h,(ix+3)
 inc hl
 inc hl
 inc hl
 call GetTileSave
 cp 127
 jr z,ShotPowerDome
 cp 123
 jr z,ShotEgg
 cp 81
 jr nc,KillBullet
 ld (ix+4),e
 ld (ix+5),d
 jr EndMB

MoveBDown:
 ld a,(Rows)
 ld l,(ix+4)
 ld h,(ix+5)
 push hl
 pop de
 call DivHLby8
 cp l
 jp z,KillBullet
 inc de
 inc de
 push de
 ld hl,6
 add hl,de
 ex de,hl
 ld l,(ix+2)
 ld h,(ix+3)
 inc hl
 inc hl
 inc hl
 inc hl
 call GetTileSave
 cp 127
 jr z,ShotPowerDomePop
 cp 123
 jr z,ShotEggPop
 pop de
 cp 81
 jr nc,KillBullet
 ld (ix+4),e
 ld (ix+5),d
 jp EndMB

MoveBLeft:
 ld l,(ix+2)
 ld h,(ix+3)
 ld a,h
 or l
 jr z,KillBullet
 dec hl
 ld a,h
 or l
 jp z,KillBullet
 dec hl
 ld e,(ix+4)
 ld d,(ix+5)
 inc de
 inc de
 inc de
 inc de
 call GetTileSave
 cp 127
 jp z,ShotPowerDome
 cp 123
 jp z,ShotEgg
 cp 81
 jp nc,KillBullet
 ld (ix+2),l
 ld (ix+3),h
 jp EndMB

MoveBRight:
 ld a,(Columns)
 ld l,(ix+2)
 ld h,(ix+3)
 push hl
 call DivHLby8
 cp l
 pop hl
 jp z,KillBullet
 inc hl
 inc hl
 push hl
 ld de,6
 add hl,de
 ld e,(ix+4)
 ld d,(ix+5)
 inc de
 inc de
 inc de
 call GetTileSave
 cp 127
 jp z,ShotPowerDomePop
 cp 123
 jp z,ShotEggPop
 pop hl
 cp 81
 jp nc,KillBullet
 ld (ix+2),l
 ld (ix+3),h
 jp EndMB

CheckBulletHits:
 ld b,10
 di
 push iy
 ld iy,BulletTable
BHits:
 push bc
 ld a,(iy)
 or a
 jp z,EndBHits
 add a,a
 add a,a
 add a,(iy+1)
 ld e,a
 ld d,0
 ld hl,BCXTable-4
 add hl,de
 ld a,(hl)
 ld (TempX),a
 ld hl,BCYTable-4
 add hl,de
 ld a,(hl)
 ld (TempY),a
 ld ix,EnemyTable
 ld b,NO_ALIENS
BHits2:
 push bc
 ld a,(ix)
 or a
 jr z,EndBHits2
 ld e,(ix+2)
 ld d,(ix+3)
 ld l,(iy+2)
 ld h,(iy+3)
 or a
 sbc hl,de
 ld a,l
 jr nc,AbsX
 neg
AbsX:
 ld hl,TempX
 cp (hl)
 jr nc,EndBHits2
 ld e,(ix+4)
 ld d,(ix+5)
 ld l,(iy+4)
 ld h,(iy+5)
 or a
 sbc hl,de
 ld a,l
 jr nc,AbsY
 neg
AbsY:
 ld hl,TempY
 cp (hl)
 jr nc,EndBHits2
 ld a,(ix+7)
 sub (iy)
 ld (iy),0
 ld (ix+7),a
 cp 1
 jp p,EndBHits2
 ld (ix),0
 ld hl,(Score)
 ld de,20
 add hl,de
 ld (Score),hl
 ld l,(ix+2)
 ld h,(ix+3)
 ld e,(ix+4)
 ld d,(ix+5)
 ld bc,4*256+1
 call NewAnimation
EndBHits2:
 pop bc
 ld de,9
 add ix,de
 djnz BHits2
EndBHits:
 pop bc
 ld de,6
 add iy,de
 dec b
 jp nz,BHits
 pop iy
 ei
 ret
